package logic

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AgreementType enumerates the values for agreement type.
type AgreementType string

const (
	// AS2 specifies the as2 state for agreement type.
	AS2 AgreementType = "AS2"
	// Edifact specifies the edifact state for agreement type.
	Edifact AgreementType = "Edifact"
	// NotSpecified specifies the not specified state for agreement type.
	NotSpecified AgreementType = "NotSpecified"
	// X12 specifies the x12 state for agreement type.
	X12 AgreementType = "X12"
)

// EdifactCharacterSet enumerates the values for edifact character set.
type EdifactCharacterSet string

const (
	// EdifactCharacterSetKECA specifies the edifact character set keca state
	// for edifact character set.
	EdifactCharacterSetKECA EdifactCharacterSet = "KECA"
	// EdifactCharacterSetNotSpecified specifies the edifact character set not
	// specified state for edifact character set.
	EdifactCharacterSetNotSpecified EdifactCharacterSet = "NotSpecified"
	// EdifactCharacterSetUNOA specifies the edifact character set unoa state
	// for edifact character set.
	EdifactCharacterSetUNOA EdifactCharacterSet = "UNOA"
	// EdifactCharacterSetUNOB specifies the edifact character set unob state
	// for edifact character set.
	EdifactCharacterSetUNOB EdifactCharacterSet = "UNOB"
	// EdifactCharacterSetUNOC specifies the edifact character set unoc state
	// for edifact character set.
	EdifactCharacterSetUNOC EdifactCharacterSet = "UNOC"
	// EdifactCharacterSetUNOD specifies the edifact character set unod state
	// for edifact character set.
	EdifactCharacterSetUNOD EdifactCharacterSet = "UNOD"
	// EdifactCharacterSetUNOE specifies the edifact character set unoe state
	// for edifact character set.
	EdifactCharacterSetUNOE EdifactCharacterSet = "UNOE"
	// EdifactCharacterSetUNOF specifies the edifact character set unof state
	// for edifact character set.
	EdifactCharacterSetUNOF EdifactCharacterSet = "UNOF"
	// EdifactCharacterSetUNOG specifies the edifact character set unog state
	// for edifact character set.
	EdifactCharacterSetUNOG EdifactCharacterSet = "UNOG"
	// EdifactCharacterSetUNOH specifies the edifact character set unoh state
	// for edifact character set.
	EdifactCharacterSetUNOH EdifactCharacterSet = "UNOH"
	// EdifactCharacterSetUNOI specifies the edifact character set unoi state
	// for edifact character set.
	EdifactCharacterSetUNOI EdifactCharacterSet = "UNOI"
	// EdifactCharacterSetUNOJ specifies the edifact character set unoj state
	// for edifact character set.
	EdifactCharacterSetUNOJ EdifactCharacterSet = "UNOJ"
	// EdifactCharacterSetUNOK specifies the edifact character set unok state
	// for edifact character set.
	EdifactCharacterSetUNOK EdifactCharacterSet = "UNOK"
	// EdifactCharacterSetUNOX specifies the edifact character set unox state
	// for edifact character set.
	EdifactCharacterSetUNOX EdifactCharacterSet = "UNOX"
	// EdifactCharacterSetUNOY specifies the edifact character set unoy state
	// for edifact character set.
	EdifactCharacterSetUNOY EdifactCharacterSet = "UNOY"
)

// EdifactDecimalIndicator enumerates the values for edifact decimal indicator.
type EdifactDecimalIndicator string

const (
	// EdifactDecimalIndicatorComma specifies the edifact decimal indicator
	// comma state for edifact decimal indicator.
	EdifactDecimalIndicatorComma EdifactDecimalIndicator = "Comma"
	// EdifactDecimalIndicatorDecimal specifies the edifact decimal indicator
	// decimal state for edifact decimal indicator.
	EdifactDecimalIndicatorDecimal EdifactDecimalIndicator = "Decimal"
	// EdifactDecimalIndicatorNotSpecified specifies the edifact decimal
	// indicator not specified state for edifact decimal indicator.
	EdifactDecimalIndicatorNotSpecified EdifactDecimalIndicator = "NotSpecified"
)

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmAES128 specifies the encryption algorithm aes128
	// state for encryption algorithm.
	EncryptionAlgorithmAES128 EncryptionAlgorithm = "AES128"
	// EncryptionAlgorithmAES192 specifies the encryption algorithm aes192
	// state for encryption algorithm.
	EncryptionAlgorithmAES192 EncryptionAlgorithm = "AES192"
	// EncryptionAlgorithmAES256 specifies the encryption algorithm aes256
	// state for encryption algorithm.
	EncryptionAlgorithmAES256 EncryptionAlgorithm = "AES256"
	// EncryptionAlgorithmDES3 specifies the encryption algorithm des3 state
	// for encryption algorithm.
	EncryptionAlgorithmDES3 EncryptionAlgorithm = "DES3"
	// EncryptionAlgorithmNone specifies the encryption algorithm none state
	// for encryption algorithm.
	EncryptionAlgorithmNone EncryptionAlgorithm = "None"
	// EncryptionAlgorithmNotSpecified specifies the encryption algorithm not
	// specified state for encryption algorithm.
	EncryptionAlgorithmNotSpecified EncryptionAlgorithm = "NotSpecified"
	// EncryptionAlgorithmRC2 specifies the encryption algorithm rc2 state for
	// encryption algorithm.
	EncryptionAlgorithmRC2 EncryptionAlgorithm = "RC2"
)

// HashingAlgorithm enumerates the values for hashing algorithm.
type HashingAlgorithm string

const (
	// HashingAlgorithmNone specifies the hashing algorithm none state for
	// hashing algorithm.
	HashingAlgorithmNone HashingAlgorithm = "None"
	// HashingAlgorithmNotSpecified specifies the hashing algorithm not
	// specified state for hashing algorithm.
	HashingAlgorithmNotSpecified HashingAlgorithm = "NotSpecified"
	// HashingAlgorithmSHA2256 specifies the hashing algorithm sha2256 state
	// for hashing algorithm.
	HashingAlgorithmSHA2256 HashingAlgorithm = "SHA2256"
	// HashingAlgorithmSHA2384 specifies the hashing algorithm sha2384 state
	// for hashing algorithm.
	HashingAlgorithmSHA2384 HashingAlgorithm = "SHA2384"
	// HashingAlgorithmSHA2512 specifies the hashing algorithm sha2512 state
	// for hashing algorithm.
	HashingAlgorithmSHA2512 HashingAlgorithm = "SHA2512"
)

// MapType enumerates the values for map type.
type MapType string

const (
	// MapTypeNotSpecified specifies the map type not specified state for map
	// type.
	MapTypeNotSpecified MapType = "NotSpecified"
	// MapTypeXslt specifies the map type xslt state for map type.
	MapTypeXslt MapType = "Xslt"
)

// MessageFilterType enumerates the values for message filter type.
type MessageFilterType string

const (
	// MessageFilterTypeExclude specifies the message filter type exclude
	// state for message filter type.
	MessageFilterTypeExclude MessageFilterType = "Exclude"
	// MessageFilterTypeInclude specifies the message filter type include
	// state for message filter type.
	MessageFilterTypeInclude MessageFilterType = "Include"
	// MessageFilterTypeNotSpecified specifies the message filter type not
	// specified state for message filter type.
	MessageFilterTypeNotSpecified MessageFilterType = "NotSpecified"
)

// PartnerType enumerates the values for partner type.
type PartnerType string

const (
	// PartnerTypeB2B specifies the partner type b2b state for partner type.
	PartnerTypeB2B PartnerType = "B2B"
	// PartnerTypeNotSpecified specifies the partner type not specified state
	// for partner type.
	PartnerTypeNotSpecified PartnerType = "NotSpecified"
)

// SchemaType enumerates the values for schema type.
type SchemaType string

const (
	// SchemaTypeNotSpecified specifies the schema type not specified state
	// for schema type.
	SchemaTypeNotSpecified SchemaType = "NotSpecified"
	// SchemaTypeXML specifies the schema type xml state for schema type.
	SchemaTypeXML SchemaType = "Xml"
)

// SegmentTerminatorSuffix enumerates the values for segment terminator suffix.
type SegmentTerminatorSuffix string

const (
	// SegmentTerminatorSuffixCR specifies the segment terminator suffix cr
	// state for segment terminator suffix.
	SegmentTerminatorSuffixCR SegmentTerminatorSuffix = "CR"
	// SegmentTerminatorSuffixCRLF specifies the segment terminator suffix
	// crlf state for segment terminator suffix.
	SegmentTerminatorSuffixCRLF SegmentTerminatorSuffix = "CRLF"
	// SegmentTerminatorSuffixLF specifies the segment terminator suffix lf
	// state for segment terminator suffix.
	SegmentTerminatorSuffixLF SegmentTerminatorSuffix = "LF"
	// SegmentTerminatorSuffixNone specifies the segment terminator suffix
	// none state for segment terminator suffix.
	SegmentTerminatorSuffixNone SegmentTerminatorSuffix = "None"
	// SegmentTerminatorSuffixNotSpecified specifies the segment terminator
	// suffix not specified state for segment terminator suffix.
	SegmentTerminatorSuffixNotSpecified SegmentTerminatorSuffix = "NotSpecified"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic specifies the sku name basic state for sku name.
	SkuNameBasic SkuName = "Basic"
	// SkuNameFree specifies the sku name free state for sku name.
	SkuNameFree SkuName = "Free"
	// SkuNameNotSpecified specifies the sku name not specified state for sku
	// name.
	SkuNameNotSpecified SkuName = "NotSpecified"
	// SkuNamePremium specifies the sku name premium state for sku name.
	SkuNamePremium SkuName = "Premium"
	// SkuNameShared specifies the sku name shared state for sku name.
	SkuNameShared SkuName = "Shared"
	// SkuNameStandard specifies the sku name standard state for sku name.
	SkuNameStandard SkuName = "Standard"
)

// TrailingSeparatorPolicy enumerates the values for trailing separator policy.
type TrailingSeparatorPolicy string

const (
	// TrailingSeparatorPolicyMandatory specifies the trailing separator
	// policy mandatory state for trailing separator policy.
	TrailingSeparatorPolicyMandatory TrailingSeparatorPolicy = "Mandatory"
	// TrailingSeparatorPolicyNotAllowed specifies the trailing separator
	// policy not allowed state for trailing separator policy.
	TrailingSeparatorPolicyNotAllowed TrailingSeparatorPolicy = "NotAllowed"
	// TrailingSeparatorPolicyNotSpecified specifies the trailing separator
	// policy not specified state for trailing separator policy.
	TrailingSeparatorPolicyNotSpecified TrailingSeparatorPolicy = "NotSpecified"
	// TrailingSeparatorPolicyOptional specifies the trailing separator policy
	// optional state for trailing separator policy.
	TrailingSeparatorPolicyOptional TrailingSeparatorPolicy = "Optional"
)

// UsageIndicator enumerates the values for usage indicator.
type UsageIndicator string

const (
	// UsageIndicatorInformation specifies the usage indicator information
	// state for usage indicator.
	UsageIndicatorInformation UsageIndicator = "Information"
	// UsageIndicatorNotSpecified specifies the usage indicator not specified
	// state for usage indicator.
	UsageIndicatorNotSpecified UsageIndicator = "NotSpecified"
	// UsageIndicatorProduction specifies the usage indicator production state
	// for usage indicator.
	UsageIndicatorProduction UsageIndicator = "Production"
	// UsageIndicatorTest specifies the usage indicator test state for usage
	// indicator.
	UsageIndicatorTest UsageIndicator = "Test"
)

// X12CharacterSet enumerates the values for x12 character set.
type X12CharacterSet string

const (
	// X12CharacterSetBasic specifies the x12 character set basic state for
	// x12 character set.
	X12CharacterSetBasic X12CharacterSet = "Basic"
	// X12CharacterSetExtended specifies the x12 character set extended state
	// for x12 character set.
	X12CharacterSetExtended X12CharacterSet = "Extended"
	// X12CharacterSetNotSpecified specifies the x12 character set not
	// specified state for x12 character set.
	X12CharacterSetNotSpecified X12CharacterSet = "NotSpecified"
	// X12CharacterSetUTF8 specifies the x12 character set utf8 state for x12
	// character set.
	X12CharacterSetUTF8 X12CharacterSet = "UTF8"
)

// X12DateFormat enumerates the values for x12 date format.
type X12DateFormat string

const (
	// X12DateFormatCCYYMMDD specifies the x12 date format ccyymmdd state for
	// x12 date format.
	X12DateFormatCCYYMMDD X12DateFormat = "CCYYMMDD"
	// X12DateFormatNotSpecified specifies the x12 date format not specified
	// state for x12 date format.
	X12DateFormatNotSpecified X12DateFormat = "NotSpecified"
	// X12DateFormatYYMMDD specifies the x12 date format yymmdd state for x12
	// date format.
	X12DateFormatYYMMDD X12DateFormat = "YYMMDD"
)

// X12TimeFormat enumerates the values for x12 time format.
type X12TimeFormat string

const (
	// X12TimeFormatHHMM specifies the x12 time format hhmm state for x12 time
	// format.
	X12TimeFormatHHMM X12TimeFormat = "HHMM"
	// X12TimeFormatHHMMSS specifies the x12 time format hhmmss state for x12
	// time format.
	X12TimeFormatHHMMSS X12TimeFormat = "HHMMSS"
	// X12TimeFormatHHMMSSd specifies the x12 time format hhmms sd state for
	// x12 time format.
	X12TimeFormatHHMMSSd X12TimeFormat = "HHMMSSd"
	// X12TimeFormatHHMMSSdd specifies the x12 time format hhmms sdd state for
	// x12 time format.
	X12TimeFormatHHMMSSdd X12TimeFormat = "HHMMSSdd"
	// X12TimeFormatNotSpecified specifies the x12 time format not specified
	// state for x12 time format.
	X12TimeFormatNotSpecified X12TimeFormat = "NotSpecified"
)

// AgreementContent is
type AgreementContent struct {
	AS2     *AS2AgreementContent     `json:"AS2,omitempty"`
	X12     *X12AgreementContent     `json:"X12,omitempty"`
	Edifact *EdifactAgreementContent `json:"Edifact,omitempty"`
}

// AS2AcknowledgementConnectionSettings is
type AS2AcknowledgementConnectionSettings struct {
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`
	KeepHTTPConnectionAlive       *bool `json:"keepHttpConnectionAlive,omitempty"`
	UnfoldHTTPHeaders             *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2AgreementContent is
type AS2AgreementContent struct {
	ReceiveAgreement *AS2OneWayAgreement `json:"receiveAgreement,omitempty"`
	SendAgreement    *AS2OneWayAgreement `json:"sendAgreement,omitempty"`
}

// AS2EnvelopeSettings is
type AS2EnvelopeSettings struct {
	MessageContentType                      *string `json:"messageContentType,omitempty"`
	TransmitFileNameInMimeHeader            *bool   `json:"transmitFileNameInMimeHeader,omitempty"`
	FileNameTemplate                        *string `json:"fileNameTemplate,omitempty"`
	SuspendMessageOnFileNameGenerationError *bool   `json:"SuspendMessageOnFileNameGenerationError,omitempty"`
	AutogenerateFileName                    *bool   `json:"AutogenerateFileName,omitempty"`
}

// AS2ErrorSettings is
type AS2ErrorSettings struct {
	SuspendDuplicateMessage *bool `json:"SuspendDuplicateMessage,omitempty"`
	ResendIfMdnNotReceived  *bool `json:"ResendIfMdnNotReceived,omitempty"`
}

// AS2MdnSettings is
type AS2MdnSettings struct {
	NeedMdn                    *bool            `json:"needMdn,omitempty"`
	SignMdn                    *bool            `json:"signMdn,omitempty"`
	SendMdnAsynchronously      *bool            `json:"sendMdnAsynchronously,omitempty"`
	ReceiptDeliveryURL         *string          `json:"receiptDeliveryUrl,omitempty"`
	DispositionNotificationTo  *string          `json:"dispositionNotificationTo,omitempty"`
	SignOutboundMdnIfOptional  *bool            `json:"signOutboundMdnIfOptional,omitempty"`
	MdnText                    *string          `json:"mdnText,omitempty"`
	SendInboundMdnToMessageBox *bool            `json:"sendInboundMdnToMessageBox,omitempty"`
	MicHashingAlgorithm        HashingAlgorithm `json:"micHashingAlgorithm,omitempty"`
}

// AS2MessageConnectionSettings is
type AS2MessageConnectionSettings struct {
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`
	KeepHTTPConnectionAlive       *bool `json:"keepHttpConnectionAlive,omitempty"`
	UnfoldHTTPHeaders             *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2OneWayAgreement is
type AS2OneWayAgreement struct {
	SenderBusinessIdentity   *BusinessIdentity    `json:"senderBusinessIdentity,omitempty"`
	ReceiverBusinessIdentity *BusinessIdentity    `json:"receiverBusinessIdentity,omitempty"`
	ProtocolSettings         *AS2ProtocolSettings `json:"protocolSettings,omitempty"`
}

// AS2ProtocolSettings is
type AS2ProtocolSettings struct {
	MessageConnectionSettings         *AS2MessageConnectionSettings         `json:"messageConnectionSettings,omitempty"`
	AcknowledgementConnectionSettings *AS2AcknowledgementConnectionSettings `json:"acknowledgementConnectionSettings,omitempty"`
	MdnSettings                       *AS2MdnSettings                       `json:"mdnSettings,omitempty"`
	SecuritySettings                  *AS2SecuritySettings                  `json:"securitySettings,omitempty"`
	ValidationSettings                *AS2ValidationSettings                `json:"validationSettings,omitempty"`
	EnvelopeSettings                  *AS2EnvelopeSettings                  `json:"envelopeSettings,omitempty"`
	ErrorSettings                     *AS2ErrorSettings                     `json:"errorSettings,omitempty"`
}

// AS2SecuritySettings is
type AS2SecuritySettings struct {
	OverrideGroupSigningCertificate     *bool   `json:"overrideGroupSigningCertificate,omitempty"`
	SigningCertificateName              *string `json:"signingCertificateName,omitempty"`
	EncryptionCertificateName           *string `json:"encryptionCertificateName,omitempty"`
	EnableNrrForInboundEncodedMessages  *bool   `json:"enableNrrForInboundEncodedMessages,omitempty"`
	EnableNrrForInboundDecodedMessages  *bool   `json:"enableNrrForInboundDecodedMessages,omitempty"`
	EnableNrrForOutboundMdn             *bool   `json:"enableNrrForOutboundMdn,omitempty"`
	EnableNrrForOutboundEncodedMessages *bool   `json:"enableNrrForOutboundEncodedMessages,omitempty"`
	EnableNrrForOutboundDecodedMessages *bool   `json:"enableNrrForOutboundDecodedMessages,omitempty"`
	EnableNrrForInboundMdn              *bool   `json:"enableNrrForInboundMdn,omitempty"`
}

// AS2ValidationSettings is
type AS2ValidationSettings struct {
	OverrideMessageProperties               *bool               `json:"overrideMessageProperties,omitempty"`
	EncryptMessage                          *bool               `json:"encryptMessage,omitempty"`
	SignMessage                             *bool               `json:"signMessage,omitempty"`
	CompressMessage                         *bool               `json:"compressMessage,omitempty"`
	CheckDuplicateMessage                   *bool               `json:"checkDuplicateMessage,omitempty"`
	InterchangeDuplicatesValidityDays       *int32              `json:"interchangeDuplicatesValidityDays,omitempty"`
	CheckCertificateRevocationListOnSend    *bool               `json:"checkCertificateRevocationListOnSend,omitempty"`
	CheckCertificateRevocationListOnReceive *bool               `json:"checkCertificateRevocationListOnReceive,omitempty"`
	EncryptionAlgorithm                     EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
}

// B2BPartnerContent is
type B2BPartnerContent struct {
	BusinessIdentities *[]BusinessIdentity `json:"businessIdentities,omitempty"`
}

// BusinessIdentity is
type BusinessIdentity struct {
	Qualifier *string `json:"Qualifier,omitempty"`
	Value     *string `json:"Value,omitempty"`
}

// CallbackURL is
type CallbackURL struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// EdifactAcknowledgementSettings is
type EdifactAcknowledgementSettings struct {
	NeedTechnicalAcknowledgement           *bool   `json:"needTechnicalAcknowledgement,omitempty"`
	BatchTechnicalAcknowledgements         *bool   `json:"batchTechnicalAcknowledgements,omitempty"`
	NeedFunctionalAcknowledgement          *bool   `json:"needFunctionalAcknowledgement,omitempty"`
	BatchFunctionalAcknowledgements        *bool   `json:"batchFunctionalAcknowledgements,omitempty"`
	NeedLoopForValidMessages               *bool   `json:"needLoopForValidMessages,omitempty"`
	SendSynchronousAcknowledgement         *bool   `json:"sendSynchronousAcknowledgement,omitempty"`
	AcknowledgementControlNumberPrefix     *string `json:"acknowledgementControlNumberPrefix,omitempty"`
	AcknowledgementControlNumberSuffix     *string `json:"acknowledgementControlNumberSuffix,omitempty"`
	AcknowledgementControlNumberLowerBound *int32  `json:"acknowledgementControlNumberLowerBound,omitempty"`
	AcknowledgementControlNumberUpperBound *int32  `json:"acknowledgementControlNumberUpperBound,omitempty"`
	RolloverAcknowledgementControlNumber   *bool   `json:"rolloverAcknowledgementControlNumber,omitempty"`
}

// EdifactAgreementContent is
type EdifactAgreementContent struct {
	ReceiveAgreement *EdifactOneWayAgreement `json:"receiveAgreement,omitempty"`
	SendAgreement    *EdifactOneWayAgreement `json:"sendAgreement,omitempty"`
}

// EdifactDelimiterOverride is
type EdifactDelimiterOverride struct {
	MessageID                      *string                 `json:"messageId,omitempty"`
	MessageVersion                 *string                 `json:"messageVersion,omitempty"`
	MessageRelease                 *string                 `json:"messageRelease,omitempty"`
	DataElementSeparator           *int32                  `json:"dataElementSeparator,omitempty"`
	ComponentSeparator             *int32                  `json:"componentSeparator,omitempty"`
	SegmentTerminator              *int32                  `json:"segmentTerminator,omitempty"`
	RepetitionSeparator            *int32                  `json:"repetitionSeparator,omitempty"`
	SegmentTerminatorSuffix        SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
	DecimalPointIndicator          EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`
	ReleaseIndicator               *int32                  `json:"releaseIndicator,omitempty"`
	MessageAssociationAssignedCode *string                 `json:"messageAssociationAssignedCode,omitempty"`
	TargetNamespace                *string                 `json:"targetNamespace,omitempty"`
}

// EdifactEnvelopeOverride is
type EdifactEnvelopeOverride struct {
	MessageID                      *string `json:"messageId,omitempty"`
	MessageVersion                 *string `json:"messageVersion,omitempty"`
	MessageRelease                 *string `json:"messageRelease,omitempty"`
	MessageAssociationAssignedCode *string `json:"messageAssociationAssignedCode,omitempty"`
	TargetNamespace                *string `json:"targetNamespace,omitempty"`
	FunctionalGroupID              *string `json:"functionalGroupId,omitempty"`
	SenderApplicationQualifier     *string `json:"senderApplicationQualifier,omitempty"`
	SenderApplicationID            *string `json:"senderApplicationId,omitempty"`
	ReceiverApplicationQualifier   *string `json:"receiverApplicationQualifier,omitempty"`
	ReceiverApplicationID          *string `json:"receiverApplicationId,omitempty"`
	ControllingAgencyCode          *string `json:"controllingAgencyCode,omitempty"`
	GroupHeaderMessageVersion      *string `json:"groupHeaderMessageVersion,omitempty"`
	GroupHeaderMessageRelease      *string `json:"groupHeaderMessageRelease,omitempty"`
	AssociationAssignedCode        *string `json:"associationAssignedCode,omitempty"`
	ApplicationPassword            *string `json:"applicationPassword,omitempty"`
}

// EdifactEnvelopeSettings is
type EdifactEnvelopeSettings struct {
	GroupAssociationAssignedCode                 *string `json:"groupAssociationAssignedCode,omitempty"`
	CommunicationAgreementID                     *string `json:"communicationAgreementId,omitempty"`
	ApplyDelimiterStringAdvice                   *bool   `json:"applyDelimiterStringAdvice,omitempty"`
	CreateGroupingSegments                       *bool   `json:"createGroupingSegments,omitempty"`
	EnableDefaultGroupHeaders                    *bool   `json:"enableDefaultGroupHeaders,omitempty"`
	RecipientReferencePasswordValue              *string `json:"recipientReferencePasswordValue,omitempty"`
	RecipientReferencePasswordQualifier          *string `json:"recipientReferencePasswordQualifier,omitempty"`
	ApplicationReferenceID                       *string `json:"applicationReferenceId,omitempty"`
	ProcessingPriorityCode                       *string `json:"processingPriorityCode,omitempty"`
	InterchangeControlNumberLowerBound           *int64  `json:"interchangeControlNumberLowerBound,omitempty"`
	InterchangeControlNumberUpperBound           *int64  `json:"interchangeControlNumberUpperBound,omitempty"`
	RolloverInterchangeControlNumber             *bool   `json:"rolloverInterchangeControlNumber,omitempty"`
	InterchangeControlNumberPrefix               *string `json:"interchangeControlNumberPrefix,omitempty"`
	InterchangeControlNumberSuffix               *string `json:"interchangeControlNumberSuffix,omitempty"`
	SenderReverseRoutingAddress                  *string `json:"senderReverseRoutingAddress,omitempty"`
	ReceiverReverseRoutingAddress                *string `json:"receiverReverseRoutingAddress,omitempty"`
	FunctionalGroupID                            *string `json:"functionalGroupId,omitempty"`
	GroupControllingAgencyCode                   *string `json:"groupControllingAgencyCode,omitempty"`
	GroupMessageVersion                          *string `json:"groupMessageVersion,omitempty"`
	GroupMessageRelease                          *string `json:"groupMessageRelease,omitempty"`
	GroupControlNumberLowerBound                 *int64  `json:"groupControlNumberLowerBound,omitempty"`
	GroupControlNumberUpperBound                 *int64  `json:"groupControlNumberUpperBound,omitempty"`
	RolloverGroupControlNumber                   *bool   `json:"rolloverGroupControlNumber,omitempty"`
	GroupControlNumberPrefix                     *string `json:"groupControlNumberPrefix,omitempty"`
	GroupControlNumberSuffix                     *string `json:"groupControlNumberSuffix,omitempty"`
	GroupApplicationReceiverQualifier            *string `json:"groupApplicationReceiverQualifier,omitempty"`
	GroupApplicationReceiverID                   *string `json:"groupApplicationReceiverId,omitempty"`
	GroupApplicationSenderQualifier              *string `json:"groupApplicationSenderQualifier,omitempty"`
	GroupApplicationSenderID                     *string `json:"groupApplicationSenderId,omitempty"`
	GroupApplicationPassword                     *string `json:"groupApplicationPassword,omitempty"`
	OverwriteExistingTransactionSetControlNumber *bool   `json:"overwriteExistingTransactionSetControlNumber,omitempty"`
	TransactionSetControlNumberPrefix            *string `json:"transactionSetControlNumberPrefix,omitempty"`
	TransactionSetControlNumberSuffix            *string `json:"transactionSetControlNumberSuffix,omitempty"`
	TransactionSetControlNumberLowerBound        *int64  `json:"transactionSetControlNumberLowerBound,omitempty"`
	TransactionSetControlNumberUpperBound        *int64  `json:"transactionSetControlNumberUpperBound,omitempty"`
	RolloverTransactionSetControlNumber          *bool   `json:"rolloverTransactionSetControlNumber,omitempty"`
	IsTestInterchange                            *bool   `json:"isTestInterchange,omitempty"`
	SenderInternalIdentification                 *string `json:"senderInternalIdentification,omitempty"`
	SenderInternalSubIdentification              *string `json:"senderInternalSubIdentification,omitempty"`
	ReceiverInternalIdentification               *string `json:"receiverInternalIdentification,omitempty"`
	ReceiverInternalSubIdentification            *string `json:"receiverInternalSubIdentification,omitempty"`
}

// EdifactFramingSettings is
type EdifactFramingSettings struct {
	ServiceCodeListDirectoryVersion *string                 `json:"serviceCodeListDirectoryVersion,omitempty"`
	CharacterEncoding               *string                 `json:"characterEncoding,omitempty"`
	ProtocolVersion                 *int32                  `json:"protocolVersion,omitempty"`
	DataElementSeparator            *int32                  `json:"dataElementSeparator,omitempty"`
	ComponentSeparator              *int32                  `json:"componentSeparator,omitempty"`
	SegmentTerminator               *int32                  `json:"segmentTerminator,omitempty"`
	ReleaseIndicator                *int32                  `json:"releaseIndicator,omitempty"`
	RepetitionSeparator             *int32                  `json:"repetitionSeparator,omitempty"`
	CharacterSet                    EdifactCharacterSet     `json:"characterSet,omitempty"`
	DecimalPointIndicator           EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`
	SegmentTerminatorSuffix         SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
}

// EdifactMessageFilter is
type EdifactMessageFilter struct {
	MessageFilterType MessageFilterType `json:"messageFilterType,omitempty"`
}

// EdifactMessageIdentifier is
type EdifactMessageIdentifier struct {
	MessageID *string `json:"messageId,omitempty"`
}

// EdifactOneWayAgreement is
type EdifactOneWayAgreement struct {
	SenderBusinessIdentity   *BusinessIdentity        `json:"senderBusinessIdentity,omitempty"`
	ReceiverBusinessIdentity *BusinessIdentity        `json:"receiverBusinessIdentity,omitempty"`
	ProtocolSettings         *EdifactProtocolSettings `json:"protocolSettings,omitempty"`
}

// EdifactProcessingSettings is
type EdifactProcessingSettings struct {
	MaskSecurityInfo                        *bool `json:"maskSecurityInfo,omitempty"`
	PreserveInterchange                     *bool `json:"preserveInterchange,omitempty"`
	SuspendInterchangeOnError               *bool `json:"suspendInterchangeOnError,omitempty"`
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`
	UseDotAsDecimalSeparator                *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// EdifactProtocolSettings is
type EdifactProtocolSettings struct {
	ValidationSettings        *EdifactValidationSettings      `json:"validationSettings,omitempty"`
	FramingSettings           *EdifactFramingSettings         `json:"framingSettings,omitempty"`
	EnvelopeSettings          *EdifactEnvelopeSettings        `json:"envelopeSettings,omitempty"`
	AcknowledgementSettings   *EdifactAcknowledgementSettings `json:"acknowledgementSettings,omitempty"`
	MessageFilter             *EdifactMessageFilter           `json:"messageFilter,omitempty"`
	ProcessingSettings        *EdifactProcessingSettings      `json:"processingSettings,omitempty"`
	EnvelopeOverrides         *[]EdifactEnvelopeOverride      `json:"envelopeOverrides,omitempty"`
	MessageFilterList         *[]EdifactMessageIdentifier     `json:"messageFilterList,omitempty"`
	SchemaReferences          *[]EdifactSchemaReference       `json:"schemaReferences,omitempty"`
	ValidationOverrides       *[]EdifactValidationOverride    `json:"validationOverrides,omitempty"`
	EdifactDelimiterOverrides *[]EdifactDelimiterOverride     `json:"edifactDelimiterOverrides,omitempty"`
}

// EdifactSchemaReference is
type EdifactSchemaReference struct {
	MessageID                  *string `json:"messageId,omitempty"`
	MessageVersion             *string `json:"messageVersion,omitempty"`
	MessageRelease             *string `json:"messageRelease,omitempty"`
	SenderApplicationID        *string `json:"senderApplicationId,omitempty"`
	SenderApplicationQualifier *string `json:"senderApplicationQualifier,omitempty"`
	AssociationAssignedCode    *string `json:"associationAssignedCode,omitempty"`
	SchemaName                 *string `json:"schemaName,omitempty"`
}

// EdifactValidationOverride is
type EdifactValidationOverride struct {
	MessageID                              *string                 `json:"messageId,omitempty"`
	EnforceCharacterSet                    *bool                   `json:"enforceCharacterSet,omitempty"`
	ValidateEDITypes                       *bool                   `json:"validateEDITypes,omitempty"`
	ValidateXSDTypes                       *bool                   `json:"validateXSDTypes,omitempty"`
	AllowLeadingAndTrailingSpacesAndZeroes *bool                   `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrailingSeparatorPolicy                TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
	TrimLeadingAndTrailingSpacesAndZeroes  *bool                   `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
}

// EdifactValidationSettings is
type EdifactValidationSettings struct {
	ValidateCharacterSet                      *bool                   `json:"validateCharacterSet,omitempty"`
	CheckDuplicateInterchangeControlNumber    *bool                   `json:"checkDuplicateInterchangeControlNumber,omitempty"`
	InterchangeControlNumberValidityDays      *int32                  `json:"interchangeControlNumberValidityDays,omitempty"`
	CheckDuplicateGroupControlNumber          *bool                   `json:"checkDuplicateGroupControlNumber,omitempty"`
	CheckDuplicateTransactionSetControlNumber *bool                   `json:"checkDuplicateTransactionSetControlNumber,omitempty"`
	ValidateEDITypes                          *bool                   `json:"validateEDITypes,omitempty"`
	ValidateXSDTypes                          *bool                   `json:"validateXSDTypes,omitempty"`
	AllowLeadingAndTrailingSpacesAndZeroes    *bool                   `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrimLeadingAndTrailingSpacesAndZeroes     *bool                   `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrailingSeparatorPolicy                   TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}

// IntegrationAccount is
type IntegrationAccount struct {
	autorest.Response `json:"-"`
	ID                *string                 `json:"id,omitempty"`
	Name              *string                 `json:"name,omitempty"`
	Type              *string                 `json:"type,omitempty"`
	Location          *string                 `json:"location,omitempty"`
	Tags              *map[string]*string     `json:"tags,omitempty"`
	Properties        *map[string]interface{} `json:"properties,omitempty"`
	Sku               *IntegrationAccountSku  `json:"sku,omitempty"`
}

// IntegrationAccountAgreement is
type IntegrationAccountAgreement struct {
	autorest.Response `json:"-"`
	ID                *string                                `json:"id,omitempty"`
	Name              *string                                `json:"name,omitempty"`
	Type              *string                                `json:"type,omitempty"`
	Location          *string                                `json:"location,omitempty"`
	Tags              *map[string]*string                    `json:"tags,omitempty"`
	Properties        *IntegrationAccountAgreementProperties `json:"properties,omitempty"`
}

// IntegrationAccountAgreementFilter is
type IntegrationAccountAgreementFilter struct {
	AgreementType AgreementType `json:"agreementType,omitempty"`
}

// IntegrationAccountAgreementListResult is
type IntegrationAccountAgreementListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountAgreement `json:"value,omitempty"`
	NextLink          *string                        `json:"nextLink,omitempty"`
}

// IntegrationAccountAgreementListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountAgreementListResult) IntegrationAccountAgreementListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountAgreementProperties is
type IntegrationAccountAgreementProperties struct {
	CreatedTime   *date.Time              `json:"createdTime,omitempty"`
	ChangedTime   *date.Time              `json:"changedTime,omitempty"`
	Metadata      *map[string]interface{} `json:"metadata,omitempty"`
	AgreementType AgreementType           `json:"agreementType,omitempty"`
	HostPartner   *string                 `json:"hostPartner,omitempty"`
	GuestPartner  *string                 `json:"guestPartner,omitempty"`
	HostIdentity  *BusinessIdentity       `json:"hostIdentity,omitempty"`
	GuestIdentity *BusinessIdentity       `json:"guestIdentity,omitempty"`
	Content       *AgreementContent       `json:"content,omitempty"`
}

// IntegrationAccountCertificate is
type IntegrationAccountCertificate struct {
	autorest.Response `json:"-"`
	ID                *string                                  `json:"id,omitempty"`
	Name              *string                                  `json:"name,omitempty"`
	Type              *string                                  `json:"type,omitempty"`
	Location          *string                                  `json:"location,omitempty"`
	Tags              *map[string]*string                      `json:"tags,omitempty"`
	Properties        *IntegrationAccountCertificateProperties `json:"properties,omitempty"`
}

// IntegrationAccountCertificateListResult is
type IntegrationAccountCertificateListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountCertificate `json:"value,omitempty"`
	NextLink          *string                          `json:"nextLink,omitempty"`
}

// IntegrationAccountCertificateListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountCertificateListResult) IntegrationAccountCertificateListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountCertificateProperties is
type IntegrationAccountCertificateProperties struct {
	CreatedTime       *date.Time              `json:"createdTime,omitempty"`
	ChangedTime       *date.Time              `json:"changedTime,omitempty"`
	Metadata          *map[string]interface{} `json:"metadata,omitempty"`
	Key               *KeyVaultKeyReference   `json:"key,omitempty"`
	PublicCertificate *string                 `json:"publicCertificate,omitempty"`
}

// IntegrationAccountContentHash is
type IntegrationAccountContentHash struct {
	Algorithm *string `json:"algorithm,omitempty"`
	Value     *string `json:"value,omitempty"`
}

// IntegrationAccountContentLink is
type IntegrationAccountContentLink struct {
	URI            *string                        `json:"uri,omitempty"`
	ContentVersion *string                        `json:"contentVersion,omitempty"`
	ContentSize    *int64                         `json:"contentSize,omitempty"`
	ContentHash    *IntegrationAccountContentHash `json:"contentHash,omitempty"`
	Metadata       *map[string]interface{}        `json:"metadata,omitempty"`
}

// IntegrationAccountListResult is
type IntegrationAccountListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccount `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// IntegrationAccountListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountListResult) IntegrationAccountListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountMap is
type IntegrationAccountMap struct {
	autorest.Response `json:"-"`
	ID                *string                          `json:"id,omitempty"`
	Name              *string                          `json:"name,omitempty"`
	Type              *string                          `json:"type,omitempty"`
	Location          *string                          `json:"location,omitempty"`
	Tags              *map[string]*string              `json:"tags,omitempty"`
	Properties        *IntegrationAccountMapProperties `json:"properties,omitempty"`
}

// IntegrationAccountMapFilter is
type IntegrationAccountMapFilter struct {
	SchemaType MapType `json:"schemaType,omitempty"`
}

// IntegrationAccountMapListResult is
type IntegrationAccountMapListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountMap `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// IntegrationAccountMapListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountMapListResult) IntegrationAccountMapListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountMapProperties is
type IntegrationAccountMapProperties struct {
	MapType     MapType                        `json:"mapType,omitempty"`
	CreatedTime *date.Time                     `json:"createdTime,omitempty"`
	ChangedTime *date.Time                     `json:"changedTime,omitempty"`
	Content     *map[string]interface{}        `json:"content,omitempty"`
	ContentType *string                        `json:"contentType,omitempty"`
	ContentLink *IntegrationAccountContentLink `json:"contentLink,omitempty"`
	Metadata    *map[string]interface{}        `json:"metadata,omitempty"`
}

// IntegrationAccountPartner is
type IntegrationAccountPartner struct {
	autorest.Response `json:"-"`
	ID                *string                              `json:"id,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	Type              *string                              `json:"type,omitempty"`
	Location          *string                              `json:"location,omitempty"`
	Tags              *map[string]*string                  `json:"tags,omitempty"`
	Properties        *IntegrationAccountPartnerProperties `json:"properties,omitempty"`
}

// IntegrationAccountPartnerFilter is
type IntegrationAccountPartnerFilter struct {
	PartnerType PartnerType `json:"partnerType,omitempty"`
}

// IntegrationAccountPartnerListResult is
type IntegrationAccountPartnerListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountPartner `json:"value,omitempty"`
	NextLink          *string                      `json:"nextLink,omitempty"`
}

// IntegrationAccountPartnerListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountPartnerListResult) IntegrationAccountPartnerListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountPartnerProperties is
type IntegrationAccountPartnerProperties struct {
	PartnerType PartnerType             `json:"partnerType,omitempty"`
	CreatedTime *date.Time              `json:"createdTime,omitempty"`
	ChangedTime *date.Time              `json:"changedTime,omitempty"`
	Metadata    *map[string]interface{} `json:"metadata,omitempty"`
	Content     *PartnerContent         `json:"content,omitempty"`
}

// IntegrationAccountResource is
type IntegrationAccountResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// IntegrationAccountSchema is
type IntegrationAccountSchema struct {
	autorest.Response `json:"-"`
	ID                *string                             `json:"id,omitempty"`
	Name              *string                             `json:"name,omitempty"`
	Type              *string                             `json:"type,omitempty"`
	Location          *string                             `json:"location,omitempty"`
	Tags              *map[string]*string                 `json:"tags,omitempty"`
	Properties        *IntegrationAccountSchemaProperties `json:"properties,omitempty"`
}

// IntegrationAccountSchemaFilter is
type IntegrationAccountSchemaFilter struct {
	SchemaType SchemaType `json:"schemaType,omitempty"`
}

// IntegrationAccountSchemaListResult is
type IntegrationAccountSchemaListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountSchema `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// IntegrationAccountSchemaListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountSchemaListResult) IntegrationAccountSchemaListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountSchemaProperties is
type IntegrationAccountSchemaProperties struct {
	SchemaType      SchemaType                     `json:"schemaType,omitempty"`
	TargetNamespace *string                        `json:"targetNamespace,omitempty"`
	CreatedTime     *date.Time                     `json:"createdTime,omitempty"`
	ChangedTime     *date.Time                     `json:"changedTime,omitempty"`
	Content         *map[string]interface{}        `json:"content,omitempty"`
	ContentType     *string                        `json:"contentType,omitempty"`
	ContentLink     *IntegrationAccountContentLink `json:"contentLink,omitempty"`
	Metadata        *map[string]interface{}        `json:"metadata,omitempty"`
}

// IntegrationAccountSku is
type IntegrationAccountSku struct {
	Name SkuName `json:"name,omitempty"`
}

// KeyVaultKeyReference is
type KeyVaultKeyReference struct {
	KeyVault   *ResourceReference `json:"keyVault,omitempty"`
	KeyName    *string            `json:"keyName,omitempty"`
	KeyVersion *string            `json:"keyVersion,omitempty"`
}

// ListCallbackURLParameters is
type ListCallbackURLParameters struct {
	NotAfter *date.Time `json:"NotAfter,omitempty"`
}

// PartnerContent is
type PartnerContent struct {
	B2b *B2BPartnerContent `json:"b2b,omitempty"`
}

// ResourceReference is
type ResourceReference struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// X12AcknowledgementSettings is
type X12AcknowledgementSettings struct {
	NeedTechnicalAcknowledgement           *bool   `json:"needTechnicalAcknowledgement,omitempty"`
	BatchTechnicalAcknowledgements         *bool   `json:"batchTechnicalAcknowledgements,omitempty"`
	NeedFunctionalAcknowledgement          *bool   `json:"needFunctionalAcknowledgement,omitempty"`
	FunctionalAcknowledgementVersion       *string `json:"functionalAcknowledgementVersion,omitempty"`
	BatchFunctionalAcknowledgements        *bool   `json:"batchFunctionalAcknowledgements,omitempty"`
	NeedImplementationAcknowledgement      *bool   `json:"needImplementationAcknowledgement,omitempty"`
	ImplementationAcknowledgementVersion   *string `json:"implementationAcknowledgementVersion,omitempty"`
	BatchImplementationAcknowledgements    *bool   `json:"batchImplementationAcknowledgements,omitempty"`
	NeedLoopForValidMessages               *bool   `json:"needLoopForValidMessages,omitempty"`
	SendSynchronousAcknowledgement         *bool   `json:"sendSynchronousAcknowledgement,omitempty"`
	AcknowledgementControlNumberPrefix     *string `json:"acknowledgementControlNumberPrefix,omitempty"`
	AcknowledgementControlNumberSuffix     *string `json:"acknowledgementControlNumberSuffix,omitempty"`
	AcknowledgementControlNumberLowerBound *int32  `json:"acknowledgementControlNumberLowerBound,omitempty"`
	AcknowledgementControlNumberUpperBound *int32  `json:"acknowledgementControlNumberUpperBound,omitempty"`
	RolloverAcknowledgementControlNumber   *bool   `json:"rolloverAcknowledgementControlNumber,omitempty"`
}

// X12AgreementContent is
type X12AgreementContent struct {
	ReceiveAgreement *X12OneWayAgreement `json:"receiveAgreement,omitempty"`
	SendAgreement    *X12OneWayAgreement `json:"sendAgreement,omitempty"`
}

// X12DelimiterOverrides is
type X12DelimiterOverrides struct {
	ProtocolVersion            *string                 `json:"protocolVersion,omitempty"`
	MessageID                  *string                 `json:"messageId,omitempty"`
	DataElementSeparator       *int32                  `json:"dataElementSeparator,omitempty"`
	ComponentSeparator         *int32                  `json:"componentSeparator,omitempty"`
	SegmentTerminator          *int32                  `json:"segmentTerminator,omitempty"`
	SegmentTerminatorSuffix    SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
	ReplaceCharacter           *int32                  `json:"replaceCharacter,omitempty"`
	ReplaceSeparatorsInPayload *bool                   `json:"replaceSeparatorsInPayload,omitempty"`
	TargetNamespace            *string                 `json:"targetNamespace,omitempty"`
}

// X12EnvelopeOverride is
type X12EnvelopeOverride struct {
	TargetNamespace          *string       `json:"targetNamespace,omitempty"`
	ProtocolVersion          *string       `json:"protocolVersion,omitempty"`
	MessageID                *string       `json:"messageId,omitempty"`
	ResponsibleAgencyCode    *int32        `json:"responsibleAgencyCode,omitempty"`
	HeaderVersion            *string       `json:"headerVersion,omitempty"`
	SenderApplicationID      *string       `json:"senderApplicationId,omitempty"`
	ReceiverApplicationID    *string       `json:"receiverApplicationId,omitempty"`
	FunctionalIdentifierCode *string       `json:"functionalIdentifierCode,omitempty"`
	DateFormat               X12DateFormat `json:"dateFormat,omitempty"`
	TimeFormat               X12TimeFormat `json:"timeFormat,omitempty"`
}

// X12EnvelopeSettings is
type X12EnvelopeSettings struct {
	ControlStandardsID                           *int32         `json:"controlStandardsId,omitempty"`
	UseControlStandardsIDAsRepetitionCharacter   *bool          `json:"useControlStandardsIdAsRepetitionCharacter,omitempty"`
	SenderApplicationID                          *string        `json:"senderApplicationId,omitempty"`
	ReceiverApplicationID                        *string        `json:"receiverApplicationId,omitempty"`
	ControlVersionNumber                         *string        `json:"controlVersionNumber,omitempty"`
	InterchangeControlNumberLowerBound           *int32         `json:"interchangeControlNumberLowerBound,omitempty"`
	InterchangeControlNumberUpperBound           *int32         `json:"interchangeControlNumberUpperBound,omitempty"`
	RolloverInterchangeControlNumber             *bool          `json:"rolloverInterchangeControlNumber,omitempty"`
	EnableDefaultGroupHeaders                    *bool          `json:"enableDefaultGroupHeaders,omitempty"`
	FunctionalGroupID                            *string        `json:"functionalGroupId,omitempty"`
	GroupControlNumberLowerBound                 *int32         `json:"groupControlNumberLowerBound,omitempty"`
	GroupControlNumberUpperBound                 *int32         `json:"groupControlNumberUpperBound,omitempty"`
	RolloverGroupControlNumber                   *bool          `json:"rolloverGroupControlNumber,omitempty"`
	GroupHeaderAgencyCode                        *string        `json:"groupHeaderAgencyCode,omitempty"`
	GroupHeaderVersion                           *string        `json:"groupHeaderVersion,omitempty"`
	TransactionSetControlNumberLowerBound        *int32         `json:"transactionSetControlNumberLowerBound,omitempty"`
	TransactionSetControlNumberUpperBound        *int32         `json:"transactionSetControlNumberUpperBound,omitempty"`
	RolloverTransactionSetControlNumber          *bool          `json:"rolloverTransactionSetControlNumber,omitempty"`
	TransactionSetControlNumberPrefix            *string        `json:"transactionSetControlNumberPrefix,omitempty"`
	TransactionSetControlNumberSuffix            *string        `json:"transactionSetControlNumberSuffix,omitempty"`
	OverwriteExistingTransactionSetControlNumber *bool          `json:"overwriteExistingTransactionSetControlNumber,omitempty"`
	GroupHeaderDateFormat                        X12DateFormat  `json:"groupHeaderDateFormat,omitempty"`
	GroupHeaderTimeFormat                        X12TimeFormat  `json:"groupHeaderTimeFormat,omitempty"`
	UsageIndicator                               UsageIndicator `json:"usageIndicator,omitempty"`
}

// X12FramingSettings is
type X12FramingSettings struct {
	DataElementSeparator       *int32                  `json:"dataElementSeparator,omitempty"`
	ComponentSeparator         *int32                  `json:"componentSeparator,omitempty"`
	ReplaceSeparatorsInPayload *bool                   `json:"replaceSeparatorsInPayload,omitempty"`
	ReplaceCharacter           *int32                  `json:"replaceCharacter,omitempty"`
	SegmentTerminator          *int32                  `json:"segmentTerminator,omitempty"`
	CharacterSet               X12CharacterSet         `json:"characterSet,omitempty"`
	SegmentTerminatorSuffix    SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
}

// X12MessageFilter is
type X12MessageFilter struct {
	MessageFilterType MessageFilterType `json:"messageFilterType,omitempty"`
}

// X12MessageIdentifier is
type X12MessageIdentifier struct {
	MessageID *string `json:"messageId,omitempty"`
}

// X12OneWayAgreement is
type X12OneWayAgreement struct {
	SenderBusinessIdentity   *BusinessIdentity    `json:"senderBusinessIdentity,omitempty"`
	ReceiverBusinessIdentity *BusinessIdentity    `json:"receiverBusinessIdentity,omitempty"`
	ProtocolSettings         *X12ProtocolSettings `json:"protocolSettings,omitempty"`
}

// X12ProcessingSettings is
type X12ProcessingSettings struct {
	MaskSecurityInfo                        *bool `json:"maskSecurityInfo,omitempty"`
	ConvertImpliedDecimal                   *bool `json:"convertImpliedDecimal,omitempty"`
	PreserveInterchange                     *bool `json:"preserveInterchange,omitempty"`
	SuspendInterchangeOnError               *bool `json:"suspendInterchangeOnError,omitempty"`
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`
	UseDotAsDecimalSeparator                *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// X12ProtocolSettings is
type X12ProtocolSettings struct {
	ValidationSettings      *X12ValidationSettings      `json:"validationSettings,omitempty"`
	FramingSettings         *X12FramingSettings         `json:"framingSettings,omitempty"`
	EnvelopeSettings        *X12EnvelopeSettings        `json:"envelopeSettings,omitempty"`
	AcknowledgementSettings *X12AcknowledgementSettings `json:"acknowledgementSettings,omitempty"`
	MessageFilter           *X12MessageFilter           `json:"messageFilter,omitempty"`
	SecuritySettings        *X12SecuritySettings        `json:"securitySettings,omitempty"`
	ProcessingSettings      *X12ProcessingSettings      `json:"processingSettings,omitempty"`
	EnvelopeOverrides       *[]X12EnvelopeOverride      `json:"envelopeOverrides,omitempty"`
	ValidationOverrides     *[]X12ValidationOverride    `json:"validationOverrides,omitempty"`
	MessageFilterList       *[]X12MessageIdentifier     `json:"messageFilterList,omitempty"`
	SchemaReferences        *[]X12SchemaReference       `json:"schemaReferences,omitempty"`
	X12DelimiterOverrides   *[]X12DelimiterOverrides    `json:"x12DelimiterOverrides,omitempty"`
}

// X12SchemaReference is
type X12SchemaReference struct {
	MessageID           *string `json:"messageId,omitempty"`
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	SchemaVersion       *string `json:"schemaVersion,omitempty"`
	SchemaName          *string `json:"schemaName,omitempty"`
}

// X12SecuritySettings is
type X12SecuritySettings struct {
	AuthorizationQualifier *string `json:"authorizationQualifier,omitempty"`
	AuthorizationValue     *string `json:"authorizationValue,omitempty"`
	SecurityQualifier      *string `json:"securityQualifier,omitempty"`
	PasswordValue          *string `json:"passwordValue,omitempty"`
}

// X12ValidationOverride is
type X12ValidationOverride struct {
	MessageID                              *string                 `json:"messageId,omitempty"`
	ValidateEDITypes                       *bool                   `json:"validateEDITypes,omitempty"`
	ValidateXSDTypes                       *bool                   `json:"validateXSDTypes,omitempty"`
	AllowLeadingAndTrailingSpacesAndZeroes *bool                   `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	ValidateCharacterSet                   *bool                   `json:"validateCharacterSet,omitempty"`
	TrimLeadingAndTrailingSpacesAndZeroes  *bool                   `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrailingSeparatorPolicy                TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}

// X12ValidationSettings is
type X12ValidationSettings struct {
	ValidateCharacterSet                      *bool                   `json:"validateCharacterSet,omitempty"`
	CheckDuplicateInterchangeControlNumber    *bool                   `json:"checkDuplicateInterchangeControlNumber,omitempty"`
	InterchangeControlNumberValidityDays      *int32                  `json:"interchangeControlNumberValidityDays,omitempty"`
	CheckDuplicateGroupControlNumber          *bool                   `json:"checkDuplicateGroupControlNumber,omitempty"`
	CheckDuplicateTransactionSetControlNumber *bool                   `json:"checkDuplicateTransactionSetControlNumber,omitempty"`
	ValidateEDITypes                          *bool                   `json:"validateEDITypes,omitempty"`
	ValidateXSDTypes                          *bool                   `json:"validateXSDTypes,omitempty"`
	AllowLeadingAndTrailingSpacesAndZeroes    *bool                   `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrimLeadingAndTrailingSpacesAndZeroes     *bool                   `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrailingSeparatorPolicy                   TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}
