/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DatanodeBlockInfo;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;
import org.mortbay.log.Log;

public class FSDataset
implements FSConstants,
FSDatasetInterface {
    public static final String METADATA_EXTENSION = ".meta";
    public static final short METADATA_VERSION = 1;
    FSVolumeSet volumes;
    private HashMap<Block, ActiveFile> ongoingCreates = new HashMap();
    private int maxBlocksPerDir = 0;
    HashMap<Block, DatanodeBlockInfo> volumeMap = new HashMap();
    static Random random = new Random();
    private int validVolsRequired;
    private static final String DISK_ERROR = "Possible disk error on file creation: ";
    private ObjectName mbeanName;
    private Random rand = new Random();

    private static long getGenerationStampFromFile(File[] listdir, File blockFile) {
        String blockName = blockFile.getName();
        for (int j = 0; j < listdir.length; ++j) {
            String[] str;
            String[] vals;
            String path = listdir[j].getName();
            if (!path.startsWith(blockName) || (vals = path.split("_")).length != 3 || (str = vals[2].split("\\.")).length != 2) continue;
            return Long.parseLong(str[0]);
        }
        DataNode.LOG.warn((Object)("Block " + blockFile + " does not have a metafile!"));
        return 0L;
    }

    static String getMetaFileName(String blockFileName, long genStamp) {
        return blockFileName + "_" + genStamp + METADATA_EXTENSION;
    }

    static File getMetaFile(File f, Block b) {
        return new File(FSDataset.getMetaFileName(f.getAbsolutePath(), b.getGenerationStamp()));
    }

    protected File getMetaFile(Block b) throws IOException {
        return FSDataset.getMetaFile(this.getBlockFile(b), b);
    }

    public static File findMetaFile(File blockFile) throws IOException {
        final String prefix = blockFile.getName() + "_";
        final File parent = blockFile.getParentFile();
        File[] matches = parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.equals(parent) && name.startsWith(prefix) && name.endsWith(FSDataset.METADATA_EXTENSION);
            }
        });
        if (matches == null || matches.length == 0) {
            throw new IOException("Meta file not found, blockFile=" + blockFile);
        }
        if (matches.length > 1) {
            throw new IOException("Found more than one meta files: " + Arrays.asList(matches));
        }
        return matches[0];
    }

    private static long parseGenerationStamp(File blockFile, File metaFile) throws IOException {
        String metaname = metaFile.getName();
        String gs = metaname.substring(blockFile.getName().length() + 1, metaname.length() - METADATA_EXTENSION.length());
        try {
            return Long.parseLong(gs);
        }
        catch (NumberFormatException nfe) {
            throw (IOException)new IOException("blockFile=" + blockFile + ", metaFile=" + metaFile).initCause(nfe);
        }
    }

    public synchronized File findBlockFile(long blockId) {
        Block b = new Block(blockId);
        File blockfile = null;
        ActiveFile activefile = this.ongoingCreates.get(b);
        if (activefile != null) {
            blockfile = activefile.file;
        }
        if (blockfile == null) {
            blockfile = this.getFile(b);
        }
        if (blockfile == null && DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug((Object)("ongoingCreates=" + this.ongoingCreates));
            DataNode.LOG.debug((Object)("volumeMap=" + this.volumeMap));
        }
        return blockfile;
    }

    @Override
    public synchronized Block getStoredBlock(long blkid) throws IOException {
        File blockfile = this.findBlockFile(blkid);
        if (blockfile == null) {
            return null;
        }
        File metafile = FSDataset.findMetaFile(blockfile);
        Block block = new Block(blkid);
        return new Block(blkid, this.getVisibleLength(block), FSDataset.parseGenerationStamp(blockfile, metafile));
    }

    @Override
    public boolean metaFileExists(Block b) throws IOException {
        return this.getMetaFile(b).exists();
    }

    @Override
    public long getMetaDataLength(Block b) throws IOException {
        File checksumFile = this.getMetaFile(b);
        return checksumFile.length();
    }

    @Override
    public FSDatasetInterface.MetaDataInputStream getMetaDataInputStream(Block b) throws IOException {
        File checksumFile = this.getMetaFile(b);
        return new FSDatasetInterface.MetaDataInputStream(new FileInputStream(checksumFile), checksumFile.length());
    }

    public FSDataset(DataStorage storage, Configuration conf) throws IOException {
        int volsFailed;
        this.maxBlocksPerDir = conf.getInt("dfs.datanode.numblocks", 64);
        int volFailuresTolerated = conf.getInt("dfs.datanode.failed.volumes.tolerated", 0);
        String[] dataDirs = conf.getStrings("dfs.data.dir");
        int volsConfigured = 0;
        if (dataDirs != null) {
            volsConfigured = dataDirs.length;
        }
        if ((volsFailed = volsConfigured - storage.getNumStorageDirs()) < 0 || volsFailed > volFailuresTolerated) {
            throw new DiskChecker.DiskErrorException("Invalid value for volsFailed : " + volsFailed + " , Volumes tolerated : " + volFailuresTolerated);
        }
        this.validVolsRequired = volsConfigured - volFailuresTolerated;
        if (this.validVolsRequired < 1 || this.validVolsRequired > storage.getNumStorageDirs()) {
            throw new DiskChecker.DiskErrorException("Invalid value for validVolsRequired : " + this.validVolsRequired + " , Current valid volumes: " + storage.getNumStorageDirs());
        }
        FSVolume[] volArray = new FSVolume[storage.getNumStorageDirs()];
        for (int idx = 0; idx < storage.getNumStorageDirs(); ++idx) {
            volArray[idx] = new FSVolume(storage.getStorageDir(idx).getCurrentDir(), conf);
        }
        this.volumes = new FSVolumeSet(volArray);
        this.volumes.getVolumeMap(this.volumeMap);
        this.registerMBean(storage.getStorageID());
    }

    @Override
    public long getDfsUsed() throws IOException {
        return this.volumes.getDfsUsed();
    }

    @Override
    public boolean hasEnoughResource() {
        return this.volumes.numberOfVolumes() >= this.validVolsRequired;
    }

    @Override
    public long getCapacity() throws IOException {
        return this.volumes.getCapacity();
    }

    @Override
    public long getRemaining() throws IOException {
        return this.volumes.getRemaining();
    }

    @Override
    public long getLength(Block b) throws IOException {
        return this.getBlockFile(b).length();
    }

    @Override
    public synchronized long getVisibleLength(Block b) throws IOException {
        ActiveFile activeFile = this.ongoingCreates.get(b);
        if (activeFile != null) {
            return activeFile.getVisibleLength();
        }
        return this.getLength(b);
    }

    @Override
    public synchronized void setVisibleLength(Block b, long length) throws IOException {
        ActiveFile activeFile = this.ongoingCreates.get(b);
        if (activeFile == null) {
            throw new IOException(String.format("block %s is not being written to", b));
        }
        activeFile.setVisibleLength(length);
    }

    public synchronized File getBlockFile(Block b) throws IOException {
        File f = this.validateBlockFile(b);
        if (f == null) {
            if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
                InterDatanodeProtocol.LOG.debug((Object)("b=" + b + ", volumeMap=" + this.volumeMap));
            }
            throw new IOException("Block " + b + " is not valid.");
        }
        return f;
    }

    @Override
    public synchronized InputStream getBlockInputStream(Block b) throws IOException {
        return new FileInputStream(this.getBlockFile(b));
    }

    @Override
    public synchronized InputStream getBlockInputStream(Block b, long seekOffset) throws IOException {
        File blockFile = this.getBlockFile(b);
        RandomAccessFile blockInFile = new RandomAccessFile(blockFile, "r");
        if (seekOffset > 0L) {
            blockInFile.seek(seekOffset);
        }
        return new FileInputStream(blockInFile.getFD());
    }

    @Override
    public synchronized FSDatasetInterface.BlockInputStreams getTmpInputStreams(Block b, long blkOffset, long ckoff) throws IOException {
        DatanodeBlockInfo info = this.volumeMap.get(b);
        if (info == null) {
            throw new IOException("Block " + b + " does not exist in volumeMap.");
        }
        FSVolume v = info.getVolume();
        File blockFile = info.getFile();
        if (blockFile == null) {
            blockFile = v.getTmpFile(b);
        }
        RandomAccessFile blockInFile = new RandomAccessFile(blockFile, "r");
        if (blkOffset > 0L) {
            blockInFile.seek(blkOffset);
        }
        File metaFile = FSDataset.getMetaFile(blockFile, b);
        RandomAccessFile metaInFile = new RandomAccessFile(metaFile, "r");
        if (ckoff > 0L) {
            metaInFile.seek(ckoff);
        }
        return new FSDatasetInterface.BlockInputStreams(new FileInputStream(blockInFile.getFD()), new FileInputStream(metaInFile.getFD()));
    }

    private FSDatasetInterface.BlockWriteStreams createBlockWriteStreams(File f, File metafile) throws IOException {
        return new FSDatasetInterface.BlockWriteStreams(new FileOutputStream(new RandomAccessFile(f, "rw").getFD()), new FileOutputStream(new RandomAccessFile(metafile, "rw").getFD()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detachBlock(Block block, int numLinks) throws IOException {
        DatanodeBlockInfo info = null;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            info = this.volumeMap.get(block);
        }
        return info.detachBlock(block, numLinks);
    }

    private static <T> void updateBlockMap(Map<Block, T> blockmap, Block oldblock, Block newblock) throws IOException {
        if (blockmap.containsKey(oldblock)) {
            T value = blockmap.remove(oldblock);
            blockmap.put(newblock, value);
        }
    }

    @Override
    public void updateBlock(Block oldblock, Block newblock) throws IOException {
        boolean isValidUpdate;
        if (oldblock.getBlockId() != newblock.getBlockId()) {
            throw new IOException("Cannot update oldblock (=" + oldblock + ") to newblock (=" + newblock + ").");
        }
        boolean bl = isValidUpdate = newblock.getGenerationStamp() > oldblock.getGenerationStamp() || newblock.getGenerationStamp() == oldblock.getGenerationStamp() && newblock.getNumBytes() == oldblock.getNumBytes();
        if (!isValidUpdate) {
            throw new IOException("Cannot update oldblock=" + oldblock + " to newblock=" + newblock + " since generation stamps must " + "increase, or else length must not change.");
        }
        List<Thread> threads;
        while ((threads = this.tryUpdateBlock(oldblock, newblock)) != null) {
            this.interruptAndJoinThreads(threads);
        }
        return;
    }

    private boolean interruptAndJoinThreads(List<Thread> threads) {
        for (Thread t : threads) {
            t.interrupt();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                DataNode.LOG.warn((Object)("interruptOngoingCreates: t=" + t), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private synchronized ArrayList<Thread> getActiveThreads(Block block) {
        ActiveFile activefile = this.ongoingCreates.get(block);
        if (activefile != null && !activefile.threads.isEmpty()) {
            Iterator<Thread> i = activefile.threads.iterator();
            while (i.hasNext()) {
                Thread t = i.next();
                if (t.isAlive()) continue;
                i.remove();
            }
            if (!activefile.threads.isEmpty()) {
                return new ArrayList<Thread>(activefile.threads);
            }
        }
        return null;
    }

    private synchronized List<Thread> tryUpdateBlock(Block oldblock, Block newblock) throws IOException {
        File newMetaFile;
        ArrayList<Thread> activeThreads = this.getActiveThreads(oldblock);
        if (activeThreads != null) {
            return activeThreads;
        }
        File blockFile = this.findBlockFile(oldblock.getBlockId());
        if (blockFile == null) {
            throw new IOException("Block " + oldblock + " does not exist.");
        }
        File oldMetaFile = FSDataset.findMetaFile(blockFile);
        long oldgs = FSDataset.parseGenerationStamp(blockFile, oldMetaFile);
        if (oldgs > newblock.getGenerationStamp()) {
            throw new IOException("Cannot update block (id=" + newblock.getBlockId() + ") generation stamp from " + oldgs + " to " + newblock.getGenerationStamp());
        }
        if (newblock.getNumBytes() > oldblock.getNumBytes()) {
            throw new IOException("Cannot update block file (=" + blockFile + ") length from " + oldblock.getNumBytes() + " to " + newblock.getNumBytes());
        }
        File tmpMetaFile = new File(oldMetaFile.getParent(), oldMetaFile.getName() + "_tmp" + newblock.getGenerationStamp());
        if (!oldMetaFile.renameTo(tmpMetaFile)) {
            throw new IOException("Cannot rename block meta file to " + tmpMetaFile);
        }
        if (newblock.getNumBytes() < oldblock.getNumBytes()) {
            FSDataset.truncateBlock(blockFile, tmpMetaFile, oldblock.getNumBytes(), newblock.getNumBytes());
        }
        if (!tmpMetaFile.renameTo(newMetaFile = FSDataset.getMetaFile(blockFile, newblock))) {
            throw new IOException("Cannot rename tmp meta file to " + newMetaFile);
        }
        FSDataset.updateBlockMap(this.ongoingCreates, oldblock, newblock);
        FSDataset.updateBlockMap(this.volumeMap, oldblock, newblock);
        this.validateBlockMetadata(newblock);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void truncateBlock(File blockFile, File metaFile, long oldlen, long newlen) throws IOException {
        if (newlen == oldlen) {
            return;
        }
        if (newlen > oldlen) {
            throw new IOException("Cannot truncate block to from oldlen (=" + oldlen + ") to newlen (=" + newlen + ")");
        }
        if (newlen == 0L) {
            RandomAccessFile blockRAF = new RandomAccessFile(blockFile, "rw");
            try {
                blockRAF.setLength(newlen);
            }
            finally {
                blockRAF.close();
            }
            RandomAccessFile metaRAF = new RandomAccessFile(metaFile, "rw");
            try {
                metaRAF.setLength(BlockMetadataHeader.getHeaderSize());
            }
            finally {
                metaRAF.close();
            }
            return;
        }
        DataChecksum dcs = BlockMetadataHeader.readHeader(metaFile).getChecksum();
        int checksumsize = dcs.getChecksumSize();
        int bpc = dcs.getBytesPerChecksum();
        long newChunkCount = (newlen - 1L) / (long)bpc + 1L;
        long newmetalen = (long)BlockMetadataHeader.getHeaderSize() + newChunkCount * (long)checksumsize;
        long lastchunkoffset = (newChunkCount - 1L) * (long)bpc;
        int lastchunksize = (int)(newlen - lastchunkoffset);
        byte[] b = new byte[Math.max(lastchunksize, checksumsize)];
        RandomAccessFile blockRAF = new RandomAccessFile(blockFile, "rw");
        try {
            blockRAF.setLength(newlen);
            blockRAF.seek(lastchunkoffset);
            blockRAF.readFully(b, 0, lastchunksize);
        }
        finally {
            blockRAF.close();
        }
        dcs.update(b, 0, lastchunksize);
        dcs.writeValue(b, 0, false);
        RandomAccessFile metaRAF = new RandomAccessFile(metaFile, "rw");
        try {
            metaRAF.setLength(newmetalen);
            metaRAF.seek(newmetalen - (long)checksumsize);
            metaRAF.write(b, 0, checksumsize);
        }
        finally {
            metaRAF.close();
        }
    }

    static IOException getCauseIfDiskError(IOException ioe) {
        if (ioe.getMessage() != null && ioe.getMessage().startsWith(DISK_ERROR)) {
            return (IOException)ioe.getCause();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FSDatasetInterface.BlockWriteStreams writeToBlock(Block b, boolean isRecovery, boolean replicationRequest) throws IOException {
        if (this.isValidBlock(b)) {
            if (!isRecovery) {
                throw new BlockAlreadyExistsException("Block " + b + " is valid, and cannot be written to.");
            }
            this.detachBlock(b, 1);
        }
        long blockSize = b.getNumBytes();
        File f = null;
        List<Thread> threads = null;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            ActiveFile activeFile = this.ongoingCreates.get(b);
            if (activeFile != null) {
                f = activeFile.file;
                threads = activeFile.threads;
                if (!isRecovery) {
                    throw new BlockAlreadyExistsException("Block " + b + " has already been started (though not completed), and thus cannot be created.");
                }
                for (Thread thread : threads) {
                    thread.interrupt();
                }
                this.ongoingCreates.remove(b);
            }
            FSVolume v = null;
            if (!isRecovery) {
                v = this.volumes.getNextVolume(blockSize);
                f = this.createTmpFile(v, b, replicationRequest);
            } else if (f != null) {
                DataNode.LOG.info((Object)("Reopen already-open Block for append " + b));
                v = this.volumeMap.get(b).getVolume();
                this.volumeMap.put(b, new DatanodeBlockInfo(v, f));
            } else {
                DataNode.LOG.info((Object)("Reopen Block for append " + b));
                v = this.volumeMap.get(b).getVolume();
                f = this.createTmpFile(v, b, replicationRequest);
                File blkfile = this.getBlockFile(b);
                File oldmeta = this.getMetaFile(b);
                File newmeta = FSDataset.getMetaFile(f, b);
                DataNode.LOG.debug((Object)("Renaming " + oldmeta + " to " + newmeta));
                if (!oldmeta.renameTo(newmeta)) {
                    throw new IOException("Block " + b + " reopen failed. " + " Unable to move meta file  " + oldmeta + " to tmp dir " + newmeta);
                }
                DataNode.LOG.debug((Object)("Renaming " + blkfile + " to " + f));
                if (!blkfile.renameTo(f)) {
                    if (!f.delete()) {
                        throw new IOException("Block " + b + " reopen failed. " + " Unable to remove file " + f);
                    }
                    if (!blkfile.renameTo(f)) {
                        throw new IOException("Block " + b + " reopen failed. " + " Unable to move block file " + blkfile + " to tmp dir " + f);
                    }
                }
            }
            if (f == null) {
                DataNode.LOG.warn((Object)("Block " + b + " reopen failed " + " Unable to locate tmp file."));
                throw new IOException("Block " + b + " reopen failed " + " Unable to locate tmp file.");
            }
            if (replicationRequest) {
                this.volumeMap.put(b, new DatanodeBlockInfo(v));
            } else {
                this.volumeMap.put(b, new DatanodeBlockInfo(v, f));
            }
            this.ongoingCreates.put(b, new ActiveFile(f, threads));
        }
        try {
            if (threads != null) {
                for (Thread thread : threads) {
                    thread.join();
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Recovery waiting for thread interrupted.");
        }
        File metafile = FSDataset.getMetaFile(f, b);
        DataNode.LOG.debug((Object)("writeTo blockfile is " + f + " of size " + f.length()));
        DataNode.LOG.debug((Object)("writeTo metafile is " + metafile + " of size " + metafile.length()));
        return this.createBlockWriteStreams(f, metafile);
    }

    @Override
    public long getChannelPosition(Block b, FSDatasetInterface.BlockWriteStreams streams) throws IOException {
        FileOutputStream file = (FileOutputStream)streams.dataOut;
        return file.getChannel().position();
    }

    @Override
    public void setChannelPosition(Block b, FSDatasetInterface.BlockWriteStreams streams, long dataOffset, long ckOffset) throws IOException {
        FileOutputStream file = (FileOutputStream)streams.dataOut;
        if (file.getChannel().size() < dataOffset) {
            String msg = "Trying to change block file offset of block " + b + " file " + this.volumeMap.get(b).getVolume().getTmpFile(b) + " to " + dataOffset + " but actual size of file is " + file.getChannel().size();
            throw new IOException(msg);
        }
        file.getChannel().position(dataOffset);
        file = (FileOutputStream)streams.checksumOut;
        file.getChannel().position(ckOffset);
    }

    synchronized File createTmpFile(FSVolume vol, Block blk, boolean replicationRequest) throws IOException {
        if (vol == null && (vol = this.volumeMap.get(blk).getVolume()) == null) {
            throw new IOException("Could not find volume for block " + blk);
        }
        return vol.createTmpFile(blk, replicationRequest);
    }

    @Override
    public void finalizeBlock(Block b) throws IOException {
        this.finalizeBlockInternal(b, false);
    }

    @Override
    public void finalizeBlockIfNeeded(Block b) throws IOException {
        this.finalizeBlockInternal(b, true);
    }

    private synchronized void finalizeBlockInternal(Block b, boolean reFinalizeOk) throws IOException {
        ActiveFile activeFile = this.ongoingCreates.get(b);
        if (activeFile == null) {
            if (reFinalizeOk) {
                return;
            }
            throw new IOException("Block " + b + " is already finalized.");
        }
        File f = activeFile.file;
        if (f == null || !f.exists()) {
            throw new IOException("No temporary file " + f + " for block " + b);
        }
        FSVolume v = this.volumeMap.get(b).getVolume();
        if (v == null) {
            throw new IOException("No volume for temporary file " + f + " for block " + b);
        }
        File dest = null;
        dest = v.addBlock(b, f);
        this.volumeMap.put(b, new DatanodeBlockInfo(v, dest));
        this.ongoingCreates.remove(b);
    }

    private synchronized boolean isFinalized(Block b) {
        FSVolume v = this.volumeMap.get(b).getVolume();
        if (v == null) {
            DataNode.LOG.warn((Object)("No volume for block " + b));
            return false;
        }
        ActiveFile activeFile = this.ongoingCreates.get(b);
        if (activeFile == null) {
            return true;
        }
        File f = activeFile.file;
        if (f == null || !f.exists()) {
            DataNode.LOG.warn((Object)("No temporary file " + f + " for block " + b));
        }
        return false;
    }

    @Override
    public synchronized void unfinalizeBlock(Block b) throws IOException {
        ActiveFile activefile = this.ongoingCreates.remove(b);
        if (activefile == null) {
            return;
        }
        this.volumeMap.remove(b);
        if (this.delBlockFromDisk(activefile.file, FSDataset.getMetaFile(activefile.file, b), b)) {
            DataNode.LOG.warn((Object)("Block " + b + " unfinalized and removed. "));
        }
    }

    private boolean delBlockFromDisk(File blockFile, File metaFile, Block b) {
        if (blockFile == null) {
            DataNode.LOG.warn((Object)("No file exists for block: " + b));
            return true;
        }
        if (!blockFile.delete()) {
            DataNode.LOG.warn((Object)("Not able to delete the block file: " + blockFile));
            return false;
        }
        if (metaFile != null && !metaFile.delete()) {
            DataNode.LOG.warn((Object)("Not able to delete the meta block file: " + metaFile));
            return false;
        }
        return true;
    }

    @Override
    public Block[] getBlocksBeingWrittenReport() {
        TreeSet<Block> blockSet = new TreeSet<Block>();
        this.volumes.getBlocksBeingWrittenInfo(blockSet);
        Block[] blockTable = new Block[blockSet.size()];
        int i = 0;
        Iterator<Block> it = blockSet.iterator();
        while (it.hasNext()) {
            blockTable[i] = it.next();
            ++i;
        }
        return blockTable;
    }

    @Override
    public Block[] getBlockReport() {
        TreeSet<Block> blockSet = new TreeSet<Block>();
        this.volumes.getBlockInfo(blockSet);
        Block[] blockTable = new Block[blockSet.size()];
        int i = 0;
        Iterator<Block> it = blockSet.iterator();
        while (it.hasNext()) {
            blockTable[i] = it.next();
            ++i;
        }
        return blockTable;
    }

    @Override
    public boolean isValidBlock(Block b) {
        File f = null;
        try {
            f = this.validateBlockFile(b);
        }
        catch (IOException e) {
            Log.warn((String)("Block " + b + " is not valid:"), (Throwable)e);
        }
        return f != null ? this.isFinalized(b) : false;
    }

    File validateBlockFile(Block b) throws IOException {
        File f = this.getFile(b);
        if (f != null) {
            if (f.exists()) {
                return f;
            }
            DataNode datanode = DataNode.getDataNode();
            datanode.checkDiskError();
        }
        if (InterDatanodeProtocol.LOG.isDebugEnabled()) {
            InterDatanodeProtocol.LOG.debug((Object)("b=" + b + ", f=" + f));
        }
        return null;
    }

    @Override
    public synchronized void validateBlockMetadata(Block b) throws IOException {
        DatanodeBlockInfo info = this.volumeMap.get(b);
        if (info == null) {
            throw new IOException("Block " + b + " does not exist in volumeMap.");
        }
        FSVolume v = info.getVolume();
        File tmp = v.getTmpFile(b);
        File f = this.getFile(b);
        if (f == null) {
            f = tmp;
        }
        if (f == null) {
            throw new IOException("Block " + b + " does not exist on disk.");
        }
        if (!f.exists()) {
            throw new IOException("Block " + b + " block file " + f + " does not exist on disk.");
        }
        if (b.getNumBytes() != f.length()) {
            throw new IOException("Block " + b + " length is " + b.getNumBytes() + " does not match block file length " + f.length());
        }
        File meta = FSDataset.getMetaFile(f, b);
        if (meta == null) {
            throw new IOException("Block " + b + " metafile does not exist.");
        }
        if (!meta.exists()) {
            throw new IOException("Block " + b + " metafile " + meta + " does not exist on disk.");
        }
        if (meta.length() == 0L) {
            throw new IOException("Block " + b + " metafile " + meta + " is empty.");
        }
        long stamp = FSDataset.parseGenerationStamp(f, meta);
        if (stamp != b.getGenerationStamp()) {
            throw new IOException("Block " + b + " genstamp is " + b.getGenerationStamp() + " does not match meta file stamp " + stamp);
        }
        DataChecksum dcs = BlockMetadataHeader.readHeader(meta).getChecksum();
        int checksumsize = dcs.getChecksumSize();
        long actual = meta.length() - (long)BlockMetadataHeader.getHeaderSize();
        long numChunksInMeta = actual / (long)checksumsize;
        if (actual % (long)checksumsize != 0L) {
            throw new IOException("Block " + b + " has a checksum file of size " + meta.length() + " but it does not align with checksum size of " + checksumsize);
        }
        int bpc = dcs.getBytesPerChecksum();
        long minDataSize = (numChunksInMeta - 1L) * (long)bpc;
        long maxDataSize = numChunksInMeta * (long)bpc;
        if (f.length() > maxDataSize || f.length() <= minDataSize) {
            throw new IOException("Block " + b + " is of size " + f.length() + " but has " + (numChunksInMeta + 1L) + " checksums and each checksum size is " + checksumsize + " bytes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Block[] invalidBlks) throws IOException {
        boolean error = false;
        for (int i = 0; i < invalidBlks.length; ++i) {
            FSVolume v;
            File f = null;
            FSDataset fSDataset = this;
            synchronized (fSDataset) {
                f = this.getFile(invalidBlks[i]);
                DatanodeBlockInfo dinfo = this.volumeMap.get(invalidBlks[i]);
                if (dinfo == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". BlockInfo not found in volumeMap."));
                    error = true;
                    continue;
                }
                v = dinfo.getVolume();
                if (f == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". Block not found in blockMap." + (v == null ? " " : " Block found in volumeMap.")));
                    error = true;
                    continue;
                }
                if (v == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". No volume for this block." + " Block found in blockMap. " + f + "."));
                    error = true;
                    continue;
                }
                File parent = f.getParentFile();
                if (parent == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". Parent not found for file " + f + "."));
                    error = true;
                    continue;
                }
                v.clearPath(parent);
                this.volumeMap.remove(invalidBlks[i]);
            }
            File metaFile = FSDataset.getMetaFile(f, invalidBlks[i]);
            long blockSize = f.length() + metaFile.length();
            if (!f.delete() || !metaFile.delete() && metaFile.exists()) {
                DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + " at file " + f));
                error = true;
                continue;
            }
            v.decDfsUsed(blockSize);
            DataNode.LOG.info((Object)("Deleting block " + invalidBlks[i] + " file " + f));
            if (!f.exists()) continue;
            DataNode.LOG.info((Object)("File " + f + " was deleted but still exists!"));
        }
        if (error) {
            throw new IOException("Error in deleting blocks.");
        }
    }

    public synchronized File getFile(Block b) {
        DatanodeBlockInfo info = this.volumeMap.get(b);
        if (info != null) {
            return info.getFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkDataDir() throws DiskChecker.DiskErrorException {
        long total_blocks = 0L;
        long removed_blocks = 0L;
        List<FSVolume> failed_vols = this.volumes.checkDirs();
        if (failed_vols == null) {
            return;
        }
        long mlsec = System.currentTimeMillis();
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            Iterator<Block> ib = this.volumeMap.keySet().iterator();
            block3: while (ib.hasNext()) {
                Block b = ib.next();
                ++total_blocks;
                FSVolume vol = this.volumeMap.get(b).getVolume();
                for (FSVolume fv : failed_vols) {
                    if (vol != fv) continue;
                    DataNode.LOG.warn((Object)("removing block " + b.getBlockId() + " from vol " + ((FSVolume)vol).dataDir.dir.getAbsolutePath()));
                    ib.remove();
                    ++removed_blocks;
                    continue block3;
                }
            }
        }
        mlsec = System.currentTimeMillis() - mlsec;
        DataNode.LOG.warn((Object)(">>>>>>>>>>>>Removed " + removed_blocks + " out of " + total_blocks + "(took " + mlsec + " millisecs)"));
        StringBuilder sb = new StringBuilder();
        for (FSVolume fv : failed_vols) {
            sb.append(((FSVolume)fv).dataDir.dir.getAbsolutePath() + ";");
        }
        throw new DiskChecker.DiskErrorException("DataNode failed volumes:" + sb);
    }

    @Override
    public String toString() {
        return "FSDataset{dirpath='" + this.volumes + "'}";
    }

    void registerMBean(String storageId) {
        String storageName = storageId == null || storageId.equals("") ? "UndefinedStorageId" + this.rand.nextInt() : storageId;
        try {
            StandardMBean bean = new StandardMBean(this, FSDatasetMBean.class);
            this.mbeanName = MBeans.register("DataNode", "FSDatasetState-" + storageName, bean);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        DataNode.LOG.info((Object)"Registered FSDatasetStatusMBean");
    }

    @Override
    public void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister(this.mbeanName);
        }
        if (this.volumes != null) {
            for (FSVolume volume : this.volumes.volumes) {
                if (volume == null) continue;
                volume.dfsUsage.shutdown();
            }
        }
    }

    @Override
    public String getStorageInfo() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Collection<VolumeInfo> getVolumeInfo() {
        ArrayList<VolumeInfo> info = new ArrayList<VolumeInfo>();
        FSVolume[] fSVolumeArray = this.volumes.volumes;
        synchronized (this.volumes.volumes) {
            for (FSVolume volume : this.volumes.volumes) {
                long used = 0L;
                try {
                    used = volume.getDfsUsed();
                }
                catch (IOException e) {
                    DataNode.LOG.warn((Object)e.getMessage());
                }
                long free = 0L;
                try {
                    free = volume.getAvailable();
                }
                catch (IOException e) {
                    DataNode.LOG.warn((Object)e.getMessage());
                }
                info.add(new VolumeInfo(volume.toString(), used, free, volume.getReserved()));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockRecoveryInfo startBlockRecovery(long blockId) throws IOException {
        ArrayList<Thread> activeThreads;
        Block stored = this.getStoredBlock(blockId);
        if (stored == null) {
            return null;
        }
        do {
            DataNode.LOG.debug((Object)("Interrupting active writer threads for block " + stored));
        } while ((activeThreads = this.getActiveThreads(stored)) != null && !this.interruptAndJoinThreads(activeThreads));
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            ActiveFile activeFile = this.ongoingCreates.get(stored);
            boolean isRecovery = activeFile != null && activeFile.wasRecoveredOnStartup;
            BlockRecoveryInfo info = new BlockRecoveryInfo(stored, isRecovery);
            if (DataNode.LOG.isDebugEnabled()) {
                DataNode.LOG.debug((Object)("getBlockMetaDataInfo successful block=" + stored + " length " + stored.getNumBytes() + " genstamp " + stored.getGenerationStamp()));
            }
            this.validateBlockMetadata(stored);
            return info;
        }
    }

    static class VolumeInfo {
        final String directory;
        final long usedSpace;
        final long freeSpace;
        final long reservedSpace;

        VolumeInfo(String dir, long usedSpace, long freeSpace, long reservedSpace) {
            this.directory = dir;
            this.usedSpace = usedSpace;
            this.freeSpace = freeSpace;
            this.reservedSpace = reservedSpace;
        }
    }

    static class ActiveFile {
        final File file;
        final List<Thread> threads = new ArrayList<Thread>(2);
        private volatile long visibleLength;
        final boolean wasRecoveredOnStartup;

        ActiveFile(File f, List<Thread> list) {
            this(f, false);
            if (list != null) {
                this.threads.addAll(list);
            }
            this.threads.add(Thread.currentThread());
        }

        public static ActiveFile createStartupRecoveryFile(File f) {
            return new ActiveFile(f, true);
        }

        private ActiveFile(File f, boolean recovery) {
            this.file = f;
            this.visibleLength = f.length();
            this.wasRecoveredOnStartup = recovery;
        }

        public long getVisibleLength() {
            return this.visibleLength;
        }

        public void setVisibleLength(long value) {
            this.visibleLength = value;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(file=" + this.file + ", threads=" + this.threads + ")";
        }
    }

    static class FSVolumeSet {
        FSVolume[] volumes = null;
        int curVolume = 0;

        FSVolumeSet(FSVolume[] volumes) {
            this.volumes = volumes;
        }

        private int numberOfVolumes() {
            return this.volumes.length;
        }

        synchronized FSVolume getNextVolume(long blockSize) throws IOException {
            if (this.volumes.length < 1) {
                throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
            }
            if (this.curVolume >= this.volumes.length) {
                this.curVolume = 0;
            }
            int startVolume = this.curVolume;
            do {
                FSVolume volume = this.volumes[this.curVolume];
                this.curVolume = (this.curVolume + 1) % this.volumes.length;
                if (volume.getAvailable() <= blockSize) continue;
                return volume;
            } while (this.curVolume != startVolume);
            throw new DiskChecker.DiskOutOfSpaceException("Insufficient space for an additional block");
        }

        long getDfsUsed() throws IOException {
            long dfsUsed = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                dfsUsed += this.volumes[idx].getDfsUsed();
            }
            return dfsUsed;
        }

        synchronized long getCapacity() throws IOException {
            long capacity = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                capacity += this.volumes[idx].getCapacity();
            }
            return capacity;
        }

        synchronized long getRemaining() throws IOException {
            long remaining = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                remaining += this.volumes[idx].getAvailable();
            }
            return remaining;
        }

        synchronized void getBlockInfo(TreeSet<Block> blockSet) {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getBlockInfo(blockSet);
            }
        }

        synchronized void getVolumeMap(HashMap<Block, DatanodeBlockInfo> volumeMap) {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getVolumeMap(volumeMap);
            }
        }

        synchronized void getBlocksBeingWrittenInfo(TreeSet<Block> blockSet) {
            long startTime = System.currentTimeMillis();
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getBlocksBeingWrittenInfo(blockSet);
            }
            long scanTime = (System.currentTimeMillis() - startTime) / 1000L;
            DataNode.LOG.info((Object)("Finished generating blocks being written report for " + this.volumes.length + " volumes in " + scanTime + " seconds"));
        }

        synchronized List<FSVolume> checkDirs() {
            int removed_size;
            ArrayList<FSVolume> removed_vols = null;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                FSVolume fsv = this.volumes[idx];
                try {
                    fsv.checkDirs();
                    continue;
                }
                catch (DiskChecker.DiskErrorException e) {
                    DataNode.LOG.warn((Object)("Removing failed volume " + fsv + ": "), (Throwable)e);
                    if (removed_vols == null) {
                        removed_vols = new ArrayList<FSVolume>(1);
                    }
                    removed_vols.add(this.volumes[idx]);
                    this.volumes[idx].dfsUsage.shutdown();
                    this.volumes[idx] = null;
                }
            }
            int n = removed_size = removed_vols == null ? 0 : removed_vols.size();
            if (removed_size > 0) {
                FSVolume[] fsvs = new FSVolume[this.volumes.length - removed_size];
                int idy = 0;
                for (int idx = 0; idx < this.volumes.length; ++idx) {
                    if (this.volumes[idx] == null) continue;
                    fsvs[idy] = this.volumes[idx];
                    ++idy;
                }
                this.volumes = fsvs;
            }
            Log.info((String)("Completed FSVolumeSet.checkDirs. Removed=" + removed_size + "volumes. List of current volumes: " + this.toString()));
            return removed_vols;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                sb.append(this.volumes[idx].toString());
                if (idx == this.volumes.length - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
    }

    class FSVolume {
        private FSDir dataDir;
        private File tmpDir;
        private File blocksBeingWritten;
        private File detachDir;
        private DF usage;
        private DU dfsUsage;
        private long reserved;

        FSVolume(File currentDir, Configuration conf) throws IOException {
            this.reserved = conf.getLong("dfs.datanode.du.reserved", 0L);
            this.dataDir = new FSDir(currentDir);
            boolean supportAppends = conf.getBoolean("dfs.support.append", false);
            File parent = currentDir.getParentFile();
            this.detachDir = new File(parent, "detach");
            if (this.detachDir.exists()) {
                this.recoverDetachedBlocks(currentDir, this.detachDir);
            }
            this.tmpDir = new File(parent, "tmp");
            if (this.tmpDir.exists()) {
                FileUtil.fullyDelete(this.tmpDir);
            }
            this.blocksBeingWritten = new File(parent, "blocksBeingWritten");
            if (this.blocksBeingWritten.exists()) {
                if (supportAppends) {
                    this.recoverBlocksBeingWritten(this.blocksBeingWritten);
                } else {
                    FileUtil.fullyDelete(this.blocksBeingWritten);
                }
            }
            if (!this.blocksBeingWritten.mkdirs() && !this.blocksBeingWritten.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + this.blocksBeingWritten.toString());
            }
            if (!this.tmpDir.mkdirs() && !this.tmpDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + this.tmpDir.toString());
            }
            if (!this.detachDir.mkdirs() && !this.detachDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + this.detachDir.toString());
            }
            this.usage = new DF(parent, conf);
            this.dfsUsage = new DU(parent, conf);
            this.dfsUsage.start();
        }

        void decDfsUsed(long value) {
            this.dfsUsage.decDfsUsed(value);
        }

        long getDfsUsed() throws IOException {
            return this.dfsUsage.getUsed();
        }

        long getCapacity() throws IOException {
            if (this.reserved > this.usage.getCapacity()) {
                return 0L;
            }
            return this.usage.getCapacity() - this.reserved;
        }

        long getAvailable() throws IOException {
            long available;
            long remaining = this.getCapacity() - this.getDfsUsed();
            if (remaining > (available = this.usage.getAvailable())) {
                remaining = available;
            }
            return remaining > 0L ? remaining : 0L;
        }

        long getReserved() {
            return this.reserved;
        }

        String getMount() throws IOException {
            return this.usage.getMount();
        }

        File getDir() {
            return this.dataDir.dir;
        }

        File createTmpFile(Block b, boolean replicationRequest) throws IOException {
            File f = null;
            f = !replicationRequest ? new File(this.blocksBeingWritten, b.getBlockName()) : new File(this.tmpDir, b.getBlockName());
            return this.createTmpFile(b, f);
        }

        File getTmpFile(Block b) throws IOException {
            File f = new File(this.tmpDir, b.getBlockName());
            return f;
        }

        File createDetachFile(Block b, String filename) throws IOException {
            File f = new File(this.detachDir, filename);
            return this.createTmpFile(b, f);
        }

        private File createTmpFile(Block b, File f) throws IOException {
            if (f.exists()) {
                throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should not be present, but is.");
            }
            boolean fileCreated = false;
            try {
                fileCreated = f.createNewFile();
            }
            catch (IOException ioe) {
                DataNode.LOG.warn((Object)("createTmpFile failed for file " + f + " Block " + b));
                throw (IOException)new IOException(FSDataset.DISK_ERROR + f).initCause(ioe);
            }
            if (!fileCreated) {
                throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should be creatable, but is already present.");
            }
            return f;
        }

        File addBlock(Block b, File f) throws IOException {
            File blockFile = this.dataDir.addBlock(b, f);
            File metaFile = FSDataset.getMetaFile(blockFile, b);
            this.dfsUsage.incDfsUsed(b.getNumBytes() + metaFile.length());
            return blockFile;
        }

        void checkDirs() throws DiskChecker.DiskErrorException {
            this.dataDir.checkDirTree();
            DiskChecker.checkDir(this.tmpDir);
            DiskChecker.checkDir(this.blocksBeingWritten);
        }

        void getBlockInfo(TreeSet<Block> blockSet) {
            this.dataDir.getBlockInfo(blockSet);
        }

        void getBlocksBeingWrittenInfo(TreeSet<Block> blockSet) {
            if (this.blocksBeingWritten == null) {
                return;
            }
            File[] blockFiles = this.blocksBeingWritten.listFiles();
            if (blockFiles == null) {
                return;
            }
            for (int i = 0; i < blockFiles.length; ++i) {
                if (blockFiles[i].isDirectory() || !Block.isBlockFilename(blockFiles[i])) continue;
                long genStamp = FSDataset.getGenerationStampFromFile(blockFiles, blockFiles[i]);
                Block block = new Block(blockFiles[i], blockFiles[i].length(), genStamp);
                blockSet.add(block);
                if (!DataNode.LOG.isDebugEnabled()) continue;
                DataNode.LOG.debug((Object)("recoverBlocksBeingWritten for block " + block));
            }
        }

        void getVolumeMap(HashMap<Block, DatanodeBlockInfo> volumeMap) {
            this.dataDir.getVolumeMap(volumeMap, this);
        }

        void clearPath(File f) {
            this.dataDir.clearPath(f);
        }

        public String toString() {
            return this.dataDir.dir.getAbsolutePath();
        }

        private void recoverBlocksBeingWritten(File bbw) throws IOException {
            FSDir fsd = new FSDir(bbw);
            TreeSet<BlockAndFile> blockSet = new TreeSet<BlockAndFile>();
            fsd.getBlockAndFileInfo(blockSet);
            for (BlockAndFile b : blockSet) {
                File f = b.pathfile;
                FSDataset.this.volumeMap.put(b.block, new DatanodeBlockInfo(this, f));
                FSDataset.this.ongoingCreates.put(b.block, ActiveFile.createStartupRecoveryFile(f));
                if (!DataNode.LOG.isDebugEnabled()) continue;
                DataNode.LOG.debug((Object)("recoverBlocksBeingWritten for block " + b.block));
            }
        }

        private void recoverDetachedBlocks(File dataDir, File dir) throws IOException {
            File[] contents = FileUtil.listFiles(dir);
            for (int i = 0; i < contents.length; ++i) {
                if (!contents[i].isFile()) {
                    throw new IOException("Found " + contents[i] + " in " + dir + " but it is not a file.");
                }
                File blk = new File(dataDir, contents[i].getName());
                if (!blk.exists()) {
                    if (contents[i].renameTo(blk)) continue;
                    throw new IOException("Unable to recover detached file " + contents[i]);
                }
                if (contents[i].delete()) continue;
                throw new IOException("Unable to cleanup detached file " + contents[i]);
            }
        }
    }

    class FSDir {
        File dir;
        int numBlocks = 0;
        FSDir[] children;
        int lastChildIdx = 0;

        public FSDir(File dir) throws IOException {
            this.dir = dir;
            this.children = null;
            if (!dir.exists()) {
                if (!dir.mkdirs()) {
                    throw new IOException("Mkdirs failed to create " + dir.toString());
                }
            } else {
                File[] files = FileUtil.listFiles(dir);
                int numChildren = 0;
                for (int idx = 0; idx < files.length; ++idx) {
                    if (files[idx].isDirectory()) {
                        ++numChildren;
                        continue;
                    }
                    if (!Block.isBlockFilename(files[idx])) continue;
                    ++this.numBlocks;
                }
                if (numChildren > 0) {
                    this.children = new FSDir[numChildren];
                    int curdir = 0;
                    for (int idx = 0; idx < files.length; ++idx) {
                        if (!files[idx].isDirectory()) continue;
                        this.children[curdir] = new FSDir(files[idx]);
                        ++curdir;
                    }
                }
            }
        }

        public File addBlock(Block b, File src) throws IOException {
            File file = this.addBlock(b, src, false, false);
            return file != null ? file : this.addBlock(b, src, true, true);
        }

        private File addBlock(Block b, File src, boolean createOk, boolean resetIdx) throws IOException {
            if (this.numBlocks < FSDataset.this.maxBlocksPerDir) {
                File newmeta;
                File dest = new File(this.dir, b.getBlockName());
                File metaData = FSDataset.getMetaFile(src, b);
                if (!metaData.renameTo(newmeta = FSDataset.getMetaFile(dest, b)) || !src.renameTo(dest)) {
                    throw new IOException("could not move files for " + b + " from tmp to " + dest.getAbsolutePath());
                }
                if (DataNode.LOG.isDebugEnabled()) {
                    DataNode.LOG.debug((Object)("addBlock: Moved " + metaData + " to " + newmeta));
                    DataNode.LOG.debug((Object)("addBlock: Moved " + src + " to " + dest));
                }
                ++this.numBlocks;
                return dest;
            }
            if (this.lastChildIdx < 0 && resetIdx) {
                this.lastChildIdx = random.nextInt(this.children.length);
            }
            if (this.lastChildIdx >= 0 && this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    int idx = (this.lastChildIdx + i) % this.children.length;
                    File file = this.children[idx].addBlock(b, src, false, resetIdx);
                    if (file == null) continue;
                    this.lastChildIdx = idx;
                    return file;
                }
                this.lastChildIdx = -1;
            }
            if (!createOk) {
                return null;
            }
            if (this.children == null || this.children.length == 0) {
                this.children = new FSDir[FSDataset.this.maxBlocksPerDir];
                for (int idx = 0; idx < FSDataset.this.maxBlocksPerDir; ++idx) {
                    this.children[idx] = new FSDir(new File(this.dir, "subdir" + idx));
                }
            }
            this.lastChildIdx = random.nextInt(this.children.length);
            return this.children[this.lastChildIdx].addBlock(b, src, true, false);
        }

        public void getBlockInfo(TreeSet<Block> blockSet) {
            File[] blockFiles;
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getBlockInfo(blockSet);
                }
            }
            if ((blockFiles = this.dir.listFiles()) != null) {
                for (int i = 0; i < blockFiles.length; ++i) {
                    if (!Block.isBlockFilename(blockFiles[i])) continue;
                    long genStamp = FSDataset.getGenerationStampFromFile(blockFiles, blockFiles[i]);
                    blockSet.add(new Block(blockFiles[i], blockFiles[i].length(), genStamp));
                }
            }
        }

        void getBlockAndFileInfo(TreeSet<BlockAndFile> blockSet) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getBlockAndFileInfo(blockSet);
                }
            }
            File[] blockFiles = this.dir.listFiles();
            for (int i = 0; i < blockFiles.length; ++i) {
                if (!Block.isBlockFilename(blockFiles[i])) continue;
                long genStamp = FSDataset.getGenerationStampFromFile(blockFiles, blockFiles[i]);
                Block block = new Block(blockFiles[i], blockFiles[i].length(), genStamp);
                blockSet.add(new BlockAndFile(blockFiles[i].getAbsoluteFile(), block));
            }
        }

        void getVolumeMap(HashMap<Block, DatanodeBlockInfo> volumeMap, FSVolume volume) {
            File[] blockFiles;
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getVolumeMap(volumeMap, volume);
                }
            }
            if ((blockFiles = this.dir.listFiles()) != null) {
                for (int i = 0; i < blockFiles.length; ++i) {
                    if (!Block.isBlockFilename(blockFiles[i])) continue;
                    long genStamp = FSDataset.getGenerationStampFromFile(blockFiles, blockFiles[i]);
                    volumeMap.put(new Block(blockFiles[i], blockFiles[i].length(), genStamp), new DatanodeBlockInfo(volume, blockFiles[i]));
                }
            }
        }

        public void checkDirTree() throws DiskChecker.DiskErrorException {
            DiskChecker.checkDir(this.dir);
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].checkDirTree();
                }
            }
        }

        void clearPath(File f) {
            String[] dirNames;
            String root = this.dir.getAbsolutePath();
            String dir = f.getAbsolutePath();
            if (dir.startsWith(root) && this.clearPath(f, dirNames = dir.substring(root.length()).split(File.separator + "subdir"), 1)) {
                return;
            }
            this.clearPath(f, null, -1);
        }

        private boolean clearPath(File f, String[] dirNames, int idx) {
            if ((dirNames == null || idx == dirNames.length) && this.dir.compareTo(f) == 0) {
                --this.numBlocks;
                return true;
            }
            if (dirNames != null) {
                int childIdx;
                if (idx > dirNames.length - 1 || this.children == null) {
                    return false;
                }
                try {
                    childIdx = Integer.parseInt(dirNames[idx]);
                }
                catch (NumberFormatException ignored) {
                    return false;
                }
                return childIdx >= 0 && childIdx < this.children.length ? this.children[childIdx].clearPath(f, dirNames, idx + 1) : false;
            }
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!this.children[i].clearPath(f, null, -1)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "FSDir{dir=" + this.dir + ", children=" + (this.children == null ? null : Arrays.asList(this.children)) + "}";
        }
    }

    static class BlockAndFile
    implements Comparable<BlockAndFile> {
        final Block block;
        final File pathfile;

        BlockAndFile(File fullpathname, Block block) {
            this.pathfile = fullpathname;
            this.block = block;
        }

        @Override
        public int compareTo(BlockAndFile o) {
            return this.block.compareTo(o.block);
        }
    }
}

