// RUN: llvm-mc -arch=amdgcn -mcpu=bonaire -show-encoding %s | FileCheck %s

v_cmp_f_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x00,0x7c]

v_cmp_f_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x00,0x7c]

v_cmp_f_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x00,0x7c]

v_cmp_f_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x00,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_f_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x00,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_f_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x01,0x7c]

v_cmp_lt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x02,0x7c]

v_cmp_lt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x02,0x7c]

v_cmp_lt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x02,0x7c]

v_cmp_lt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x02,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_lt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x02,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_lt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x03,0x7c]

v_cmp_eq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x04,0x7c]

v_cmp_eq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x04,0x7c]

v_cmp_eq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x04,0x7c]

v_cmp_eq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x04,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_eq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x04,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_eq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x05,0x7c]

v_cmp_le_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x06,0x7c]

v_cmp_le_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x06,0x7c]

v_cmp_le_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x06,0x7c]

v_cmp_le_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x06,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_le_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x06,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_le_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x07,0x7c]

v_cmp_gt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x08,0x7c]

v_cmp_gt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x08,0x7c]

v_cmp_gt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x08,0x7c]

v_cmp_gt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x08,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_gt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x08,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_gt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x09,0x7c]

v_cmp_lg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x7c]

v_cmp_lg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x7c]

v_cmp_lg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x7c]

v_cmp_lg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_lg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_lg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x7c]

v_cmp_ge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x0c,0x7c]

v_cmp_ge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x0c,0x7c]

v_cmp_ge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0c,0x7c]

v_cmp_ge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0c,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_ge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0c,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_ge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x0d,0x7c]

v_cmp_o_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x0e,0x7c]

v_cmp_o_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x0e,0x7c]

v_cmp_o_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0e,0x7c]

v_cmp_o_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0e,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_o_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0e,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_o_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x0f,0x7c]

v_cmp_u_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x10,0x7c]

v_cmp_u_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x10,0x7c]

v_cmp_u_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x10,0x7c]

v_cmp_u_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x10,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_u_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x10,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_u_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x11,0x7c]

v_cmp_nge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x12,0x7c]

v_cmp_nge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x12,0x7c]

v_cmp_nge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x12,0x7c]

v_cmp_nge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x12,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x12,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x13,0x7c]

v_cmp_nlg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x14,0x7c]

v_cmp_nlg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x14,0x7c]

v_cmp_nlg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x14,0x7c]

v_cmp_nlg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x14,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nlg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x14,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nlg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x15,0x7c]

v_cmp_ngt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x16,0x7c]

v_cmp_ngt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x16,0x7c]

v_cmp_ngt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x16,0x7c]

v_cmp_ngt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x16,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_ngt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x16,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_ngt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x17,0x7c]

v_cmp_nle_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x18,0x7c]

v_cmp_nle_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x18,0x7c]

v_cmp_nle_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x18,0x7c]

v_cmp_nle_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x18,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nle_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x18,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nle_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x19,0x7c]

v_cmp_neq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x1a,0x7c]

v_cmp_neq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x1a,0x7c]

v_cmp_neq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x1a,0x7c]

v_cmp_neq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x1a,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_neq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x1a,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_neq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x1b,0x7c]

v_cmp_nlt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x1c,0x7c]

v_cmp_nlt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x1c,0x7c]

v_cmp_nlt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x1c,0x7c]

v_cmp_nlt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x1c,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nlt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x1c,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nlt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x1d,0x7c]

v_cmp_tru_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x1e,0x7c]

v_cmp_tru_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x1e,0x7c]

v_cmp_tru_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x1e,0x7c]

v_cmp_tru_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x1e,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_tru_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x1e,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_tru_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x1f,0x7c]

v_cmpx_f_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x20,0x7c]

v_cmpx_f_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x20,0x7c]

v_cmpx_f_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x20,0x7c]

v_cmpx_f_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x20,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_f_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x20,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_f_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x21,0x7c]

v_cmpx_lt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x22,0x7c]

v_cmpx_lt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x22,0x7c]

v_cmpx_lt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x22,0x7c]

v_cmpx_lt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x22,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x22,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x23,0x7c]

v_cmpx_eq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x24,0x7c]

v_cmpx_eq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x24,0x7c]

v_cmpx_eq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x24,0x7c]

v_cmpx_eq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x24,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x24,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_eq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x25,0x7c]

v_cmpx_le_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x26,0x7c]

v_cmpx_le_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x26,0x7c]

v_cmpx_le_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x26,0x7c]

v_cmpx_le_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x26,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_le_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x26,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_le_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x27,0x7c]

v_cmpx_gt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x28,0x7c]

v_cmpx_gt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x28,0x7c]

v_cmpx_gt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x28,0x7c]

v_cmpx_gt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x28,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x28,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_gt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x29,0x7c]

v_cmpx_lg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x2a,0x7c]

v_cmpx_lg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x2a,0x7c]

v_cmpx_lg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x2a,0x7c]

v_cmpx_lg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x2a,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x2a,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x2b,0x7c]

v_cmpx_ge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x2c,0x7c]

v_cmpx_ge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x2c,0x7c]

v_cmpx_ge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x2c,0x7c]

v_cmpx_ge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x2c,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x2c,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x2d,0x7c]

v_cmpx_o_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x2e,0x7c]

v_cmpx_o_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x2e,0x7c]

v_cmpx_o_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x2e,0x7c]

v_cmpx_o_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x2e,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_o_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x2e,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_o_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x2f,0x7c]

v_cmpx_u_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x30,0x7c]

v_cmpx_u_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x30,0x7c]

v_cmpx_u_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x30,0x7c]

v_cmpx_u_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x30,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_u_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x30,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_u_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x31,0x7c]

v_cmpx_nge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x32,0x7c]

v_cmpx_nge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x32,0x7c]

v_cmpx_nge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x32,0x7c]

v_cmpx_nge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x32,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x32,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x33,0x7c]

v_cmpx_nlg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x34,0x7c]

v_cmpx_nlg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x34,0x7c]

v_cmpx_nlg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x34,0x7c]

v_cmpx_nlg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x34,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x34,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x35,0x7c]

v_cmpx_ngt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x36,0x7c]

v_cmpx_ngt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x36,0x7c]

v_cmpx_ngt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x36,0x7c]

v_cmpx_ngt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x36,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x36,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ngt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x37,0x7c]

v_cmpx_nle_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x38,0x7c]

v_cmpx_nle_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x38,0x7c]

v_cmpx_nle_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x38,0x7c]

v_cmpx_nle_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x38,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x38,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nle_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x39,0x7c]

v_cmpx_neq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x3a,0x7c]

v_cmpx_neq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x3a,0x7c]

v_cmpx_neq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x3a,0x7c]

v_cmpx_neq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x3a,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x3a,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_neq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x3b,0x7c]

v_cmpx_nlt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x3c,0x7c]

v_cmpx_nlt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x3c,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x3c,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x3d,0x7c]

v_cmpx_tru_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x3e,0x7c]

v_cmpx_tru_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x3e,0x7c]

v_cmpx_tru_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x3e,0x7c]

v_cmpx_tru_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x3e,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_tru_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x3e,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_tru_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x3f,0x7c]

v_cmp_f_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x40,0x7c]

v_cmp_f_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x40,0x7c]

v_cmp_f_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x40,0x7c]

v_cmp_f_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x40,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_f_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x40,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_f_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x41,0x7c]

v_cmp_lt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x42,0x7c]

v_cmp_lt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x42,0x7c]

v_cmp_lt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x42,0x7c]

v_cmp_lt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x42,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_lt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x42,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_lt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x43,0x7c]

v_cmp_eq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x44,0x7c]

v_cmp_eq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x44,0x7c]

v_cmp_eq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x44,0x7c]

v_cmp_eq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x44,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_eq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x44,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_eq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x45,0x7c]

v_cmp_le_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x46,0x7c]

v_cmp_le_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x46,0x7c]

v_cmp_le_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x46,0x7c]

v_cmp_le_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x46,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_le_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x46,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_le_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x47,0x7c]

v_cmp_gt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x48,0x7c]

v_cmp_gt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x48,0x7c]

v_cmp_gt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x48,0x7c]

v_cmp_gt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x48,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_gt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x48,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_gt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x49,0x7c]

v_cmp_lg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x4a,0x7c]

v_cmp_lg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x4a,0x7c]

v_cmp_lg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x4a,0x7c]

v_cmp_lg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x4a,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_lg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x4a,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_lg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x4b,0x7c]

v_cmp_ge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x4c,0x7c]

v_cmp_ge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x4c,0x7c]

v_cmp_ge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x4c,0x7c]

v_cmp_ge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x4c,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_ge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x4c,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_ge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x4d,0x7c]

v_cmp_o_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x4e,0x7c]

v_cmp_o_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x4e,0x7c]

v_cmp_o_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x4e,0x7c]

v_cmp_o_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x4e,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_o_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x4e,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_o_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x4f,0x7c]

v_cmp_u_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x50,0x7c]

v_cmp_u_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x50,0x7c]

v_cmp_u_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x50,0x7c]

v_cmp_u_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x50,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_u_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x50,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_u_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x51,0x7c]

v_cmp_nge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x52,0x7c]

v_cmp_nge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x52,0x7c]

v_cmp_nge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x52,0x7c]

v_cmp_nge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x52,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x52,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x53,0x7c]

v_cmp_nlg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x54,0x7c]

v_cmp_nlg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x54,0x7c]

v_cmp_nlg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x54,0x7c]

v_cmp_nlg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x54,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nlg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x54,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nlg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x55,0x7c]

v_cmp_ngt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x56,0x7c]

v_cmp_ngt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x56,0x7c]

v_cmp_ngt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x56,0x7c]

v_cmp_ngt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x56,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_ngt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x56,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_ngt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x57,0x7c]

v_cmp_nle_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x58,0x7c]

v_cmp_nle_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x58,0x7c]

v_cmp_nle_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x58,0x7c]

v_cmp_nle_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x58,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nle_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x58,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nle_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x59,0x7c]

v_cmp_neq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x5a,0x7c]

v_cmp_neq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x5a,0x7c]

v_cmp_neq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x5a,0x7c]

v_cmp_neq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x5a,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_neq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x5a,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_neq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x5b,0x7c]

v_cmp_nlt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x5c,0x7c]

v_cmp_nlt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x5c,0x7c]

v_cmp_nlt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x5c,0x7c]

v_cmp_nlt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x5c,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_nlt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x5c,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_nlt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x5d,0x7c]

v_cmp_tru_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x5e,0x7c]

v_cmp_tru_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x5e,0x7c]

v_cmp_tru_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x5e,0x7c]

v_cmp_tru_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x5e,0x7c,0x56,0x34,0x12,0xaf]

v_cmp_tru_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x5e,0x7c,0x73,0x72,0x71,0x3f]

v_cmp_tru_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x5f,0x7c]

v_cmpx_f_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x60,0x7c]

v_cmpx_f_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x60,0x7c]

v_cmpx_f_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x60,0x7c]

v_cmpx_f_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x60,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_f_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x60,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_f_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x61,0x7c]

v_cmpx_lt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x62,0x7c]

v_cmpx_lt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x62,0x7c]

v_cmpx_lt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x62,0x7c]

v_cmpx_lt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x62,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x62,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x63,0x7c]

v_cmpx_eq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x64,0x7c]

v_cmpx_eq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x64,0x7c]

v_cmpx_eq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x64,0x7c]

v_cmpx_eq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x64,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x64,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_eq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x65,0x7c]

v_cmpx_le_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x66,0x7c]

v_cmpx_le_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x66,0x7c]

v_cmpx_le_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x66,0x7c]

v_cmpx_le_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x66,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_le_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x66,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_le_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x67,0x7c]

v_cmpx_gt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x68,0x7c]

v_cmpx_gt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x68,0x7c]

v_cmpx_gt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x68,0x7c]

v_cmpx_gt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x68,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x68,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_gt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x69,0x7c]

v_cmpx_lg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x6a,0x7c]

v_cmpx_lg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x6a,0x7c]

v_cmpx_lg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x6a,0x7c]

v_cmpx_lg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x6a,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x6a,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_lg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x6b,0x7c]

v_cmpx_ge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x6c,0x7c]

v_cmpx_ge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x6c,0x7c]

v_cmpx_ge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x6c,0x7c]

v_cmpx_ge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x6c,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x6c,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x6d,0x7c]

v_cmpx_o_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x6e,0x7c]

v_cmpx_o_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x6e,0x7c]

v_cmpx_o_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x6e,0x7c]

v_cmpx_o_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x6e,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_o_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x6e,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_o_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x6f,0x7c]

v_cmpx_u_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x70,0x7c]

v_cmpx_u_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x70,0x7c]

v_cmpx_u_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x70,0x7c]

v_cmpx_u_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x70,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_u_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x70,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_u_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x71,0x7c]

v_cmpx_nge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x72,0x7c]

v_cmpx_nge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x72,0x7c]

v_cmpx_nge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x72,0x7c]

v_cmpx_nge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x72,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x72,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x73,0x7c]

v_cmpx_nlg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x74,0x7c]

v_cmpx_nlg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x74,0x7c]

v_cmpx_nlg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x74,0x7c]

v_cmpx_nlg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x74,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x74,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x75,0x7c]

v_cmpx_ngt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x76,0x7c]

v_cmpx_ngt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x76,0x7c]

v_cmpx_ngt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x76,0x7c]

v_cmpx_ngt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x76,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x76,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_ngt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x77,0x7c]

v_cmpx_nle_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x78,0x7c]

v_cmpx_nle_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x78,0x7c]

v_cmpx_nle_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x78,0x7c]

v_cmpx_nle_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x78,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x78,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nle_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x79,0x7c]

v_cmpx_neq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x7a,0x7c]

v_cmpx_neq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x7a,0x7c]

v_cmpx_neq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x7a,0x7c]

v_cmpx_neq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x7a,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x7a,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_neq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x7b,0x7c]

v_cmpx_nlt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x7c,0x7c]

v_cmpx_nlt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x7c,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x7c,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_nlt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x7d,0x7c]

v_cmpx_tru_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x7e,0x7c]

v_cmpx_tru_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x7e,0x7c]

v_cmpx_tru_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x7e,0x7c]

v_cmpx_tru_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x7e,0x7c,0x56,0x34,0x12,0xaf]

v_cmpx_tru_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x7e,0x7c,0x73,0x72,0x71,0x3f]

v_cmpx_tru_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x7f,0x7c]

v_cmps_f_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x80,0x7c]

v_cmps_f_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x80,0x7c]

v_cmps_f_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x80,0x7c]

v_cmps_f_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x80,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_f_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x80,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_f_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x81,0x7c]

v_cmps_lt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x82,0x7c]

v_cmps_lt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x82,0x7c]

v_cmps_lt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x82,0x7c]

v_cmps_lt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x82,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_lt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x82,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_lt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x83,0x7c]

v_cmps_eq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x84,0x7c]

v_cmps_eq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x84,0x7c]

v_cmps_eq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x84,0x7c]

v_cmps_eq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x84,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_eq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x84,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_eq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x85,0x7c]

v_cmps_le_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x86,0x7c]

v_cmps_le_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x86,0x7c]

v_cmps_le_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x86,0x7c]

v_cmps_le_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x86,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_le_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x86,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_le_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x87,0x7c]

v_cmps_gt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x88,0x7c]

v_cmps_gt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x88,0x7c]

v_cmps_gt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x88,0x7c]

v_cmps_gt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x88,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_gt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x88,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_gt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x89,0x7c]

v_cmps_lg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8a,0x7c]

v_cmps_lg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8a,0x7c]

v_cmps_lg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8a,0x7c]

v_cmps_lg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8a,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_lg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8a,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_lg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8b,0x7c]

v_cmps_ge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8c,0x7c]

v_cmps_ge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8c,0x7c]

v_cmps_ge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8c,0x7c]

v_cmps_ge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8c,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_ge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8c,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_ge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8d,0x7c]

v_cmps_o_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8e,0x7c]

v_cmps_o_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8e,0x7c]

v_cmps_o_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8e,0x7c]

v_cmps_o_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8e,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_o_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8e,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_o_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8f,0x7c]

v_cmps_u_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x90,0x7c]

v_cmps_u_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x90,0x7c]

v_cmps_u_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x90,0x7c]

v_cmps_u_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x90,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_u_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x90,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_u_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x91,0x7c]

v_cmps_nge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x92,0x7c]

v_cmps_nge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x92,0x7c]

v_cmps_nge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x92,0x7c]

v_cmps_nge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x92,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_nge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x92,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_nge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x93,0x7c]

v_cmps_nlg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x94,0x7c]

v_cmps_nlg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x94,0x7c]

v_cmps_nlg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x94,0x7c]

v_cmps_nlg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x94,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_nlg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x94,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_nlg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x95,0x7c]

v_cmps_ngt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x96,0x7c]

v_cmps_ngt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x96,0x7c]

v_cmps_ngt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x96,0x7c]

v_cmps_ngt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x96,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_ngt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x96,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_ngt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x97,0x7c]

v_cmps_nle_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x98,0x7c]

v_cmps_nle_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x98,0x7c]

v_cmps_nle_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x98,0x7c]

v_cmps_nle_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x98,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_nle_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x98,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_nle_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x99,0x7c]

v_cmps_neq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x9a,0x7c]

v_cmps_neq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x9a,0x7c]

v_cmps_neq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x9a,0x7c]

v_cmps_neq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x9a,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_neq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x9a,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_neq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x9b,0x7c]

v_cmps_nlt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x9c,0x7c]

v_cmps_nlt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x9c,0x7c]

v_cmps_nlt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x9c,0x7c]

v_cmps_nlt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x9c,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_nlt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x9c,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_nlt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x9d,0x7c]

v_cmps_tru_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x9e,0x7c]

v_cmps_tru_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x9e,0x7c]

v_cmps_tru_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x9e,0x7c]

v_cmps_tru_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x9e,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_tru_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x9e,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_tru_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x9f,0x7c]

v_cmpsx_f_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa0,0x7c]

v_cmpsx_f_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa0,0x7c]

v_cmpsx_f_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa0,0x7c]

v_cmpsx_f_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa0,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_f_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa0,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_f_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa1,0x7c]

v_cmpsx_lt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa2,0x7c]

v_cmpsx_lt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa2,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_lt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa2,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_lt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa3,0x7c]

v_cmpsx_eq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa4,0x7c]

v_cmpsx_eq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa4,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_eq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa4,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_eq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa5,0x7c]

v_cmpsx_le_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa6,0x7c]

v_cmpsx_le_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa6,0x7c]

v_cmpsx_le_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa6,0x7c]

v_cmpsx_le_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa6,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_le_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa6,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_le_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa7,0x7c]

v_cmpsx_gt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa8,0x7c]

v_cmpsx_gt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa8,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_gt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa8,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_gt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa9,0x7c]

v_cmpsx_lg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xaa,0x7c]

v_cmpsx_lg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xaa,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_lg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xaa,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_lg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xab,0x7c]

v_cmpsx_ge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xac,0x7c]

v_cmpsx_ge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xac,0x7c]

v_cmpsx_ge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xac,0x7c]

v_cmpsx_ge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xac,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_ge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xac,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_ge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xad,0x7c]

v_cmpsx_o_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xae,0x7c]

v_cmpsx_o_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xae,0x7c]

v_cmpsx_o_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xae,0x7c]

v_cmpsx_o_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xae,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_o_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xae,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_o_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xaf,0x7c]

v_cmpsx_u_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb0,0x7c]

v_cmpsx_u_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb0,0x7c]

v_cmpsx_u_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb0,0x7c]

v_cmpsx_u_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb0,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_u_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb0,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_u_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb1,0x7c]

v_cmpsx_nge_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb2,0x7c]

v_cmpsx_nge_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb2,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_nge_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb2,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_nge_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb3,0x7c]

v_cmpsx_nlg_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb4,0x7c]

v_cmpsx_nlg_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb4,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_nlg_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb4,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_nlg_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb5,0x7c]

v_cmpsx_ngt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb6,0x7c]

v_cmpsx_ngt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb6,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_ngt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb6,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_ngt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb7,0x7c]

v_cmpsx_nle_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xb8,0x7c]

v_cmpsx_nle_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xb8,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_nle_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xb8,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_nle_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xb9,0x7c]

v_cmpsx_neq_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xba,0x7c]

v_cmpsx_neq_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xba,0x7c]

v_cmpsx_neq_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xba,0x7c]

v_cmpsx_neq_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xba,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_neq_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xba,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_neq_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xbb,0x7c]

v_cmpsx_nlt_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xbc,0x7c]

v_cmpsx_nlt_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xbc,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_nlt_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xbc,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_nlt_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xbd,0x7c]

v_cmpsx_tru_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xbe,0x7c]

v_cmpsx_tru_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xbe,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_tru_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xbe,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_tru_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0xbf,0x7c]

v_cmps_f_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc0,0x7c]

v_cmps_f_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc0,0x7c]

v_cmps_f_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc0,0x7c]

v_cmps_f_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc0,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_f_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc0,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_f_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc1,0x7c]

v_cmps_lt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc2,0x7c]

v_cmps_lt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc2,0x7c]

v_cmps_lt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc2,0x7c]

v_cmps_lt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc2,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_lt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc2,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_lt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc3,0x7c]

v_cmps_eq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc4,0x7c]

v_cmps_eq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc4,0x7c]

v_cmps_eq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc4,0x7c]

v_cmps_eq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc4,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_eq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc4,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_eq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc5,0x7c]

v_cmps_le_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc6,0x7c]

v_cmps_le_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc6,0x7c]

v_cmps_le_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc6,0x7c]

v_cmps_le_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc6,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_le_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc6,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_le_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc7,0x7c]

v_cmps_gt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc8,0x7c]

v_cmps_gt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc8,0x7c]

v_cmps_gt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc8,0x7c]

v_cmps_gt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc8,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_gt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc8,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_gt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc9,0x7c]

v_cmps_lg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xca,0x7c]

v_cmps_lg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xca,0x7c]

v_cmps_lg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xca,0x7c]

v_cmps_lg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xca,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_lg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xca,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_lg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcb,0x7c]

v_cmps_ge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xcc,0x7c]

v_cmps_ge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xcc,0x7c]

v_cmps_ge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xcc,0x7c]

v_cmps_ge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xcc,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_ge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xcc,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_ge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcd,0x7c]

v_cmps_o_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xce,0x7c]

v_cmps_o_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xce,0x7c]

v_cmps_o_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xce,0x7c]

v_cmps_o_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xce,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_o_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xce,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_o_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcf,0x7c]

v_cmps_u_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd0,0x7c]

v_cmps_u_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd0,0x7c]

v_cmps_u_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd0,0x7c]

v_cmps_u_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd0,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_u_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd0,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_u_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd1,0x7c]

v_cmps_nge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd2,0x7c]

v_cmps_nge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd2,0x7c]

v_cmps_nge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd2,0x7c]

v_cmps_nge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd2,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_nge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd2,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_nge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd3,0x7c]

v_cmps_nlg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd4,0x7c]

v_cmps_nlg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd4,0x7c]

v_cmps_nlg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd4,0x7c]

v_cmps_nlg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd4,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_nlg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd4,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_nlg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd5,0x7c]

v_cmps_ngt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd6,0x7c]

v_cmps_ngt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd6,0x7c]

v_cmps_ngt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd6,0x7c]

v_cmps_ngt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd6,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_ngt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd6,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_ngt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd7,0x7c]

v_cmps_nle_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xd8,0x7c]

v_cmps_nle_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xd8,0x7c]

v_cmps_nle_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xd8,0x7c]

v_cmps_nle_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xd8,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_nle_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xd8,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_nle_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xd9,0x7c]

v_cmps_neq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xda,0x7c]

v_cmps_neq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xda,0x7c]

v_cmps_neq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xda,0x7c]

v_cmps_neq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xda,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_neq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xda,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_neq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xdb,0x7c]

v_cmps_nlt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xdc,0x7c]

v_cmps_nlt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xdc,0x7c]

v_cmps_nlt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xdc,0x7c]

v_cmps_nlt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xdc,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_nlt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xdc,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_nlt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xdd,0x7c]

v_cmps_tru_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xde,0x7c]

v_cmps_tru_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xde,0x7c]

v_cmps_tru_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xde,0x7c]

v_cmps_tru_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xde,0x7c,0x56,0x34,0x12,0xaf]

v_cmps_tru_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xde,0x7c,0x73,0x72,0x71,0x3f]

v_cmps_tru_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xdf,0x7c]

v_cmpsx_f_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe0,0x7c]

v_cmpsx_f_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe0,0x7c]

v_cmpsx_f_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe0,0x7c]

v_cmpsx_f_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe0,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_f_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe0,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_f_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe1,0x7c]

v_cmpsx_lt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe2,0x7c]

v_cmpsx_lt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe2,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_lt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe2,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_lt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe3,0x7c]

v_cmpsx_eq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe4,0x7c]

v_cmpsx_eq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe4,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_eq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe4,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_eq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe5,0x7c]

v_cmpsx_le_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe6,0x7c]

v_cmpsx_le_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe6,0x7c]

v_cmpsx_le_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe6,0x7c]

v_cmpsx_le_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe6,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_le_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe6,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_le_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe7,0x7c]

v_cmpsx_gt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe8,0x7c]

v_cmpsx_gt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe8,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_gt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe8,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_gt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe9,0x7c]

v_cmpsx_lg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xea,0x7c]

v_cmpsx_lg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xea,0x7c]

v_cmpsx_lg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xea,0x7c]

v_cmpsx_lg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xea,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_lg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xea,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_lg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xeb,0x7c]

v_cmpsx_ge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xec,0x7c]

v_cmpsx_ge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xec,0x7c]

v_cmpsx_ge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xec,0x7c]

v_cmpsx_ge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xec,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_ge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xec,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_ge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xed,0x7c]

v_cmpsx_o_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xee,0x7c]

v_cmpsx_o_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xee,0x7c]

v_cmpsx_o_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xee,0x7c]

v_cmpsx_o_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xee,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_o_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xee,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_o_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xef,0x7c]

v_cmpsx_u_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf0,0x7c]

v_cmpsx_u_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf0,0x7c]

v_cmpsx_u_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf0,0x7c]

v_cmpsx_u_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf0,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_u_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf0,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_u_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf1,0x7c]

v_cmpsx_nge_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf2,0x7c]

v_cmpsx_nge_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf2,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_nge_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf2,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_nge_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf3,0x7c]

v_cmpsx_nlg_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf4,0x7c]

v_cmpsx_nlg_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf4,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_nlg_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf4,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_nlg_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf5,0x7c]

v_cmpsx_ngt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf6,0x7c]

v_cmpsx_ngt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf6,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_ngt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf6,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_ngt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf7,0x7c]

v_cmpsx_nle_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xf8,0x7c]

v_cmpsx_nle_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xf8,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_nle_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xf8,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_nle_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xf9,0x7c]

v_cmpsx_neq_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xfa,0x7c]

v_cmpsx_neq_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xfa,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_neq_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xfa,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_neq_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xfb,0x7c]

v_cmpsx_nlt_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xfc,0x7c]

v_cmpsx_nlt_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xfc,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_nlt_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xfc,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_nlt_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xfd,0x7c]

v_cmpsx_tru_f64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xfe,0x7c]

v_cmpsx_tru_f64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xfe,0x7c,0x56,0x34,0x12,0xaf]

v_cmpsx_tru_f64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xfe,0x7c,0x73,0x72,0x71,0x3f]

v_cmpsx_tru_f64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xff,0x7c]

v_cmp_f_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x00,0x7d]

v_cmp_f_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x00,0x7d]

v_cmp_f_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x00,0x7d]

v_cmp_f_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x00,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_f_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x00,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_f_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x01,0x7d]

v_cmp_lt_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x02,0x7d]

v_cmp_lt_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x02,0x7d]

v_cmp_lt_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x02,0x7d]

v_cmp_lt_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x02,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_lt_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x02,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_lt_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x03,0x7d]

v_cmp_eq_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x04,0x7d]

v_cmp_eq_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x04,0x7d]

v_cmp_eq_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x04,0x7d]

v_cmp_eq_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x04,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_eq_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x04,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_eq_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x05,0x7d]

v_cmp_le_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x06,0x7d]

v_cmp_le_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x06,0x7d]

v_cmp_le_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x06,0x7d]

v_cmp_le_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x06,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_le_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x06,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_le_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x07,0x7d]

v_cmp_gt_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x08,0x7d]

v_cmp_gt_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x08,0x7d]

v_cmp_gt_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x08,0x7d]

v_cmp_gt_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x08,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_gt_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x08,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_gt_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x09,0x7d]

v_cmp_ne_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x7d]

v_cmp_ne_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x7d]

v_cmp_ne_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x7d]

v_cmp_ne_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ne_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ne_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x7d]

v_cmp_ge_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x0c,0x7d]

v_cmp_ge_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x0c,0x7d]

v_cmp_ge_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0c,0x7d]

v_cmp_ge_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0c,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ge_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0c,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ge_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x0d,0x7d]

v_cmp_t_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x0e,0x7d]

v_cmp_t_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x0e,0x7d]

v_cmp_t_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0e,0x7d]

v_cmp_t_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0e,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_t_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0e,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_t_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x0f,0x7d]

v_cmpx_f_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x20,0x7d]

v_cmpx_f_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x20,0x7d]

v_cmpx_f_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x20,0x7d]

v_cmpx_f_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x20,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x20,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x21,0x7d]

v_cmpx_lt_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x22,0x7d]

v_cmpx_lt_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x22,0x7d]

v_cmpx_lt_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x22,0x7d]

v_cmpx_lt_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x22,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x22,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x23,0x7d]

v_cmpx_eq_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x24,0x7d]

v_cmpx_eq_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x24,0x7d]

v_cmpx_eq_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x24,0x7d]

v_cmpx_eq_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x24,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x24,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x25,0x7d]

v_cmpx_le_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x26,0x7d]

v_cmpx_le_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x26,0x7d]

v_cmpx_le_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x26,0x7d]

v_cmpx_le_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x26,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x26,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x27,0x7d]

v_cmpx_gt_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x28,0x7d]

v_cmpx_gt_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x28,0x7d]

v_cmpx_gt_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x28,0x7d]

v_cmpx_gt_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x28,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x28,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x29,0x7d]

v_cmpx_ne_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x2a,0x7d]

v_cmpx_ne_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x2a,0x7d]

v_cmpx_ne_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x2a,0x7d]

v_cmpx_ne_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x2a,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x2a,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x2b,0x7d]

v_cmpx_ge_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x2c,0x7d]

v_cmpx_ge_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x2c,0x7d]

v_cmpx_ge_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x2c,0x7d]

v_cmpx_ge_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x2c,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x2c,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x2d,0x7d]

v_cmpx_t_i32 vcc, v1, v2
// CHECK: [0x01,0x05,0x2e,0x7d]

v_cmpx_t_i32 vcc, v255, v2
// CHECK: [0xff,0x05,0x2e,0x7d]

v_cmpx_t_i32 vcc, s1, v2
// CHECK: [0x01,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, s103, v2
// CHECK: [0x67,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, 0, v2
// CHECK: [0x80,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x2e,0x7d]

v_cmpx_t_i32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x2e,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_i32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x2e,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_i32 vcc, v1, v255
// CHECK: [0x01,0xff,0x2f,0x7d]

v_cmp_f_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x40,0x7d]

v_cmp_f_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x40,0x7d]

v_cmp_f_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x40,0x7d]

v_cmp_f_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x40,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_f_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x40,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_f_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x41,0x7d]

v_cmp_lt_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x42,0x7d]

v_cmp_lt_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x42,0x7d]

v_cmp_lt_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x42,0x7d]

v_cmp_lt_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x42,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_lt_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x42,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_lt_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x43,0x7d]

v_cmp_eq_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x44,0x7d]

v_cmp_eq_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x44,0x7d]

v_cmp_eq_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x44,0x7d]

v_cmp_eq_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x44,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_eq_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x44,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_eq_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x45,0x7d]

v_cmp_le_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x46,0x7d]

v_cmp_le_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x46,0x7d]

v_cmp_le_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x46,0x7d]

v_cmp_le_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x46,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_le_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x46,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_le_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x47,0x7d]

v_cmp_gt_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x48,0x7d]

v_cmp_gt_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x48,0x7d]

v_cmp_gt_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x48,0x7d]

v_cmp_gt_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x48,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_gt_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x48,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_gt_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x49,0x7d]

v_cmp_ne_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x4a,0x7d]

v_cmp_ne_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x4a,0x7d]

v_cmp_ne_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x4a,0x7d]

v_cmp_ne_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x4a,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ne_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x4a,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ne_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x4b,0x7d]

v_cmp_ge_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x4c,0x7d]

v_cmp_ge_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x4c,0x7d]

v_cmp_ge_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x4c,0x7d]

v_cmp_ge_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x4c,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ge_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x4c,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ge_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x4d,0x7d]

v_cmp_t_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x4e,0x7d]

v_cmp_t_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x4e,0x7d]

v_cmp_t_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x4e,0x7d]

v_cmp_t_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x4e,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_t_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x4e,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_t_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x4f,0x7d]

v_cmpx_f_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x60,0x7d]

v_cmpx_f_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x60,0x7d]

v_cmpx_f_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x60,0x7d]

v_cmpx_f_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x60,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x60,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x61,0x7d]

v_cmpx_lt_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x62,0x7d]

v_cmpx_lt_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x62,0x7d]

v_cmpx_lt_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x62,0x7d]

v_cmpx_lt_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x62,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x62,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x63,0x7d]

v_cmpx_eq_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x64,0x7d]

v_cmpx_eq_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x64,0x7d]

v_cmpx_eq_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x64,0x7d]

v_cmpx_eq_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x64,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x64,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x65,0x7d]

v_cmpx_le_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x66,0x7d]

v_cmpx_le_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x66,0x7d]

v_cmpx_le_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x66,0x7d]

v_cmpx_le_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x66,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x66,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x67,0x7d]

v_cmpx_gt_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x68,0x7d]

v_cmpx_gt_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x68,0x7d]

v_cmpx_gt_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x68,0x7d]

v_cmpx_gt_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x68,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x68,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x69,0x7d]

v_cmpx_ne_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x6a,0x7d]

v_cmpx_ne_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x6a,0x7d]

v_cmpx_ne_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x6a,0x7d]

v_cmpx_ne_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x6a,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x6a,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x6b,0x7d]

v_cmpx_ge_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x6c,0x7d]

v_cmpx_ge_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x6c,0x7d]

v_cmpx_ge_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x6c,0x7d]

v_cmpx_ge_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x6c,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x6c,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x6d,0x7d]

v_cmpx_t_i64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0x6e,0x7d]

v_cmpx_t_i64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0x6e,0x7d]

v_cmpx_t_i64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0x6e,0x7d]

v_cmpx_t_i64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0x6e,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_i64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0x6e,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_i64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0x6f,0x7d]

v_cmp_f_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x80,0x7d]

v_cmp_f_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x80,0x7d]

v_cmp_f_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x80,0x7d]

v_cmp_f_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x80,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_f_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x80,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_f_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x81,0x7d]

v_cmp_lt_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x82,0x7d]

v_cmp_lt_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x82,0x7d]

v_cmp_lt_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x82,0x7d]

v_cmp_lt_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x82,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_lt_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x82,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_lt_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x83,0x7d]

v_cmp_eq_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x84,0x7d]

v_cmp_eq_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x84,0x7d]

v_cmp_eq_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x84,0x7d]

v_cmp_eq_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x84,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_eq_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x84,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_eq_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x85,0x7d]

v_cmp_le_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x86,0x7d]

v_cmp_le_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x86,0x7d]

v_cmp_le_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x86,0x7d]

v_cmp_le_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x86,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_le_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x86,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_le_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x87,0x7d]

v_cmp_gt_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x88,0x7d]

v_cmp_gt_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x88,0x7d]

v_cmp_gt_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x88,0x7d]

v_cmp_gt_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x88,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_gt_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x88,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_gt_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x89,0x7d]

v_cmp_ne_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8a,0x7d]

v_cmp_ne_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8a,0x7d]

v_cmp_ne_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8a,0x7d]

v_cmp_ne_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8a,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ne_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8a,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ne_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8b,0x7d]

v_cmp_ge_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8c,0x7d]

v_cmp_ge_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8c,0x7d]

v_cmp_ge_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8c,0x7d]

v_cmp_ge_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8c,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ge_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8c,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ge_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8d,0x7d]

v_cmp_t_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0x8e,0x7d]

v_cmp_t_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0x8e,0x7d]

v_cmp_t_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x8e,0x7d]

v_cmp_t_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x8e,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_t_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x8e,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_t_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0x8f,0x7d]

v_cmpx_f_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa0,0x7d]

v_cmpx_f_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa0,0x7d]

v_cmpx_f_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa0,0x7d]

v_cmpx_f_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa0,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa0,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa1,0x7d]

v_cmpx_lt_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa2,0x7d]

v_cmpx_lt_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa2,0x7d]

v_cmpx_lt_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa2,0x7d]

v_cmpx_lt_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa2,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa2,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa3,0x7d]

v_cmpx_eq_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa4,0x7d]

v_cmpx_eq_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa4,0x7d]

v_cmpx_eq_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa4,0x7d]

v_cmpx_eq_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa4,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa4,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa5,0x7d]

v_cmpx_le_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa6,0x7d]

v_cmpx_le_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa6,0x7d]

v_cmpx_le_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa6,0x7d]

v_cmpx_le_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa6,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa6,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa7,0x7d]

v_cmpx_gt_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xa8,0x7d]

v_cmpx_gt_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xa8,0x7d]

v_cmpx_gt_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xa8,0x7d]

v_cmpx_gt_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xa8,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xa8,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xa9,0x7d]

v_cmpx_ne_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xaa,0x7d]

v_cmpx_ne_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xaa,0x7d]

v_cmpx_ne_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xaa,0x7d]

v_cmpx_ne_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xaa,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xaa,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xab,0x7d]

v_cmpx_ge_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xac,0x7d]

v_cmpx_ge_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xac,0x7d]

v_cmpx_ge_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xac,0x7d]

v_cmpx_ge_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xac,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xac,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xad,0x7d]

v_cmpx_t_u32 vcc, v1, v2
// CHECK: [0x01,0x05,0xae,0x7d]

v_cmpx_t_u32 vcc, v255, v2
// CHECK: [0xff,0x05,0xae,0x7d]

v_cmpx_t_u32 vcc, s1, v2
// CHECK: [0x01,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, s103, v2
// CHECK: [0x67,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, m0, v2
// CHECK: [0x7c,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, 0, v2
// CHECK: [0x80,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, -1, v2
// CHECK: [0xc1,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0xae,0x7d]

v_cmpx_t_u32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0xae,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_u32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0xae,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_u32 vcc, v1, v255
// CHECK: [0x01,0xff,0xaf,0x7d]

v_cmp_f_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc0,0x7d]

v_cmp_f_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc0,0x7d]

v_cmp_f_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc0,0x7d]

v_cmp_f_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc0,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_f_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc0,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_f_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc1,0x7d]

v_cmp_lt_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc2,0x7d]

v_cmp_lt_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc2,0x7d]

v_cmp_lt_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc2,0x7d]

v_cmp_lt_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc2,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_lt_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc2,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_lt_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc3,0x7d]

v_cmp_eq_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc4,0x7d]

v_cmp_eq_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc4,0x7d]

v_cmp_eq_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc4,0x7d]

v_cmp_eq_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc4,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_eq_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc4,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_eq_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc5,0x7d]

v_cmp_le_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc6,0x7d]

v_cmp_le_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc6,0x7d]

v_cmp_le_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc6,0x7d]

v_cmp_le_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc6,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_le_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc6,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_le_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc7,0x7d]

v_cmp_gt_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xc8,0x7d]

v_cmp_gt_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xc8,0x7d]

v_cmp_gt_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xc8,0x7d]

v_cmp_gt_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xc8,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_gt_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xc8,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_gt_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xc9,0x7d]

v_cmp_ne_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xca,0x7d]

v_cmp_ne_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xca,0x7d]

v_cmp_ne_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xca,0x7d]

v_cmp_ne_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xca,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ne_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xca,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ne_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcb,0x7d]

v_cmp_ge_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xcc,0x7d]

v_cmp_ge_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xcc,0x7d]

v_cmp_ge_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xcc,0x7d]

v_cmp_ge_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xcc,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_ge_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xcc,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_ge_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcd,0x7d]

v_cmp_t_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xce,0x7d]

v_cmp_t_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xce,0x7d]

v_cmp_t_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xce,0x7d]

v_cmp_t_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xce,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_t_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xce,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_t_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xcf,0x7d]

v_cmpx_f_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe0,0x7d]

v_cmpx_f_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe0,0x7d]

v_cmpx_f_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe0,0x7d]

v_cmpx_f_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe0,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_f_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe0,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_f_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe1,0x7d]

v_cmpx_lt_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe2,0x7d]

v_cmpx_lt_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe2,0x7d]

v_cmpx_lt_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe2,0x7d]

v_cmpx_lt_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe2,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe2,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_lt_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe3,0x7d]

v_cmpx_eq_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe4,0x7d]

v_cmpx_eq_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe4,0x7d]

v_cmpx_eq_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe4,0x7d]

v_cmpx_eq_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe4,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe4,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_eq_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe5,0x7d]

v_cmpx_le_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe6,0x7d]

v_cmpx_le_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe6,0x7d]

v_cmpx_le_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe6,0x7d]

v_cmpx_le_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe6,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_le_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe6,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_le_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe7,0x7d]

v_cmpx_gt_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xe8,0x7d]

v_cmpx_gt_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xe8,0x7d]

v_cmpx_gt_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xe8,0x7d]

v_cmpx_gt_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xe8,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xe8,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_gt_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xe9,0x7d]

v_cmpx_ne_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xea,0x7d]

v_cmpx_ne_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xea,0x7d]

v_cmpx_ne_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xea,0x7d]

v_cmpx_ne_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xea,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xea,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ne_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xeb,0x7d]

v_cmpx_ge_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xec,0x7d]

v_cmpx_ge_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xec,0x7d]

v_cmpx_ge_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xec,0x7d]

v_cmpx_ge_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xec,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xec,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_ge_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xed,0x7d]

v_cmpx_t_u64 vcc, v[1:2], v[2:3]
// CHECK: [0x01,0x05,0xee,0x7d]

v_cmpx_t_u64 vcc, v[254:255], v[2:3]
// CHECK: [0xfe,0x05,0xee,0x7d]

v_cmpx_t_u64 vcc, s[2:3], v[2:3]
// CHECK: [0x02,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, s[4:5], v[2:3]
// CHECK: [0x04,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, s[102:103], v[2:3]
// CHECK: [0x66,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, flat_scratch, v[2:3]
// CHECK: [0x68,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, vcc, v[2:3]
// CHECK: [0x6a,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, tba, v[2:3]
// CHECK: [0x6c,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, tma, v[2:3]
// CHECK: [0x6e,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, ttmp[10:11], v[2:3]
// CHECK: [0x7a,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, exec, v[2:3]
// CHECK: [0x7e,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, 0, v[2:3]
// CHECK: [0x80,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, -1, v[2:3]
// CHECK: [0xc1,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, 0.5, v[2:3]
// CHECK: [0xf0,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, -4.0, v[2:3]
// CHECK: [0xf7,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, src_vccz, v[2:3]
// CHECK: [0xfb,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, src_execz, v[2:3]
// CHECK: [0xfc,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, src_scc, v[2:3]
// CHECK: [0xfd,0x04,0xee,0x7d]

v_cmpx_t_u64 vcc, 0xaf123456, v[2:3]
// CHECK: [0xff,0x04,0xee,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_t_u64 vcc, 0x3f717273, v[2:3]
// CHECK: [0xff,0x04,0xee,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_t_u64 vcc, v[1:2], v[254:255]
// CHECK: [0x01,0xfd,0xef,0x7d]

v_cmp_class_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x10,0x7d]

v_cmp_class_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x10,0x7d]

v_cmp_class_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x10,0x7d]

v_cmp_class_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x10,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_class_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x10,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_class_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x11,0x7d]

v_cmpx_class_f32 vcc, v1, v2
// CHECK: [0x01,0x05,0x30,0x7d]

v_cmpx_class_f32 vcc, v255, v2
// CHECK: [0xff,0x05,0x30,0x7d]

v_cmpx_class_f32 vcc, s1, v2
// CHECK: [0x01,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, s103, v2
// CHECK: [0x67,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, m0, v2
// CHECK: [0x7c,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, 0, v2
// CHECK: [0x80,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, -1, v2
// CHECK: [0xc1,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x30,0x7d]

v_cmpx_class_f32 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x30,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_class_f32 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x30,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_class_f32 vcc, v1, v255
// CHECK: [0x01,0xff,0x31,0x7d]

v_cmp_class_f64 vcc, v[1:2], v2
// CHECK: [0x01,0x05,0x50,0x7d]

v_cmp_class_f64 vcc, v[254:255], v2
// CHECK: [0xfe,0x05,0x50,0x7d]

v_cmp_class_f64 vcc, s[2:3], v2
// CHECK: [0x02,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, s[4:5], v2
// CHECK: [0x04,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, s[102:103], v2
// CHECK: [0x66,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, flat_scratch, v2
// CHECK: [0x68,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, vcc, v2
// CHECK: [0x6a,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, tba, v2
// CHECK: [0x6c,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, tma, v2
// CHECK: [0x6e,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, ttmp[10:11], v2
// CHECK: [0x7a,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, exec, v2
// CHECK: [0x7e,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, 0, v2
// CHECK: [0x80,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, -1, v2
// CHECK: [0xc1,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x50,0x7d]

v_cmp_class_f64 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x50,0x7d,0x56,0x34,0x12,0xaf]

v_cmp_class_f64 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x50,0x7d,0x73,0x72,0x71,0x3f]

v_cmp_class_f64 vcc, v[1:2], v255
// CHECK: [0x01,0xff,0x51,0x7d]

v_cmpx_class_f64 vcc, v[1:2], v2
// CHECK: [0x01,0x05,0x70,0x7d]

v_cmpx_class_f64 vcc, v[254:255], v2
// CHECK: [0xfe,0x05,0x70,0x7d]

v_cmpx_class_f64 vcc, s[2:3], v2
// CHECK: [0x02,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, s[4:5], v2
// CHECK: [0x04,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, s[102:103], v2
// CHECK: [0x66,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, flat_scratch, v2
// CHECK: [0x68,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, vcc, v2
// CHECK: [0x6a,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, tba, v2
// CHECK: [0x6c,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, tma, v2
// CHECK: [0x6e,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, ttmp[10:11], v2
// CHECK: [0x7a,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, exec, v2
// CHECK: [0x7e,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, 0, v2
// CHECK: [0x80,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, -1, v2
// CHECK: [0xc1,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x70,0x7d]

v_cmpx_class_f64 vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x70,0x7d,0x56,0x34,0x12,0xaf]

v_cmpx_class_f64 vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x70,0x7d,0x73,0x72,0x71,0x3f]

v_cmpx_class_f64 vcc, v[1:2], v255
// CHECK: [0x01,0xff,0x71,0x7d]
