; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse2 | FileCheck %s --check-prefix=SSE --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-apple-macosx10.8.0 -mattr=+ssse3 | FileCheck %s --check-prefix=SSE --check-prefix=SSSE3
; RUN: llc < %s -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse4.1 | FileCheck %s --check-prefix=SSE --check-prefix=SSE41
; RUN: llc < %s -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx | FileCheck %s --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx2 | FileCheck %s --check-prefix=AVX --check-prefix=AVX2

define <8 x i16> @test1(<8 x i16> %x) nounwind {
; SSE-LABEL: test1:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    psubusw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test1:
; AVX:       ## BB#0: ## %vector.ph
; AVX-NEXT:    vpsubusw {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %0 = icmp slt <8 x i16> %x, zeroinitializer
  %1 = xor <8 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %res = select <8 x i1> %0, <8 x i16> %1, <8 x i16> zeroinitializer
  ret <8 x i16> %res
}

define <8 x i16> @test2(<8 x i16> %x) nounwind {
; SSE-LABEL: test2:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    psubusw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2:
; AVX:       ## BB#0: ## %vector.ph
; AVX-NEXT:    vpsubusw {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %0 = icmp ugt <8 x i16> %x, <i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766>
  %1 = add <8 x i16> %x, <i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767>
  %res = select <8 x i1> %0, <8 x i16> %1, <8 x i16> zeroinitializer
  ret <8 x i16> %res
}

define <8 x i16> @test3(<8 x i16> %x, i16 zeroext %w) nounwind {
; SSE-LABEL: test3:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    movd %edi, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; SSE-NEXT:    psubusw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test3:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vmovd %edi, %xmm1
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test3:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm1
; AVX2-NEXT:    vpbroadcastw %xmm1, %xmm1
; AVX2-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
vector.ph:
  %0 = insertelement <8 x i16> undef, i16 %w, i32 0
  %broadcast15 = shufflevector <8 x i16> %0, <8 x i16> undef, <8 x i32> zeroinitializer
  %1 = icmp ult <8 x i16> %x, %broadcast15
  %2 = sub <8 x i16> %x, %broadcast15
  %res = select <8 x i1> %1, <8 x i16> zeroinitializer, <8 x i16> %2
  ret <8 x i16> %res
}

define <16 x i8> @test4(<16 x i8> %x) nounwind {
; SSE-LABEL: test4:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    psubusb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test4:
; AVX:       ## BB#0: ## %vector.ph
; AVX-NEXT:    vpsubusb {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %0 = icmp slt <16 x i8> %x, zeroinitializer
  %1 = xor <16 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %res = select <16 x i1> %0, <16 x i8> %1, <16 x i8> zeroinitializer
  ret <16 x i8> %res
}

define <16 x i8> @test5(<16 x i8> %x) nounwind {
; SSE-LABEL: test5:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    psubusb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test5:
; AVX:       ## BB#0: ## %vector.ph
; AVX-NEXT:    vpsubusb {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %0 = icmp ugt <16 x i8> %x, <i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126>
  %1 = add <16 x i8> %x, <i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127>
  %res = select <16 x i1> %0, <16 x i8> %1, <16 x i8> zeroinitializer
  ret <16 x i8> %res
}

define <16 x i8> @test6(<16 x i8> %x, i8 zeroext %w) nounwind {
; SSE2-LABEL: test6:
; SSE2:       ## BB#0: ## %vector.ph
; SSE2-NEXT:    movd %edi, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,1,1]
; SSE2-NEXT:    psubusb %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test6:
; SSSE3:       ## BB#0: ## %vector.ph
; SSSE3-NEXT:    movd %edi, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pshufb %xmm2, %xmm1
; SSSE3-NEXT:    psubusb %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test6:
; SSE41:       ## BB#0: ## %vector.ph
; SSE41-NEXT:    movd %edi, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pshufb %xmm2, %xmm1
; SSE41-NEXT:    psubusb %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test6:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vmovd %edi, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test6:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm1
; AVX2-NEXT:    vpbroadcastb %xmm1, %xmm1
; AVX2-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
vector.ph:
  %0 = insertelement <16 x i8> undef, i8 %w, i32 0
  %broadcast15 = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> zeroinitializer
  %1 = icmp ult <16 x i8> %x, %broadcast15
  %2 = sub <16 x i8> %x, %broadcast15
  %res = select <16 x i1> %1, <16 x i8> zeroinitializer, <16 x i8> %2
  ret <16 x i8> %res
}

define <16 x i16> @test7(<16 x i16> %x) nounwind {
; SSE-LABEL: test7:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test7:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vxorps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test7:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vpsubusw {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
vector.ph:
  %0 = icmp slt <16 x i16> %x, zeroinitializer
  %1 = xor <16 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %res = select <16 x i1> %0, <16 x i16> %1, <16 x i16> zeroinitializer
  ret <16 x i16> %res
}

define <16 x i16> @test8(<16 x i16> %x) nounwind {
; SSE-LABEL: test8:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32767,32767,32767,32767,32767,32767,32767,32767]
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test8:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [65534,65534,65534,65534,65534,65534,65534,65534]
; AVX1-NEXT:    vpcmpgtw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpcmpgtw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [32769,32769,32769,32769,32769,32769,32769,32769]
; AVX1-NEXT:    vpaddw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test8:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vpsubusw {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
vector.ph:
  %0 = icmp ugt <16 x i16> %x, <i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766>
  %1 = add <16 x i16> %x, <i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767>
  %res = select <16 x i1> %0, <16 x i16> %1, <16 x i16> zeroinitializer
  ret <16 x i16> %res
}

define <16 x i16> @test9(<16 x i16> %x, i16 zeroext %w) nounwind {
; SSE-LABEL: test9:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    movd %edi, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test9:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovd %edi, %xmm2
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; AVX1-NEXT:    vpsubw %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpsubw %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vpmaxuw %xmm2, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpeqw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpmaxuw %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test9:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm1
; AVX2-NEXT:    vpbroadcastw %xmm1, %ymm1
; AVX2-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
vector.ph:
  %0 = insertelement <16 x i16> undef, i16 %w, i32 0
  %broadcast15 = shufflevector <16 x i16> %0, <16 x i16> undef, <16 x i32> zeroinitializer
  %1 = icmp ult <16 x i16> %x, %broadcast15
  %2 = sub <16 x i16> %x, %broadcast15
  %res = select <16 x i1> %1, <16 x i16> zeroinitializer, <16 x i16> %2
  ret <16 x i16> %res
}

define <32 x i8> @test10(<32 x i8> %x) nounwind {
; SSE-LABEL: test10:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; SSE-NEXT:    psubusb %xmm2, %xmm0
; SSE-NEXT:    psubusb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test10:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vxorps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test10:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vpsubusb {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
vector.ph:
  %0 = icmp slt <32 x i8> %x, zeroinitializer
  %1 = xor <32 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %res = select <32 x i1> %0, <32 x i8> %1, <32 x i8> zeroinitializer
  ret <32 x i8> %res
}

define <32 x i8> @test11(<32 x i8> %x) nounwind {
; SSE-LABEL: test11:
; SSE:       ## BB#0: ## %vector.ph
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE-NEXT:    psubusb %xmm2, %xmm0
; SSE-NEXT:    psubusb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test11:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254]
; AVX1-NEXT:    vpcmpgtb %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129]
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm0, %ymm2, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test11:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vpsubusb {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
vector.ph:
  %0 = icmp ugt <32 x i8> %x, <i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126>
  %1 = add <32 x i8> %x, <i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127>
  %res = select <32 x i1> %0, <32 x i8> %1, <32 x i8> zeroinitializer
  ret <32 x i8> %res
}

define <32 x i8> @test12(<32 x i8> %x, i8 zeroext %w) nounwind {
; SSE2-LABEL: test12:
; SSE2:       ## BB#0: ## %vector.ph
; SSE2-NEXT:    movd %edi, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,1,1]
; SSE2-NEXT:    psubusb %xmm2, %xmm0
; SSE2-NEXT:    psubusb %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test12:
; SSSE3:       ## BB#0: ## %vector.ph
; SSSE3-NEXT:    movd %edi, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pshufb %xmm3, %xmm2
; SSSE3-NEXT:    psubusb %xmm2, %xmm0
; SSSE3-NEXT:    psubusb %xmm2, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test12:
; SSE41:       ## BB#0: ## %vector.ph
; SSE41-NEXT:    movd %edi, %xmm2
; SSE41-NEXT:    pxor %xmm3, %xmm3
; SSE41-NEXT:    pshufb %xmm3, %xmm2
; SSE41-NEXT:    psubusb %xmm2, %xmm0
; SSE41-NEXT:    psubusb %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test12:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vmovd %edi, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsubb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpsubb %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vpmaxub %xmm1, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpmaxub %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test12:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm1
; AVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX2-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
vector.ph:
  %0 = insertelement <32 x i8> undef, i8 %w, i32 0
  %broadcast15 = shufflevector <32 x i8> %0, <32 x i8> undef, <32 x i32> zeroinitializer
  %1 = icmp ult <32 x i8> %x, %broadcast15
  %2 = sub <32 x i8> %x, %broadcast15
  %res = select <32 x i1> %1, <32 x i8> zeroinitializer, <32 x i8> %2
  ret <32 x i8> %res
}

define <8 x i16> @test13(<8 x i16> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: test13:
; SSE2:       ## BB#0: ## %vector.ph
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    psubd %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm2
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,2,2,3]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm2
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm5[0]
; SSE2-NEXT:    psubd %xmm1, %xmm3
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    pslld $16, %xmm3
; SSE2-NEXT:    psrad $16, %xmm3
; SSE2-NEXT:    packssdw %xmm0, %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test13:
; SSSE3:       ## BB#0: ## %vector.ph
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSSE3-NEXT:    psubd %xmm2, %xmm0
; SSSE3-NEXT:    movdqa %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm4, %xmm6
; SSSE3-NEXT:    pxor %xmm4, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm5, %xmm6
; SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm2
; SSSE3-NEXT:    pshufb %xmm5, %xmm2
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm6[0]
; SSSE3-NEXT:    psubd %xmm1, %xmm3
; SSSE3-NEXT:    pshufb %xmm5, %xmm0
; SSSE3-NEXT:    pshufb %xmm5, %xmm3
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSSE3-NEXT:    pandn %xmm3, %xmm2
; SSSE3-NEXT:    movdqa %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test13:
; SSE41:       ## BB#0: ## %vector.ph
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,0,1]
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm4 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm5 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm3, %xmm6
; SSE41-NEXT:    psubd %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm5, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSE41-NEXT:    pshufb %xmm1, %xmm0
; SSE41-NEXT:    movdqa %xmm2, %xmm6
; SSE41-NEXT:    pxor %xmm5, %xmm6
; SSE41-NEXT:    pxor %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE41-NEXT:    pshufb %xmm1, %xmm6
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm6[0]
; SSE41-NEXT:    psubd %xmm2, %xmm4
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; SSE41-NEXT:    pandn %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test13:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm4
; AVX1-NEXT:    vpxor %xmm3, %xmm1, %xmm5
; AVX1-NEXT:    vpcmpgtd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpxor %xmm3, %xmm5, %xmm6
; AVX1-NEXT:    vpxor %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpacksswb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsubd %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpandn %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test13:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpbroadcastd {{.*}}(%rip), %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpgtd %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-NEXT:    vpacksswb %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpandn %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i32>
  %cond = icmp ult <8 x i32> %lhs, %y
  %sub = sub <8 x i32> %lhs, %y
  %trunc = trunc <8 x i32> %sub to <8 x i16>
  %res = select <8 x i1> %cond, <8 x i16> zeroinitializer, <8 x i16> %trunc
  ret <8 x i16> %res
}

define <16 x i8> @test14(<16 x i8> %x, <16 x i32> %y) nounwind {
; SSE2-LABEL: test14:
; SSE2:       ## BB#0: ## %vector.ph
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1],xmm6[2],xmm0[2],xmm6[3],xmm0[3],xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; SSE2-NEXT:    movdqa %xmm6, %xmm8
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm0[0],xmm8[1],xmm0[1],xmm8[2],xmm0[2],xmm8[3],xmm0[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4],xmm0[4],xmm6[5],xmm0[5],xmm6[6],xmm0[6],xmm6[7],xmm0[7]
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm5 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; SSE2-NEXT:    movdqa %xmm5, %xmm10
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm0[0],xmm10[1],xmm0[1],xmm10[2],xmm0[2],xmm10[3],xmm0[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm0[4],xmm5[5],xmm0[5],xmm5[6],xmm0[6],xmm5[7],xmm0[7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm4, %xmm9
; SSE2-NEXT:    pxor %xmm0, %xmm9
; SSE2-NEXT:    psubd %xmm5, %xmm4
; SSE2-NEXT:    pxor %xmm0, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm9, %xmm5
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255]
; SSE2-NEXT:    pand %xmm9, %xmm5
; SSE2-NEXT:    movdqa %xmm3, %xmm7
; SSE2-NEXT:    pxor %xmm0, %xmm7
; SSE2-NEXT:    psubd %xmm10, %xmm3
; SSE2-NEXT:    pxor %xmm0, %xmm10
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm10
; SSE2-NEXT:    pand %xmm9, %xmm10
; SSE2-NEXT:    packuswb %xmm5, %xmm10
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    pxor %xmm0, %xmm5
; SSE2-NEXT:    psubd %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm0, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE2-NEXT:    pand %xmm9, %xmm6
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    pxor %xmm0, %xmm5
; SSE2-NEXT:    pxor %xmm8, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE2-NEXT:    pand %xmm9, %xmm0
; SSE2-NEXT:    packuswb %xmm6, %xmm0
; SSE2-NEXT:    packuswb %xmm10, %xmm0
; SSE2-NEXT:    psubd %xmm8, %xmm1
; SSE2-NEXT:    pand %xmm9, %xmm4
; SSE2-NEXT:    pand %xmm9, %xmm3
; SSE2-NEXT:    packuswb %xmm4, %xmm3
; SSE2-NEXT:    pand %xmm9, %xmm2
; SSE2-NEXT:    pand %xmm9, %xmm1
; SSE2-NEXT:    packuswb %xmm2, %xmm1
; SSE2-NEXT:    packuswb %xmm3, %xmm1
; SSE2-NEXT:    pandn %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test14:
; SSSE3:       ## BB#0: ## %vector.ph
; SSSE3-NEXT:    pxor %xmm7, %xmm7
; SSSE3-NEXT:    movdqa %xmm0, %xmm11
; SSSE3-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm7[0],xmm11[1],xmm7[1],xmm11[2],xmm7[2],xmm11[3],xmm7[3],xmm11[4],xmm7[4],xmm11[5],xmm7[5],xmm11[6],xmm7[6],xmm11[7],xmm7[7]
; SSSE3-NEXT:    movdqa %xmm11, %xmm8
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm11 = xmm11[4],xmm7[4],xmm11[5],xmm7[5],xmm11[6],xmm7[6],xmm11[7],xmm7[7]
; SSSE3-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm7[8],xmm0[9],xmm7[9],xmm0[10],xmm7[10],xmm0[11],xmm7[11],xmm0[12],xmm7[12],xmm0[13],xmm7[13],xmm0[14],xmm7[14],xmm0[15],xmm7[15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm10
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0],xmm7[0],xmm10[1],xmm7[1],xmm10[2],xmm7[2],xmm10[3],xmm7[3]
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm7[4],xmm0[5],xmm7[5],xmm0[6],xmm7[6],xmm0[7],xmm7[7]
; SSSE3-NEXT:    movdqa {{.*#+}} xmm7 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm4, %xmm9
; SSSE3-NEXT:    pxor %xmm7, %xmm9
; SSSE3-NEXT:    psubd %xmm0, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm6
; SSSE3-NEXT:    pxor %xmm7, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm9, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm9 = <u,u,u,u,0,4,8,12,u,u,u,u,u,u,u,u>
; SSSE3-NEXT:    pshufb %xmm9, %xmm6
; SSSE3-NEXT:    movdqa %xmm3, %xmm5
; SSSE3-NEXT:    pxor %xmm7, %xmm5
; SSSE3-NEXT:    psubd %xmm10, %xmm3
; SSSE3-NEXT:    movdqa %xmm10, %xmm0
; SSSE3-NEXT:    pxor %xmm7, %xmm0
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm0
; SSSE3-NEXT:    pshufb %xmm9, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1]
; SSSE3-NEXT:    movdqa %xmm2, %xmm5
; SSSE3-NEXT:    pxor %xmm7, %xmm5
; SSSE3-NEXT:    psubd %xmm11, %xmm2
; SSSE3-NEXT:    pxor %xmm7, %xmm11
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm11
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; SSSE3-NEXT:    pshufb %xmm5, %xmm11
; SSSE3-NEXT:    movdqa %xmm1, %xmm6
; SSSE3-NEXT:    pxor %xmm7, %xmm6
; SSSE3-NEXT:    pxor %xmm8, %xmm7
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm7
; SSSE3-NEXT:    pshufb %xmm5, %xmm7
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm7 = xmm7[0],xmm11[0],xmm7[1],xmm11[1]
; SSSE3-NEXT:    movsd {{.*#+}} xmm0 = xmm7[0],xmm0[1]
; SSSE3-NEXT:    psubd %xmm8, %xmm1
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSSE3-NEXT:    pand %xmm5, %xmm4
; SSSE3-NEXT:    pand %xmm5, %xmm3
; SSSE3-NEXT:    packuswb %xmm4, %xmm3
; SSSE3-NEXT:    pand %xmm5, %xmm2
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    packuswb %xmm2, %xmm1
; SSSE3-NEXT:    packuswb %xmm3, %xmm1
; SSSE3-NEXT:    andnpd %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test14:
; SSE41:       ## BB#0: ## %vector.ph
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[1,1,2,3]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm8 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[2,3,0,1]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm9 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero,xmm6[2],zero,zero,zero,xmm6[3],zero,zero,zero
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[3,1,2,3]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm5 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm4, %xmm7
; SSE41-NEXT:    pxor %xmm5, %xmm7
; SSE41-NEXT:    psubd %xmm6, %xmm4
; SSE41-NEXT:    pxor %xmm5, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm7, %xmm6
; SSE41-NEXT:    movdqa {{.*#+}} xmm10 = <u,u,u,u,0,4,8,12,u,u,u,u,u,u,u,u>
; SSE41-NEXT:    pshufb %xmm10, %xmm6
; SSE41-NEXT:    movdqa %xmm3, %xmm7
; SSE41-NEXT:    pxor %xmm5, %xmm7
; SSE41-NEXT:    psubd %xmm9, %xmm3
; SSE41-NEXT:    pxor %xmm5, %xmm9
; SSE41-NEXT:    pcmpgtd %xmm7, %xmm9
; SSE41-NEXT:    pshufb %xmm10, %xmm9
; SSE41-NEXT:    punpckldq {{.*#+}} xmm9 = xmm9[0],xmm6[0],xmm9[1],xmm6[1]
; SSE41-NEXT:    movdqa %xmm1, %xmm6
; SSE41-NEXT:    pxor %xmm5, %xmm6
; SSE41-NEXT:    psubd %xmm0, %xmm1
; SSE41-NEXT:    pxor %xmm5, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = <0,4,8,12,u,u,u,u,u,u,u,u,u,u,u,u>
; SSE41-NEXT:    pshufb %xmm6, %xmm0
; SSE41-NEXT:    movdqa %xmm2, %xmm7
; SSE41-NEXT:    pxor %xmm5, %xmm7
; SSE41-NEXT:    pxor %xmm8, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm7, %xmm5
; SSE41-NEXT:    pshufb %xmm6, %xmm5
; SSE41-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm5[0],xmm0[1],xmm5[1]
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm9[4,5,6,7]
; SSE41-NEXT:    psubd %xmm8, %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm5 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE41-NEXT:    pand %xmm5, %xmm4
; SSE41-NEXT:    pand %xmm5, %xmm3
; SSE41-NEXT:    packuswb %xmm4, %xmm3
; SSE41-NEXT:    pand %xmm5, %xmm1
; SSE41-NEXT:    pand %xmm5, %xmm2
; SSE41-NEXT:    packuswb %xmm2, %xmm1
; SSE41-NEXT:    packuswb %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pblendvb %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test14:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm8 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm9 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm10 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm7
; AVX1-NEXT:    vpxor %xmm6, %xmm7, %xmm3
; AVX1-NEXT:    vpxor %xmm6, %xmm0, %xmm4
; AVX1-NEXT:    vpcmpgtd %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpxor %xmm6, %xmm2, %xmm4
; AVX1-NEXT:    vpxor %xmm6, %xmm10, %xmm5
; AVX1-NEXT:    vpcmpgtd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpacksswb %xmm3, %xmm4, %xmm11
; AVX1-NEXT:    vpxor %xmm6, %xmm1, %xmm4
; AVX1-NEXT:    vpxor %xmm6, %xmm9, %xmm5
; AVX1-NEXT:    vpcmpgtd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpxor %xmm6, %xmm5, %xmm3
; AVX1-NEXT:    vpxor %xmm6, %xmm8, %xmm6
; AVX1-NEXT:    vpcmpgtd %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpacksswb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpacksswb %xmm11, %xmm3, %xmm3
; AVX1-NEXT:    vpsubd %xmm8, %xmm5, %xmm4
; AVX1-NEXT:    vpsubd %xmm9, %xmm1, %xmm1
; AVX1-NEXT:    vpsubd %xmm10, %xmm2, %xmm2
; AVX1-NEXT:    vpsubd %xmm0, %xmm7, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; AVX1-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackuswb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpand %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm5, %xmm4, %xmm2
; AVX1-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpblendvb %xmm3, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test14:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[2,3,0,1]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero,xmm3[4],zero,zero,zero,xmm3[5],zero,zero,zero,xmm3[6],zero,zero,zero,xmm3[7],zero,zero,zero
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpbroadcastd {{.*}}(%rip), %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm1, %ymm5
; AVX2-NEXT:    vpxor %ymm4, %ymm0, %ymm6
; AVX2-NEXT:    vpcmpgtd %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm6
; AVX2-NEXT:    vpacksswb %xmm6, %xmm5, %xmm5
; AVX2-NEXT:    vpxor %ymm4, %ymm2, %ymm6
; AVX2-NEXT:    vpxor %ymm4, %ymm3, %ymm4
; AVX2-NEXT:    vpcmpgtd %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vextracti128 $1, %ymm4, %xmm6
; AVX2-NEXT:    vpacksswb %xmm6, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpsubd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = <0,2,4,6,8,10,12,14,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpshufb %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpblendvb %xmm4, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
vector.ph:
  %rhs = zext <16 x i8> %x to <16 x i32>
  %cond = icmp ult <16 x i32> %y, %rhs
  %sub = sub <16 x i32> %y, %rhs
  %truncsub = trunc <16 x i32> %sub to <16 x i8>
  %res = select <16 x i1> %cond, <16 x i8> zeroinitializer, <16 x i8> %truncsub
  ret <16 x i8> %res
}

define <8 x i16> @test15(<8 x i16> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: test15:
; SSE2:       ## BB#0: ## %vector.ph
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    psubd %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE2-NEXT:    psubd %xmm1, %xmm3
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    pslld $16, %xmm3
; SSE2-NEXT:    psrad $16, %xmm3
; SSE2-NEXT:    packssdw %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test15:
; SSSE3:       ## BB#0: ## %vector.ph
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSSE3-NEXT:    psubd %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm4, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm5
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm5
; SSSE3-NEXT:    movdqa %xmm1, %xmm6
; SSSE3-NEXT:    pxor %xmm4, %xmm6
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm4
; SSSE3-NEXT:    pshufb %xmm2, %xmm4
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSSE3-NEXT:    psubd %xmm1, %xmm3
; SSSE3-NEXT:    pshufb %xmm2, %xmm0
; SSSE3-NEXT:    pshufb %xmm2, %xmm3
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSSE3-NEXT:    pand %xmm4, %xmm3
; SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test15:
; SSE41:       ## BB#0: ## %vector.ph
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,0,1]
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    psubd %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm4, %xmm1
; SSE41-NEXT:    pxor %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSE41-NEXT:    pshufb %xmm1, %xmm5
; SSE41-NEXT:    movdqa %xmm2, %xmm6
; SSE41-NEXT:    pxor %xmm4, %xmm6
; SSE41-NEXT:    pxor %xmm3, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm4
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; SSE41-NEXT:    psubd %xmm2, %xmm3
; SSE41-NEXT:    pshufb %xmm1, %xmm0
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test15:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vpxor %xmm3, %xmm1, %xmm4
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm5
; AVX1-NEXT:    vpcmpgtd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpxor %xmm3, %xmm5, %xmm6
; AVX1-NEXT:    vpxor %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpacksswb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsubd %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test15:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpbroadcastd {{.*}}(%rip), %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpgtd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-NEXT:    vpacksswb %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i32>
  %cond = icmp ugt <8 x i32> %lhs, %y
  %sub = sub <8 x i32> %lhs, %y
  %truncsub = trunc <8 x i32> %sub to <8 x i16>
  %res = select <8 x i1> %cond, <8 x i16> %truncsub, <8 x i16> zeroinitializer
  ret <8 x i16> %res
}

define <8 x i16> @test16(<8 x i16> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: test16:
; SSE2:       ## BB#0: ## %vector.ph
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    psubd %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE2-NEXT:    psubd %xmm1, %xmm3
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    pslld $16, %xmm3
; SSE2-NEXT:    psrad $16, %xmm3
; SSE2-NEXT:    packssdw %xmm0, %xmm3
; SSE2-NEXT:    pand %xmm4, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test16:
; SSSE3:       ## BB#0: ## %vector.ph
; SSSE3-NEXT:    pxor %xmm4, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1],xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4],xmm4[4],xmm0[5],xmm4[5],xmm0[6],xmm4[6],xmm0[7],xmm4[7]
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSSE3-NEXT:    psubd %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm4, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm5
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm5
; SSSE3-NEXT:    movdqa %xmm1, %xmm6
; SSSE3-NEXT:    pxor %xmm4, %xmm6
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm4
; SSSE3-NEXT:    pshufb %xmm2, %xmm4
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSSE3-NEXT:    psubd %xmm1, %xmm3
; SSSE3-NEXT:    pshufb %xmm2, %xmm0
; SSSE3-NEXT:    pshufb %xmm2, %xmm3
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm0[0]
; SSSE3-NEXT:    pand %xmm4, %xmm3
; SSSE3-NEXT:    movdqa %xmm3, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test16:
; SSE41:       ## BB#0: ## %vector.ph
; SSE41-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,0,1]
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    psubd %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm4, %xmm1
; SSE41-NEXT:    pxor %xmm4, %xmm5
; SSE41-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSE41-NEXT:    pshufb %xmm1, %xmm5
; SSE41-NEXT:    movdqa %xmm2, %xmm6
; SSE41-NEXT:    pxor %xmm4, %xmm6
; SSE41-NEXT:    pxor %xmm3, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm4
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; SSE41-NEXT:    psubd %xmm2, %xmm3
; SSE41-NEXT:    pshufb %xmm1, %xmm0
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test16:
; AVX1:       ## BB#0: ## %vector.ph
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vpxor %xmm3, %xmm1, %xmm4
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm5
; AVX1-NEXT:    vpcmpgtd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpxor %xmm3, %xmm5, %xmm6
; AVX1-NEXT:    vpxor %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vpcmpgtd %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpacksswb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsubd %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpand %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test16:
; AVX2:       ## BB#0: ## %vector.ph
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpbroadcastd {{.*}}(%rip), %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpgtd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-NEXT:    vpacksswb %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i32>
  %cond = icmp ult <8 x i32> %y, %lhs
  %sub = sub <8 x i32> %lhs, %y
  %truncsub = trunc <8 x i32> %sub to <8 x i16>
  %res = select <8 x i1> %cond, <8 x i16> %truncsub, <8 x i16> zeroinitializer
  ret <8 x i16> %res
}
