/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-policy-authorizer.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_POLICY_AUTHORIZER_H
#define __UNITY_WEBAPPS_POLICY_AUTHORIZER_H


#define UNITY_WEBAPPS_TYPE_POLICY_AUTHORIZER              (unity_webapps_policy_authorizer_get_type())
#define UNITY_WEBAPPS_POLICY_AUTHORIZER(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_POLICY_AUTHORIZER, UnityWebappsPolicyAuthorizer))
#define UNITY_WEBAPPS_POLICY_AUTHORIZER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_POLICY_AUTHORIZER, UnityWebappsPolicyAuthorizerClass))
#define UNITY_WEBAPPS_IS_POLICY_AUTHORIZER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_POLICY_AUTHORIZER))
#define UNITY_WEBAPPS_IS_POLICY_AUTHORIZER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_POLICY_AUTHORIZER))
#define UNITY_WEBAPPS_POLICY_AUTHORIZER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_POLICY_AUTHORIZER, UnityWebappsPolicyAuthorizerClass))

#include <glib-object.h>

typedef struct _UnityWebappsPolicyAuthorizerPrivate UnityWebappsPolicyAuthorizerPrivate;
typedef struct _UnityWebappsPolicyAuthorizer UnityWebappsPolicyAuthorizer;

struct _UnityWebappsPolicyAuthorizer {
	GObject object;

	UnityWebappsPolicyAuthorizerPrivate *priv;
};

typedef struct _UnityWebappsPolicyAuthorizerClass UnityWebappsPolicyAuthorizerClass;

struct _UnityWebappsPolicyAuthorizerClass
{
	GObjectClass parent_class;
};

typedef void (*UnityWebappsPolicyAuthorizerCallback) (UnityWebappsPolicyAuthorizer *authorizer, gboolean authorized, gpointer user_data);

GType unity_webapps_policy_authorizer_get_type (void) G_GNUC_CONST;
UnityWebappsPolicyAuthorizer *unity_webapps_policy_authorizer_new ();

gboolean unity_webapps_policy_authorizer_get_install_authorization (UnityWebappsPolicyAuthorizer *authorizer, UnityWebappsPolicyAuthorizerCallback callback, gpointer user_data);

#endif
