/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.zoom;

import java.awt.event.MouseEvent;
import org.jhotdraw.contrib.zoom.ZoomAreaTracker;
import org.jhotdraw.contrib.zoom.ZoomDrawingView;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.AbstractTool;

public class ZoomTool
extends AbstractTool {
    private Tool child;

    public ZoomTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.child != null) {
                return;
            }
            this.view().freezeView();
            this.child = new ZoomAreaTracker(this.editor());
            this.child.mouseDown(mouseEvent, n, n2);
        } else if ((mouseEvent.getModifiers() & 8) != 0) {
            ((ZoomDrawingView)this.view()).deZoom(n, n2);
        } else if ((mouseEvent.getModifiers() & 4) != 0) {
            if ((mouseEvent.getModifiers() & 1) != 0) {
                ((ZoomDrawingView)this.view()).zoomIn(n, n2);
            } else if ((mouseEvent.getModifiers() & 2) != 0) {
                ((ZoomDrawingView)this.view()).deZoom(n, n2);
            } else {
                ((ZoomDrawingView)this.view()).zoomOut(n, n2);
            }
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.child != null) {
            this.child.mouseDrag(mouseEvent, n, n2);
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.child != null) {
            this.view().unfreezeView();
            this.child.mouseUp(mouseEvent, n, n2);
        }
        this.child = null;
    }
}

