.TH "sane\-pixma" "5" "15 Aug 2020" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-pixma
.SH NAME
sane\-pixma \- SANE backend for Canon Multi-Function Printers and CanoScan Scanners
.SH DESCRIPTION
The
.B sane\-pixma
library implements a SANE (Scanner Access Now Easy) backend that provides
access to Canon PIXMA / i-SENSYS / imageCLASS / imageRUNNER multi-function
devices (All-in-one printers) and the Canon CanoScan Flatbed/TPU scanners.
The backend implements both the USB interface and network interface
(using Canon's BJNP and MFNP protocols). The network interface supports scanners
over IPv4 as well as IPv6 (MFNP over IPv6 is untested).
.PP
Currently, the following models work with this backend:


.PP
.RS
PIXMA E410, E510, E4500
.br
PIXMA G600, G2000, G2010, G2100, G4000, G4511
.br
PIXMA GX6000, GX7000
.br
PIXMA MG2100, MG2200, MG2400, MG2500, MG2900, MG3000, MG3100
.br
PIXMA MG3200, MG3500, MG3600, MG4200, MG5100, MG5200, MG5300
.br
PIXMA MG5400, MG5500, MG5600, MG5700, MG6100, MG6200, MG6300
.br
PIXMA MG6400, MG7100, MG7500, MG7700, MG8200
.br
PIXMA MP140, MP150, MP160, MP170, MP180, MP190
.br
PIXMA MP210, MP220, MP230, MP240, MP250, MP260, MP270, MP280
.br
PIXMA MP360, MP370, MP390
.br
PIXMA MP450, MP460, MP470, MP480, MP490, MP495
.br
PIXMA MP500, MP510, MP520, MP530, MP540, MP550, MP560
.br
PIXMA MP600, MP600R, MP610, MP620, MP630, MP640
.br
PIXMA MP700, MP710, MP730, PIXMA MP750 (no grayscale)
.br
PIXMA MP800, MP800R, MP810, MP830
.br
PIXMA MP960, MP970, MP980, MP990
.br
PIXMA MX300, MX310, MX330, MX340, MX350, MX360, MX370
.br
PIXMA MX410, MX420, MX470, MX510, MX520, MX530, MX700, MX720
.br
PIXMA MX850, MX860, MX870, MX882, MX885, MX890, MX920, MX7600
.br
PIXMA TR4500, TR4600, TR4700
.br
PIXMA TS2400, TS2600, TS3100, TS3300, TS3450, TS3451, TS3452
.br
PIXMA TS3500, TS5000, TS5100, TS5350i, TS5400, TS6100, TS6200
.br
PIXMA TS7530, TS7450i ,TS8000, TS8530, TS8200
.br
PIXUS MP10
.br
imageCLASS MF634Cdw, MF733Cdw
.br
imageCLASS MF3110, MF3240, MF4010, MF4018
.br
imageCLASS MF4120, MF4122, MF4140, MF4150
.br
imageCLASS MF4270, MF4350d, MF4370dn, MF4380dn
.br
imageCLASS MF4410, MF4430, MF4570dw, MF4660, MF4690
.br
imageCLASS MF5730, MF5770, MF6550, MPC200
.br
imageCLASS D420, D480, D530, D570
.br
i-SENSYS MF210, MF230, MF240, MF440, MF620, MF630, MF640
.br
i-SENSYS MF645C, MF730, MF731/733, MF741/743
.br
i-SENSYS MF3010, MF4320d, MF4330d, MF4500, MF4700, MF4800
.br
i-SENSYS MF6100, MF8030, MF8200C, MF8300
.br
imageRUNNER 1018/1022/1023, 1020/1024/1025, 1133
.br
CanoScan 8800F, 9000F, 9000F Mark II
.br
CanoScan LiDE 300, 400
.br
MAXIFY MB2000, MB2100, MB2300, MB2700, MB5000, MB5100, MB5400
.RE
.PP
The following models are not well tested and/or the scanner sometimes hangs
and must be switched off and on.
.PP
.RS
PIXMA MP760, MP770, MP780, MP790
.RE
.PP
The following models may use the same Pixma protocol as those listed
above, but have not yet been reported to work (or not). They are declared
in the backend so that they get recognized and activated.
Feedback in the sane\-devel mailing list welcome.
.PP
.RS
PIXMA E400, E460, E470, E480, E500, E560, E600, E610
.br
PIXMA E3100, E3300, E3400, E4200
.br
PIXMA G2020, G2060, G3020, G3060, G7000, G7080
.br
PIXMA MG4100, MG6500, MG6600, MG6800, MG6900, MG8100
.br
PIXMA MP375R, MP493, MP740
.br
PIXMA MX320, MX390, MX430, MX450, MX490, MX710
.br
PIXMA G3000, G3010, G4010, G6000, G6080, G7000, GM4000, GM4080
.br
PIXMA TR7500, TR7530, TR7600, TR8500, TR8530, TR8580, TR8600
.br
PIXMA TR8630, TR9530
.br
PIXMA TS3400, TS5100, TS6000, TS6130, TS6180, TS6230, TS6280, TS6300
.br
PIXMA TS6330, TS6330, TS6380, TS6400, TS7330, TS7400, TS7430, TS8100
.br
PIXMA TS8130, TS8180, TS8230, TS8280, TS8300, TS8330, TS8380, TS9000
.br
PIXMA TS9100, TS9180, TS9500, TS9580
.br
PIXUS MP5, XK50, XK60, XK70, XK80, XK90, XK100, XK500
.br
imageCLASS MF720, MF810/820, MF5630, MF5650, MF5750, MF8170c
.br
imageCLASS MPC190, D550
.br
i-SENSYS MF110, MF220, MF260, MF410, MF420, MF510, MF520, MF740
.br
i-SENSYS MF5880dn, MF5900, MF6680dn, MF8500C
.br
MAXIFY MB5300
.RE
.PP
The following models may use partly the same Pixma protocol as other devices
listed above, but may still need some work. They are declared in the backend
as experimental and need the environment variable PIXMA_EXPERIMENT=1 to get
recognized and activated. Snoop logs are required to further investigate,
please contact the sane\-devel mailing list.
.PP
.RS
\-\- none \-\-
.RE
.PP
The backend supports:
.PP
.RS
* resolutions of 75, 150, 300, 600, 1200, 2400, 4800, and 9600 DPI (some maybe buggy),
.br
* color and grayscale mode, as well as lineart on certain models,
.br
* a custom gamma table,
.br
* Automatic Document Feeder, Simplex and Duplex.
.br
* Transparency Unit, 24 or 48 bits depth. Infrared channel on certain models.
.RE
.PP
The device name for USB devices is in the form pixma:xxxxyyyy_zzzzz
where x, y and z are vendor ID, product ID and serial number respectively.
.PP
Example: pixma:04A91709_123456 is a MP150.
.PP
Device names for BJNP/MFNP devices is in the form pixma:aaaa_bbbbb
where aaaa is the scanners model and bbbb is the hostname or ip-adress.
.PP
Example: pixma:MF4800_192.168.1.45 is a MF4800 Series multi-function peripheral.
.PP
This backend, based on cloning original Canon drivers protocols, is in
a production stage. Designed has been carried out without any applicable
manufacturer documentation, probably never available. However, we have tested
it as well as we could, but it may not work in all situations. You will find
an up-to-date status at the project homepage. (See below).
Users feedback is essential to help improve features and performances.
.SH OPTIONS
Besides "well-known" options (e.g. resolution, mode etc.)
.B sane\-pixma
backend also
provides the following options, i.e. the options might change in the future.
.br
The button status can be polled i.e. with
.I scanimage \-A.
.br
Button scan is disabled on MAC OS X due to darwin libusb not handling
timeouts in usb interrupt reads, but may work when using the network protocol.
.TP
.I adf\-wait
This option enables and sets the time in seconds waiting for a document
inserted into the
.BR Automatic
.BR Document
.BR Feeder .
The maximum allowed waiting time is 3600 sec (= 1 hour).
.TP
.I button\-controlled
This option can be used by applications (like
.BR scanadf (1)
and
.BR scanimage (1))
in batch mode, for example when you want to scan many photos or
multiple-page documents. If it is enabled (i.e. is set to true or yes), the
backend waits before every scan until the user presses the "SCAN" button
(for MP150) or the color-scan button (for other models). Just put the
first page in the scanner, press the button, then the next page, press
the button and so on. When you finished, press the gray-scan button. (For
MP150 you have to stop the frontend by pressing Ctrl-C for example.)
.TP
.I button\-update (deprecated)
(write only) In the past this option was required to be set to force
reading of the button status for
.I button\-1
and
.I button\-2.
The
.B sane\-pixma
backend no longer requires this option to be used: if no fresh data is available, it
will be now requested automatically from the scanner. This option is left for
backward compatibility reasons.
.TP
.I button\-1 button\-2
(read only) These options will return the value of the respective buttons.
value 0 means that the button was not pressed, 1 is returned when the button
was pressed. Some scanners with more than two buttons send the button number
as target.
.TP
.I original
(read only) Returns the value of the type or size of original to be scanned
if the scanner provides that data. Known values of type: 1 = document, 2 = photo,
5 = film. Known values of size: 1 = A4, 2 = Letter, 8 = 10x15, 9 = 13x18, b = auto.
Not all scanners can provide this data.
.TP
.I target
(read only) Returns the value of the target of the scan operation if the scanner
provides that data. The values depend on the scanner type. Known values:
1 = save to disk, 2 = save to pdf, 3 = send to email, 4 = send to application
or 1 = JPEG, 2 = TIFF, 3 = PDF, 4 = Compact PDF. For some scanners this value
is equivalent to the number of the pressed button. Not all scanners can provide
this data.
.TP
.I scan\-resolution
(read only) Returns the resolution of the scan operation if the scanner
provides that data. Known values: 1 = 75 dpi, 2 = 150 dpi, 3 = 300 dpi,
4 = 600 dpi. Not all scanners can provide this data.
.TP
.I document\-type
(read only) Returns the type of the scanned document if the scanner provides
that data. Known values: 1 = Document, 2 = Photo, 3 = Auto scan. Not all scanners
can provide this data.
.TP
.I adf\-status
(read only) Returns the status of the document feeder if the scanner provides
that data. Known values: 1 = ADF empty, 2 = ADF filled. Not all scanners can
provide this data.
.TP
.I adf\-orientation
(read only) Returns the scan orientation of the medium scanned from ADF if the
scanner provides that data. Known values: 1 = Portrait, 2 = Landscape. Not all
scanners can provide this data.
.SH FILES
.TP
.I @LIBDIR@/libsane\-pixma.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-pixma.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.TP
.I @CONFIGDIR@/pixma.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.RS
.PP
The file contains an optional list of networked scanners using the BJNP or MFNP protools
(See below for datails on networking support for scanners). Normally
only scanners that cannot be auto-detected because they are on a different
subnet shall be listed here. If you do not use Linux and your OS does not allow enumeration of
interfaces (i.e. it does not support the
.BR getifaddrs ()
qfunction) you also may need
to add your scanner here as well.
.PP
Scanners shall be listed in the configuration file as follows:
.PP
.RS
.I <method>://<host>[:port][/timeout=<value>]
.RE
.PP
where method indicates the protocol used (bjnp is used for inkjet multi-functionals
and mfnp is used for laser multi-functionals).
.PP
host is the hostname or IP address of the scanner, e.g. bjnp://10.0.1.4
for IPv4, bjnp://[2001:888:118e:18e2:21e:8fff:fe36:b64a] for a literal
IPv6-address or bjnp://myscanner.mydomain.org for a hostname.
.PP
The port number is optional and in normally implied by the method.
Port 8610 is the standard port for mfnp, 8612 for bjnp.
.PP
A scanner specific timeout value for the network protocol can be set using the
bjnp-timeout parameter. The value is in ms.
.PP
Define scanners each on a new line.
.PP
More globally applicable timeouts can be set using the bjnp-timeout parameter as follows:
.PP
.RS
.I bjnp-timeout=<value>
.RE
.PP
A timeout defined using bjnp-timeout will apply to the following scanner definitions
in the file. If required the bjnp-timeout setting
can be defined multiple times, where each setting will apply only to the scanners that
follow the setting. The last setting is used for the auto discovered scanners.
If not explicitly set, the default 1000ms setting will apply.
.PP
Setting timeouts should only be required in exceptional cases.
.PP
.RE
.PP
If so desired networking can be disabled as follows:
.RS
.IP -
If the first non-commented line contains
.B networking=no
all networking will be disabled.
This will cause all further statements in the configuration file to be ignored.
.IP -
A line that contains
.B auto_detection=no
will cause auto-detection to be skipped. Explicitly defined network scanners will still be probed.
.SH USB SUPPORT
USB scanners will be auto-detected and require no configuration.
.SH NETWORKING SUPPORT
The
.B sane\-pixma
backend supports network scanners using the so called Canon BJNP
and MFNP protocols.
.PP
Canon seems to be dropping support for these protocols in recent scanners.
To verify if your scanner supports one of these protocols, check the content of
the _scanner._tcp service entry in mDNS/DNS-SD (using for example
.BR avahi-discover (1)).
If that does not list port 8610
or 8612 your scanner probably does not support the mfmp or bjnp protols.
.PP
Both IPv4 and IPv6 are supported, but IPv6 is as
yet untested with MFNP. Please report your results on the mailing list.
.PP
Configuration is normally not required.
The
.B sane\-pixma
backend will auto-detect your scanner if it is within
the same subnet as your computer if your OS does support this.
.PP
If your scanner can not be auto-detected, you can add it to the
.B sane\-pixma
configuration file (see above).
.SH FIREWALLING FOR NETWORKED SCANNERS
The
.B sane\-pixma
backend communicates with port 8610 for MFNP or port 8612
for BJNP on the scanner. So
you will have to allow outgoing traffic TO port 8610 or 8612 on the
common subnet for scanning.
.PP
Scanner detection is slightly more complicated. The
.B sane\-pixma
backend sends
a broadcast on all direct connected subnets it can find (provided your OS
allows for enumeration of all network interfaces). The broadcast is sent FROM
port 8612 TO port 8610 or 8612 on the broadcast address of each interface.
The outgoing packets will be allowed by the rule described above.
.PP
Responses from the scanner are sent back to the computer TO port 8612.
Connection tracking however does not see a match as the response does not come
from the broadcast address but from the scanners own address.
For automatic detection of your scanner, you will therefore have to allow
incoming packets TO port 8612 on your computer. This applies to both MFNP and
BJNP.
.PP
So in short: open the firewall for all traffic from your computer to port
8610 (for MFNP) or 8612 (for BJNP)
AND to port 8612 (for both BJNP and MFNP) to your computer.
.PP
With the firewall rules above there is no need to add the scanner to the
.I pixma.conf
file, unless the scanner is on a network that is not directly
connected to your computer.
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_PIXMA
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend itself. Higher value increases
the verbosity and includes the information printed at the lower levels.
.RS
0  print nothing (default)
.br
1  print error and warning messages (recommended)
.br
2  print informational messages
.br
3  print debug-level messages
.br
4  print verbose debug-level messages
.br
11 dump USB traffic
.br
21 full dump USB traffic
.br
.RE
.TP
.B SANE_DEBUG_BJNP
If the library was compiled with debug support enabled, this environment
variable controls the debug level for the
.B BJNP and MFNP
network protocols for this backend. Higher value increases
the verbosity and includes the information printed at the lower levels.
.RS
0 print nothing (default)
.br
1 Print error and warning messages (recommended)
.br
2 Print high level function tracing information
.br
3 Print more detailed protocol tracing information
.br
4 Print protocol headers
.br
5 Print full protocol contents
.RE
.TP
.B PIXMA_EXPERIMENT
Setting to a non-zero value will enable the support for experimental models.
You should also set SANE_DEBUG_PIXMA to 11.
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  On *NIX systems, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in
.IR @CONFIGDIR@ .
If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories
.IR "tmp/config" ,
.IR "." ,
and
.I "@CONFIGDIR@"
being searched (in this order).
.SH "SEE ALSO"
.BR sane (7),
.BR sane\-dll (5),
.BR scanimage (1),
.BR scanadf (1),
.BR gamma4scanimage (1),
.BR getifaddrs (3)
.PP
In case of trouble with a recent Pixma model, try the latest code for
the
.B sane\-pixma
backend, available in the Sane git repository at:
.br
.I https://gitlab.com/sane-project/backends.git
.PP
You can also post into the Sane-devel mailing list for support.

.SH AUTHORS
Wittawat Yamwong, Nicolas Martin, Dennis Lou, Louis Lagendijk, Rolf Bensch
.PP
We would like to thank all testers and helpers. Without them we could not be
able to write subdrivers for models we don't have. See also the project
homepage.
