#if 0
/* Enhanced 3D Now!߂̂݃AZuꍇ */
#define ONLY_E3DN
#endif

#include "mydef.h"
#include "parser.h"
#include "errmes.h"
#include "getnum.h"
#include <ctype.h>

#ifdef __unix__
#define stricmp strcmp
#endif

/*
 *	ANSIWstricmpgB(͑啶ʂɔr)
 */

/*
 *	MMX,3D Now!߂̃R[hꗗ
 *	3D Now!߂łȂprefix0x0F݂̂femms߂MMX̂Ƃɂ
 *	lprefetch,prefetchwʈɂ
 */

static CODE_MAP MMXcode[]={
	{"emms"		,tNONE		,tNONE		,0x77,0},	/* emmsfemms͂ */
	{"femms"	,tNONE		,tNONE		,0x0E,0},	/* ړs! */
#ifndef ONLY_E3DN
	{"movd"		,tMMX		,tR32|tMEM	,0x6E,0},
	{"movd"		,tR32|tMEM	,tMMX		,0x7E,0},
	{"movq"		,tMMX		,tMMX|tMEM	,0x6F,0},
	{"movq"		,tMMX|tMEM	,tMMX		,0x7F,0},
	{"packssdw"	,tMMX		,tMMX|tMEM	,0x6B,0},
	{"packsswb"	,tMMX		,tMMX|tMEM	,0x63,0},
	{"packuswb"	,tMMX		,tMMX|tMEM	,0x67,0},
	{"paddb"	,tMMX		,tMMX|tMEM	,0xFC,0},
	{"paddd"	,tMMX		,tMMX|tMEM	,0xFE,0},
	{"paddsb"	,tMMX		,tMMX|tMEM	,0xEC,0},
	{"paddsw"	,tMMX		,tMMX|tMEM	,0xED,0},
	{"paddusb"	,tMMX		,tMMX|tMEM	,0xDC,0},
	{"paddusw"	,tMMX		,tMMX|tMEM	,0xDD,0},
	{"paddw"	,tMMX		,tMMX|tMEM	,0xFD,0},
	{"pand"		,tMMX		,tMMX|tMEM	,0xDB,0},
	{"pandn"	,tMMX		,tMMX|tMEM	,0xDF,0},
	{"pcmpeqb"	,tMMX		,tMMX|tMEM	,0x74,0},
	{"pcmpeqd"	,tMMX		,tMMX|tMEM	,0x76,0},
	{"pcmpeqw"	,tMMX		,tMMX|tMEM	,0x75,0},
	{"pcmpgtb"	,tMMX		,tMMX|tMEM	,0x64,0},
	{"pcmpgtd"	,tMMX		,tMMX|tMEM	,0x66,0},
	{"pcmpgtw"	,tMMX		,tMMX|tMEM	,0x65,0},
	{"pmaddwd"	,tMMX		,tMMX|tMEM	,0xF5,0},
	{"pmulhw"	,tMMX		,tMMX|tMEM	,0xE5,0},
	{"pmullw"	,tMMX		,tMMX|tMEM	,0xD5,0},
	{"por"		,tMMX		,tMMX|tMEM	,0xEB,0},
	{"psllw"	,tMMX		,tMMX|tMEM	,0xF1,0},
	{"psllw"	,tMMX		,tIMM8		,0x71,0xF0},
	{"pslld"	,tMMX		,tMMX|tMEM	,0xF2,0},
	{"pslld"	,tMMX		,tIMM8		,0x72,0xF0},
	{"psllq"	,tMMX		,tMMX|tMEM	,0xF3,0},
	{"psllq"	,tMMX		,tIMM8		,0x73,0xF0},
	{"psraw"	,tMMX		,tMMX|tMEM	,0xE1,0},
	{"psraw"	,tMMX		,tIMM8		,0x71,0xE0},
	{"psrad"	,tMMX		,tMMX|tMEM	,0xE2,0},
	{"psrad"	,tMMX		,tIMM8		,0x72,0xE0},
	{"psraq"	,tMMX		,tMMX|tMEM	,0xE3,0},
	{"psraq"	,tMMX		,tIMM8		,0x73,0xE0},
	{"psrlw"	,tMMX		,tMMX|tMEM	,0xD1,0},
	{"psrlw"	,tMMX		,tIMM8		,0x71,0xD0},
	{"psrld"	,tMMX		,tMMX|tMEM	,0xD2,0},
	{"psrld"	,tMMX		,tIMM8		,0x72,0xD0},
	{"psrlq"	,tMMX		,tMMX|tMEM	,0xD3,0},
	{"psrlq"	,tMMX		,tIMM8		,0x73,0xD0},
	{"psubb"	,tMMX		,tMMX|tMEM	,0xF8,0},
	{"psubd"	,tMMX		,tMMX|tMEM	,0xFA,0},
	{"psubsb"	,tMMX		,tMMX|tMEM	,0xE8,0},
	{"psubsw"	,tMMX		,tMMX|tMEM	,0xE9,0},
	{"psubusb"	,tMMX		,tMMX|tMEM	,0xD8,0},
	{"psubusw"	,tMMX		,tMMX|tMEM	,0xD9,0},
	{"psubw"	,tMMX		,tMMX|tMEM	,0xF9,0},
	{"punpckhbw",tMMX		,tMMX|tMEM	,0x68,0},
	{"punpckhwd",tMMX		,tMMX|tMEM	,0x69,0},
	{"punpckhdq",tMMX		,tMMX|tMEM	,0x6A,0},
	{"punpcklbw",tMMX		,tMMX|tMEM	,0x60,0},
	{"punpcklwd",tMMX		,tMMX|tMEM	,0x61,0},
	{"punpckldq",tMMX		,tMMX|tMEM	,0x62,0},
	{"pxor"		,tMMX		,tMMX|tMEM	,0xEF,0},
#endif
	{""			,tNONE		,tNONE		,0   ,0},
},
_3DNOWcode[]={
#ifndef ONLY_E3DN
	{"pavgusb"	,tMMX		,tMMX|tMEM	,0xBF,0},
	{"pfadd"	,tMMX		,tMMX|tMEM	,0x9E,0},
	{"pfsub"	,tMMX		,tMMX|tMEM	,0x9A,0},
	{"pfsubr"	,tMMX		,tMMX|tMEM	,0xAA,0},
	{"pfacc"	,tMMX		,tMMX|tMEM	,0xAE,0},
	{"pfmul"	,tMMX		,tMMX|tMEM	,0xB4,0},
	{"pfcmpge"	,tMMX		,tMMX|tMEM	,0x90,0},
	{"pfcmpgt"	,tMMX		,tMMX|tMEM	,0xA0,0},
	{"pfcmpeq"	,tMMX		,tMMX|tMEM	,0xB0,0},
	{"pfmin"	,tMMX		,tMMX|tMEM	,0x94,0},
	{"pfmax"	,tMMX		,tMMX|tMEM	,0xA4,0},
	{"pi2fd"	,tMMX		,tMMX|tMEM	,0x0D,0},
	{"pf2id"	,tMMX		,tMMX|tMEM	,0x1D,0},
	{"pfrcp"	,tMMX		,tMMX|tMEM	,0x96,0},
	{"pfrsqrt"	,tMMX		,tMMX|tMEM	,0x97,0},
	{"pfrcpit1"	,tMMX		,tMMX|tMEM	,0xA6,0},
	{"pfrsqit1"	,tMMX		,tMMX|tMEM	,0xA7,0},
	{"pfrcpit2"	,tMMX		,tMMX|tMEM	,0xB6,0},
	{"pmulhrw"	,tMMX		,tMMX|tMEM	,0xB7,0},
#endif
/* 99/09/28 Enhanced 3D Now! */
	{"pfnacc"	,tMMX		,tMMX|tMEM	,0x8A,0},
	{"pfpnacc"	,tMMX		,tMMX|tMEM	,0x8E,0},
	{"pi2fw"	,tMMX		,tMMX|tMEM	,0x0C,0},
	{"pf2iw"	,tMMX		,tMMX|tMEM	,0x1C,0},
	{"pswapd"	,tMMX		,tMMX|tMEM	,0xBB,0},
	{""			,tNONE		,tNONE		,0   ,0},
},
PREFETCHcode[]={
#ifndef ONLY_E3DN
	{"prefetch"	,tMEM		,tNONE		,0x0D,0},
	{"prefetchw",tMEM		,tNONE		,0x0D,8},
#endif
	{""			,tNONE		,tNONE		,0   ,0},
};

/*
 *	͂Iyh̏𓾂
 *	ope͐lłȂƂȂ
 */

CODE_MAP *getCodeProperty(OPECODE ope){
	switch(ope.group){
	case MMX_CODE:
		return &MMXcode[ope.num];
	case _3DNOW_CODE:
		return &_3DNOWcode[ope.num];
	case PREFETCH_CODE:
		return &PREFETCHcode[ope.num];
	default:
		fprintf(stderr,"code err in getCodeProperty\n");
		exit(1);
	}
}

/*
 *	TOKEN_TYPEɑΉ鎟̕Ă
 *	o̍Ō̕|C^+1Ԃ
 *	*src==NUL̏ꍇsrcԂ
 */

char *nextToken(TOKEN *tok,char *src){
	char *p=tok->str;
	while(*src==' ' || *src=='\t')src++;	/* 󔒂XLbv */
	tok->begin=src;
	switch(*src){
	case NUL:
		tok->type=TOKEN_NONE;
		*p=NUL;
		return src;
	case ':':
		tok->type=TOKEN_COLON;
		break;
	case ',':
		tok->type=TOKEN_COMMA;
		break;
	case '+':
		tok->type=TOKEN_ADD;
		break;
	case '-':
		tok->type=TOKEN_SUB;
		break;
	case '*':
		tok->type=TOKEN_MUL;
		break;
	case '[':
		tok->type=TOKEN_OPEN;
		break;
	case ']':
		tok->type=TOKEN_CLOSE;
		break;
	case '=':
		tok->type=TOKEN_EQU;
		break;
	default:
		tok->type=TOKEN_STR;
		while(*src && *src!=':' && *src!=',' && *src!='+' && *src!='-' &&
					  *src!='*' && *src!='[' && *src!=']' && *src!='=' &&
					  *src!=' ' && *src!='\t')*p++=*src++;
		*p=NUL;
		return src;
	}
	/* NONE,STRȊO1؂蕶̏ꍇ */
	*p++=*src++;
	*p=NUL;
	return src;
}

/*
 *	ėpWX^̃R[hԂ
 *	ꍇ-1Ԃ
 */

static int get32bitRegCode(char *src){
	static char reg[8][4]={
		"eax","ecx","edx","ebx","esp","ebp","esi","edi"
	};
	int i;
	char buf[4];
	if(src[3])return -1;
	buf[0]=tolower(src[0]);
	buf[1]=tolower(src[1]);
	buf[2]=tolower(src[2]);
	for(i=0;i<8;i++){
		if(!strncmp(reg[i],buf,3))return i;
	}
	return -1;
}

/*
 *	mmxWX^̃R[hԂ
 *	ꍇ-1Ԃ
 */

static int getMMXRegCode(char *src){
	int i;
	char buf[3];
	if(src[3])return -1;
	buf[0]=tolower(src[0]);
	buf[1]=tolower(src[1]);
	buf[2]=tolower(src[2]);
	if(buf[0]!='m' || buf[1]!='m')return -1;
	for(i=0;i<8;i++){
		if(buf[2]==(char)('0'+i))return i;
	}
	return -1;
}

/*
 *	sreg̃R[hԂ
 *	ꍇ-1Ԃ
 */

static int getSegRegCode(char *src){
	char buf[2];
	buf[0]=tolower(src[0]);
	buf[1]=tolower(src[1]);
	if(buf[1]!='s')return -1;
	switch(buf[0]){
	case 'c':
		return 0x2E;
	case 'd':
		return 0x3E;
	case 'e':
		return 0x26;
	case 'f':
		return 0x64;
	case 'g':
		return 0x65;
	case 's':
		return 0x36;
	default:
		return -1;
	}
}

/*
 *	AhbVO͂
 *	src=sreg:[base+index*scale+disp]
 *	ǂ̍ȗĂ\
 *	disp͂̘a⍷ɂȂĂĂ
 *	[]̏ԂȂ
 *	sreg,base,index̕@I͌Ȃ
 *	adr̒g
 *	ERRԂꍇ͕s
 *	NOERȐꍇ' ','\t'܂܂Ȃ񂪕Ԃ
 */

static int analyzeAddressing(ADDRESSING *adr,char *src){
	TOKEN tok;
	int baseFlag=0;
	int indexFlag=0;
	int prevFlag=0;	/*O 0:STRȊO 1:STR */
	int canOmitKakko=0;	/* []ȗo邩 */
	int code,len;
	char *buf=adr->disp;
	if(src==NULL)return errMes(ERR_NOTHING);

	/* ϐ̏ */
	adr->seg  =-1;
	adr->base =-1;
	adr->index=-1;
	adr->scale=-1;
	adr->disp[0]=NUL;

	src=nextToken(&tok,src);
	if(tok.type==TOKEN_STR){

		/* [d|q]word ptrZq̖(bI) */

		if(!stricmp(tok.str,"dword")||!stricmp(tok.str,"qword")){
			src=nextToken(&tok,src);
#if 1
		/* 99/09/28 ptr ZqΔ΂(NASMΉ) */
			if(tok.type==TOKEN_STR && !stricmp(tok.str,"ptr")){
				src=nextToken(&tok,src);
			}
#else
			if(tok.type!=TOKEN_STR || stricmp(tok.str,"ptr")){
				return errMes(ERR_PTR);
			}
			src=nextToken(&tok,src);
#endif
			canOmitKakko++;	/* '[',']'ȗĂ悢 */
		}

		/* sreg邩ǂ̉ */

		code=getSegRegCode(tok.str);
		if(code!=-1){	/* sregł */
			adr->seg=code;
			src=nextToken(&tok,src);
			if(tok.type!=TOKEN_COLON){	/* sreg̎':'łȂƂȂ */
				return errMes(ERR_SEG);
			}
			src=nextToken(&tok,src);
		}
	}
	if(canOmitKakko){
		if(tok.type==TOKEN_OPEN){
			canOmitKakko=0;	/* '['̂Ȃ']'͏ȗsɂȂ */
			src=nextToken(&tok,src);
		}
	}else{
		if(tok.type!=TOKEN_OPEN){	/* '['Ŏn܂͂ */
			return errMes(ERR_OPEN);
		}
		src=nextToken(&tok,src);
	}
	/* [base+index+disp]̉ */
	for(;;){
		if(tok.type==TOKEN_STR){
			code=get32bitRegCode(tok.str);
			if(code!=-1){	/* WX^݂ */
				src=nextToken(&tok,src);
				if(tok.type==TOKEN_MUL){	/* indexWX^H */
					if(indexFlag)return errMes(ERR_DOUBLE_INDEX);
					if(code==ESP_CODE)return errMes(ERR_ESP_INDEX);
					indexFlag++;
					adr->index=code;
					
					/* "reg * ?"?߂ */
					src=nextToken(&tok,src);
					if(tok.str[1]!=NUL)return errMes(ERR_SCALE);
					switch(tok.str[0]){
					case '1':
						adr->scale=0;
						break;
					case '2':
						adr->scale=1;
						break;
					case '4':
						adr->scale=2;
						break;
					case '8':
						adr->scale=3;
						break;
					default:
						return errMes(ERR_SCALE);
					}
					src=nextToken(&tok,src);	/* ̂o */
				}else{
					/* xbaseWX^ */
					if(baseFlag){	/* basegĂȂindexƂ */
						if(indexFlag)return errMes(ERR_DOUBLE_INDEX);
						if(code==ESP_CODE)return errMes(ERR_ESP_INDEX);
						indexFlag++;
						adr->scale=0;
						adr->index=code;
					}else{
						baseFlag++;
						adr->base=code;
					}
				}	/* WX^͏I */

				/* WX^̎'+'܂'-'܂']'łȂƑʖ */
				if( tok.type!=TOKEN_ADD && tok.type!=TOKEN_SUB &&
					(!canOmitKakko && tok.type!=TOKEN_CLOSE)){
						return errMes(ERR_REG_NEXT);
				}

				/* WX^̑O'+'łȂƂȂ */
				len=strlen(buf);
				if(len>0){
					if(buf[len-1]!='+')return errMes(ERR_REG_PREV);
					buf[len-1]=NUL;/* displacementreg */
				}
			}
		}
		if(tok.type==TOKEN_NONE)break;
		/* bufɂ */
		if(tok.type==TOKEN_STR){
			if(prevFlag)return errMes(ERR_STR);
			prevFlag=1;
		}else{
			prevFlag=0;
		}
		len=strlen(buf)+strlen(tok.str);
		if(len>=sizeof(adr->disp))return errMes(ERR_TOO_LONG);
		strcat(buf,tok.str);
		src=nextToken(&tok,src);
	}
	len=strlen(buf);
	if(adr->base==-1 && adr->index==-1 && len<=1)return errMes(ERR_NOTHING);
	/* Ō']'ŏI͂ */
	if(buf[len-1]==']'){
		if(canOmitKakko)return errMes(ERR_OPEN); /* '['͂Ȃ񂾂 */
		buf[len-1]=NUL;
	}else{
		if(!canOmitKakko)return errMes(ERR_CLOSE);
	}
	return NOERR;
}

/*
 *	Iyh
 *	ėpWX^->̃R[h
 *	MMXWX^ ->̃R[h
 *	l    ->̒l
 *	AhbVO[h->̌`
 */

static int analyzeOperand(OPERAND *ope,char *src){
	int ret;
	int32 num;
	TOKEN tok;
	nextToken(&tok,src);
	if(tok.type==TOKEN_NONE){
		ope->type=tNONE;
		return NOERR;
	}
	ret=get32bitRegCode(tok.str);
	if(ret!=-1){
		ope->type=tR32;
		ope->ope.reg=ret;
		return NOERR;
	}
	ret=getMMXRegCode(tok.str);
	if(ret!=-1){
		ope->type=tMMX;
		ope->ope.reg=ret;
		return NOERR;
	}
	/* ȉ2̊֐ւtokenɋ؂Ȃœn */
	if(getNumber(&num,src)==NOERR){
		ope->type=tIMM8;
		ope->ope.imm=num;
		return NOERR;
	}
	if(analyzeAddressing(&ope->ope.adr,src)==ERR)return ERR;
	ope->type=tMEM;
	return NOERR;
}

/*
 *	srcnextToken()ŋ؂ꂽ
 *	K閽߂̔ԍԂ
 */

static int searchCode(OPECODE *code,char *src){
	char buf[12];
	char *p;
	int i;

	if(strlen(src)>=sizeof(buf)){
		code->group=NO_MATCH;
		code->num=0;
		return NOERR;
	}
	p=buf;
	for(p=buf;*src;src++){
		*p++=tolower(*src);
	}
	*p=NUL;
	for(i=0;i<sizeof(MMXcode)/sizeof(MMXcode[0])-1;i++){
		if(!strcmp(MMXcode[i].name,buf)){
			code->group=MMX_CODE;
			code->num=i;
			return NOERR;
		}
	}
	for(i=0;i<sizeof(_3DNOWcode)/sizeof(_3DNOWcode[0])-1;i++){
		if(!strcmp(_3DNOWcode[i].name,buf)){
			code->group=_3DNOW_CODE;
			code->num=i;
			return NOERR;
		}
	}
	for(i=0;i<sizeof(PREFETCHcode)/sizeof(PREFETCHcode[0])-1;i++){
		if(!strcmp(PREFETCHcode[i].name,buf)){
			code->group=PREFETCH_CODE;
			code->num=i;
			return NOERR;
		}
	}
	code->group=NO_MATCH;
	code->num=0;
	return NOERR;
}

/*
 *	Rg폜y'\n'̍폜
 */

static void deleteComment(char *dst,char *src){
	char *p;
	int len;
	p=strchr(src,';');
	if(p){
		strncpy(dst,src,p-src);
		dst[p-src]=NUL;
	}else{
		strcpy(dst,src);
	}
	len=strlen(dst);
#if 0
	if(len>0 && dst[len-1]=='\n')dst[len-1]=NUL;	/* '\n' ̍폜 */
#endif
}

/*
 *	1s̃f[^烉xAIyR[hAIyh͂
 */

int analyzeCode(CODE *code,char *src){
	char buf[strLenMax];
	TOKEN prevTok;
	TOKEN nowTok;
	CODE_MAP *map;
	char *p,*q;

	/* ϐ */
	code->label[0]=NUL;
	code->icode.group=NO_MATCH;

	/* Rg폜 */
	deleteComment(buf,src);

	/* xo */
	p=nextToken(&prevTok,buf);
	if(prevTok.type!=TOKEN_STR)return NOERR;
	
	p=nextToken(&nowTok,p);
	if(nowTok.type==TOKEN_COLON){	/* prev̓xł */
		if(strlen(prevTok.str)>=sizeof(code->label)){
			return errMes(ERR_TOO_LONG);
		}
		strcpy(code->label,prevTok.str);
		p=nextToken(&prevTok,p);		/* x蒼 */
		p=nextToken(&nowTok,p);
	}
	/* prev͖߂ł͂ */

	if(prevTok.type==TOKEN_NONE)return NOERR;
	if(prevTok.type!=TOKEN_STR)return errMes(ERR_OPERAND);

	if(searchCode(&code->icode,prevTok.str)==ERR)return ERR;
	if(code->icode.group==NO_MATCH)return NOERR;

	/* 2ڂ̃Iyh邩H */
	q=strchr(p,',');
	if(q){
		*q=NUL;	/* 1ڂ2ڂ؂ */
		if(analyzeOperand(&code->ope2,q+1)==ERR)return ERR;
	}else{
		code->ope2.type=tNONE;
	}
	
	/* 1ڂ̃Iyh(󂩂Ȃ) */
	if(analyzeOperand(&code->ope1,nowTok.begin)==ERR)return ERR;
	map=getCodeProperty(code->icode);
	if((map->ope1 & code->ope1.type) && (map->ope2 & code->ope2.type)){
		return NOERR;
	}
	/* ͂Ȃꂵ IyhɂmodR/Mς̂̂ */
	if(!strcmp(map->name,map[1].name) 
		&& (map[1].ope1 & code->ope1.type) && (map[1].ope2 & code->ope2.type)){
		code->icode.num++;
		return NOERR;
	}
	return errMes(ERR_OPERAND_OPECODE);
}

#if 0
static char regR32[8][4]={
	"eax","ecx","edx","ebx","esp","ebp","esi","edi"
};
void putAdr(ADDRESSING adr){
	printf("seg=%x\n",adr.seg);
	printf("base=%s\n" ,(adr.base!=-1) ?regR32[adr.base] :"none");
	printf("index=%s\n",(adr.index!=-1)?regR32[adr.index]:"none");
	if(adr.index!=-1){
		printf("scale=%d\n",1<<adr.scale);
	}
	printf("disp=%s\n",adr.disp);
}

void putOPERAND(OPERAND ope){
	switch(ope.type){
	case tNONE:
		puts("none");
		return;
	case tR32:
		printf("reg=%s\n",regR32[ope.ope.reg]);
		return;
	case tMMX:
		printf("reg=MM%d\n",ope.ope.reg);
		return;
	case tIMM8:
		printf("imm=%ld\n",ope.ope.imm);
		return;
	case tMEM:
		putAdr(ope.ope.adr);
		return;
	default:
		puts("err ???");
		return;
	}
}

putCODE(CODE code){
	OPECODE *c=&code.icode;
	CODE_MAP *m;
	printf("label=%s\n",code.label);
	if(c->group==NO_MATCH){
		puts("code none");
		return;
	}
	m=getCodeProperty(*c);
	printf("kind of code is %s:"
			,(c->group==MMX_CODE)?"MMX"
			:(c->group==_3DNOW_CODE)?"3D Now!"
			:(c->group==PREFETCH_CODE)?"prefetch":"err");
	printf("%s  [%x][%x]\n",m->name,m->code,m->mod);
	if(code.ope1.type==tNONE){
		puts("ope1=none");return;
	}
	putOPERAND(code.ope1);
	if(code.ope2.type==tNONE){
		puts("ope2=none");return;
	}
	putOPERAND(code.ope2);
}

int main(int argc,char *argv[]){
	CODE code;
	argc--,argv++;
	printf("cmd=%s\n",*argv);
	if(analyzeCode(&code,*argv)==ERR)return ERR;
	putCODE(code);
	return NOERR;
}
#endif
