/*
 *	This is `readsmpl.c' for Windows
 */
/*
 *	for new GOGO-no-coda (1999/09)
 *	Copyright (C) 1999 PEN@MarineCat, shigeo, Noisyu
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <limits.h>
#include "common.h"
#include "global.h"
#include "readsmpl.h"
#include "musenc.h"

/* #define		_1SHL32			( (double)(1UL<<31) * 2.0 ) */
#define		_1SHL32			4294967296.0
#define		SAMPLE_LENGTH		2304
#define		SAMPLE_TAKEBACK		8
#define		USE_FLOATING
struct _SAMPLE_CONVERTER {
	unsigned long		pitch_lo, pitch_hi;
	unsigned long		pos_lo, pos_hi;
	unsigned long		pcmreadpos;
	unsigned long		fill_len;
	int					bFirstAttach;
	int					bHitEof;
	short				sample_org[ SAMPLE_LENGTH + SAMPLE_TAKEBACK];

	char				bPausedRead;
	unsigned long		pcmdecodepos;
	short				sample_decode[ SAMPLE_LENGTH ];
} samplecnverter;


extern struct MCP_INPDEV_USERFUNC	mc_userfunc;		// extern/[U[֐ݒ
extern unsigned long read_limitsize;

int		InitializeSampleConverter( int freq_in, int freq_out )
{
	double	pitch_tmp;
	if( freq_in <= 0 || freq_out <= 0){
		return FALSE;
	}
	memset( &samplecnverter, 0, sizeof( samplecnverter ) );
	if(freq_in == freq_out ){
	/* freqin == freqout̂Ƃ̓Ro[^[ʂȂǈꉞvZĂ */
		samplecnverter.pitch_hi = 1;
		samplecnverter.pitch_lo = 0;
	} else {
		samplecnverter.pitch_hi = freq_in / freq_out;
		if( freq_in >= freq_out ) freq_in %= freq_out;
		pitch_tmp = (double)freq_in * _1SHL32 / (double)freq_out;
		samplecnverter.pitch_lo = (unsigned long)pitch_tmp;
	}

	samplecnverter.pcmreadpos   = - SAMPLE_TAKEBACK - SAMPLE_LENGTH;
	samplecnverter.bFirstAttach = TRUE;
	samplecnverter.bPausedRead = FALSE;

	return TRUE;
}

/* wait for realtime-encoding by zin@jaist.ac.jp (00/02/22) */
static INLINE
size_t fread_nitems(
	void *buf,
	size_t size,
	size_t nitems,
	FILE *stream)
{
	size_t nread;

	nitems *= size;
	if( read_limitsize == ULONG_MAX ) {
		return fread( buf, 1, nitems, stream) / size;
	} else {
		nread = 0;
		if( read_limitsize < nitems )
			nitems = read_limitsize;
		if( nitems > 0 ){
			nread = fread( buf, 1, nitems , stream);
			if( nread > 0 )
				read_limitsize -= nread;
		} else {
			nread = 0;
		}
		return nread / size;
	}
}

#ifdef BENCH_ONLY
int initBenchFlag;	/* exported to musenc.c */
static int enc_testtime = 10;
static unsigned int seed = 0;
static int GENRAND()
{
	seed = seed * 0x32842851 + 12398321;
	return seed & INT_MAX;
}

/* ----------------------------------------------------------------------- */
#define		MAX_CHANNEL			16	
static	short test_sample[MAX_CHANNEL][2304];
static
MERET	enctest_inputfunc(void *buf, unsigned long nLength )
{
//	static	int firstcall = 1;
	static	int	nRestFrame;
	if(initBenchFlag){
		int		i, j, nMax;

//		firstcall = 0;
		initBenchFlag = 0;
		seed = 0;
		for(i = 0;i < MAX_CHANNEL; i ++ ){
			nMax = 0x4000 + 0x6000 * i / MAX_CHANNEL;
			for(j = 0;j < 2304;j++){
				test_sample[i][j] = (GENRAND() % nMax) - nMax/2 ;
			}
		}
		nRestFrame = (int)(mc_userfunc.nSize / 4608.0);		// ct[
	}
	if( 0 < nRestFrame-- ){
		memcpy( buf, test_sample[ GENRAND() % MAX_CHANNEL ], nLength );
		return ME_NOERR;
	}
	return ME_EMPTYSTREAM;
}
#endif /* BENCH_ONLY */

static SAMPLES_T
read_samples_sub(
	FILE			*musicin,
	short			*sample_buffer,
	unsigned long	*frame_size)
{
	unsigned long	samples_read;
	samples_read = *frame_size;

#ifdef BENCH_ONLY
	mc_userfunc.pUserFunc = enctest_inputfunc;
#endif /* BENCH_ONLY */

	if( mc_userfunc.pUserFunc == MPGE_NULL_FUNC ){
		if( !bBitConvert ){
			// 16BIT PCM
			samples_read = fread_nitems(sample_buffer, sizeof(short), (int)samples_read, musicin);
#ifdef RAW_INPUT
			if( bSwapByte == TRUE ){
				int i;
				char low, high;
				for( i = 0; i < samples_read; i++ ){
					low = sample_buffer[i] & 0xFF;
					high = (unsigned)sample_buffer[i] >> 8;
					sample_buffer[i] = high + ( low << 8 );
				}
			}
#endif /* RAW_INPUT */
		} else {
			// 8BIT PCM
			int		i;
			unsigned char	org_buffer[4096];
			if ((samples_read =	fread_nitems(org_buffer, sizeof(char), (int)samples_read, musicin)) == 0){
				// HIT END OF DATA //

			}
			// 8BIT to 16BIT 
#ifdef RAW_INPUT
			if( bTownsSND ){
				for( i = 0; i < samples_read; i++ ){
					char data;
					data = org_buffer[i];
					if( data & 0x80 ){
						sample_buffer[i] = ((short)( data - 128 )) << 8;
					}else{
						sample_buffer[i] = ((short)( - data )) << 8;
					}
				}
			}else
#endif /* RAW_INPUT */
			for(i = 0;i < (signed)samples_read;i++){
				sample_buffer[i] = (org_buffer[i] - 128) << 8;
			}
		}
	} else {
		// [U[֐x[X
		// œȃG[R[hKvL
		if( !bBitConvert ){
			// 16BIT PCM
			MERET	rval;

			memset( sample_buffer, 0, (int)samples_read * 2 );
			rval = mc_userfunc.pUserFunc( sample_buffer, (int)samples_read * 2);
			if ( rval == ME_NOERR ){
				/// ǂݍݐ̏ꍇɂ͉Ȃ
			} else if( rval == ME_MOREDATA ){ 
				/// ɓǂݍ݂
				return SAMPLES_PAUSED;
			} else {
				samples_read = 0;
			}
		} else {
			// 8BIT PCM
			int		i;
			MERET	rval;
			unsigned char	org_buffer[4096];

			memset( org_buffer, 0, (int)samples_read );
			rval = mc_userfunc.pUserFunc( org_buffer, (int)samples_read );
			if ( rval == ME_NOERR ){
				/// ǂݍݐ̏ꍇɂ͉Ȃ
			} else if( rval == ME_MOREDATA ) {
				/// ɓǂݍ݂
				return SAMPLES_PAUSED;
			} else {
				samples_read = 0;
			}
			// 8BIT to 16BIT 
			for(i = 0;i < (signed)samples_read;i++)
				sample_buffer[i] = (org_buffer[i] - 128) << 8;
		}
	}
	if( samples_read < *frame_size ){
		int	clr = samples_read;
		for (; clr < (signed)*frame_size; sample_buffer[clr++] = 0);
	}
	*frame_size = samples_read;

	return	(samples_read == 0) ? SAMPLES_FAIL : SAMPLES_READ;
}



static	SAMPLES_T
getsample(unsigned long pos, FILE *musicin, int *sample )
{
	assert( pos - samplecnverter.pcmreadpos >= 0 );
	if( (int)pos >= (int)(samplecnverter.pcmreadpos + samplecnverter.fill_len) ){
		unsigned long		readsamplenum;
		SAMPLES_T			rval;

		// f[^̖[ɓBĂꍇ
		if( samplecnverter.bHitEof ) {
			*sample = 0;
			return SAMPLES_HITEND;				// ȍ~f[^
		}

		// obt@̍Ō̕𓪂ɎĂ
		memcpy( &samplecnverter.sample_org[0], &samplecnverter.sample_org[SAMPLE_LENGTH    ], sizeof( short ) * SAMPLE_TAKEBACK );

		// ȍ~̃f[^fill
		readsamplenum = SAMPLE_LENGTH;
		rval = read_samples_sub( musicin, &samplecnverter.sample_org[SAMPLE_TAKEBACK], &readsamplenum );
		if( rval == SAMPLES_PAUSED )
			return rval;
//		assert( readsamplenum == SAMPLE_LENGTH );

		if( readsamplenum != SAMPLE_LENGTH ){
			samplecnverter.bHitEof = TRUE;
		}

		// f[^vʒũZbg
		samplecnverter.pcmreadpos += readsamplenum;
		samplecnverter.fill_len    = SAMPLE_TAKEBACK + readsamplenum;

		return	getsample( pos, musicin, sample );			// ċA
	}

	assert( pos < samplecnverter.pcmreadpos + samplecnverter.fill_len );

	*sample = (signed int )(samplecnverter.sample_org[ pos - samplecnverter.pcmreadpos]);
	return SAMPLES_READ;
}



static	SAMPLES_T
read_samples(
	FILE			*musicin,
	short			sample_buffer[2304],
	unsigned long	frame_size,
	int				chn
) {
	int		i;
	if( gl.enc_freqHz == gl.inp_freqHz ){
		// ̂܂܃X[
		return read_samples_sub( musicin, sample_buffer, &frame_size );
	} else {
		if( samplecnverter.bHitEof && (samplecnverter.pos_hi * 2) >= samplecnverter.pcmreadpos + samplecnverter.fill_len ){
			memset( sample_buffer, 0, frame_size );
			return SAMPLES_HITEND;				// ǂݍ݂łȂ
		}
		if( chn == 1 ){
			// MONO
			SAMPLES_T		rval = SAMPLES_READ;
			i = 0;
			if( samplecnverter.bPausedRead ){
				int		n;
				i = samplecnverter.pcmdecodepos;
				for(n = 0;n < i;n ++){
					sample_buffer[n] = samplecnverter.sample_decode[n];
				}
				samplecnverter.bPausedRead = FALSE;
			}
			for(;i < (signed)frame_size;i++){
				int			s1, s2;
				int			pts;

				rval = getsample( samplecnverter.pos_hi, musicin, &s1 );
				if( SAMPLES_READ != rval )
					break;
				if( samplecnverter.pos_lo == 0 ){
					sample_buffer[ i ] = s1 ;
				} else {
					pts = samplecnverter.pos_lo >> 17;
					rval = getsample( samplecnverter.pos_hi + 1, musicin, &s2 );
					if( SAMPLES_READ != rval )
						break;
assert( pts >= 0 && pts < 0x8000 );
					sample_buffer[ i ] = (s1 * ( 0x8000 - pts ) + s2 * pts) >> 15;  
				}

				{
					unsigned long		org_lo;
					org_lo = samplecnverter.pos_lo;
					samplecnverter.pos_lo += samplecnverter.pitch_lo;
					if( samplecnverter.pos_lo < org_lo ){
						samplecnverter.pos_hi += samplecnverter.pitch_hi + 1;
					} else {
						samplecnverter.pos_hi +=samplecnverter.pitch_hi;
					}
				}
			}

			if( rval != SAMPLES_READ ){
				int		n;
				if( rval == SAMPLES_PAUSED ){
					samplecnverter.bPausedRead  = TRUE;
					samplecnverter.pcmdecodepos = i;
					for(n = 0;n < i;n++){
						samplecnverter.sample_decode[n] = sample_buffer[n];
					}
				} else {
					for(n = i;n < frame_size;n++){
						samplecnverter.sample_decode[n] = 0;
					}
				}
			}
			return rval;
		} else {
			// STEREO
			SAMPLES_T		rval = SAMPLES_READ;
			i = 0;
			if( samplecnverter.bPausedRead ){
				int		n;
				i = samplecnverter.pcmdecodepos;
				for(n = 0;n < i;n ++){
					sample_buffer[n] = samplecnverter.sample_decode[n];
				}
				samplecnverter.bPausedRead = FALSE;
			}
			for(;i < (signed)frame_size;i += 2){
				int				s1, s2, sa;
//				int				pts;

				// LEFT 
				rval = getsample( samplecnverter.pos_hi * 2, musicin, &s1 );
				if( SAMPLES_READ != rval )
					break;
				if( samplecnverter.pos_lo == 0 ){
					sample_buffer[ i ] = s1;
				} else {
#ifdef	USE_FLOATING
					double	pts;
					rval = getsample( samplecnverter.pos_hi * 2 + 2, musicin, &s2 );
					if( SAMPLES_READ != rval )
						break;

					pts = (double)samplecnverter.pos_lo / _1SHL32;
					sa = (int)((double)s1 * ( 1.0 - pts ) + (double)s2 * pts); 
assert( sa >= -0x8000 && sa <= 0x7fff );
					sample_buffer[ i ] = sa ;
#else
					pts = samplecnverter.pos_lo >> 17;
					rval = getsample( samplecnverter.pos_hi * 2 + 2, musicin, &s2 );
					if( SAMPLES_READ != rval )
						break;
assert( pts >= 0 && pts < 0x8000 );
					sa = s1 * ( 0x8000 - pts ) + s2 * pts; 
					sample_buffer[ i ] = sa >> 15;
#endif
				}

				// RIGHT
				rval = getsample( samplecnverter.pos_hi * 2 + 1, musicin, &s1 );
				if( SAMPLES_READ != rval )
					break;
				if( samplecnverter.pos_lo == 0 ){
					sample_buffer[ i + 1 ] = s1;
				} else {
#ifdef	USE_FLOATING
					double	pts;
					rval = getsample( samplecnverter.pos_hi * 2 + 3, musicin, &s2 );
					if( SAMPLES_READ != rval )
						break;
					pts = (double)samplecnverter.pos_lo / _1SHL32;
					sa = (int)((double)s1 * ( 1.0 - pts ) + (double)s2 * pts); 
assert( sa >= -0x8000 && sa <= 0x7fff );
					sample_buffer[ i + 1 ] = sa ;
#else
					pts = samplecnverter.pos_lo >> 17;
					rval = getsample( samplecnverter.pos_hi * 2 + 3, musicin, &s2 );
					if( SAMPLES_READ != rval )
						break;
assert( pts >= 0 && pts < 0x8000 );
					sa = s1 * ( 0x8000 - pts ) + s2 * pts; 
					sample_buffer[ i + 1 ] = sa >> 15;
#endif
				}

				{
					unsigned long		org_low;
					org_low = samplecnverter.pos_lo;
					samplecnverter.pos_lo += samplecnverter.pitch_lo ;
					if( samplecnverter.pos_lo < org_low ){
						samplecnverter.pos_hi += samplecnverter.pitch_hi + 1;
					} else {
						samplecnverter.pos_hi += samplecnverter.pitch_hi;
					}
				}
			}
			
			if( rval != SAMPLES_READ ){
				int		n;
				if( rval == SAMPLES_PAUSED ){
					samplecnverter.bPausedRead  = TRUE;
					samplecnverter.pcmdecodepos = i;
					for(n = 0;n < i;n++){
						samplecnverter.sample_decode[n] = sample_buffer[n];
					}
				} else {
					for(n = i;n < frame_size;n++){
						samplecnverter.sample_decode[n] = 0;
					}
				}
			}
			return rval;
		}
	}
}

SAMPLES_T 
get_audio(FILE *musicin, short *buffer)
{
	unsigned long	j, num;
	short			insamp[1152*2];
	SAMPLES_T		rval;

	num = gl.frameSize;
	if( gl.stereo == 2 ){
		/* stereo -> stereo */
		/* No conversion needed, fall through... */
		return read_samples( musicin, buffer, num * 2, 2 );
	} else if( bForceMono == FALSE ){
		/* mono -> mono */
		/* No conversion needed, fall through... */
		return read_samples( musicin, buffer, num, 1 );
	} else {
		/* stereo -> mono */
		rval = read_samples( musicin, insamp, num * 2, 2 );
		if( rval != SAMPLES_READ )
			return rval;		
		for( j = 0; j < num; j++ ){
			buffer[j] = ( (int)insamp[j*2] + (int)insamp[j*2 + 1] ) / 2;
		}
		return rval;
	}
}
