/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CompOptionsBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.InstructionSetBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CompositionBox
extends JP2Box {
    private List instSets;
    private long _height;
    private long _width;
    private int _loop;

    public CompositionBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        this.hasBoxes = true;
        this.instSets = new LinkedList();
        if (!this.hasNext()) {
            this.emptyBox();
            return false;
        }
        JP2Box jP2Box = (JP2Box)this.next();
        if (!(jP2Box instanceof CompOptionsBox)) {
            this._repInfo.setMessage(new ErrorMessage("First box in Composition Box must be Composition Options Box", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        long l = this._boxHeader.getDataLength() - jP2Box.getLength();
        if (!jP2Box.readBox()) {
            return false;
        }
        while (this.hasNext() && (jP2Box = (JP2Box)this.next()) != null) {
            if (jP2Box instanceof InstructionSetBox) {
                if (jP2Box.readBox()) continue;
                return false;
            }
            jP2Box.skipBox();
        }
        if (l != 0L) {
            this.superboxUnderrun();
            return false;
        }
        this.finalizeBytesRead();
        ArrayList<Property> arrayList = new ArrayList<Property>(4);
        arrayList.add(new Property("Width", PropertyType.LONG, new Long(this._width)));
        arrayList.add(new Property("Height", PropertyType.LONG, new Long(this._height)));
        arrayList.add(new Property("Loop", PropertyType.INTEGER, new Integer(this._loop)));
        if (!this.instSets.isEmpty()) {
            arrayList.add(new Property("InstructionSets", PropertyType.PROPERTY, PropertyArity.LIST, this.instSets));
        }
        this._module.addProperty(new Property("Composition", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }

    protected void addInstSet(Property property) {
        this.instSets.add(property);
    }

    protected void setHeight(long l) {
        this._height = l;
    }

    protected void setWidth(long l) {
        this._width = l;
    }

    protected void setLoop(int n) {
        this._loop = n;
    }
}

