//
// Copyright (c) 2021, NVIDIA CORPORATION.  All rights reserved.
//
// NVIDIA CORPORATION and its licensors retain all intellectual property
// and proprietary rights in and to this software, related documentation
// and any modifications thereto.  Any use, reproduction, disclosure or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA CORPORATION is strictly prohibited.
//

#pragma once

#include "cqi.hpp"

#include "nscq/nscq.h"

#include <memory>

namespace nscq::cqi {

struct nvswitch_nvlink_lane;

struct nvswitch_nvlink_lane : public cqi {
    using cqi_t = nvswitch_nvlink_lane;
    using id_t = uint8_t;
    using cqi::cqi;
    [[nodiscard]] virtual auto get_id() const -> id_t = 0;

    struct crc_err_count_field : public field<nvswitch_nvlink_lane, readable<std::optional<uint64_t>>> {};
    virtual auto get(crc_err_count_field) -> std::optional<uint64_t> = 0;

    struct ecc_err_count_field : public field<nvswitch_nvlink_lane, readable<std::optional<uint64_t>>> {};
    virtual auto get(ecc_err_count_field) -> std::optional<uint64_t> = 0;

    struct max_correctable_lane_crc_error_rate_daily_field : public field<nvswitch_nvlink_lane,
               readable<std::vector<nscq_link_max_correctable_error_rate>>> {};
    virtual auto get(max_correctable_lane_crc_error_rate_daily_field) -> std::vector<nscq_link_max_correctable_error_rate> = 0;

    struct max_correctable_lane_crc_error_rate_monthly_field : public field<nvswitch_nvlink_lane,
               readable<std::vector<nscq_link_max_correctable_error_rate>>> {};
    virtual auto get(max_correctable_lane_crc_error_rate_monthly_field) -> std::vector<nscq_link_max_correctable_error_rate> = 0;

};
} // namespace nscq::cqi
