#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Jenny LeClue - Detectivu
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220403.4

# Set game-specific variables

GAME_ID='jenny-leclue-detectivu'
GAME_NAME='Jenny LeClue - Detectivú'

ARCHIVE_BASE_1='jenny_leclue_detectivu_2_2_1_47129.sh'
ARCHIVE_BASE_1_MD5='bb03cb3d7c6abf4be7060ed4cf126b2e'
ARCHIVE_BASE_1_TYPE='mojosetup'
ARCHIVE_BASE_1_SIZE='2100000'
ARCHIVE_BASE_1_VERSION='2.2.1-gog47129'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/jenny_leclue_detectivu'

ARCHIVE_BASE_0='jenny_leclue_detectivu_2_1_1_42681.sh'
ARCHIVE_BASE_0_MD5='21c681f13664bbb1259f4807cc388742'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='1900000'
ARCHIVE_BASE_0_VERSION='2.1.1-gog42681'

UNITY3D_NAME='Jenny LeClue - Detectivu'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN32_FILES='
Jenny?LeClue?-?Detectivu.x86
Jenny?LeClue?-?Detectivu_Data/MonoBleedingEdge/x86
Jenny?LeClue?-?Detectivu_Data/Plugins/x86'
ARCHIVE_GAME_BIN64_FILES='
Jenny?LeClue?-?Detectivu.x86_64
Jenny?LeClue?-?Detectivu_Data/MonoBleedingEdge/x86_64
Jenny?LeClue?-?Detectivu_Data/Plugins/x86_64'
ARCHIVE_GAME_DATA_FILES='
Jenny?LeClue?-?Detectivu_Data'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libgtk-x11-2.0.so.0 libz.so.1 libgdk_pixbuf-2.0.so.0 libgobject-2.0.so.0 libglib-2.0.so.0"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
