#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Anna Lea
set -o errexit

###
# Thimbleweed Park
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220212.1

# Set game-specific variables

GAME_ID='thimbleweed-park'
GAME_NAME='Thimbleweed Park'

ARCHIVE_BASE_0='thimbleweed_park_en_1_0_958_19330.sh'
ARCHIVE_BASE_0_MD5='2803fd41a66c1163f02b61bb6ff286ab'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='970000'
ARCHIVE_BASE_0_VERSION='1.0.958-gog19330'

# Archives content

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN_FILES='
ThimbleweedPark'
ARCHIVE_GAME_DATA_FILES='
ThimbleweedPark.ggpack?
Icon1024.png'

# Applications

APP_MAIN_TYPE='native'
APP_MAIN_EXE='ThimbleweedPark'
APP_MAIN_ICON='Icon1024.png'

PACKAGES_LIST='PKG_DATA PKG_BIN'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGL.so.1"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN' 

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
