!{\src2tex{textfont=tt}}
!!****f* ABINIT/contistr01
!! NAME
!! contistr01
!!
!! FUNCTION
!! Carries out specialized metric tensor operations needed for contraction
!! of the 2nd strain derivative of the l=0,1,2,3 nonlocal Kleinman-Bylander
!! pseudopotential operation.  Derivatives are wrt a pair of cartesian
!! strain components.
!! Full advantage is taken of the full permutational symmetry of these
!! tensors.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2016 ABINIT group (DRH)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  istr=1,...6 specifies cartesian strain component 11,22,33,32,31,21
!!  rank=angular momentum
!!  gm(3,3)=metric tensor (array is symmetric but stored as 3x3)
!!  gprimd(3,3)=reciprocal space dimensional primitive translations
!!  aa(2,*)=unique elements of complex right-hand tensor
!!  bb(2,*)=unique elements of complex left-hand tensor
!!
!! OUTPUT
!!  eisnl(3)=contraction for nonlocal internal strain derivative energy
!!
!! NOTES
!! All tensors are stored in a compressed storage mode defined below;
!! input and output conform to this scheme.
!! When tensor elements occur repeatedly due to symmetry, the
!! WEIGHT IS INCLUDED in the output tensor element to simplify later
!! contractions with other tensors of the same rank and form, i.e. the
!! next contraction is then simply a dot product over the unique elements.
!!
!! PARENTS
!!      nonlop_pl
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"

subroutine contistr01(istr,rank,gm,gprimd,eisnl,aa,bb)

 use defs_basis
 use m_profiling_abi

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'contistr01'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: istr,rank
!arrays
 real(dp),intent(in) :: aa(2,((rank+1)*(rank+2))/2),bb(2,((rank+2)*(rank+3))/2)
 real(dp),intent(in) :: gm(3,3),gprimd(3,3)
 real(dp),intent(out) :: eisnl(3)

!Local variables-------------------------------
!scalars
 integer :: ii,jj,ka,kb
!arrays
 integer,parameter :: idx(12)=(/1,1,2,2,3,3,3,2,3,1,2,1/)
 real(dp) :: dgm(3,3),tmp(2,3)
 real(dp),allocatable :: cm(:,:,:)

! *************************************************************************

 ABI_ALLOCATE(cm,(3,((rank+1)*(rank+2))/2,((rank+2)*(rank+3))/2))

 ka=idx(2*istr-1);kb=idx(2*istr)

 do ii = 1,3
   dgm(:,ii)=-(gprimd(ka,:)*gprimd(kb,ii)+gprimd(kb,:)*gprimd(ka,ii))
 end do

 cm(:,:,:)=0.d0
!
!The code below was written by a Mathematica program and formatted by
!a combination of editing scripts.  It is not intended to be read
!by human beings, and certainly not to be modified by one.  Conceivably
!it could be shortened somewhat by identifying common subexpressions.
!
 if(rank==1)then
   cm(1,1,1)=dgm(1,1)
   cm(1,2,1)=dgm(1,2)
   cm(1,3,1)=dgm(1,3)
   cm(1,1,5)=dgm(1,3)
   cm(1,2,5)=dgm(2,3)
   cm(1,3,5)=dgm(3,3)
   cm(1,1,6)=dgm(1,2)
   cm(1,2,6)=dgm(2,2)
   cm(1,3,6)=dgm(2,3)
   cm(2,1,2)=dgm(1,2)
   cm(2,2,2)=dgm(2,2)
   cm(2,3,2)=dgm(2,3)
   cm(2,1,4)=dgm(1,3)
   cm(2,2,4)=dgm(2,3)
   cm(2,3,4)=dgm(3,3)
   cm(2,1,6)=dgm(1,1)
   cm(2,2,6)=dgm(1,2)
   cm(2,3,6)=dgm(1,3)
   cm(3,1,3)=dgm(1,3)
   cm(3,2,3)=dgm(2,3)
   cm(3,3,3)=dgm(3,3)
   cm(3,1,4)=dgm(1,2)
   cm(3,2,4)=dgm(2,2)
   cm(3,3,4)=dgm(2,3)
   cm(3,1,5)=dgm(1,1)
   cm(3,2,5)=dgm(1,2)
   cm(3,3,5)=dgm(1,3)
 elseif(rank==2)then
   cm(1,1,1)=2*gm(1,1)*dgm(1,1)
   cm(1,2,1)=-0.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)*dgm(1,2)-0.5d0*gm(1,1)&
&   *dgm(2,2)
   cm(1,3,1)=-0.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)*dgm(1,3)-0.5d0*gm(1,1)&
&   *dgm(3,3)
   cm(1,4,1)=-gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)&
&   -gm(1,1)*dgm(2,3)
   cm(1,5,1)=2*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))
   cm(1,6,1)=2*(gm(1,2)*dgm(1,1)+gm(1,1)*dgm(1,2))
   cm(1,1,2)=-0.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)*dgm(1,2)-0.5d0*gm(1,1)&
&   *dgm(2,2)
   cm(1,2,2)=2*gm(2,2)*dgm(2,2)
   cm(1,3,2)=-0.5d0*gm(3,3)*dgm(2,2)+3*gm(2,3)*dgm(2,3)-0.5d0*gm(2,2)&
&   *dgm(3,3)
   cm(1,4,2)=2*(gm(2,3)*dgm(2,2)+gm(2,2)*dgm(2,3))
   cm(1,5,2)=3*gm(2,3)*dgm(1,2)-gm(2,2)*dgm(1,3)-gm(1,3)*dgm(2,2)&
&   +3*gm(1,2)*dgm(2,3)
   cm(1,6,2)=2*(gm(2,2)*dgm(1,2)+gm(1,2)*dgm(2,2))
   cm(1,1,3)=-0.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)*dgm(1,3)-0.5d0*gm(1,1)&
&   *dgm(3,3)
   cm(1,2,3)=-0.5d0*gm(3,3)*dgm(2,2)+3*gm(2,3)*dgm(2,3)-0.5d0*gm(2,2)&
&   *dgm(3,3)
   cm(1,3,3)=2*gm(3,3)*dgm(3,3)
   cm(1,4,3)=2*(gm(3,3)*dgm(2,3)+gm(2,3)*dgm(3,3))
   cm(1,5,3)=2*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(1,6,3)=-gm(3,3)*dgm(1,2)+3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)&
&   -gm(1,2)*dgm(3,3)
   cm(1,1,4)=-gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)&
&   -gm(1,1)*dgm(2,3)
   cm(1,2,4)=2*(gm(2,3)*dgm(2,2)+gm(2,2)*dgm(2,3))
   cm(1,3,4)=2*(gm(3,3)*dgm(2,3)+gm(2,3)*dgm(3,3))
   cm(1,4,4)=3*gm(3,3)*dgm(2,2)+2*gm(2,3)*dgm(2,3)+3*gm(2,2)*dgm(3,3)
   cm(1,5,4)=3*gm(3,3)*dgm(1,2)+gm(2,3)*dgm(1,3)+gm(1,3)*dgm(2,3)&
&   +3*gm(1,2)*dgm(3,3)
   cm(1,6,4)=gm(2,3)*dgm(1,2)+3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)&
&   +gm(1,2)*dgm(2,3)
   cm(1,1,5)=2*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))
   cm(1,2,5)=3*gm(2,3)*dgm(1,2)-gm(2,2)*dgm(1,3)-gm(1,3)*dgm(2,2)&
&   +3*gm(1,2)*dgm(2,3)
   cm(1,3,5)=2*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(1,4,5)=3*gm(3,3)*dgm(1,2)+gm(2,3)*dgm(1,3)+gm(1,3)*dgm(2,3)&
&   +3*gm(1,2)*dgm(3,3)
   cm(1,5,5)=3*gm(3,3)*dgm(1,1)+2*gm(1,3)*dgm(1,3)+3*gm(1,1)*dgm(3,3)
   cm(1,6,5)=3*gm(2,3)*dgm(1,1)+gm(1,3)*dgm(1,2)+gm(1,2)*dgm(1,3)&
&   +3*gm(1,1)*dgm(2,3)
   cm(1,1,6)=2*(gm(1,2)*dgm(1,1)+gm(1,1)*dgm(1,2))
   cm(1,2,6)=2*(gm(2,2)*dgm(1,2)+gm(1,2)*dgm(2,2))
   cm(1,3,6)=-gm(3,3)*dgm(1,2)+3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)&
&   -gm(1,2)*dgm(3,3)
   cm(1,4,6)=gm(2,3)*dgm(1,2)+3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)&
&   +gm(1,2)*dgm(2,3)
   cm(1,5,6)=3*gm(2,3)*dgm(1,1)+gm(1,3)*dgm(1,2)+gm(1,2)*dgm(1,3)&
&   +3*gm(1,1)*dgm(2,3)
   cm(1,6,6)=3*gm(2,2)*dgm(1,1)+2*gm(1,2)*dgm(1,2)+3*gm(1,1)*dgm(2,2)
   cm(2,1,2)=2*(gm(1,2)*dgm(1,1)+gm(1,1)*dgm(1,2))
   cm(2,2,2)=2*(gm(2,2)*dgm(1,2)+gm(1,2)*dgm(2,2))
   cm(2,3,2)=-gm(3,3)*dgm(1,2)+3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)&
&   -gm(1,2)*dgm(3,3)
   cm(2,4,2)=gm(2,3)*dgm(1,2)+3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)&
&   +gm(1,2)*dgm(2,3)
   cm(2,5,2)=3*gm(2,3)*dgm(1,1)+gm(1,3)*dgm(1,2)+gm(1,2)*dgm(1,3)&
&   +3*gm(1,1)*dgm(2,3)
   cm(2,6,2)=3*gm(2,2)*dgm(1,1)+2*gm(1,2)*dgm(1,2)+3*gm(1,1)*dgm(2,2)
   cm(2,1,4)=2*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))
   cm(2,2,4)=3*gm(2,3)*dgm(1,2)-gm(2,2)*dgm(1,3)-gm(1,3)*dgm(2,2)&
&   +3*gm(1,2)*dgm(2,3)
   cm(2,3,4)=2*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(2,4,4)=3*gm(3,3)*dgm(1,2)+gm(2,3)*dgm(1,3)+gm(1,3)*dgm(2,3)&
&   +3*gm(1,2)*dgm(3,3)
   cm(2,5,4)=3*gm(3,3)*dgm(1,1)+2*gm(1,3)*dgm(1,3)+3*gm(1,1)*dgm(3,3)
   cm(2,6,4)=3*gm(2,3)*dgm(1,1)+gm(1,3)*dgm(1,2)+gm(1,2)*dgm(1,3)&
&   +3*gm(1,1)*dgm(2,3)
   cm(2,1,6)=2*gm(1,1)*dgm(1,1)
   cm(2,2,6)=-0.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)*dgm(1,2)-0.5d0*gm(1,1)&
&   *dgm(2,2)
   cm(2,3,6)=-0.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)*dgm(1,3)-0.5d0*gm(1,1)&
&   *dgm(3,3)
   cm(2,4,6)=-gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)&
&   -gm(1,1)*dgm(2,3)
   cm(2,5,6)=2*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))
   cm(2,6,6)=2*(gm(1,2)*dgm(1,1)+gm(1,1)*dgm(1,2))
   cm(2,1,7)=-0.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)*dgm(1,2)-0.5d0*gm(1,1)&
&   *dgm(2,2)
   cm(2,2,7)=2*gm(2,2)*dgm(2,2)
   cm(2,3,7)=-0.5d0*gm(3,3)*dgm(2,2)+3*gm(2,3)*dgm(2,3)-0.5d0*gm(2,2)&
&   *dgm(3,3)
   cm(2,4,7)=2*(gm(2,3)*dgm(2,2)+gm(2,2)*dgm(2,3))
   cm(2,5,7)=3*gm(2,3)*dgm(1,2)-gm(2,2)*dgm(1,3)-gm(1,3)*dgm(2,2)&
&   +3*gm(1,2)*dgm(2,3)
   cm(2,6,7)=2*(gm(2,2)*dgm(1,2)+gm(1,2)*dgm(2,2))
   cm(2,1,8)=-0.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)*dgm(1,3)-0.5d0*gm(1,1)&
&   *dgm(3,3)
   cm(2,2,8)=-0.5d0*gm(3,3)*dgm(2,2)+3*gm(2,3)*dgm(2,3)-0.5d0*gm(2,2)&
&   *dgm(3,3)
   cm(2,3,8)=2*gm(3,3)*dgm(3,3)
   cm(2,4,8)=2*(gm(3,3)*dgm(2,3)+gm(2,3)*dgm(3,3))
   cm(2,5,8)=2*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(2,6,8)=-gm(3,3)*dgm(1,2)+3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)&
&   -gm(1,2)*dgm(3,3)
   cm(2,1,9)=-gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)&
&   -gm(1,1)*dgm(2,3)
   cm(2,2,9)=2*(gm(2,3)*dgm(2,2)+gm(2,2)*dgm(2,3))
   cm(2,3,9)=2*(gm(3,3)*dgm(2,3)+gm(2,3)*dgm(3,3))
   cm(2,4,9)=3*gm(3,3)*dgm(2,2)+2*gm(2,3)*dgm(2,3)+3*gm(2,2)*dgm(3,3)
   cm(2,5,9)=3*gm(3,3)*dgm(1,2)+gm(2,3)*dgm(1,3)+gm(1,3)*dgm(2,3)&
&   +3*gm(1,2)*dgm(3,3)
   cm(2,6,9)=gm(2,3)*dgm(1,2)+3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)&
&   +gm(1,2)*dgm(2,3)
   cm(3,1,3)=2*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))
   cm(3,2,3)=3*gm(2,3)*dgm(1,2)-gm(2,2)*dgm(1,3)-gm(1,3)*dgm(2,2)&
&   +3*gm(1,2)*dgm(2,3)
   cm(3,3,3)=2*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(3,4,3)=3*gm(3,3)*dgm(1,2)+gm(2,3)*dgm(1,3)+gm(1,3)*dgm(2,3)&
&   +3*gm(1,2)*dgm(3,3)
   cm(3,5,3)=3*gm(3,3)*dgm(1,1)+2*gm(1,3)*dgm(1,3)+3*gm(1,1)*dgm(3,3)
   cm(3,6,3)=3*gm(2,3)*dgm(1,1)+gm(1,3)*dgm(1,2)+gm(1,2)*dgm(1,3)&
&   +3*gm(1,1)*dgm(2,3)
   cm(3,1,4)=2*(gm(1,2)*dgm(1,1)+gm(1,1)*dgm(1,2))
   cm(3,2,4)=2*(gm(2,2)*dgm(1,2)+gm(1,2)*dgm(2,2))
   cm(3,3,4)=-gm(3,3)*dgm(1,2)+3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)&
&   -gm(1,2)*dgm(3,3)
   cm(3,4,4)=gm(2,3)*dgm(1,2)+3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)&
&   +gm(1,2)*dgm(2,3)
   cm(3,5,4)=3*gm(2,3)*dgm(1,1)+gm(1,3)*dgm(1,2)+gm(1,2)*dgm(1,3)&
&   +3*gm(1,1)*dgm(2,3)
   cm(3,6,4)=3*gm(2,2)*dgm(1,1)+2*gm(1,2)*dgm(1,2)+3*gm(1,1)*dgm(2,2)
   cm(3,1,5)=2*gm(1,1)*dgm(1,1)
   cm(3,2,5)=-0.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)*dgm(1,2)-0.5d0*gm(1,1)&
&   *dgm(2,2)
   cm(3,3,5)=-0.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)*dgm(1,3)-0.5d0*gm(1,1)&
&   *dgm(3,3)
   cm(3,4,5)=-gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)&
&   -gm(1,1)*dgm(2,3)
   cm(3,5,5)=2*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))
   cm(3,6,5)=2*(gm(1,2)*dgm(1,1)+gm(1,1)*dgm(1,2))
   cm(3,1,8)=-gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)&
&   -gm(1,1)*dgm(2,3)
   cm(3,2,8)=2*(gm(2,3)*dgm(2,2)+gm(2,2)*dgm(2,3))
   cm(3,3,8)=2*(gm(3,3)*dgm(2,3)+gm(2,3)*dgm(3,3))
   cm(3,4,8)=3*gm(3,3)*dgm(2,2)+2*gm(2,3)*dgm(2,3)+3*gm(2,2)*dgm(3,3)
   cm(3,5,8)=3*gm(3,3)*dgm(1,2)+gm(2,3)*dgm(1,3)+gm(1,3)*dgm(2,3)&
&   +3*gm(1,2)*dgm(3,3)
   cm(3,6,8)=gm(2,3)*dgm(1,2)+3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)&
&   +gm(1,2)*dgm(2,3)
   cm(3,1,9)=-0.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)*dgm(1,2)-0.5d0*gm(1,1)&
&   *dgm(2,2)
   cm(3,2,9)=2*gm(2,2)*dgm(2,2)
   cm(3,3,9)=-0.5d0*gm(3,3)*dgm(2,2)+3*gm(2,3)*dgm(2,3)-0.5d0*gm(2,2)&
&   *dgm(3,3)
   cm(3,4,9)=2*(gm(2,3)*dgm(2,2)+gm(2,2)*dgm(2,3))
   cm(3,5,9)=3*gm(2,3)*dgm(1,2)-gm(2,2)*dgm(1,3)-gm(1,3)*dgm(2,2)&
&   +3*gm(1,2)*dgm(2,3)
   cm(3,6,9)=2*(gm(2,2)*dgm(1,2)+gm(1,2)*dgm(2,2))
   cm(3,1,10)=-0.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)*dgm(1,3)-0.5d0*gm(1,1)&
&   *dgm(3,3)
   cm(3,2,10)=-0.5d0*gm(3,3)*dgm(2,2)+3*gm(2,3)*dgm(2,3)-0.5d0*gm(2,2)&
&   *dgm(3,3)
   cm(3,3,10)=2*gm(3,3)*dgm(3,3)
   cm(3,4,10)=2*(gm(3,3)*dgm(2,3)+gm(2,3)*dgm(3,3))
   cm(3,5,10)=2*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(3,6,10)=-gm(3,3)*dgm(1,2)+3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)&
&   -gm(1,2)*dgm(3,3)
 elseif(rank==3)then
   cm(1,1,1)=3*gm(1,1)**2*dgm(1,1)
   cm(1,2,1)=4.5d0*gm(1,2)**2*dgm(1,1)+9*gm(1,1)*gm(1,2)*dgm(1,2)&
&   +gm(1,1)*(-3*gm(2,2)*dgm(1,1)-1.5d0*gm(1,1)*dgm(2,2))
   cm(1,3,1)=4.5d0*gm(1,3)**2*dgm(1,1)+9*gm(1,1)*gm(1,3)*dgm(1,3)&
&   +gm(1,1)*(-3*gm(3,3)*dgm(1,1)-1.5d0*gm(1,1)*dgm(3,3))
   cm(1,4,1)=9*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(-6*gm(2,3)*dgm(1,1)+9*gm(1,3)*dgm(1,2)-3*gm(1,1)*dgm(2,3))
   cm(1,5,1)=gm(1,1)*(6*gm(1,3)*dgm(1,1)+3*gm(1,1)*dgm(1,3))
   cm(1,6,1)=gm(1,1)*(6*gm(1,2)*dgm(1,1)+3*gm(1,1)*dgm(1,2))
   cm(1,7,1)=7.5d0*gm(1,2)**2*dgm(1,2)-1.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   -1.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(1,8,1)=7.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-1.5d0*gm(3,3)*dgm(1,2)&
&   -3*gm(2,3)*dgm(1,3))+gm(1,3)*(-3*gm(2,3)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,3)-3*gm(1,1)*dgm(2,3))-1.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(1,9,1)=7.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(-3*gm(2,3)*dgm(1,2)&
&   -1.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-1.5d0*gm(2,2)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,2)-1.5d0*gm(1,1)*dgm(2,2))-3*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(1,10,1)=7.5d0*gm(1,3)**2*dgm(1,3)-1.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   -1.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(1,1,2)=4.5d0*gm(1,2)**2*dgm(1,1)+9*gm(1,1)*gm(1,2)*dgm(1,2)&
&   +gm(1,1)*(-3*gm(2,2)*dgm(1,1)-1.5d0*gm(1,1)*dgm(2,2))
   cm(1,2,2)=6*gm(2,2)**2*dgm(1,1)+3*gm(1,2)**2*dgm(2,2)+gm(2,2)&
&   *(6*gm(1,2)*dgm(1,2)+12*gm(1,1)*dgm(2,2))
   cm(1,3,2)=7.5d0*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)&
&   -3*gm(1,3)**2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)&
&   *gm(1,3)*dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)&
&   +15*gm(1,1)*dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(1,4,2)=12*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(6*gm(2,3)*dgm(1,2)&
&   +3*gm(1,3)*dgm(2,2))+3*gm(1,2)**2*dgm(2,3)+gm(2,2)*(12*gm(2,3)&
&   *dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)+12*gm(1,1)*dgm(2,3))
   cm(1,5,2)=1.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(12*gm(2,3)*dgm(1,2)&
&   -4.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-4.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,2)-4.5d0*gm(1,1)*dgm(2,2))+12*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(1,6,2)=4.5d0*gm(1,2)**2*dgm(1,2)+7.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   +7.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(1,7,2)=gm(2,2)*(3*gm(2,2)*dgm(1,2)+6*gm(1,2)*dgm(2,2))
   cm(1,8,2)=1.5d0*gm(2,3)**2*dgm(1,2)-4.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(12*gm(2,2)*dgm(1,3)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-4.5d0*gm(3,3)*dgm(1,2)+12*gm(1,3)*dgm(2,3)-4.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(1,9,2)=6*gm(2,2)**2*dgm(1,3)+3*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(3*gm(2,3)*dgm(1,2)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))
   cm(1,10,2)=7.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-1.5d0*gm(1,3)*dgm(2,2)&
&   -3*gm(1,2)*dgm(2,3))+gm(2,3)*(-3*gm(3,3)*dgm(1,2)+15*gm(1,3)&
&   *dgm(2,3)-3*gm(1,2)*dgm(3,3))-1.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(1,1,3)=4.5d0*gm(1,3)**2*dgm(1,1)+9*gm(1,1)*gm(1,3)*dgm(1,3)&
&   +gm(1,1)*(-3*gm(3,3)*dgm(1,1)-1.5d0*gm(1,1)*dgm(3,3))
   cm(1,2,3)=7.5d0*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)&
&   -3*gm(1,3)**2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)&
&   *gm(1,3)*dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)&
&   +15*gm(1,1)*dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(1,3,3)=6*gm(3,3)**2*dgm(1,1)+3*gm(1,3)**2*dgm(3,3)+gm(3,3)&
&   *(6*gm(1,3)*dgm(1,3)+12*gm(1,1)*dgm(3,3))
   cm(1,4,3)=3*gm(1,3)**2*dgm(2,3)+gm(3,3)*(3*gm(1,2)*dgm(1,3)+12*gm(1,1)&
&   *dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,1)+6*gm(1,3)*dgm(1,3)+12*gm(1,1)&
&   *dgm(3,3))+3*gm(1,3)*(gm(3,3)*dgm(1,2)+gm(1,2)*dgm(3,3))
   cm(1,5,3)=4.5d0*gm(1,3)**2*dgm(1,3)+7.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   +7.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(1,6,3)=1.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-4.5d0*gm(3,3)*dgm(1,2)&
&   +12*gm(2,3)*dgm(1,3))+gm(1,3)*(12*gm(2,3)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,3)+12*gm(1,1)*dgm(2,3))-4.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(1,7,3)=7.5d0*gm(2,3)**2*dgm(1,2)-1.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(-3*gm(2,2)*dgm(1,3)-3*gm(1,3)*dgm(2,2)+15*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,2)-3*gm(1,3)*dgm(2,3)-1.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(1,8,3)=6*gm(3,3)**2*dgm(1,2)+3*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(1,9,3)=1.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-4.5d0*gm(1,3)*dgm(2,2)&
&   +12*gm(1,2)*dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,2)+3*gm(1,3)&
&   *dgm(2,3)+12*gm(1,2)*dgm(3,3))-4.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(1,10,3)=gm(3,3)*(3*gm(3,3)*dgm(1,3)+6*gm(1,3)*dgm(3,3))
   cm(1,1,4)=9*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(-6*gm(2,3)*dgm(1,1)+9*gm(1,3)*dgm(1,2)-3*gm(1,1)*dgm(2,3))
   cm(1,2,4)=12*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(6*gm(2,3)*dgm(1,2)&
&   +3*gm(1,3)*dgm(2,2))+3*gm(1,2)**2*dgm(2,3)+gm(2,2)*(12*gm(2,3)&
&   *dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)+12*gm(1,1)*dgm(2,3))
   cm(1,3,4)=3*gm(1,3)**2*dgm(2,3)+gm(3,3)*(3*gm(1,2)*dgm(1,3)+12*gm(1,1)&
&   *dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,1)+6*gm(1,3)*dgm(1,3)+12*gm(1,1)&
&   *dgm(3,3))+3*gm(1,3)*(gm(3,3)*dgm(1,2)+gm(1,2)*dgm(3,3))
   cm(1,4,4)=9*gm(2,3)**2*dgm(1,1)+18*gm(1,2)*gm(3,3)*dgm(1,2)+9*gm(1,3)&
&   **2*dgm(2,2)+15*gm(1,1)*gm(3,3)*dgm(2,2)-6*gm(1,2)*gm(1,3)*dgm(2,3)&
&   +gm(2,3)*(-6*gm(1,3)*dgm(1,2)-6*gm(1,2)*dgm(1,3)+18*gm(1,1)*dgm(2,3))&
&   +9*gm(1,2)**2*dgm(3,3)+gm(2,2)*(15*gm(3,3)*dgm(1,1)+18*gm(1,3)&
&   *dgm(1,3)+15*gm(1,1)*dgm(3,3))
   cm(1,5,4)=3*gm(1,3)**2*dgm(1,2)+gm(1,1)*(12*gm(3,3)*dgm(1,2)+3*gm(2,3)&
&   *dgm(1,3))+gm(1,3)*(3*gm(2,3)*dgm(1,1)+6*gm(1,2)*dgm(1,3)+3*gm(1,1)&
&   *dgm(2,3))+12*gm(1,2)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(1,6,4)=3*gm(1,2)**2*dgm(1,3)+gm(1,1)*(3*gm(2,3)*dgm(1,2)+12*gm(2,2)&
&   *dgm(1,3))+gm(1,3)*(12*gm(2,2)*dgm(1,1)+6*gm(1,2)*dgm(1,2)+12*gm(1,1)&
&   *dgm(2,2))+3*gm(1,2)*(gm(2,3)*dgm(1,1)+gm(1,1)*dgm(2,3))
   cm(1,7,4)=-3*gm(2,2)**2*dgm(1,3)+9*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(9*gm(2,3)*dgm(1,2)-6*gm(1,3)*dgm(2,2)+9*gm(1,2)*dgm(2,3))
   cm(1,8,4)=3*gm(2,3)**2*dgm(1,3)+gm(3,3)*(12*gm(1,3)*dgm(2,2)+3*gm(1,2)&
&   *dgm(2,3))+gm(2,3)*(3*gm(3,3)*dgm(1,2)+6*gm(1,3)*dgm(2,3)+3*gm(1,2)&
&   *dgm(3,3))+12*gm(2,2)*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(1,9,4)=3*gm(2,3)**2*dgm(1,2)+12*gm(1,2)*gm(3,3)*dgm(2,2)+gm(2,3)&
&   *(3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)+6*gm(1,2)*dgm(2,3))+gm(2,2)&
&   *(12*gm(3,3)*dgm(1,2)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(1,10,4)=-3*gm(3,3)**2*dgm(1,2)+9*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(9*gm(2,3)*dgm(1,3)+9*gm(1,3)*dgm(2,3)-6*gm(1,2)*dgm(3,3))
   cm(1,1,5)=gm(1,1)*(6*gm(1,3)*dgm(1,1)+3*gm(1,1)*dgm(1,3))
   cm(1,2,5)=1.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(12*gm(2,3)*dgm(1,2)&
&   -4.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-4.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,2)-4.5d0*gm(1,1)*dgm(2,2))+12*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(1,3,5)=4.5d0*gm(1,3)**2*dgm(1,3)+7.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   +7.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(1,4,5)=3*gm(1,3)**2*dgm(1,2)+gm(1,1)*(12*gm(3,3)*dgm(1,2)+3*gm(2,3)&
&   *dgm(1,3))+gm(1,3)*(3*gm(2,3)*dgm(1,1)+6*gm(1,2)*dgm(1,3)+3*gm(1,1)&
&   *dgm(2,3))+12*gm(1,2)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(1,5,5)=3*gm(1,3)**2*dgm(1,1)+6*gm(1,1)*gm(1,3)*dgm(1,3)+gm(1,1)&
&   *(12*gm(3,3)*dgm(1,1)+6*gm(1,1)*dgm(3,3))
   cm(1,6,5)=3*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(12*gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+6*gm(1,1)*dgm(2,3))
   cm(1,7,5)=-1.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(15*gm(2,3)&
&   *dgm(1,2)-3*gm(1,3)*dgm(2,2))+7.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)&
&   *(-1.5d0*gm(2,3)*dgm(1,1)-3*gm(1,3)*dgm(1,2)-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))
   cm(1,8,5)=1.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(12*gm(1,2)*dgm(1,3)&
&   -4.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-4.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)&
&   *dgm(1,3)-4.5d0*gm(1,1)*dgm(3,3))+12*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(1,9,5)=-3*gm(2,3)**2*dgm(1,1)+15*gm(1,2)*gm(3,3)*dgm(1,2)-3*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))+7.5d0*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(1,10,5)=-1.5d0*gm(3,3)**2*dgm(1,1)+4.5d0*gm(1,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(1,3)*dgm(1,3)-3*gm(1,1)*dgm(3,3))
   cm(1,1,6)=gm(1,1)*(6*gm(1,2)*dgm(1,1)+3*gm(1,1)*dgm(1,2))
   cm(1,2,6)=4.5d0*gm(1,2)**2*dgm(1,2)+7.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   +7.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(1,3,6)=1.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-4.5d0*gm(3,3)*dgm(1,2)&
&   +12*gm(2,3)*dgm(1,3))+gm(1,3)*(12*gm(2,3)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,3)+12*gm(1,1)*dgm(2,3))-4.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(1,4,6)=3*gm(1,2)**2*dgm(1,3)+gm(1,1)*(3*gm(2,3)*dgm(1,2)+12*gm(2,2)&
&   *dgm(1,3))+gm(1,3)*(12*gm(2,2)*dgm(1,1)+6*gm(1,2)*dgm(1,2)+12*gm(1,1)&
&   *dgm(2,2))+3*gm(1,2)*(gm(2,3)*dgm(1,1)+gm(1,1)*dgm(2,3))
   cm(1,5,6)=3*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(12*gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+6*gm(1,1)*dgm(2,3))
   cm(1,6,6)=3*gm(1,2)**2*dgm(1,1)+6*gm(1,1)*gm(1,2)*dgm(1,2)+gm(1,1)&
&   *(12*gm(2,2)*dgm(1,1)+6*gm(1,1)*dgm(2,2))
   cm(1,7,6)=-1.5d0*gm(2,2)**2*dgm(1,1)+4.5d0*gm(1,2)**2*dgm(2,2)&
&   +gm(2,2)*(9*gm(1,2)*dgm(1,2)-3*gm(1,1)*dgm(2,2))
   cm(1,8,6)=-3*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)+7.5d0*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,1)&
&   +15*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(1,9,6)=-4.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(3*gm(2,3)*dgm(1,2)&
&   +12*gm(1,3)*dgm(2,2))+1.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)*(-4.5d0*gm(2,3)&
&   *dgm(1,1)+12*gm(1,3)*dgm(1,2)+12*gm(1,2)*dgm(1,3)-4.5d0*gm(1,1)&
&   *dgm(2,3))
   cm(1,10,6)=7.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-1.5d0*gm(3,3)*dgm(1,1)+15*gm(1,3)&
&   *dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))-3*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(1,1,7)=7.5d0*gm(1,2)**2*dgm(1,2)-1.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   -1.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(1,2,7)=gm(2,2)*(3*gm(2,2)*dgm(1,2)+6*gm(1,2)*dgm(2,2))
   cm(1,3,7)=7.5d0*gm(2,3)**2*dgm(1,2)-1.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(-3*gm(2,2)*dgm(1,3)-3*gm(1,3)*dgm(2,2)+15*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,2)-3*gm(1,3)*dgm(2,3)-1.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(1,4,7)=-3*gm(2,2)**2*dgm(1,3)+9*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(9*gm(2,3)*dgm(1,2)-6*gm(1,3)*dgm(2,2)+9*gm(1,2)*dgm(2,3))
   cm(1,5,7)=-1.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(15*gm(2,3)&
&   *dgm(1,2)-3*gm(1,3)*dgm(2,2))+7.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)&
&   *(-1.5d0*gm(2,3)*dgm(1,1)-3*gm(1,3)*dgm(1,2)-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))
   cm(1,6,7)=-1.5d0*gm(2,2)**2*dgm(1,1)+4.5d0*gm(1,2)**2*dgm(2,2)&
&   +gm(2,2)*(9*gm(1,2)*dgm(1,2)-3*gm(1,1)*dgm(2,2))
   cm(1,7,7)=3*gm(2,2)**2*dgm(2,2)
   cm(1,8,7)=4.5d0*gm(2,3)**2*dgm(2,2)+9*gm(2,2)*gm(2,3)*dgm(2,3)&
&   +gm(2,2)*(-3*gm(3,3)*dgm(2,2)-1.5d0*gm(2,2)*dgm(3,3))
   cm(1,9,7)=gm(2,2)*(6*gm(2,3)*dgm(2,2)+3*gm(2,2)*dgm(2,3))
   cm(1,10,7)=7.5d0*gm(2,3)**2*dgm(2,3)-1.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   -1.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(1,1,8)=7.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-1.5d0*gm(3,3)*dgm(1,2)&
&   -3*gm(2,3)*dgm(1,3))+gm(1,3)*(-3*gm(2,3)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,3)-3*gm(1,1)*dgm(2,3))-1.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(1,2,8)=1.5d0*gm(2,3)**2*dgm(1,2)-4.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(12*gm(2,2)*dgm(1,3)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-4.5d0*gm(3,3)*dgm(1,2)+12*gm(1,3)*dgm(2,3)-4.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(1,3,8)=6*gm(3,3)**2*dgm(1,2)+3*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(1,4,8)=3*gm(2,3)**2*dgm(1,3)+gm(3,3)*(12*gm(1,3)*dgm(2,2)+3*gm(1,2)&
&   *dgm(2,3))+gm(2,3)*(3*gm(3,3)*dgm(1,2)+6*gm(1,3)*dgm(2,3)+3*gm(1,2)&
&   *dgm(3,3))+12*gm(2,2)*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(1,5,8)=1.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(12*gm(1,2)*dgm(1,3)&
&   -4.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-4.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)&
&   *dgm(1,3)-4.5d0*gm(1,1)*dgm(3,3))+12*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(1,6,8)=-3*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)+7.5d0*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,1)&
&   +15*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(1,7,8)=4.5d0*gm(2,3)**2*dgm(2,2)+9*gm(2,2)*gm(2,3)*dgm(2,3)&
&   +gm(2,2)*(-3*gm(3,3)*dgm(2,2)-1.5d0*gm(2,2)*dgm(3,3))
   cm(1,8,8)=6*gm(3,3)**2*dgm(2,2)+3*gm(2,3)**2*dgm(3,3)+gm(3,3)&
&   *(6*gm(2,3)*dgm(2,3)+12*gm(2,2)*dgm(3,3))
   cm(1,9,8)=4.5d0*gm(2,3)**2*dgm(2,3)+7.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   +7.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(1,10,8)=gm(3,3)*(3*gm(3,3)*dgm(2,3)+6*gm(2,3)*dgm(3,3))
   cm(1,1,9)=7.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(-3*gm(2,3)*dgm(1,2)&
&   -1.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-1.5d0*gm(2,2)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,2)-1.5d0*gm(1,1)*dgm(2,2))-3*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(1,2,9)=6*gm(2,2)**2*dgm(1,3)+3*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(3*gm(2,3)*dgm(1,2)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))
   cm(1,3,9)=1.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-4.5d0*gm(1,3)*dgm(2,2)&
&   +12*gm(1,2)*dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,2)+3*gm(1,3)&
&   *dgm(2,3)+12*gm(1,2)*dgm(3,3))-4.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(1,4,9)=3*gm(2,3)**2*dgm(1,2)+12*gm(1,2)*gm(3,3)*dgm(2,2)+gm(2,3)&
&   *(3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)+6*gm(1,2)*dgm(2,3))+gm(2,2)&
&   *(12*gm(3,3)*dgm(1,2)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(1,5,9)=-3*gm(2,3)**2*dgm(1,1)+15*gm(1,2)*gm(3,3)*dgm(1,2)-3*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))+7.5d0*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(1,6,9)=-4.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(3*gm(2,3)*dgm(1,2)&
&   +12*gm(1,3)*dgm(2,2))+1.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)*(-4.5d0*gm(2,3)&
&   *dgm(1,1)+12*gm(1,3)*dgm(1,2)+12*gm(1,2)*dgm(1,3)-4.5d0*gm(1,1)&
&   *dgm(2,3))
   cm(1,7,9)=gm(2,2)*(6*gm(2,3)*dgm(2,2)+3*gm(2,2)*dgm(2,3))
   cm(1,8,9)=4.5d0*gm(2,3)**2*dgm(2,3)+7.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   +7.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(1,9,9)=3*gm(2,3)**2*dgm(2,2)+6*gm(2,2)*gm(2,3)*dgm(2,3)+gm(2,2)&
&   *(12*gm(3,3)*dgm(2,2)+6*gm(2,2)*dgm(3,3))
   cm(1,10,9)=-1.5d0*gm(3,3)**2*dgm(2,2)+4.5d0*gm(2,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(2,3)*dgm(2,3)-3*gm(2,2)*dgm(3,3))
   cm(1,1,10)=7.5d0*gm(1,3)**2*dgm(1,3)-1.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   -1.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(1,2,10)=7.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-1.5d0*gm(1,3)*dgm(2,2)&
&   -3*gm(1,2)*dgm(2,3))+gm(2,3)*(-3*gm(3,3)*dgm(1,2)+15*gm(1,3)&
&   *dgm(2,3)-3*gm(1,2)*dgm(3,3))-1.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(1,3,10)=gm(3,3)*(3*gm(3,3)*dgm(1,3)+6*gm(1,3)*dgm(3,3))
   cm(1,4,10)=-3*gm(3,3)**2*dgm(1,2)+9*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(9*gm(2,3)*dgm(1,3)+9*gm(1,3)*dgm(2,3)-6*gm(1,2)*dgm(3,3))
   cm(1,5,10)=-1.5d0*gm(3,3)**2*dgm(1,1)+4.5d0*gm(1,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(1,3)*dgm(1,3)-3*gm(1,1)*dgm(3,3))
   cm(1,6,10)=7.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-1.5d0*gm(3,3)*dgm(1,1)+15*gm(1,3)&
&   *dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))-3*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(1,7,10)=7.5d0*gm(2,3)**2*dgm(2,3)-1.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   -1.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(1,8,10)=gm(3,3)*(3*gm(3,3)*dgm(2,3)+6*gm(2,3)*dgm(3,3))
   cm(1,9,10)=-1.5d0*gm(3,3)**2*dgm(2,2)+4.5d0*gm(2,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(2,3)*dgm(2,3)-3*gm(2,2)*dgm(3,3))
   cm(1,10,10)=3*gm(3,3)**2*dgm(3,3)
   cm(2,1,2)=gm(1,1)*(6*gm(1,2)*dgm(1,1)+3*gm(1,1)*dgm(1,2))
   cm(2,2,2)=4.5d0*gm(1,2)**2*dgm(1,2)+7.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   +7.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(2,3,2)=1.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-4.5d0*gm(3,3)*dgm(1,2)&
&   +12*gm(2,3)*dgm(1,3))+gm(1,3)*(12*gm(2,3)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,3)+12*gm(1,1)*dgm(2,3))-4.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(2,4,2)=3*gm(1,2)**2*dgm(1,3)+gm(1,1)*(3*gm(2,3)*dgm(1,2)+12*gm(2,2)&
&   *dgm(1,3))+gm(1,3)*(12*gm(2,2)*dgm(1,1)+6*gm(1,2)*dgm(1,2)+12*gm(1,1)&
&   *dgm(2,2))+3*gm(1,2)*(gm(2,3)*dgm(1,1)+gm(1,1)*dgm(2,3))
   cm(2,5,2)=3*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(12*gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+6*gm(1,1)*dgm(2,3))
   cm(2,6,2)=3*gm(1,2)**2*dgm(1,1)+6*gm(1,1)*gm(1,2)*dgm(1,2)+gm(1,1)&
&   *(12*gm(2,2)*dgm(1,1)+6*gm(1,1)*dgm(2,2))
   cm(2,7,2)=-1.5d0*gm(2,2)**2*dgm(1,1)+4.5d0*gm(1,2)**2*dgm(2,2)&
&   +gm(2,2)*(9*gm(1,2)*dgm(1,2)-3*gm(1,1)*dgm(2,2))
   cm(2,8,2)=-3*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)+7.5d0*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,1)&
&   +15*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(2,9,2)=-4.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(3*gm(2,3)*dgm(1,2)&
&   +12*gm(1,3)*dgm(2,2))+1.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)*(-4.5d0*gm(2,3)&
&   *dgm(1,1)+12*gm(1,3)*dgm(1,2)+12*gm(1,2)*dgm(1,3)-4.5d0*gm(1,1)&
&   *dgm(2,3))
   cm(2,10,2)=7.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-1.5d0*gm(3,3)*dgm(1,1)+15*gm(1,3)&
&   *dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))-3*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(2,1,4)=gm(1,1)*(6*gm(1,3)*dgm(1,1)+3*gm(1,1)*dgm(1,3))
   cm(2,2,4)=1.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(12*gm(2,3)*dgm(1,2)&
&   -4.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-4.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,2)-4.5d0*gm(1,1)*dgm(2,2))+12*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(2,3,4)=4.5d0*gm(1,3)**2*dgm(1,3)+7.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   +7.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(2,4,4)=3*gm(1,3)**2*dgm(1,2)+gm(1,1)*(12*gm(3,3)*dgm(1,2)+3*gm(2,3)&
&   *dgm(1,3))+gm(1,3)*(3*gm(2,3)*dgm(1,1)+6*gm(1,2)*dgm(1,3)+3*gm(1,1)&
&   *dgm(2,3))+12*gm(1,2)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(2,5,4)=3*gm(1,3)**2*dgm(1,1)+6*gm(1,1)*gm(1,3)*dgm(1,3)+gm(1,1)&
&   *(12*gm(3,3)*dgm(1,1)+6*gm(1,1)*dgm(3,3))
   cm(2,6,4)=3*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(12*gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+6*gm(1,1)*dgm(2,3))
   cm(2,7,4)=-1.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(15*gm(2,3)&
&   *dgm(1,2)-3*gm(1,3)*dgm(2,2))+7.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)&
&   *(-1.5d0*gm(2,3)*dgm(1,1)-3*gm(1,3)*dgm(1,2)-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))
   cm(2,8,4)=1.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(12*gm(1,2)*dgm(1,3)&
&   -4.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-4.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)&
&   *dgm(1,3)-4.5d0*gm(1,1)*dgm(3,3))+12*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(2,9,4)=-3*gm(2,3)**2*dgm(1,1)+15*gm(1,2)*gm(3,3)*dgm(1,2)-3*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))+7.5d0*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(2,10,4)=-1.5d0*gm(3,3)**2*dgm(1,1)+4.5d0*gm(1,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(1,3)*dgm(1,3)-3*gm(1,1)*dgm(3,3))
   cm(2,1,6)=3*gm(1,1)**2*dgm(1,1)
   cm(2,2,6)=4.5d0*gm(1,2)**2*dgm(1,1)+9*gm(1,1)*gm(1,2)*dgm(1,2)&
&   +gm(1,1)*(-3*gm(2,2)*dgm(1,1)-1.5d0*gm(1,1)*dgm(2,2))
   cm(2,3,6)=4.5d0*gm(1,3)**2*dgm(1,1)+9*gm(1,1)*gm(1,3)*dgm(1,3)&
&   +gm(1,1)*(-3*gm(3,3)*dgm(1,1)-1.5d0*gm(1,1)*dgm(3,3))
   cm(2,4,6)=9*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(-6*gm(2,3)*dgm(1,1)+9*gm(1,3)*dgm(1,2)-3*gm(1,1)*dgm(2,3))
   cm(2,5,6)=gm(1,1)*(6*gm(1,3)*dgm(1,1)+3*gm(1,1)*dgm(1,3))
   cm(2,6,6)=gm(1,1)*(6*gm(1,2)*dgm(1,1)+3*gm(1,1)*dgm(1,2))
   cm(2,7,6)=7.5d0*gm(1,2)**2*dgm(1,2)-1.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   -1.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(2,8,6)=7.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-1.5d0*gm(3,3)*dgm(1,2)&
&   -3*gm(2,3)*dgm(1,3))+gm(1,3)*(-3*gm(2,3)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,3)-3*gm(1,1)*dgm(2,3))-1.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(2,9,6)=7.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(-3*gm(2,3)*dgm(1,2)&
&   -1.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-1.5d0*gm(2,2)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,2)-1.5d0*gm(1,1)*dgm(2,2))-3*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(2,10,6)=7.5d0*gm(1,3)**2*dgm(1,3)-1.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   -1.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(2,1,7)=4.5d0*gm(1,2)**2*dgm(1,1)+9*gm(1,1)*gm(1,2)*dgm(1,2)&
&   +gm(1,1)*(-3*gm(2,2)*dgm(1,1)-1.5d0*gm(1,1)*dgm(2,2))
   cm(2,2,7)=6*gm(2,2)**2*dgm(1,1)+3*gm(1,2)**2*dgm(2,2)+gm(2,2)&
&   *(6*gm(1,2)*dgm(1,2)+12*gm(1,1)*dgm(2,2))
   cm(2,3,7)=7.5d0*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)&
&   -3*gm(1,3)**2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)&
&   *gm(1,3)*dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)&
&   +15*gm(1,1)*dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(2,4,7)=12*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(6*gm(2,3)*dgm(1,2)&
&   +3*gm(1,3)*dgm(2,2))+3*gm(1,2)**2*dgm(2,3)+gm(2,2)*(12*gm(2,3)&
&   *dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)+12*gm(1,1)*dgm(2,3))
   cm(2,5,7)=1.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(12*gm(2,3)*dgm(1,2)&
&   -4.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-4.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,2)-4.5d0*gm(1,1)*dgm(2,2))+12*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(2,6,7)=4.5d0*gm(1,2)**2*dgm(1,2)+7.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   +7.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(2,7,7)=gm(2,2)*(3*gm(2,2)*dgm(1,2)+6*gm(1,2)*dgm(2,2))
   cm(2,8,7)=1.5d0*gm(2,3)**2*dgm(1,2)-4.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(12*gm(2,2)*dgm(1,3)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-4.5d0*gm(3,3)*dgm(1,2)+12*gm(1,3)*dgm(2,3)-4.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(2,9,7)=6*gm(2,2)**2*dgm(1,3)+3*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(3*gm(2,3)*dgm(1,2)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))
   cm(2,10,7)=7.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-1.5d0*gm(1,3)*dgm(2,2)&
&   -3*gm(1,2)*dgm(2,3))+gm(2,3)*(-3*gm(3,3)*dgm(1,2)+15*gm(1,3)&
&   *dgm(2,3)-3*gm(1,2)*dgm(3,3))-1.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(2,1,8)=4.5d0*gm(1,3)**2*dgm(1,1)+9*gm(1,1)*gm(1,3)*dgm(1,3)&
&   +gm(1,1)*(-3*gm(3,3)*dgm(1,1)-1.5d0*gm(1,1)*dgm(3,3))
   cm(2,2,8)=7.5d0*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)&
&   -3*gm(1,3)**2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)&
&   *gm(1,3)*dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)&
&   +15*gm(1,1)*dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(2,3,8)=6*gm(3,3)**2*dgm(1,1)+3*gm(1,3)**2*dgm(3,3)+gm(3,3)&
&   *(6*gm(1,3)*dgm(1,3)+12*gm(1,1)*dgm(3,3))
   cm(2,4,8)=3*gm(1,3)**2*dgm(2,3)+gm(3,3)*(3*gm(1,2)*dgm(1,3)+12*gm(1,1)&
&   *dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,1)+6*gm(1,3)*dgm(1,3)+12*gm(1,1)&
&   *dgm(3,3))+3*gm(1,3)*(gm(3,3)*dgm(1,2)+gm(1,2)*dgm(3,3))
   cm(2,5,8)=4.5d0*gm(1,3)**2*dgm(1,3)+7.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   +7.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(2,6,8)=1.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-4.5d0*gm(3,3)*dgm(1,2)&
&   +12*gm(2,3)*dgm(1,3))+gm(1,3)*(12*gm(2,3)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,3)+12*gm(1,1)*dgm(2,3))-4.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(2,7,8)=7.5d0*gm(2,3)**2*dgm(1,2)-1.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(-3*gm(2,2)*dgm(1,3)-3*gm(1,3)*dgm(2,2)+15*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,2)-3*gm(1,3)*dgm(2,3)-1.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(2,8,8)=6*gm(3,3)**2*dgm(1,2)+3*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(2,9,8)=1.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-4.5d0*gm(1,3)*dgm(2,2)&
&   +12*gm(1,2)*dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,2)+3*gm(1,3)&
&   *dgm(2,3)+12*gm(1,2)*dgm(3,3))-4.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(2,10,8)=gm(3,3)*(3*gm(3,3)*dgm(1,3)+6*gm(1,3)*dgm(3,3))
   cm(2,1,9)=9*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(-6*gm(2,3)*dgm(1,1)+9*gm(1,3)*dgm(1,2)-3*gm(1,1)*dgm(2,3))
   cm(2,2,9)=12*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(6*gm(2,3)*dgm(1,2)&
&   +3*gm(1,3)*dgm(2,2))+3*gm(1,2)**2*dgm(2,3)+gm(2,2)*(12*gm(2,3)&
&   *dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)+12*gm(1,1)*dgm(2,3))
   cm(2,3,9)=3*gm(1,3)**2*dgm(2,3)+gm(3,3)*(3*gm(1,2)*dgm(1,3)+12*gm(1,1)&
&   *dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,1)+6*gm(1,3)*dgm(1,3)+12*gm(1,1)&
&   *dgm(3,3))+3*gm(1,3)*(gm(3,3)*dgm(1,2)+gm(1,2)*dgm(3,3))
   cm(2,4,9)=9*gm(2,3)**2*dgm(1,1)+18*gm(1,2)*gm(3,3)*dgm(1,2)+9*gm(1,3)&
&   **2*dgm(2,2)+15*gm(1,1)*gm(3,3)*dgm(2,2)-6*gm(1,2)*gm(1,3)*dgm(2,3)&
&   +gm(2,3)*(-6*gm(1,3)*dgm(1,2)-6*gm(1,2)*dgm(1,3)+18*gm(1,1)*dgm(2,3))&
&   +9*gm(1,2)**2*dgm(3,3)+gm(2,2)*(15*gm(3,3)*dgm(1,1)+18*gm(1,3)&
&   *dgm(1,3)+15*gm(1,1)*dgm(3,3))
   cm(2,5,9)=3*gm(1,3)**2*dgm(1,2)+gm(1,1)*(12*gm(3,3)*dgm(1,2)+3*gm(2,3)&
&   *dgm(1,3))+gm(1,3)*(3*gm(2,3)*dgm(1,1)+6*gm(1,2)*dgm(1,3)+3*gm(1,1)&
&   *dgm(2,3))+12*gm(1,2)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(2,6,9)=3*gm(1,2)**2*dgm(1,3)+gm(1,1)*(3*gm(2,3)*dgm(1,2)+12*gm(2,2)&
&   *dgm(1,3))+gm(1,3)*(12*gm(2,2)*dgm(1,1)+6*gm(1,2)*dgm(1,2)+12*gm(1,1)&
&   *dgm(2,2))+3*gm(1,2)*(gm(2,3)*dgm(1,1)+gm(1,1)*dgm(2,3))
   cm(2,7,9)=-3*gm(2,2)**2*dgm(1,3)+9*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(9*gm(2,3)*dgm(1,2)-6*gm(1,3)*dgm(2,2)+9*gm(1,2)*dgm(2,3))
   cm(2,8,9)=3*gm(2,3)**2*dgm(1,3)+gm(3,3)*(12*gm(1,3)*dgm(2,2)+3*gm(1,2)&
&   *dgm(2,3))+gm(2,3)*(3*gm(3,3)*dgm(1,2)+6*gm(1,3)*dgm(2,3)+3*gm(1,2)&
&   *dgm(3,3))+12*gm(2,2)*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(2,9,9)=3*gm(2,3)**2*dgm(1,2)+12*gm(1,2)*gm(3,3)*dgm(2,2)+gm(2,3)&
&   *(3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)+6*gm(1,2)*dgm(2,3))+gm(2,2)&
&   *(12*gm(3,3)*dgm(1,2)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(2,10,9)=-3*gm(3,3)**2*dgm(1,2)+9*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(9*gm(2,3)*dgm(1,3)+9*gm(1,3)*dgm(2,3)-6*gm(1,2)*dgm(3,3))
   cm(2,1,11)=7.5d0*gm(1,2)**2*dgm(1,2)-1.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   -1.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(2,2,11)=gm(2,2)*(3*gm(2,2)*dgm(1,2)+6*gm(1,2)*dgm(2,2))
   cm(2,3,11)=7.5d0*gm(2,3)**2*dgm(1,2)-1.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(-3*gm(2,2)*dgm(1,3)-3*gm(1,3)*dgm(2,2)+15*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,2)-3*gm(1,3)*dgm(2,3)-1.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(2,4,11)=-3*gm(2,2)**2*dgm(1,3)+9*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(9*gm(2,3)*dgm(1,2)-6*gm(1,3)*dgm(2,2)+9*gm(1,2)*dgm(2,3))
   cm(2,5,11)=-1.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(15*gm(2,3)&
&   *dgm(1,2)-3*gm(1,3)*dgm(2,2))+7.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)&
&   *(-1.5d0*gm(2,3)*dgm(1,1)-3*gm(1,3)*dgm(1,2)-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))
   cm(2,6,11)=-1.5d0*gm(2,2)**2*dgm(1,1)+4.5d0*gm(1,2)**2*dgm(2,2)&
&   +gm(2,2)*(9*gm(1,2)*dgm(1,2)-3*gm(1,1)*dgm(2,2))
   cm(2,7,11)=3*gm(2,2)**2*dgm(2,2)
   cm(2,8,11)=4.5d0*gm(2,3)**2*dgm(2,2)+9*gm(2,2)*gm(2,3)*dgm(2,3)&
&   +gm(2,2)*(-3*gm(3,3)*dgm(2,2)-1.5d0*gm(2,2)*dgm(3,3))
   cm(2,9,11)=gm(2,2)*(6*gm(2,3)*dgm(2,2)+3*gm(2,2)*dgm(2,3))
   cm(2,10,11)=7.5d0*gm(2,3)**2*dgm(2,3)-1.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   -1.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(2,1,12)=7.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-1.5d0*gm(3,3)*dgm(1,2)&
&   -3*gm(2,3)*dgm(1,3))+gm(1,3)*(-3*gm(2,3)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,3)-3*gm(1,1)*dgm(2,3))-1.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(2,2,12)=1.5d0*gm(2,3)**2*dgm(1,2)-4.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(12*gm(2,2)*dgm(1,3)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-4.5d0*gm(3,3)*dgm(1,2)+12*gm(1,3)*dgm(2,3)-4.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(2,3,12)=6*gm(3,3)**2*dgm(1,2)+3*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(2,4,12)=3*gm(2,3)**2*dgm(1,3)+gm(3,3)*(12*gm(1,3)*dgm(2,2)&
&   +3*gm(1,2)*dgm(2,3))+gm(2,3)*(3*gm(3,3)*dgm(1,2)+6*gm(1,3)*dgm(2,3)&
&   +3*gm(1,2)*dgm(3,3))+12*gm(2,2)*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(2,5,12)=1.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(12*gm(1,2)*dgm(1,3)&
&   -4.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-4.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)&
&   *dgm(1,3)-4.5d0*gm(1,1)*dgm(3,3))+12*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(2,6,12)=-3*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)+7.5d0*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,1)&
&   +15*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(2,7,12)=4.5d0*gm(2,3)**2*dgm(2,2)+9*gm(2,2)*gm(2,3)*dgm(2,3)&
&   +gm(2,2)*(-3*gm(3,3)*dgm(2,2)-1.5d0*gm(2,2)*dgm(3,3))
   cm(2,8,12)=6*gm(3,3)**2*dgm(2,2)+3*gm(2,3)**2*dgm(3,3)+gm(3,3)&
&   *(6*gm(2,3)*dgm(2,3)+12*gm(2,2)*dgm(3,3))
   cm(2,9,12)=4.5d0*gm(2,3)**2*dgm(2,3)+7.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   +7.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(2,10,12)=gm(3,3)*(3*gm(3,3)*dgm(2,3)+6*gm(2,3)*dgm(3,3))
   cm(2,1,13)=7.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(-3*gm(2,3)*dgm(1,2)&
&   -1.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-1.5d0*gm(2,2)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,2)-1.5d0*gm(1,1)*dgm(2,2))-3*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(2,2,13)=6*gm(2,2)**2*dgm(1,3)+3*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(3*gm(2,3)*dgm(1,2)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))
   cm(2,3,13)=1.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-4.5d0*gm(1,3)*dgm(2,2)&
&   +12*gm(1,2)*dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,2)+3*gm(1,3)&
&   *dgm(2,3)+12*gm(1,2)*dgm(3,3))-4.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(2,4,13)=3*gm(2,3)**2*dgm(1,2)+12*gm(1,2)*gm(3,3)*dgm(2,2)+gm(2,3)&
&   *(3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)+6*gm(1,2)*dgm(2,3))+gm(2,2)&
&   *(12*gm(3,3)*dgm(1,2)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(2,5,13)=-3*gm(2,3)**2*dgm(1,1)+15*gm(1,2)*gm(3,3)*dgm(1,2)&
&   -3*gm(1,3)**2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)&
&   *gm(1,3)*dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)&
&   -6*gm(1,1)*dgm(2,3))+7.5d0*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(2,6,13)=-4.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(3*gm(2,3)&
&   *dgm(1,2)+12*gm(1,3)*dgm(2,2))+1.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)&
&   *(-4.5d0*gm(2,3)*dgm(1,1)+12*gm(1,3)*dgm(1,2)+12*gm(1,2)*dgm(1,3)&
&   -4.5d0*gm(1,1)*dgm(2,3))
   cm(2,7,13)=gm(2,2)*(6*gm(2,3)*dgm(2,2)+3*gm(2,2)*dgm(2,3))
   cm(2,8,13)=4.5d0*gm(2,3)**2*dgm(2,3)+7.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   +7.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(2,9,13)=3*gm(2,3)**2*dgm(2,2)+6*gm(2,2)*gm(2,3)*dgm(2,3)+gm(2,2)&
&   *(12*gm(3,3)*dgm(2,2)+6*gm(2,2)*dgm(3,3))
   cm(2,10,13)=-1.5d0*gm(3,3)**2*dgm(2,2)+4.5d0*gm(2,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(2,3)*dgm(2,3)-3*gm(2,2)*dgm(3,3))
   cm(2,1,14)=7.5d0*gm(1,3)**2*dgm(1,3)-1.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   -1.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(2,2,14)=7.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-1.5d0*gm(1,3)*dgm(2,2)&
&   -3*gm(1,2)*dgm(2,3))+gm(2,3)*(-3*gm(3,3)*dgm(1,2)+15*gm(1,3)&
&   *dgm(2,3)-3*gm(1,2)*dgm(3,3))-1.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(2,3,14)=gm(3,3)*(3*gm(3,3)*dgm(1,3)+6*gm(1,3)*dgm(3,3))
   cm(2,4,14)=-3*gm(3,3)**2*dgm(1,2)+9*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(9*gm(2,3)*dgm(1,3)+9*gm(1,3)*dgm(2,3)-6*gm(1,2)*dgm(3,3))
   cm(2,5,14)=-1.5d0*gm(3,3)**2*dgm(1,1)+4.5d0*gm(1,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(1,3)*dgm(1,3)-3*gm(1,1)*dgm(3,3))
   cm(2,6,14)=7.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-1.5d0*gm(3,3)*dgm(1,1)+15*gm(1,3)&
&   *dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))-3*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(2,7,14)=7.5d0*gm(2,3)**2*dgm(2,3)-1.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   -1.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(2,8,14)=gm(3,3)*(3*gm(3,3)*dgm(2,3)+6*gm(2,3)*dgm(3,3))
   cm(2,9,14)=-1.5d0*gm(3,3)**2*dgm(2,2)+4.5d0*gm(2,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(2,3)*dgm(2,3)-3*gm(2,2)*dgm(3,3))
   cm(2,10,14)=3*gm(3,3)**2*dgm(3,3)
   cm(3,1,3)=gm(1,1)*(6*gm(1,3)*dgm(1,1)+3*gm(1,1)*dgm(1,3))
   cm(3,2,3)=1.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(12*gm(2,3)*dgm(1,2)&
&   -4.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-4.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,2)-4.5d0*gm(1,1)*dgm(2,2))+12*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(3,3,3)=4.5d0*gm(1,3)**2*dgm(1,3)+7.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   +7.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(3,4,3)=3*gm(1,3)**2*dgm(1,2)+gm(1,1)*(12*gm(3,3)*dgm(1,2)+3*gm(2,3)&
&   *dgm(1,3))+gm(1,3)*(3*gm(2,3)*dgm(1,1)+6*gm(1,2)*dgm(1,3)+3*gm(1,1)&
&   *dgm(2,3))+12*gm(1,2)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(3,5,3)=3*gm(1,3)**2*dgm(1,1)+6*gm(1,1)*gm(1,3)*dgm(1,3)+gm(1,1)&
&   *(12*gm(3,3)*dgm(1,1)+6*gm(1,1)*dgm(3,3))
   cm(3,6,3)=3*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(12*gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+6*gm(1,1)*dgm(2,3))
   cm(3,7,3)=-1.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(15*gm(2,3)&
&   *dgm(1,2)-3*gm(1,3)*dgm(2,2))+7.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)&
&   *(-1.5d0*gm(2,3)*dgm(1,1)-3*gm(1,3)*dgm(1,2)-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))
   cm(3,8,3)=1.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(12*gm(1,2)*dgm(1,3)&
&   -4.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-4.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)&
&   *dgm(1,3)-4.5d0*gm(1,1)*dgm(3,3))+12*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(3,9,3)=-3*gm(2,3)**2*dgm(1,1)+15*gm(1,2)*gm(3,3)*dgm(1,2)-3*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))+7.5d0*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(3,10,3)=-1.5d0*gm(3,3)**2*dgm(1,1)+4.5d0*gm(1,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(1,3)*dgm(1,3)-3*gm(1,1)*dgm(3,3))
   cm(3,1,4)=gm(1,1)*(6*gm(1,2)*dgm(1,1)+3*gm(1,1)*dgm(1,2))
   cm(3,2,4)=4.5d0*gm(1,2)**2*dgm(1,2)+7.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   +7.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(3,3,4)=1.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-4.5d0*gm(3,3)*dgm(1,2)&
&   +12*gm(2,3)*dgm(1,3))+gm(1,3)*(12*gm(2,3)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,3)+12*gm(1,1)*dgm(2,3))-4.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(3,4,4)=3*gm(1,2)**2*dgm(1,3)+gm(1,1)*(3*gm(2,3)*dgm(1,2)+12*gm(2,2)&
&   *dgm(1,3))+gm(1,3)*(12*gm(2,2)*dgm(1,1)+6*gm(1,2)*dgm(1,2)+12*gm(1,1)&
&   *dgm(2,2))+3*gm(1,2)*(gm(2,3)*dgm(1,1)+gm(1,1)*dgm(2,3))
   cm(3,5,4)=3*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(12*gm(2,3)*dgm(1,1)+3*gm(1,3)*dgm(1,2)+6*gm(1,1)*dgm(2,3))
   cm(3,6,4)=3*gm(1,2)**2*dgm(1,1)+6*gm(1,1)*gm(1,2)*dgm(1,2)+gm(1,1)&
&   *(12*gm(2,2)*dgm(1,1)+6*gm(1,1)*dgm(2,2))
   cm(3,7,4)=-1.5d0*gm(2,2)**2*dgm(1,1)+4.5d0*gm(1,2)**2*dgm(2,2)&
&   +gm(2,2)*(9*gm(1,2)*dgm(1,2)-3*gm(1,1)*dgm(2,2))
   cm(3,8,4)=-3*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)+7.5d0*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,1)&
&   +15*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(3,9,4)=-4.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(3*gm(2,3)*dgm(1,2)&
&   +12*gm(1,3)*dgm(2,2))+1.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)*(-4.5d0*gm(2,3)&
&   *dgm(1,1)+12*gm(1,3)*dgm(1,2)+12*gm(1,2)*dgm(1,3)-4.5d0*gm(1,1)&
&   *dgm(2,3))
   cm(3,10,4)=7.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-1.5d0*gm(3,3)*dgm(1,1)+15*gm(1,3)&
&   *dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))-3*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(3,1,5)=3*gm(1,1)**2*dgm(1,1)
   cm(3,2,5)=4.5d0*gm(1,2)**2*dgm(1,1)+9*gm(1,1)*gm(1,2)*dgm(1,2)&
&   +gm(1,1)*(-3*gm(2,2)*dgm(1,1)-1.5d0*gm(1,1)*dgm(2,2))
   cm(3,3,5)=4.5d0*gm(1,3)**2*dgm(1,1)+9*gm(1,1)*gm(1,3)*dgm(1,3)&
&   +gm(1,1)*(-3*gm(3,3)*dgm(1,1)-1.5d0*gm(1,1)*dgm(3,3))
   cm(3,4,5)=9*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(-6*gm(2,3)*dgm(1,1)+9*gm(1,3)*dgm(1,2)-3*gm(1,1)*dgm(2,3))
   cm(3,5,5)=gm(1,1)*(6*gm(1,3)*dgm(1,1)+3*gm(1,1)*dgm(1,3))
   cm(3,6,5)=gm(1,1)*(6*gm(1,2)*dgm(1,1)+3*gm(1,1)*dgm(1,2))
   cm(3,7,5)=7.5d0*gm(1,2)**2*dgm(1,2)-1.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   -1.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(3,8,5)=7.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-1.5d0*gm(3,3)*dgm(1,2)&
&   -3*gm(2,3)*dgm(1,3))+gm(1,3)*(-3*gm(2,3)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,3)-3*gm(1,1)*dgm(2,3))-1.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(3,9,5)=7.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(-3*gm(2,3)*dgm(1,2)&
&   -1.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-1.5d0*gm(2,2)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,2)-1.5d0*gm(1,1)*dgm(2,2))-3*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(3,10,5)=7.5d0*gm(1,3)**2*dgm(1,3)-1.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   -1.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(3,1,8)=9*gm(1,2)*(gm(1,3)*dgm(1,1)+gm(1,1)*dgm(1,3))+gm(1,1)&
&   *(-6*gm(2,3)*dgm(1,1)+9*gm(1,3)*dgm(1,2)-3*gm(1,1)*dgm(2,3))
   cm(3,2,8)=12*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(6*gm(2,3)*dgm(1,2)&
&   +3*gm(1,3)*dgm(2,2))+3*gm(1,2)**2*dgm(2,3)+gm(2,2)*(12*gm(2,3)&
&   *dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)+12*gm(1,1)*dgm(2,3))
   cm(3,3,8)=3*gm(1,3)**2*dgm(2,3)+gm(3,3)*(3*gm(1,2)*dgm(1,3)+12*gm(1,1)&
&   *dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,1)+6*gm(1,3)*dgm(1,3)+12*gm(1,1)&
&   *dgm(3,3))+3*gm(1,3)*(gm(3,3)*dgm(1,2)+gm(1,2)*dgm(3,3))
   cm(3,4,8)=9*gm(2,3)**2*dgm(1,1)+18*gm(1,2)*gm(3,3)*dgm(1,2)+9*gm(1,3)&
&   **2*dgm(2,2)+15*gm(1,1)*gm(3,3)*dgm(2,2)-6*gm(1,2)*gm(1,3)*dgm(2,3)&
&   +gm(2,3)*(-6*gm(1,3)*dgm(1,2)-6*gm(1,2)*dgm(1,3)+18*gm(1,1)*dgm(2,3))&
&   +9*gm(1,2)**2*dgm(3,3)+gm(2,2)*(15*gm(3,3)*dgm(1,1)+18*gm(1,3)&
&   *dgm(1,3)+15*gm(1,1)*dgm(3,3))
   cm(3,5,8)=3*gm(1,3)**2*dgm(1,2)+gm(1,1)*(12*gm(3,3)*dgm(1,2)+3*gm(2,3)&
&   *dgm(1,3))+gm(1,3)*(3*gm(2,3)*dgm(1,1)+6*gm(1,2)*dgm(1,3)+3*gm(1,1)&
&   *dgm(2,3))+12*gm(1,2)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(3,6,8)=3*gm(1,2)**2*dgm(1,3)+gm(1,1)*(3*gm(2,3)*dgm(1,2)+12*gm(2,2)&
&   *dgm(1,3))+gm(1,3)*(12*gm(2,2)*dgm(1,1)+6*gm(1,2)*dgm(1,2)+12*gm(1,1)&
&   *dgm(2,2))+3*gm(1,2)*(gm(2,3)*dgm(1,1)+gm(1,1)*dgm(2,3))
   cm(3,7,8)=-3*gm(2,2)**2*dgm(1,3)+9*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(9*gm(2,3)*dgm(1,2)-6*gm(1,3)*dgm(2,2)+9*gm(1,2)*dgm(2,3))
   cm(3,8,8)=3*gm(2,3)**2*dgm(1,3)+gm(3,3)*(12*gm(1,3)*dgm(2,2)+3*gm(1,2)&
&   *dgm(2,3))+gm(2,3)*(3*gm(3,3)*dgm(1,2)+6*gm(1,3)*dgm(2,3)+3*gm(1,2)&
&   *dgm(3,3))+12*gm(2,2)*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(3,9,8)=3*gm(2,3)**2*dgm(1,2)+12*gm(1,2)*gm(3,3)*dgm(2,2)+gm(2,3)&
&   *(3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)+6*gm(1,2)*dgm(2,3))+gm(2,2)&
&   *(12*gm(3,3)*dgm(1,2)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(3,10,8)=-3*gm(3,3)**2*dgm(1,2)+9*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(9*gm(2,3)*dgm(1,3)+9*gm(1,3)*dgm(2,3)-6*gm(1,2)*dgm(3,3))
   cm(3,1,9)=4.5d0*gm(1,2)**2*dgm(1,1)+9*gm(1,1)*gm(1,2)*dgm(1,2)&
&   +gm(1,1)*(-3*gm(2,2)*dgm(1,1)-1.5d0*gm(1,1)*dgm(2,2))
   cm(3,2,9)=6*gm(2,2)**2*dgm(1,1)+3*gm(1,2)**2*dgm(2,2)+gm(2,2)&
&   *(6*gm(1,2)*dgm(1,2)+12*gm(1,1)*dgm(2,2))
   cm(3,3,9)=7.5d0*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)&
&   -3*gm(1,3)**2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)&
&   *gm(1,3)*dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)&
&   +15*gm(1,1)*dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(3,4,9)=12*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(6*gm(2,3)*dgm(1,2)&
&   +3*gm(1,3)*dgm(2,2))+3*gm(1,2)**2*dgm(2,3)+gm(2,2)*(12*gm(2,3)&
&   *dgm(1,1)+3*gm(1,3)*dgm(1,2)+3*gm(1,2)*dgm(1,3)+12*gm(1,1)*dgm(2,3))
   cm(3,5,9)=1.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(12*gm(2,3)*dgm(1,2)&
&   -4.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-4.5d0*gm(2,2)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,2)-4.5d0*gm(1,1)*dgm(2,2))+12*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(3,6,9)=4.5d0*gm(1,2)**2*dgm(1,2)+7.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   +7.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(3,7,9)=gm(2,2)*(3*gm(2,2)*dgm(1,2)+6*gm(1,2)*dgm(2,2))
   cm(3,8,9)=1.5d0*gm(2,3)**2*dgm(1,2)-4.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(12*gm(2,2)*dgm(1,3)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-4.5d0*gm(3,3)*dgm(1,2)+12*gm(1,3)*dgm(2,3)-4.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(3,9,9)=6*gm(2,2)**2*dgm(1,3)+3*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(3*gm(2,3)*dgm(1,2)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))
   cm(3,10,9)=7.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-1.5d0*gm(1,3)*dgm(2,2)&
&   -3*gm(1,2)*dgm(2,3))+gm(2,3)*(-3*gm(3,3)*dgm(1,2)+15*gm(1,3)&
&   *dgm(2,3)-3*gm(1,2)*dgm(3,3))-1.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(3,1,10)=4.5d0*gm(1,3)**2*dgm(1,1)+9*gm(1,1)*gm(1,3)*dgm(1,3)&
&   +gm(1,1)*(-3*gm(3,3)*dgm(1,1)-1.5d0*gm(1,1)*dgm(3,3))
   cm(3,2,10)=7.5d0*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)&
&   -3*gm(1,3)**2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)&
&   *gm(1,3)*dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)&
&   +15*gm(1,1)*dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(3,3,10)=6*gm(3,3)**2*dgm(1,1)+3*gm(1,3)**2*dgm(3,3)+gm(3,3)&
&   *(6*gm(1,3)*dgm(1,3)+12*gm(1,1)*dgm(3,3))
   cm(3,4,10)=3*gm(1,3)**2*dgm(2,3)+gm(3,3)*(3*gm(1,2)*dgm(1,3)+12*gm(1,1)&
&   *dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,1)+6*gm(1,3)*dgm(1,3)+12*gm(1,1)&
&   *dgm(3,3))+3*gm(1,3)*(gm(3,3)*dgm(1,2)+gm(1,2)*dgm(3,3))
   cm(3,5,10)=4.5d0*gm(1,3)**2*dgm(1,3)+7.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   +7.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(3,6,10)=1.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-4.5d0*gm(3,3)*dgm(1,2)&
&   +12*gm(2,3)*dgm(1,3))+gm(1,3)*(12*gm(2,3)*dgm(1,1)+3*gm(1,2)&
&   *dgm(1,3)+12*gm(1,1)*dgm(2,3))-4.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(3,7,10)=7.5d0*gm(2,3)**2*dgm(1,2)-1.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(-3*gm(2,2)*dgm(1,3)-3*gm(1,3)*dgm(2,2)+15*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,2)-3*gm(1,3)*dgm(2,3)-1.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(3,8,10)=6*gm(3,3)**2*dgm(1,2)+3*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(3,9,10)=1.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-4.5d0*gm(1,3)*dgm(2,2)&
&   +12*gm(1,2)*dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,2)+3*gm(1,3)&
&   *dgm(2,3)+12*gm(1,2)*dgm(3,3))-4.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(3,10,10)=gm(3,3)*(3*gm(3,3)*dgm(1,3)+6*gm(1,3)*dgm(3,3))
   cm(3,1,12)=7.5d0*gm(1,2)**2*dgm(1,3)+gm(1,1)*(-3*gm(2,3)*dgm(1,2)&
&   -1.5d0*gm(2,2)*dgm(1,3))+gm(1,3)*(-1.5d0*gm(2,2)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,2)-1.5d0*gm(1,1)*dgm(2,2))-3*gm(1,2)*(gm(2,3)*dgm(1,1)&
&   +gm(1,1)*dgm(2,3))
   cm(3,2,12)=6*gm(2,2)**2*dgm(1,3)+3*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(3*gm(2,3)*dgm(1,2)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))
   cm(3,3,12)=1.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-4.5d0*gm(1,3)*dgm(2,2)&
&   +12*gm(1,2)*dgm(2,3))+gm(2,3)*(12*gm(3,3)*dgm(1,2)+3*gm(1,3)&
&   *dgm(2,3)+12*gm(1,2)*dgm(3,3))-4.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(3,4,12)=3*gm(2,3)**2*dgm(1,2)+12*gm(1,2)*gm(3,3)*dgm(2,2)+gm(2,3)&
&   *(3*gm(2,2)*dgm(1,3)+3*gm(1,3)*dgm(2,2)+6*gm(1,2)*dgm(2,3))+gm(2,2)&
&   *(12*gm(3,3)*dgm(1,2)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(3,5,12)=-3*gm(2,3)**2*dgm(1,1)+15*gm(1,2)*gm(3,3)*dgm(1,2)&
&   -3*gm(1,3)**2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)&
&   *gm(1,3)*dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)&
&   -6*gm(1,1)*dgm(2,3))+7.5d0*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)&
&   *dgm(1,1)-6*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(3,6,12)=-4.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(3*gm(2,3)&
&   *dgm(1,2)+12*gm(1,3)*dgm(2,2))+1.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)&
&   *(-4.5d0*gm(2,3)*dgm(1,1)+12*gm(1,3)*dgm(1,2)+12*gm(1,2)*dgm(1,3)&
&   -4.5d0*gm(1,1)*dgm(2,3))
   cm(3,7,12)=gm(2,2)*(6*gm(2,3)*dgm(2,2)+3*gm(2,2)*dgm(2,3))
   cm(3,8,12)=4.5d0*gm(2,3)**2*dgm(2,3)+7.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   +7.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(3,9,12)=3*gm(2,3)**2*dgm(2,2)+6*gm(2,2)*gm(2,3)*dgm(2,3)+gm(2,2)&
&   *(12*gm(3,3)*dgm(2,2)+6*gm(2,2)*dgm(3,3))
   cm(3,10,12)=-1.5d0*gm(3,3)**2*dgm(2,2)+4.5d0*gm(2,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(2,3)*dgm(2,3)-3*gm(2,2)*dgm(3,3))
   cm(3,1,13)=7.5d0*gm(1,2)**2*dgm(1,2)-1.5d0*gm(1,1)*gm(2,2)*dgm(1,2)&
&   -1.5d0*gm(1,2)*(gm(2,2)*dgm(1,1)+gm(1,1)*dgm(2,2))
   cm(3,2,13)=gm(2,2)*(3*gm(2,2)*dgm(1,2)+6*gm(1,2)*dgm(2,2))
   cm(3,3,13)=7.5d0*gm(2,3)**2*dgm(1,2)-1.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(-3*gm(2,2)*dgm(1,3)-3*gm(1,3)*dgm(2,2)+15*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,2)-3*gm(1,3)*dgm(2,3)-1.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(3,4,13)=-3*gm(2,2)**2*dgm(1,3)+9*gm(1,2)*gm(2,3)*dgm(2,2)+gm(2,2)&
&   *(9*gm(2,3)*dgm(1,2)-6*gm(1,3)*dgm(2,2)+9*gm(1,2)*dgm(2,3))
   cm(3,5,13)=-1.5d0*gm(1,1)*gm(2,3)*dgm(2,2)+gm(1,2)*(15*gm(2,3)&
&   *dgm(1,2)-3*gm(1,3)*dgm(2,2))+7.5d0*gm(1,2)**2*dgm(2,3)+gm(2,2)&
&   *(-1.5d0*gm(2,3)*dgm(1,1)-3*gm(1,3)*dgm(1,2)-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))
   cm(3,6,13)=-1.5d0*gm(2,2)**2*dgm(1,1)+4.5d0*gm(1,2)**2*dgm(2,2)&
&   +gm(2,2)*(9*gm(1,2)*dgm(1,2)-3*gm(1,1)*dgm(2,2))
   cm(3,7,13)=3*gm(2,2)**2*dgm(2,2)
   cm(3,8,13)=4.5d0*gm(2,3)**2*dgm(2,2)+9*gm(2,2)*gm(2,3)*dgm(2,3)&
&   +gm(2,2)*(-3*gm(3,3)*dgm(2,2)-1.5d0*gm(2,2)*dgm(3,3))
   cm(3,9,13)=gm(2,2)*(6*gm(2,3)*dgm(2,2)+3*gm(2,2)*dgm(2,3))
   cm(3,10,13)=7.5d0*gm(2,3)**2*dgm(2,3)-1.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   -1.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(3,1,14)=7.5d0*gm(1,3)**2*dgm(1,2)+gm(1,1)*(-1.5d0*gm(3,3)*dgm(1,2)&
&   -3*gm(2,3)*dgm(1,3))+gm(1,3)*(-3*gm(2,3)*dgm(1,1)+15*gm(1,2)&
&   *dgm(1,3)-3*gm(1,1)*dgm(2,3))-1.5d0*gm(1,2)*(gm(3,3)*dgm(1,1)&
&   +gm(1,1)*dgm(3,3))
   cm(3,2,14)=1.5d0*gm(2,3)**2*dgm(1,2)-4.5d0*gm(1,2)*gm(3,3)*dgm(2,2)&
&   +gm(2,3)*(12*gm(2,2)*dgm(1,3)+12*gm(1,3)*dgm(2,2)+3*gm(1,2)*dgm(2,3))&
&   +gm(2,2)*(-4.5d0*gm(3,3)*dgm(1,2)+12*gm(1,3)*dgm(2,3)-4.5d0*gm(1,2)&
&   *dgm(3,3))
   cm(3,3,14)=6*gm(3,3)**2*dgm(1,2)+3*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(3*gm(2,3)*dgm(1,3)+3*gm(1,3)*dgm(2,3)+12*gm(1,2)*dgm(3,3))
   cm(3,4,14)=3*gm(2,3)**2*dgm(1,3)+gm(3,3)*(12*gm(1,3)*dgm(2,2)&
&   +3*gm(1,2)*dgm(2,3))+gm(2,3)*(3*gm(3,3)*dgm(1,2)+6*gm(1,3)*dgm(2,3)&
&   +3*gm(1,2)*dgm(3,3))+12*gm(2,2)*(gm(3,3)*dgm(1,3)+gm(1,3)*dgm(3,3))
   cm(3,5,14)=1.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(12*gm(1,2)*dgm(1,3)&
&   -4.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-4.5d0*gm(3,3)*dgm(1,1)+3*gm(1,3)&
&   *dgm(1,3)-4.5d0*gm(1,1)*dgm(3,3))+12*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(3,6,14)=-3*gm(2,3)**2*dgm(1,1)-6*gm(1,2)*gm(3,3)*dgm(1,2)+7.5d0*gm(1,3)&
&   **2*dgm(2,2)-1.5d0*gm(1,1)*gm(3,3)*dgm(2,2)+9*gm(1,2)*gm(1,3)&
&   *dgm(2,3)+gm(2,3)*(9*gm(1,3)*dgm(1,2)+9*gm(1,2)*dgm(1,3)-6*gm(1,1)&
&   *dgm(2,3))-3*gm(1,2)**2*dgm(3,3)+gm(2,2)*(-1.5d0*gm(3,3)*dgm(1,1)&
&   +15*gm(1,3)*dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))
   cm(3,7,14)=4.5d0*gm(2,3)**2*dgm(2,2)+9*gm(2,2)*gm(2,3)*dgm(2,3)&
&   +gm(2,2)*(-3*gm(3,3)*dgm(2,2)-1.5d0*gm(2,2)*dgm(3,3))
   cm(3,8,14)=6*gm(3,3)**2*dgm(2,2)+3*gm(2,3)**2*dgm(3,3)+gm(3,3)&
&   *(6*gm(2,3)*dgm(2,3)+12*gm(2,2)*dgm(3,3))
   cm(3,9,14)=4.5d0*gm(2,3)**2*dgm(2,3)+7.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   +7.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(3,10,14)=gm(3,3)*(3*gm(3,3)*dgm(2,3)+6*gm(2,3)*dgm(3,3))
   cm(3,1,15)=7.5d0*gm(1,3)**2*dgm(1,3)-1.5d0*gm(1,1)*gm(3,3)*dgm(1,3)&
&   -1.5d0*gm(1,3)*(gm(3,3)*dgm(1,1)+gm(1,1)*dgm(3,3))
   cm(3,2,15)=7.5d0*gm(2,3)**2*dgm(1,3)+gm(3,3)*(-1.5d0*gm(1,3)*dgm(2,2)&
&   -3*gm(1,2)*dgm(2,3))+gm(2,3)*(-3*gm(3,3)*dgm(1,2)+15*gm(1,3)&
&   *dgm(2,3)-3*gm(1,2)*dgm(3,3))-1.5d0*gm(2,2)*(gm(3,3)*dgm(1,3)&
&   +gm(1,3)*dgm(3,3))
   cm(3,3,15)=gm(3,3)*(3*gm(3,3)*dgm(1,3)+6*gm(1,3)*dgm(3,3))
   cm(3,4,15)=-3*gm(3,3)**2*dgm(1,2)+9*gm(1,3)*gm(2,3)*dgm(3,3)+gm(3,3)&
&   *(9*gm(2,3)*dgm(1,3)+9*gm(1,3)*dgm(2,3)-6*gm(1,2)*dgm(3,3))
   cm(3,5,15)=-1.5d0*gm(3,3)**2*dgm(1,1)+4.5d0*gm(1,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(1,3)*dgm(1,3)-3*gm(1,1)*dgm(3,3))
   cm(3,6,15)=7.5d0*gm(1,3)**2*dgm(2,3)+gm(3,3)*(-3*gm(1,2)*dgm(1,3)&
&   -1.5d0*gm(1,1)*dgm(2,3))+gm(2,3)*(-1.5d0*gm(3,3)*dgm(1,1)+15*gm(1,3)&
&   *dgm(1,3)-1.5d0*gm(1,1)*dgm(3,3))-3*gm(1,3)*(gm(3,3)*dgm(1,2)&
&   +gm(1,2)*dgm(3,3))
   cm(3,7,15)=7.5d0*gm(2,3)**2*dgm(2,3)-1.5d0*gm(2,2)*gm(3,3)*dgm(2,3)&
&   -1.5d0*gm(2,3)*(gm(3,3)*dgm(2,2)+gm(2,2)*dgm(3,3))
   cm(3,8,15)=gm(3,3)*(3*gm(3,3)*dgm(2,3)+6*gm(2,3)*dgm(3,3))
   cm(3,9,15)=-1.5d0*gm(3,3)**2*dgm(2,2)+4.5d0*gm(2,3)**2*dgm(3,3)&
&   +gm(3,3)*(9*gm(2,3)*dgm(2,3)-3*gm(2,2)*dgm(3,3))
   cm(3,10,15)=3*gm(3,3)**2*dgm(3,3)
 end if
!
!Section for volume derivative term for diagonal strains.  This is
!equivalent to calculating the reduced gradients but it is easier
!to embed it here as a separate calculation than cope with the logic
!and ffkg index rearrangements necessary to do a separate force
!calculation.
!
 if(istr<=3) then
   if(rank==0)then
     cm(1,1,1)=cm(1,1,1)-(1)
     cm(2,1,2)=cm(2,1,2)-(1)
     cm(3,1,3)=cm(3,1,3)-(1)
   elseif(rank==1)then
     cm(1,1,1)=cm(1,1,1)-(gm(1,1))
     cm(1,2,1)=cm(1,2,1)-(gm(1,2))
     cm(1,3,1)=cm(1,3,1)-(gm(1,3))
     cm(1,1,5)=cm(1,1,5)-(gm(1,3))
     cm(1,2,5)=cm(1,2,5)-(gm(2,3))
     cm(1,3,5)=cm(1,3,5)-(gm(3,3))
     cm(1,1,6)=cm(1,1,6)-(gm(1,2))
     cm(1,2,6)=cm(1,2,6)-(gm(2,2))
     cm(1,3,6)=cm(1,3,6)-(gm(2,3))
     cm(2,1,2)=cm(2,1,2)-(gm(1,2))
     cm(2,2,2)=cm(2,2,2)-(gm(2,2))
     cm(2,3,2)=cm(2,3,2)-(gm(2,3))
     cm(2,1,4)=cm(2,1,4)-(gm(1,3))
     cm(2,2,4)=cm(2,2,4)-(gm(2,3))
     cm(2,3,4)=cm(2,3,4)-(gm(3,3))
     cm(2,1,6)=cm(2,1,6)-(gm(1,1))
     cm(2,2,6)=cm(2,2,6)-(gm(1,2))
     cm(2,3,6)=cm(2,3,6)-(gm(1,3))
     cm(3,1,3)=cm(3,1,3)-(gm(1,3))
     cm(3,2,3)=cm(3,2,3)-(gm(2,3))
     cm(3,3,3)=cm(3,3,3)-(gm(3,3))
     cm(3,1,4)=cm(3,1,4)-(gm(1,2))
     cm(3,2,4)=cm(3,2,4)-(gm(2,2))
     cm(3,3,4)=cm(3,3,4)-(gm(2,3))
     cm(3,1,5)=cm(3,1,5)-(gm(1,1))
     cm(3,2,5)=cm(3,2,5)-(gm(1,2))
     cm(3,3,5)=cm(3,3,5)-(gm(1,3))
   elseif(rank==2)then
     cm(1,1,1)=cm(1,1,1)-(gm(1,1)**2)
     cm(1,2,1)=cm(1,2,1)-(1.5d0*gm(1,2)**2-0.5d0*gm(1,1)*gm(2,2))
     cm(1,3,1)=cm(1,3,1)-(1.5d0*gm(1,3)**2-0.5d0*gm(1,1)*gm(3,3))
     cm(1,4,1)=cm(1,4,1)-(3*gm(1,2)*gm(1,3)-gm(1,1)*gm(2,3))
     cm(1,5,1)=cm(1,5,1)-(2*gm(1,1)*gm(1,3))
     cm(1,6,1)=cm(1,6,1)-(2*gm(1,1)*gm(1,2))
     cm(1,1,2)=cm(1,1,2)-(1.5d0*gm(1,2)**2-0.5d0*gm(1,1)*gm(2,2))
     cm(1,2,2)=cm(1,2,2)-(gm(2,2)**2)
     cm(1,3,2)=cm(1,3,2)-(1.5d0*gm(2,3)**2-0.5d0*gm(2,2)*gm(3,3))
     cm(1,4,2)=cm(1,4,2)-(2*gm(2,2)*gm(2,3))
     cm(1,5,2)=cm(1,5,2)-(-gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3))
     cm(1,6,2)=cm(1,6,2)-(2*gm(1,2)*gm(2,2))
     cm(1,1,3)=cm(1,1,3)-(1.5d0*gm(1,3)**2-0.5d0*gm(1,1)*gm(3,3))
     cm(1,2,3)=cm(1,2,3)-(1.5d0*gm(2,3)**2-0.5d0*gm(2,2)*gm(3,3))
     cm(1,3,3)=cm(1,3,3)-(gm(3,3)**2)
     cm(1,4,3)=cm(1,4,3)-(2*gm(2,3)*gm(3,3))
     cm(1,5,3)=cm(1,5,3)-(2*gm(1,3)*gm(3,3))
     cm(1,6,3)=cm(1,6,3)-(3*gm(1,3)*gm(2,3)-gm(1,2)*gm(3,3))
     cm(1,1,4)=cm(1,1,4)-(3*gm(1,2)*gm(1,3)-gm(1,1)*gm(2,3))
     cm(1,2,4)=cm(1,2,4)-(2*gm(2,2)*gm(2,3))
     cm(1,3,4)=cm(1,3,4)-(2*gm(2,3)*gm(3,3))
     cm(1,4,4)=cm(1,4,4)-(gm(2,3)**2+3*gm(2,2)*gm(3,3))
     cm(1,5,4)=cm(1,5,4)-(gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))
     cm(1,6,4)=cm(1,6,4)-(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))
     cm(1,1,5)=cm(1,1,5)-(2*gm(1,1)*gm(1,3))
     cm(1,2,5)=cm(1,2,5)-(-gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3))
     cm(1,3,5)=cm(1,3,5)-(2*gm(1,3)*gm(3,3))
     cm(1,4,5)=cm(1,4,5)-(gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))
     cm(1,5,5)=cm(1,5,5)-(gm(1,3)**2+3*gm(1,1)*gm(3,3))
     cm(1,6,5)=cm(1,6,5)-(gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))
     cm(1,1,6)=cm(1,1,6)-(2*gm(1,1)*gm(1,2))
     cm(1,2,6)=cm(1,2,6)-(2*gm(1,2)*gm(2,2))
     cm(1,3,6)=cm(1,3,6)-(3*gm(1,3)*gm(2,3)-gm(1,2)*gm(3,3))
     cm(1,4,6)=cm(1,4,6)-(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))
     cm(1,5,6)=cm(1,5,6)-(gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))
     cm(1,6,6)=cm(1,6,6)-(gm(1,2)**2+3*gm(1,1)*gm(2,2))
     cm(2,1,2)=cm(2,1,2)-(2*gm(1,1)*gm(1,2))
     cm(2,2,2)=cm(2,2,2)-(2*gm(1,2)*gm(2,2))
     cm(2,3,2)=cm(2,3,2)-(3*gm(1,3)*gm(2,3)-gm(1,2)*gm(3,3))
     cm(2,4,2)=cm(2,4,2)-(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))
     cm(2,5,2)=cm(2,5,2)-(gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))
     cm(2,6,2)=cm(2,6,2)-(gm(1,2)**2+3*gm(1,1)*gm(2,2))
     cm(2,1,4)=cm(2,1,4)-(2*gm(1,1)*gm(1,3))
     cm(2,2,4)=cm(2,2,4)-(-gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3))
     cm(2,3,4)=cm(2,3,4)-(2*gm(1,3)*gm(3,3))
     cm(2,4,4)=cm(2,4,4)-(gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))
     cm(2,5,4)=cm(2,5,4)-(gm(1,3)**2+3*gm(1,1)*gm(3,3))
     cm(2,6,4)=cm(2,6,4)-(gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))
     cm(2,1,6)=cm(2,1,6)-(gm(1,1)**2)
     cm(2,2,6)=cm(2,2,6)-(1.5d0*gm(1,2)**2-0.5d0*gm(1,1)*gm(2,2))
     cm(2,3,6)=cm(2,3,6)-(1.5d0*gm(1,3)**2-0.5d0*gm(1,1)*gm(3,3))
     cm(2,4,6)=cm(2,4,6)-(3*gm(1,2)*gm(1,3)-gm(1,1)*gm(2,3))
     cm(2,5,6)=cm(2,5,6)-(2*gm(1,1)*gm(1,3))
     cm(2,6,6)=cm(2,6,6)-(2*gm(1,1)*gm(1,2))
     cm(2,1,7)=cm(2,1,7)-(1.5d0*gm(1,2)**2-0.5d0*gm(1,1)*gm(2,2))
     cm(2,2,7)=cm(2,2,7)-(gm(2,2)**2)
     cm(2,3,7)=cm(2,3,7)-(1.5d0*gm(2,3)**2-0.5d0*gm(2,2)*gm(3,3))
     cm(2,4,7)=cm(2,4,7)-(2*gm(2,2)*gm(2,3))
     cm(2,5,7)=cm(2,5,7)-(-gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3))
     cm(2,6,7)=cm(2,6,7)-(2*gm(1,2)*gm(2,2))
     cm(2,1,8)=cm(2,1,8)-(1.5d0*gm(1,3)**2-0.5d0*gm(1,1)*gm(3,3))
     cm(2,2,8)=cm(2,2,8)-(1.5d0*gm(2,3)**2-0.5d0*gm(2,2)*gm(3,3))
     cm(2,3,8)=cm(2,3,8)-(gm(3,3)**2)
     cm(2,4,8)=cm(2,4,8)-(2*gm(2,3)*gm(3,3))
     cm(2,5,8)=cm(2,5,8)-(2*gm(1,3)*gm(3,3))
     cm(2,6,8)=cm(2,6,8)-(3*gm(1,3)*gm(2,3)-gm(1,2)*gm(3,3))
     cm(2,1,9)=cm(2,1,9)-(3*gm(1,2)*gm(1,3)-gm(1,1)*gm(2,3))
     cm(2,2,9)=cm(2,2,9)-(2*gm(2,2)*gm(2,3))
     cm(2,3,9)=cm(2,3,9)-(2*gm(2,3)*gm(3,3))
     cm(2,4,9)=cm(2,4,9)-(gm(2,3)**2+3*gm(2,2)*gm(3,3))
     cm(2,5,9)=cm(2,5,9)-(gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))
     cm(2,6,9)=cm(2,6,9)-(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))
     cm(3,1,3)=cm(3,1,3)-(2*gm(1,1)*gm(1,3))
     cm(3,2,3)=cm(3,2,3)-(-gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3))
     cm(3,3,3)=cm(3,3,3)-(2*gm(1,3)*gm(3,3))
     cm(3,4,3)=cm(3,4,3)-(gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))
     cm(3,5,3)=cm(3,5,3)-(gm(1,3)**2+3*gm(1,1)*gm(3,3))
     cm(3,6,3)=cm(3,6,3)-(gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))
     cm(3,1,4)=cm(3,1,4)-(2*gm(1,1)*gm(1,2))
     cm(3,2,4)=cm(3,2,4)-(2*gm(1,2)*gm(2,2))
     cm(3,3,4)=cm(3,3,4)-(3*gm(1,3)*gm(2,3)-gm(1,2)*gm(3,3))
     cm(3,4,4)=cm(3,4,4)-(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))
     cm(3,5,4)=cm(3,5,4)-(gm(1,2)*gm(1,3)+3*gm(1,1)*gm(2,3))
     cm(3,6,4)=cm(3,6,4)-(gm(1,2)**2+3*gm(1,1)*gm(2,2))
     cm(3,1,5)=cm(3,1,5)-(gm(1,1)**2)
     cm(3,2,5)=cm(3,2,5)-(1.5d0*gm(1,2)**2-0.5d0*gm(1,1)*gm(2,2))
     cm(3,3,5)=cm(3,3,5)-(1.5d0*gm(1,3)**2-0.5d0*gm(1,1)*gm(3,3))
     cm(3,4,5)=cm(3,4,5)-(3*gm(1,2)*gm(1,3)-gm(1,1)*gm(2,3))
     cm(3,5,5)=cm(3,5,5)-(2*gm(1,1)*gm(1,3))
     cm(3,6,5)=cm(3,6,5)-(2*gm(1,1)*gm(1,2))
     cm(3,1,8)=cm(3,1,8)-(3*gm(1,2)*gm(1,3)-gm(1,1)*gm(2,3))
     cm(3,2,8)=cm(3,2,8)-(2*gm(2,2)*gm(2,3))
     cm(3,3,8)=cm(3,3,8)-(2*gm(2,3)*gm(3,3))
     cm(3,4,8)=cm(3,4,8)-(gm(2,3)**2+3*gm(2,2)*gm(3,3))
     cm(3,5,8)=cm(3,5,8)-(gm(1,3)*gm(2,3)+3*gm(1,2)*gm(3,3))
     cm(3,6,8)=cm(3,6,8)-(3*gm(1,3)*gm(2,2)+gm(1,2)*gm(2,3))
     cm(3,1,9)=cm(3,1,9)-(1.5d0*gm(1,2)**2-0.5d0*gm(1,1)*gm(2,2))
     cm(3,2,9)=cm(3,2,9)-(gm(2,2)**2)
     cm(3,3,9)=cm(3,3,9)-(1.5d0*gm(2,3)**2-0.5d0*gm(2,2)*gm(3,3))
     cm(3,4,9)=cm(3,4,9)-(2*gm(2,2)*gm(2,3))
     cm(3,5,9)=cm(3,5,9)-(-gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3))
     cm(3,6,9)=cm(3,6,9)-(2*gm(1,2)*gm(2,2))
     cm(3,1,10)=cm(3,1,10)-(1.5d0*gm(1,3)**2-0.5d0*gm(1,1)*gm(3,3))
     cm(3,2,10)=cm(3,2,10)-(1.5d0*gm(2,3)**2-0.5d0*gm(2,2)*gm(3,3))
     cm(3,3,10)=cm(3,3,10)-(gm(3,3)**2)
     cm(3,4,10)=cm(3,4,10)-(2*gm(2,3)*gm(3,3))
     cm(3,5,10)=cm(3,5,10)-(2*gm(1,3)*gm(3,3))
     cm(3,6,10)=cm(3,6,10)-(3*gm(1,3)*gm(2,3)-gm(1,2)*gm(3,3))
   elseif(rank==3)then
     cm(1,1,1)=cm(1,1,1)-(gm(1,1)**3)
     cm(1,2,1)=cm(1,2,1)-(gm(1,1)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(1,3,1)=cm(1,3,1)-(gm(1,1)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)*gm(3,3)))
     cm(1,4,1)=cm(1,4,1)-(gm(1,1)*(9*gm(1,2)*gm(1,3)-3*gm(1,1)*gm(2,3)))
     cm(1,5,1)=cm(1,5,1)-(3*gm(1,1)**2*gm(1,3))
     cm(1,6,1)=cm(1,6,1)-(3*gm(1,1)**2*gm(1,2))
     cm(1,7,1)=cm(1,7,1)-(2.5d0*gm(1,2)**3-1.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(1,8,1)=cm(1,8,1)-(-3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(7.5d0*gm(1,3)&
&     **2-1.5d0*gm(1,1)*gm(3,3)))
     cm(1,9,1)=cm(1,9,1)-(7.5d0*gm(1,2)**2*gm(1,3)-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)-3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(1,10,1)=cm(1,10,1)-(2.5d0*gm(1,3)**3-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(3,3))
     cm(1,1,2)=cm(1,1,2)-(gm(1,1)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(1,2,2)=cm(1,2,2)-(gm(2,2)*(3*gm(1,2)**2+6*gm(1,1)*gm(2,2)))
     cm(1,3,2)=cm(1,3,2)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)*gm(2,3)&
&     -3*gm(1,2)**2*gm(3,3)+gm(1,1)*(7.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(1,4,2)=cm(1,4,2)-(3*gm(1,2)*gm(1,3)*gm(2,2)+3*gm(1,2)**2*gm(2,3)&
&     +12*gm(1,1)*gm(2,2)*gm(2,3))
     cm(1,5,2)=cm(1,5,2)-(1.5d0*gm(1,2)**2*gm(1,3)-4.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)+12*gm(1,1)*gm(1,2)*gm(2,3))
     cm(1,6,2)=cm(1,6,2)-(1.5d0*gm(1,2)**3+7.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(1,7,2)=cm(1,7,2)-(3*gm(1,2)*gm(2,2)**2)
     cm(1,8,2)=cm(1,8,2)-(12*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(1,9,2)=cm(1,9,2)-(gm(2,2)*(6*gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3)))
     cm(1,10,2)=cm(1,10,2)-(-3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(1,1,3)=cm(1,1,3)-(gm(1,1)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)*gm(3,3)))
     cm(1,2,3)=cm(1,2,3)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)*gm(2,3)&
&     -3*gm(1,2)**2*gm(3,3)+gm(1,1)*(7.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(1,3,3)=cm(1,3,3)-(gm(3,3)*(3*gm(1,3)**2+6*gm(1,1)*gm(3,3)))
     cm(1,4,3)=cm(1,4,3)-(3*gm(1,3)**2*gm(2,3)+3*gm(1,2)*gm(1,3)*gm(3,3)&
&     +12*gm(1,1)*gm(2,3)*gm(3,3))
     cm(1,5,3)=cm(1,5,3)-(1.5d0*gm(1,3)**3+7.5d0*gm(1,1)*gm(1,3)*gm(3,3))
     cm(1,6,3)=cm(1,6,3)-(12*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(1.5d0*gm(1,3)&
&     **2-4.5d0*gm(1,1)*gm(3,3)))
     cm(1,7,3)=cm(1,7,3)-(-3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(1,8,3)=cm(1,8,3)-(gm(3,3)*(3*gm(1,3)*gm(2,3)+6*gm(1,2)*gm(3,3)))
     cm(1,9,3)=cm(1,9,3)-(12*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(1,10,3)=cm(1,10,3)-(3*gm(1,3)*gm(3,3)**2)
     cm(1,1,4)=cm(1,1,4)-(gm(1,1)*(9*gm(1,2)*gm(1,3)-3*gm(1,1)*gm(2,3)))
     cm(1,2,4)=cm(1,2,4)-(3*gm(1,2)*gm(1,3)*gm(2,2)+3*gm(1,2)**2*gm(2,3)&
&     +12*gm(1,1)*gm(2,2)*gm(2,3))
     cm(1,3,4)=cm(1,3,4)-(3*gm(1,3)**2*gm(2,3)+3*gm(1,2)*gm(1,3)*gm(3,3)&
&     +12*gm(1,1)*gm(2,3)*gm(3,3))
     cm(1,4,4)=cm(1,4,4)-(9*gm(1,3)**2*gm(2,2)-6*gm(1,2)*gm(1,3)*gm(2,3)&
&     +9*gm(1,2)**2*gm(3,3)+gm(1,1)*(9*gm(2,3)**2+15*gm(2,2)*gm(3,3)))
     cm(1,5,4)=cm(1,5,4)-(3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(3*gm(1,3)&
&     **2+12*gm(1,1)*gm(3,3)))
     cm(1,6,4)=cm(1,6,4)-(3*gm(1,2)**2*gm(1,3)+12*gm(1,1)*gm(1,3)*gm(2,2)&
&     +3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(1,7,4)=cm(1,7,4)-(gm(2,2)*(-3*gm(1,3)*gm(2,2)+9*gm(1,2)*gm(2,3)))
     cm(1,8,4)=cm(1,8,4)-(3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(1,9,4)=cm(1,9,4)-(3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(1,10,4)=cm(1,10,4)-(gm(3,3)*(9*gm(1,3)*gm(2,3)-3*gm(1,2)*gm(3,3)))
     cm(1,1,5)=cm(1,1,5)-(3*gm(1,1)**2*gm(1,3))
     cm(1,2,5)=cm(1,2,5)-(1.5d0*gm(1,2)**2*gm(1,3)-4.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)+12*gm(1,1)*gm(1,2)*gm(2,3))
     cm(1,3,5)=cm(1,3,5)-(1.5d0*gm(1,3)**3+7.5d0*gm(1,1)*gm(1,3)*gm(3,3))
     cm(1,4,5)=cm(1,4,5)-(3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(3*gm(1,3)&
&     **2+12*gm(1,1)*gm(3,3)))
     cm(1,5,5)=cm(1,5,5)-(gm(1,1)*(3*gm(1,3)**2+6*gm(1,1)*gm(3,3)))
     cm(1,6,5)=cm(1,6,5)-(gm(1,1)*(3*gm(1,2)*gm(1,3)+6*gm(1,1)*gm(2,3)))
     cm(1,7,5)=cm(1,7,5)-(-3*gm(1,2)*gm(1,3)*gm(2,2)+7.5d0*gm(1,2)&
&     **2*gm(2,3)-1.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(1,8,5)=cm(1,8,5)-(1.5d0*gm(1,3)**2*gm(2,3)+12*gm(1,2)*gm(1,3)&
&     *gm(3,3)-4.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(1,9,5)=cm(1,9,5)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)*gm(2,3)&
&     +7.5d0*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(1,10,5)=cm(1,10,5)-(gm(3,3)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)&
&     *gm(3,3)))
     cm(1,1,6)=cm(1,1,6)-(3*gm(1,1)**2*gm(1,2))
     cm(1,2,6)=cm(1,2,6)-(1.5d0*gm(1,2)**3+7.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(1,3,6)=cm(1,3,6)-(12*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(1.5d0*gm(1,3)&
&     **2-4.5d0*gm(1,1)*gm(3,3)))
     cm(1,4,6)=cm(1,4,6)-(3*gm(1,2)**2*gm(1,3)+12*gm(1,1)*gm(1,3)*gm(2,2)&
&     +3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(1,5,6)=cm(1,5,6)-(gm(1,1)*(3*gm(1,2)*gm(1,3)+6*gm(1,1)*gm(2,3)))
     cm(1,6,6)=cm(1,6,6)-(gm(1,1)*(3*gm(1,2)**2+6*gm(1,1)*gm(2,2)))
     cm(1,7,6)=cm(1,7,6)-(gm(2,2)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(1,8,6)=cm(1,8,6)-(7.5d0*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)&
&     *gm(2,3)-3*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(1,9,6)=cm(1,9,6)-(12*gm(1,2)*gm(1,3)*gm(2,2)+1.5d0*gm(1,2)&
&     **2*gm(2,3)-4.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(1,10,6)=cm(1,10,6)-(7.5d0*gm(1,3)**2*gm(2,3)-3*gm(1,2)*gm(1,3)&
&     *gm(3,3)-1.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(1,1,7)=cm(1,1,7)-(2.5d0*gm(1,2)**3-1.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(1,2,7)=cm(1,2,7)-(3*gm(1,2)*gm(2,2)**2)
     cm(1,3,7)=cm(1,3,7)-(-3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(1,4,7)=cm(1,4,7)-(gm(2,2)*(-3*gm(1,3)*gm(2,2)+9*gm(1,2)*gm(2,3)))
     cm(1,5,7)=cm(1,5,7)-(-3*gm(1,2)*gm(1,3)*gm(2,2)+7.5d0*gm(1,2)&
&     **2*gm(2,3)-1.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(1,6,7)=cm(1,6,7)-(gm(2,2)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(1,7,7)=cm(1,7,7)-(gm(2,2)**3)
     cm(1,8,7)=cm(1,8,7)-(gm(2,2)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)*gm(3,3)))
     cm(1,9,7)=cm(1,9,7)-(3*gm(2,2)**2*gm(2,3))
     cm(1,10,7)=cm(1,10,7)-(2.5d0*gm(2,3)**3-1.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(1,1,8)=cm(1,1,8)-(-3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(7.5d0*gm(1,3)&
&     **2-1.5d0*gm(1,1)*gm(3,3)))
     cm(1,2,8)=cm(1,2,8)-(12*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(1,3,8)=cm(1,3,8)-(gm(3,3)*(3*gm(1,3)*gm(2,3)+6*gm(1,2)*gm(3,3)))
     cm(1,4,8)=cm(1,4,8)-(3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(1,5,8)=cm(1,5,8)-(1.5d0*gm(1,3)**2*gm(2,3)+12*gm(1,2)*gm(1,3)&
&     *gm(3,3)-4.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(1,6,8)=cm(1,6,8)-(7.5d0*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)&
&     *gm(2,3)-3*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(1,7,8)=cm(1,7,8)-(gm(2,2)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)*gm(3,3)))
     cm(1,8,8)=cm(1,8,8)-(gm(3,3)*(3*gm(2,3)**2+6*gm(2,2)*gm(3,3)))
     cm(1,9,8)=cm(1,9,8)-(1.5d0*gm(2,3)**3+7.5d0*gm(2,2)*gm(2,3)*gm(3,3))
     cm(1,10,8)=cm(1,10,8)-(3*gm(2,3)*gm(3,3)**2)
     cm(1,1,9)=cm(1,1,9)-(7.5d0*gm(1,2)**2*gm(1,3)-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)-3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(1,2,9)=cm(1,2,9)-(gm(2,2)*(6*gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3)))
     cm(1,3,9)=cm(1,3,9)-(12*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(1,4,9)=cm(1,4,9)-(3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(1,5,9)=cm(1,5,9)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)*gm(2,3)&
&     +7.5d0*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(1,6,9)=cm(1,6,9)-(12*gm(1,2)*gm(1,3)*gm(2,2)+1.5d0*gm(1,2)&
&     **2*gm(2,3)-4.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(1,7,9)=cm(1,7,9)-(3*gm(2,2)**2*gm(2,3))
     cm(1,8,9)=cm(1,8,9)-(1.5d0*gm(2,3)**3+7.5d0*gm(2,2)*gm(2,3)*gm(3,3))
     cm(1,9,9)=cm(1,9,9)-(gm(2,2)*(3*gm(2,3)**2+6*gm(2,2)*gm(3,3)))
     cm(1,10,9)=cm(1,10,9)-(gm(3,3)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(1,1,10)=cm(1,1,10)-(2.5d0*gm(1,3)**3-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(3,3))
     cm(1,2,10)=cm(1,2,10)-(-3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(1,3,10)=cm(1,3,10)-(3*gm(1,3)*gm(3,3)**2)
     cm(1,4,10)=cm(1,4,10)-(gm(3,3)*(9*gm(1,3)*gm(2,3)-3*gm(1,2)*gm(3,3)))
     cm(1,5,10)=cm(1,5,10)-(gm(3,3)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)&
&     *gm(3,3)))
     cm(1,6,10)=cm(1,6,10)-(7.5d0*gm(1,3)**2*gm(2,3)-3*gm(1,2)*gm(1,3)&
&     *gm(3,3)-1.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(1,7,10)=cm(1,7,10)-(2.5d0*gm(2,3)**3-1.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(1,8,10)=cm(1,8,10)-(3*gm(2,3)*gm(3,3)**2)
     cm(1,9,10)=cm(1,9,10)-(gm(3,3)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(1,10,10)=cm(1,10,10)-(gm(3,3)**3)
     cm(2,1,2)=cm(2,1,2)-(3*gm(1,1)**2*gm(1,2))
     cm(2,2,2)=cm(2,2,2)-(1.5d0*gm(1,2)**3+7.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(2,3,2)=cm(2,3,2)-(12*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(1.5d0*gm(1,3)&
&     **2-4.5d0*gm(1,1)*gm(3,3)))
     cm(2,4,2)=cm(2,4,2)-(3*gm(1,2)**2*gm(1,3)+12*gm(1,1)*gm(1,3)*gm(2,2)&
&     +3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(2,5,2)=cm(2,5,2)-(gm(1,1)*(3*gm(1,2)*gm(1,3)+6*gm(1,1)*gm(2,3)))
     cm(2,6,2)=cm(2,6,2)-(gm(1,1)*(3*gm(1,2)**2+6*gm(1,1)*gm(2,2)))
     cm(2,7,2)=cm(2,7,2)-(gm(2,2)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(2,8,2)=cm(2,8,2)-(7.5d0*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)&
&     *gm(2,3)-3*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,9,2)=cm(2,9,2)-(12*gm(1,2)*gm(1,3)*gm(2,2)+1.5d0*gm(1,2)&
&     **2*gm(2,3)-4.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(2,10,2)=cm(2,10,2)-(7.5d0*gm(1,3)**2*gm(2,3)-3*gm(1,2)*gm(1,3)&
&     *gm(3,3)-1.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(2,1,4)=cm(2,1,4)-(3*gm(1,1)**2*gm(1,3))
     cm(2,2,4)=cm(2,2,4)-(1.5d0*gm(1,2)**2*gm(1,3)-4.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)+12*gm(1,1)*gm(1,2)*gm(2,3))
     cm(2,3,4)=cm(2,3,4)-(1.5d0*gm(1,3)**3+7.5d0*gm(1,1)*gm(1,3)*gm(3,3))
     cm(2,4,4)=cm(2,4,4)-(3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(3*gm(1,3)&
&     **2+12*gm(1,1)*gm(3,3)))
     cm(2,5,4)=cm(2,5,4)-(gm(1,1)*(3*gm(1,3)**2+6*gm(1,1)*gm(3,3)))
     cm(2,6,4)=cm(2,6,4)-(gm(1,1)*(3*gm(1,2)*gm(1,3)+6*gm(1,1)*gm(2,3)))
     cm(2,7,4)=cm(2,7,4)-(-3*gm(1,2)*gm(1,3)*gm(2,2)+7.5d0*gm(1,2)&
&     **2*gm(2,3)-1.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(2,8,4)=cm(2,8,4)-(1.5d0*gm(1,3)**2*gm(2,3)+12*gm(1,2)*gm(1,3)&
&     *gm(3,3)-4.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(2,9,4)=cm(2,9,4)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)*gm(2,3)&
&     +7.5d0*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,10,4)=cm(2,10,4)-(gm(3,3)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)&
&     *gm(3,3)))
     cm(2,1,6)=cm(2,1,6)-(gm(1,1)**3)
     cm(2,2,6)=cm(2,2,6)-(gm(1,1)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(2,3,6)=cm(2,3,6)-(gm(1,1)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)*gm(3,3)))
     cm(2,4,6)=cm(2,4,6)-(gm(1,1)*(9*gm(1,2)*gm(1,3)-3*gm(1,1)*gm(2,3)))
     cm(2,5,6)=cm(2,5,6)-(3*gm(1,1)**2*gm(1,3))
     cm(2,6,6)=cm(2,6,6)-(3*gm(1,1)**2*gm(1,2))
     cm(2,7,6)=cm(2,7,6)-(2.5d0*gm(1,2)**3-1.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(2,8,6)=cm(2,8,6)-(-3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(7.5d0*gm(1,3)&
&     **2-1.5d0*gm(1,1)*gm(3,3)))
     cm(2,9,6)=cm(2,9,6)-(7.5d0*gm(1,2)**2*gm(1,3)-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)-3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(2,10,6)=cm(2,10,6)-(2.5d0*gm(1,3)**3-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(3,3))
     cm(2,1,7)=cm(2,1,7)-(gm(1,1)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(2,2,7)=cm(2,2,7)-(gm(2,2)*(3*gm(1,2)**2+6*gm(1,1)*gm(2,2)))
     cm(2,3,7)=cm(2,3,7)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)*gm(2,3)&
&     -3*gm(1,2)**2*gm(3,3)+gm(1,1)*(7.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,4,7)=cm(2,4,7)-(3*gm(1,2)*gm(1,3)*gm(2,2)+3*gm(1,2)**2*gm(2,3)&
&     +12*gm(1,1)*gm(2,2)*gm(2,3))
     cm(2,5,7)=cm(2,5,7)-(1.5d0*gm(1,2)**2*gm(1,3)-4.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)+12*gm(1,1)*gm(1,2)*gm(2,3))
     cm(2,6,7)=cm(2,6,7)-(1.5d0*gm(1,2)**3+7.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(2,7,7)=cm(2,7,7)-(3*gm(1,2)*gm(2,2)**2)
     cm(2,8,7)=cm(2,8,7)-(12*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(2,9,7)=cm(2,9,7)-(gm(2,2)*(6*gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3)))
     cm(2,10,7)=cm(2,10,7)-(-3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(2,1,8)=cm(2,1,8)-(gm(1,1)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)*gm(3,3)))
     cm(2,2,8)=cm(2,2,8)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)*gm(2,3)&
&     -3*gm(1,2)**2*gm(3,3)+gm(1,1)*(7.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,3,8)=cm(2,3,8)-(gm(3,3)*(3*gm(1,3)**2+6*gm(1,1)*gm(3,3)))
     cm(2,4,8)=cm(2,4,8)-(3*gm(1,3)**2*gm(2,3)+3*gm(1,2)*gm(1,3)*gm(3,3)&
&     +12*gm(1,1)*gm(2,3)*gm(3,3))
     cm(2,5,8)=cm(2,5,8)-(1.5d0*gm(1,3)**3+7.5d0*gm(1,1)*gm(1,3)*gm(3,3))
     cm(2,6,8)=cm(2,6,8)-(12*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(1.5d0*gm(1,3)&
&     **2-4.5d0*gm(1,1)*gm(3,3)))
     cm(2,7,8)=cm(2,7,8)-(-3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(2,8,8)=cm(2,8,8)-(gm(3,3)*(3*gm(1,3)*gm(2,3)+6*gm(1,2)*gm(3,3)))
     cm(2,9,8)=cm(2,9,8)-(12*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(2,10,8)=cm(2,10,8)-(3*gm(1,3)*gm(3,3)**2)
     cm(2,1,9)=cm(2,1,9)-(gm(1,1)*(9*gm(1,2)*gm(1,3)-3*gm(1,1)*gm(2,3)))
     cm(2,2,9)=cm(2,2,9)-(3*gm(1,2)*gm(1,3)*gm(2,2)+3*gm(1,2)**2*gm(2,3)&
&     +12*gm(1,1)*gm(2,2)*gm(2,3))
     cm(2,3,9)=cm(2,3,9)-(3*gm(1,3)**2*gm(2,3)+3*gm(1,2)*gm(1,3)*gm(3,3)&
&     +12*gm(1,1)*gm(2,3)*gm(3,3))
     cm(2,4,9)=cm(2,4,9)-(9*gm(1,3)**2*gm(2,2)-6*gm(1,2)*gm(1,3)*gm(2,3)&
&     +9*gm(1,2)**2*gm(3,3)+gm(1,1)*(9*gm(2,3)**2+15*gm(2,2)*gm(3,3)))
     cm(2,5,9)=cm(2,5,9)-(3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(3*gm(1,3)&
&     **2+12*gm(1,1)*gm(3,3)))
     cm(2,6,9)=cm(2,6,9)-(3*gm(1,2)**2*gm(1,3)+12*gm(1,1)*gm(1,3)*gm(2,2)&
&     +3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(2,7,9)=cm(2,7,9)-(gm(2,2)*(-3*gm(1,3)*gm(2,2)+9*gm(1,2)*gm(2,3)))
     cm(2,8,9)=cm(2,8,9)-(3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(2,9,9)=cm(2,9,9)-(3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(2,10,9)=cm(2,10,9)-(gm(3,3)*(9*gm(1,3)*gm(2,3)-3*gm(1,2)*gm(3,3)))
     cm(2,1,11)=cm(2,1,11)-(2.5d0*gm(1,2)**3-1.5d0*gm(1,1)*gm(1,2)&
&     *gm(2,2))
     cm(2,2,11)=cm(2,2,11)-(3*gm(1,2)*gm(2,2)**2)
     cm(2,3,11)=cm(2,3,11)-(-3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(2,4,11)=cm(2,4,11)-(gm(2,2)*(-3*gm(1,3)*gm(2,2)+9*gm(1,2)*gm(2,3)))
     cm(2,5,11)=cm(2,5,11)-(-3*gm(1,2)*gm(1,3)*gm(2,2)+7.5d0*gm(1,2)&
&     **2*gm(2,3)-1.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(2,6,11)=cm(2,6,11)-(gm(2,2)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)&
&     *gm(2,2)))
     cm(2,7,11)=cm(2,7,11)-(gm(2,2)**3)
     cm(2,8,11)=cm(2,8,11)-(gm(2,2)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,9,11)=cm(2,9,11)-(3*gm(2,2)**2*gm(2,3))
     cm(2,10,11)=cm(2,10,11)-(2.5d0*gm(2,3)**3-1.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(2,1,12)=cm(2,1,12)-(-3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(7.5d0*gm(1,3)&
&     **2-1.5d0*gm(1,1)*gm(3,3)))
     cm(2,2,12)=cm(2,2,12)-(12*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(2,3,12)=cm(2,3,12)-(gm(3,3)*(3*gm(1,3)*gm(2,3)+6*gm(1,2)*gm(3,3)))
     cm(2,4,12)=cm(2,4,12)-(3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(2,5,12)=cm(2,5,12)-(1.5d0*gm(1,3)**2*gm(2,3)+12*gm(1,2)*gm(1,3)&
&     *gm(3,3)-4.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(2,6,12)=cm(2,6,12)-(7.5d0*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)&
&     *gm(2,3)-3*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,7,12)=cm(2,7,12)-(gm(2,2)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,8,12)=cm(2,8,12)-(gm(3,3)*(3*gm(2,3)**2+6*gm(2,2)*gm(3,3)))
     cm(2,9,12)=cm(2,9,12)-(1.5d0*gm(2,3)**3+7.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(2,10,12)=cm(2,10,12)-(3*gm(2,3)*gm(3,3)**2)
     cm(2,1,13)=cm(2,1,13)-(7.5d0*gm(1,2)**2*gm(1,3)-1.5d0*gm(1,1)&
&     *gm(1,3)*gm(2,2)-3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(2,2,13)=cm(2,2,13)-(gm(2,2)*(6*gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3)))
     cm(2,3,13)=cm(2,3,13)-(12*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(2,4,13)=cm(2,4,13)-(3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(2,5,13)=cm(2,5,13)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)&
&     *gm(2,3)+7.5d0*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,6,13)=cm(2,6,13)-(12*gm(1,2)*gm(1,3)*gm(2,2)+1.5d0*gm(1,2)&
&     **2*gm(2,3)-4.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(2,7,13)=cm(2,7,13)-(3*gm(2,2)**2*gm(2,3))
     cm(2,8,13)=cm(2,8,13)-(1.5d0*gm(2,3)**3+7.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(2,9,13)=cm(2,9,13)-(gm(2,2)*(3*gm(2,3)**2+6*gm(2,2)*gm(3,3)))
     cm(2,10,13)=cm(2,10,13)-(gm(3,3)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,1,14)=cm(2,1,14)-(2.5d0*gm(1,3)**3-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(3,3))
     cm(2,2,14)=cm(2,2,14)-(-3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(2,3,14)=cm(2,3,14)-(3*gm(1,3)*gm(3,3)**2)
     cm(2,4,14)=cm(2,4,14)-(gm(3,3)*(9*gm(1,3)*gm(2,3)-3*gm(1,2)*gm(3,3)))
     cm(2,5,14)=cm(2,5,14)-(gm(3,3)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)&
&     *gm(3,3)))
     cm(2,6,14)=cm(2,6,14)-(7.5d0*gm(1,3)**2*gm(2,3)-3*gm(1,2)*gm(1,3)&
&     *gm(3,3)-1.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(2,7,14)=cm(2,7,14)-(2.5d0*gm(2,3)**3-1.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(2,8,14)=cm(2,8,14)-(3*gm(2,3)*gm(3,3)**2)
     cm(2,9,14)=cm(2,9,14)-(gm(3,3)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(2,10,14)=cm(2,10,14)-(gm(3,3)**3)
     cm(3,1,3)=cm(3,1,3)-(3*gm(1,1)**2*gm(1,3))
     cm(3,2,3)=cm(3,2,3)-(1.5d0*gm(1,2)**2*gm(1,3)-4.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)+12*gm(1,1)*gm(1,2)*gm(2,3))
     cm(3,3,3)=cm(3,3,3)-(1.5d0*gm(1,3)**3+7.5d0*gm(1,1)*gm(1,3)*gm(3,3))
     cm(3,4,3)=cm(3,4,3)-(3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(3*gm(1,3)&
&     **2+12*gm(1,1)*gm(3,3)))
     cm(3,5,3)=cm(3,5,3)-(gm(1,1)*(3*gm(1,3)**2+6*gm(1,1)*gm(3,3)))
     cm(3,6,3)=cm(3,6,3)-(gm(1,1)*(3*gm(1,2)*gm(1,3)+6*gm(1,1)*gm(2,3)))
     cm(3,7,3)=cm(3,7,3)-(-3*gm(1,2)*gm(1,3)*gm(2,2)+7.5d0*gm(1,2)&
&     **2*gm(2,3)-1.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(3,8,3)=cm(3,8,3)-(1.5d0*gm(1,3)**2*gm(2,3)+12*gm(1,2)*gm(1,3)&
&     *gm(3,3)-4.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(3,9,3)=cm(3,9,3)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)*gm(2,3)&
&     +7.5d0*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,10,3)=cm(3,10,3)-(gm(3,3)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)&
&     *gm(3,3)))
     cm(3,1,4)=cm(3,1,4)-(3*gm(1,1)**2*gm(1,2))
     cm(3,2,4)=cm(3,2,4)-(1.5d0*gm(1,2)**3+7.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(3,3,4)=cm(3,3,4)-(12*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(1.5d0*gm(1,3)&
&     **2-4.5d0*gm(1,1)*gm(3,3)))
     cm(3,4,4)=cm(3,4,4)-(3*gm(1,2)**2*gm(1,3)+12*gm(1,1)*gm(1,3)*gm(2,2)&
&     +3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(3,5,4)=cm(3,5,4)-(gm(1,1)*(3*gm(1,2)*gm(1,3)+6*gm(1,1)*gm(2,3)))
     cm(3,6,4)=cm(3,6,4)-(gm(1,1)*(3*gm(1,2)**2+6*gm(1,1)*gm(2,2)))
     cm(3,7,4)=cm(3,7,4)-(gm(2,2)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(3,8,4)=cm(3,8,4)-(7.5d0*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)&
&     *gm(2,3)-3*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,9,4)=cm(3,9,4)-(12*gm(1,2)*gm(1,3)*gm(2,2)+1.5d0*gm(1,2)&
&     **2*gm(2,3)-4.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(3,10,4)=cm(3,10,4)-(7.5d0*gm(1,3)**2*gm(2,3)-3*gm(1,2)*gm(1,3)&
&     *gm(3,3)-1.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(3,1,5)=cm(3,1,5)-(gm(1,1)**3)
     cm(3,2,5)=cm(3,2,5)-(gm(1,1)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(3,3,5)=cm(3,3,5)-(gm(1,1)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)*gm(3,3)))
     cm(3,4,5)=cm(3,4,5)-(gm(1,1)*(9*gm(1,2)*gm(1,3)-3*gm(1,1)*gm(2,3)))
     cm(3,5,5)=cm(3,5,5)-(3*gm(1,1)**2*gm(1,3))
     cm(3,6,5)=cm(3,6,5)-(3*gm(1,1)**2*gm(1,2))
     cm(3,7,5)=cm(3,7,5)-(2.5d0*gm(1,2)**3-1.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(3,8,5)=cm(3,8,5)-(-3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(7.5d0*gm(1,3)&
&     **2-1.5d0*gm(1,1)*gm(3,3)))
     cm(3,9,5)=cm(3,9,5)-(7.5d0*gm(1,2)**2*gm(1,3)-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)-3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(3,10,5)=cm(3,10,5)-(2.5d0*gm(1,3)**3-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(3,3))
     cm(3,1,8)=cm(3,1,8)-(gm(1,1)*(9*gm(1,2)*gm(1,3)-3*gm(1,1)*gm(2,3)))
     cm(3,2,8)=cm(3,2,8)-(3*gm(1,2)*gm(1,3)*gm(2,2)+3*gm(1,2)**2*gm(2,3)&
&     +12*gm(1,1)*gm(2,2)*gm(2,3))
     cm(3,3,8)=cm(3,3,8)-(3*gm(1,3)**2*gm(2,3)+3*gm(1,2)*gm(1,3)*gm(3,3)&
&     +12*gm(1,1)*gm(2,3)*gm(3,3))
     cm(3,4,8)=cm(3,4,8)-(9*gm(1,3)**2*gm(2,2)-6*gm(1,2)*gm(1,3)*gm(2,3)&
&     +9*gm(1,2)**2*gm(3,3)+gm(1,1)*(9*gm(2,3)**2+15*gm(2,2)*gm(3,3)))
     cm(3,5,8)=cm(3,5,8)-(3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(3*gm(1,3)&
&     **2+12*gm(1,1)*gm(3,3)))
     cm(3,6,8)=cm(3,6,8)-(3*gm(1,2)**2*gm(1,3)+12*gm(1,1)*gm(1,3)*gm(2,2)&
&     +3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(3,7,8)=cm(3,7,8)-(gm(2,2)*(-3*gm(1,3)*gm(2,2)+9*gm(1,2)*gm(2,3)))
     cm(3,8,8)=cm(3,8,8)-(3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(3,9,8)=cm(3,9,8)-(3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(3,10,8)=cm(3,10,8)-(gm(3,3)*(9*gm(1,3)*gm(2,3)-3*gm(1,2)*gm(3,3)))
     cm(3,1,9)=cm(3,1,9)-(gm(1,1)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)*gm(2,2)))
     cm(3,2,9)=cm(3,2,9)-(gm(2,2)*(3*gm(1,2)**2+6*gm(1,1)*gm(2,2)))
     cm(3,3,9)=cm(3,3,9)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)*gm(2,3)&
&     -3*gm(1,2)**2*gm(3,3)+gm(1,1)*(7.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,4,9)=cm(3,4,9)-(3*gm(1,2)*gm(1,3)*gm(2,2)+3*gm(1,2)**2*gm(2,3)&
&     +12*gm(1,1)*gm(2,2)*gm(2,3))
     cm(3,5,9)=cm(3,5,9)-(1.5d0*gm(1,2)**2*gm(1,3)-4.5d0*gm(1,1)*gm(1,3)&
&     *gm(2,2)+12*gm(1,1)*gm(1,2)*gm(2,3))
     cm(3,6,9)=cm(3,6,9)-(1.5d0*gm(1,2)**3+7.5d0*gm(1,1)*gm(1,2)*gm(2,2))
     cm(3,7,9)=cm(3,7,9)-(3*gm(1,2)*gm(2,2)**2)
     cm(3,8,9)=cm(3,8,9)-(12*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(3,9,9)=cm(3,9,9)-(gm(2,2)*(6*gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3)))
     cm(3,10,9)=cm(3,10,9)-(-3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(3,1,10)=cm(3,1,10)-(gm(1,1)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)&
&     *gm(3,3)))
     cm(3,2,10)=cm(3,2,10)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)&
&     *gm(2,3)-3*gm(1,2)**2*gm(3,3)+gm(1,1)*(7.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,3,10)=cm(3,3,10)-(gm(3,3)*(3*gm(1,3)**2+6*gm(1,1)*gm(3,3)))
     cm(3,4,10)=cm(3,4,10)-(3*gm(1,3)**2*gm(2,3)+3*gm(1,2)*gm(1,3)&
&     *gm(3,3)+12*gm(1,1)*gm(2,3)*gm(3,3))
     cm(3,5,10)=cm(3,5,10)-(1.5d0*gm(1,3)**3+7.5d0*gm(1,1)*gm(1,3)&
&     *gm(3,3))
     cm(3,6,10)=cm(3,6,10)-(12*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(1.5d0*gm(1,3)&
&     **2-4.5d0*gm(1,1)*gm(3,3)))
     cm(3,7,10)=cm(3,7,10)-(-3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(3,8,10)=cm(3,8,10)-(gm(3,3)*(3*gm(1,3)*gm(2,3)+6*gm(1,2)*gm(3,3)))
     cm(3,9,10)=cm(3,9,10)-(12*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(3,10,10)=cm(3,10,10)-(3*gm(1,3)*gm(3,3)**2)
     cm(3,1,12)=cm(3,1,12)-(7.5d0*gm(1,2)**2*gm(1,3)-1.5d0*gm(1,1)&
&     *gm(1,3)*gm(2,2)-3*gm(1,1)*gm(1,2)*gm(2,3))
     cm(3,2,12)=cm(3,2,12)-(gm(2,2)*(6*gm(1,3)*gm(2,2)+3*gm(1,2)*gm(2,3)))
     cm(3,3,12)=cm(3,3,12)-(12*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(3,4,12)=cm(3,4,12)-(3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(3,5,12)=cm(3,5,12)-(-3*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)&
&     *gm(2,3)+7.5d0*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,6,12)=cm(3,6,12)-(12*gm(1,2)*gm(1,3)*gm(2,2)+1.5d0*gm(1,2)&
&     **2*gm(2,3)-4.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(3,7,12)=cm(3,7,12)-(3*gm(2,2)**2*gm(2,3))
     cm(3,8,12)=cm(3,8,12)-(1.5d0*gm(2,3)**3+7.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(3,9,12)=cm(3,9,12)-(gm(2,2)*(3*gm(2,3)**2+6*gm(2,2)*gm(3,3)))
     cm(3,10,12)=cm(3,10,12)-(gm(3,3)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,1,13)=cm(3,1,13)-(2.5d0*gm(1,2)**3-1.5d0*gm(1,1)*gm(1,2)&
&     *gm(2,2))
     cm(3,2,13)=cm(3,2,13)-(3*gm(1,2)*gm(2,2)**2)
     cm(3,3,13)=cm(3,3,13)-(-3*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(3,4,13)=cm(3,4,13)-(gm(2,2)*(-3*gm(1,3)*gm(2,2)+9*gm(1,2)*gm(2,3)))
     cm(3,5,13)=cm(3,5,13)-(-3*gm(1,2)*gm(1,3)*gm(2,2)+7.5d0*gm(1,2)&
&     **2*gm(2,3)-1.5d0*gm(1,1)*gm(2,2)*gm(2,3))
     cm(3,6,13)=cm(3,6,13)-(gm(2,2)*(4.5d0*gm(1,2)**2-1.5d0*gm(1,1)&
&     *gm(2,2)))
     cm(3,7,13)=cm(3,7,13)-(gm(2,2)**3)
     cm(3,8,13)=cm(3,8,13)-(gm(2,2)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,9,13)=cm(3,9,13)-(3*gm(2,2)**2*gm(2,3))
     cm(3,10,13)=cm(3,10,13)-(2.5d0*gm(2,3)**3-1.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(3,1,14)=cm(3,1,14)-(-3*gm(1,1)*gm(1,3)*gm(2,3)+gm(1,2)*(7.5d0*gm(1,3)&
&     **2-1.5d0*gm(1,1)*gm(3,3)))
     cm(3,2,14)=cm(3,2,14)-(12*gm(1,3)*gm(2,2)*gm(2,3)+gm(1,2)*(1.5d0*gm(2,3)&
&     **2-4.5d0*gm(2,2)*gm(3,3)))
     cm(3,3,14)=cm(3,3,14)-(gm(3,3)*(3*gm(1,3)*gm(2,3)+6*gm(1,2)*gm(3,3)))
     cm(3,4,14)=cm(3,4,14)-(3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(3*gm(2,3)&
&     **2+12*gm(2,2)*gm(3,3)))
     cm(3,5,14)=cm(3,5,14)-(1.5d0*gm(1,3)**2*gm(2,3)+12*gm(1,2)*gm(1,3)&
&     *gm(3,3)-4.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(3,6,14)=cm(3,6,14)-(7.5d0*gm(1,3)**2*gm(2,2)+9*gm(1,2)*gm(1,3)&
&     *gm(2,3)-3*gm(1,2)**2*gm(3,3)+gm(1,1)*(-3*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,7,14)=cm(3,7,14)-(gm(2,2)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,8,14)=cm(3,8,14)-(gm(3,3)*(3*gm(2,3)**2+6*gm(2,2)*gm(3,3)))
     cm(3,9,14)=cm(3,9,14)-(1.5d0*gm(2,3)**3+7.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(3,10,14)=cm(3,10,14)-(3*gm(2,3)*gm(3,3)**2)
     cm(3,1,15)=cm(3,1,15)-(2.5d0*gm(1,3)**3-1.5d0*gm(1,1)*gm(1,3)&
&     *gm(3,3))
     cm(3,2,15)=cm(3,2,15)-(-3*gm(1,2)*gm(2,3)*gm(3,3)+gm(1,3)*(7.5d0*gm(2,3)&
&     **2-1.5d0*gm(2,2)*gm(3,3)))
     cm(3,3,15)=cm(3,3,15)-(3*gm(1,3)*gm(3,3)**2)
     cm(3,4,15)=cm(3,4,15)-(gm(3,3)*(9*gm(1,3)*gm(2,3)-3*gm(1,2)*gm(3,3)))
     cm(3,5,15)=cm(3,5,15)-(gm(3,3)*(4.5d0*gm(1,3)**2-1.5d0*gm(1,1)&
&     *gm(3,3)))
     cm(3,6,15)=cm(3,6,15)-(7.5d0*gm(1,3)**2*gm(2,3)-3*gm(1,2)*gm(1,3)&
&     *gm(3,3)-1.5d0*gm(1,1)*gm(2,3)*gm(3,3))
     cm(3,7,15)=cm(3,7,15)-(2.5d0*gm(2,3)**3-1.5d0*gm(2,2)*gm(2,3)&
&     *gm(3,3))
     cm(3,8,15)=cm(3,8,15)-(3*gm(2,3)*gm(3,3)**2)
     cm(3,9,15)=cm(3,9,15)-(gm(3,3)*(4.5d0*gm(2,3)**2-1.5d0*gm(2,2)&
&     *gm(3,3)))
     cm(3,10,15)=cm(3,10,15)-(gm(3,3)**3)
   end if
 end if
!
!contraction to output 3-vector
!
 eisnl(:)=0.d0
 do jj=1,((rank+2)*(rank+3))/2
   tmp(:,:)=0.d0
   do ii=1,((rank+1)*(rank+2))/2
     tmp(:,1)=tmp(:,1)+aa(:,ii)*cm(1,ii,jj)
     tmp(:,2)=tmp(:,2)+aa(:,ii)*cm(2,ii,jj)
     tmp(:,3)=tmp(:,3)+aa(:,ii)*cm(3,ii,jj)
   end do
   eisnl(:)=eisnl(:)+tmp(1,:)*bb(1,jj)+tmp(2,:)*bb(2,jj)
 end do
 eisnl(:)=2.0d0*eisnl(:)
!factor of 2 multiplied in to drop call to conjugate contraction
!eisnl(:)=0.5d0*eisnl(:)

 ABI_DEALLOCATE(cm)

end subroutine contistr01
!!***
