/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:48:19 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.MSPcrunchComparisonData;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class MSPcrunchComparisonData_ESTest extends MSPcrunchComparisonData_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      boolean boolean0 = MSPcrunchComparisonData.formatCorrect("One or more contigs must be in the contig list.");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(38, 38, 38, (-4349), (-4349), (-4349));
      CharArrayWriter charArrayWriter0 = new CharArrayWriter();
      MSPcrunchComparisonData.writeMatchFromAlignMatch(alignMatch0, " not in this VariantContex ", "\n", charArrayWriter0);
      assertEquals(57, charArrayWriter0.size());
      assertEquals("-4349 -4349 38 -4349  not in this VariantContex  38 38 \n\n", charArrayWriter0.toString());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(0, 0, 394, 394, 1738, 1738);
      // Undeclared exception!
      try { 
        MSPcrunchComparisonData.writeMatchFromAlignMatch(alignMatch0, "nY]>098Xe=H?SU.", "se+m", (Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      try { 
        mSPcrunchComparisonData0.makeMatchFromString("wR0,o/riUUI&,a43H$");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading MSPcrunch data: not enough fields in this line: wR0,o/riUUI&,a43H$
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      // Undeclared exception!
      try { 
        MSPcrunchComparisonData.formatCorrect((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.StringTokenizer", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      char[] charArray0 = new char[8];
      charArray0[0] = '|';
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      MSPcrunchComparisonData mSPcrunchComparisonData0 = null;
      try {
        mSPcrunchComparisonData0 = new MSPcrunchComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // while reading MSPcrunch data: not enough fields in this line: |\u0000\u0000\u0000\u0000\u0000\u0000\u0000
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      MSPcrunchComparisonData mSPcrunchComparisonData0 = null;
      try {
        mSPcrunchComparisonData0 = new MSPcrunchComparisonData(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      char[] charArray0 = new char[9];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0, 0, 0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData(linePushBackReader0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      try { 
        mSPcrunchComparisonData0.makeMatchFromString("The list of prefixes must not be null");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // while reading MSPcrunch data: failed to parse a number from this string: For input string: \"The\"
         //
         verifyException("uk.ac.sanger.artemis.MSPcrunchComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = null;
      try {
        mSPcrunchComparisonData0 = new MSPcrunchComparisonData((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      // Undeclared exception!
      try { 
        mSPcrunchComparisonData0.makeMatchFromString((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.StringTokenizer", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(0, 0, (-1149), 735, 735, (-1149));
      PipedWriter pipedWriter0 = new PipedWriter();
      try { 
        MSPcrunchComparisonData.writeMatchFromAlignMatch(alignMatch0, "", "", pipedWriter0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedWriter", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      SimpleComparisonData simpleComparisonData0 = mSPcrunchComparisonData0.getNewSimpleComparisonData();
      assertNotSame(mSPcrunchComparisonData0, simpleComparisonData0);
  }
}
