_autojump()
{
        local cur
        cur=${COMP_WORDS[*]:1}
        comps=$(autojump --bash --complete $cur)
        while read i
        do
            COMPREPLY=("${COMPREPLY[@]}" "${i}")
        done <<EOF
        $comps
EOF
}
complete -F _autojump j

_autojump_files()
{
    if [[ ${COMP_WORDS[COMP_CWORD]} == *__* ]]; then
        local cur
        #cur=${COMP_WORDS[*]:1}
        cur=${COMP_WORDS[COMP_CWORD]}
        comps=$(autojump --bash --complete $cur)
        while read i
        do
            COMPREPLY=("${COMPREPLY[@]}" "${i}")
        done <<EOF
        $comps
EOF
    fi
}

if [[ -n ${AUTOJUMP_AUTOCOMPLETE_CMDS} ]]; then
    complete -o default -o bashdefault -F _autojump_files ${AUTOJUMP_AUTOCOMPLETE_CMDS}
fi

#determine the data directory according to the XDG Base Directory Specification
if [[ -n ${XDG_DATA_HOME} ]] && [[ ${XDG_DATA_HOME} =~ ${USER} ]]; then
    export AUTOJUMP_DATA_DIR="${XDG_DATA_HOME}/autojump"
else
    export AUTOJUMP_DATA_DIR=~/.local/share/autojump
fi

if [ ! -e "${AUTOJUMP_DATA_DIR}" ]; then
    mkdir -p "${AUTOJUMP_DATA_DIR}"
fi

# set paths if necessary for local installations
if [ -d ~/.autojump/ ]; then
    export PATH=~/.autojump/bin:"${PATH}"
fi

export AUTOJUMP_HOME=${HOME}
if [ "${AUTOJUMP_KEEP_SYMLINKS}" == "1" ]; then
    _PWD_ARGS=""
else
    _PWD_ARGS="-P"
fi

autojump_add_to_database() {
    if [[ "${AUTOJUMP_HOME}" == "${HOME}" ]]; then
        autojump -a "$(pwd ${_PWD_ARGS})" 1>/dev/null 2>>"${AUTOJUMP_DATA_DIR}/autojump_errors"
    fi
}

case $PROMPT_COMMAND in
    *autojump*)
        ;;
    *)
        PROMPT_COMMAND="${PROMPT_COMMAND:+$(echo "${PROMPT_COMMAND}" | awk '{gsub(/; *$/,"")}1') ; }autojump_add_to_database"
        ;;
esac

function j {
    if [[ ${@} =~ ^-{1,2}.* ]]; then
        autojump ${@}
        return
    fi

    new_path="$(autojump ${@})"
    if [ -d "${new_path}" ]; then
        echo -e "\\033[31m${new_path}\\033[0m"
        cd "${new_path}"
    else
        echo "autojump: directory '${@}' not found"
        echo "Try \`autojump --help\` for more information."
        false
    fi
}

function jc {
    if [[ ${@} == -* ]]; then
        j ${@}
    else
        j $(pwd)/ ${@}
    fi
}

function jo {
    if [ -z $(autojump $@) ]; then
        echo "autojump: directory '${@}' not found"
        echo "Try \`autojump --help\` for more information."
        false
    else
        case ${OSTYPE} in
            linux-gnu)
                xdg-open "$(autojump $@)"
                ;;
            darwin*)
                open "$(autojump $@)"
                ;;
            cygwin)
                cygstart "" $(cygpath -w -a $(pwd))
                ;;
            *)
                echo "Unknown operating system." 1>&2
                ;;
        esac
    fi
}

function jco {
    if [[ ${@} == -* ]]; then
        j ${@}
    else
        jo $(pwd) ${@}
    fi
}
