//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/SampleListModel.h
//! @brief     Defines class SampleListModel
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLELISTMODEL_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLELISTMODEL_H

#include <QAbstractItemModel>

class SampleModel;
class SampleItem;

//! List model for sample selection (used in the left pane of the layer oriented sample editor)
class SampleListModel : public QAbstractListModel {
    Q_OBJECT
public:
    SampleListModel(QObject* parent, SampleModel* model);

    int rowCount(const QModelIndex& parent = QModelIndex()) const override;
    QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const override;
    Qt::ItemFlags flags(const QModelIndex& index) const override;
    bool setData(const QModelIndex& index, const QVariant& value, int role) override;

    SampleItem* itemForIndex(const QModelIndex& index) const;
    QModelIndex indexForItem(SampleItem* item) const;

    //! Remove the given sample. nullptr is allowed.
    void removeSample(SampleItem* item);

    //! Create a new sample (sample) and return the index of it.
    QModelIndex createSample();

    //! Create sample from list of built-in examples.
    //!
    //! Returns invalid index if anything went wrong.
    QModelIndex createSampleFromExamples(const QString& className, const QString& title,
                                         const QString& description);

#ifdef BORNAGAIN_PYTHON
    //! Create sample from an imported python code.
    //!
    //! Returns invalid index if anything went wrong.
    QModelIndex createSampleFromPython();
#endif

private:
    SampleModel* m_sampleItems = nullptr;
};

#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_SAMPLELISTMODEL_H
