//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// <random>

// template<class Engine, size_t w, class UIntType>
// class independent_bits_engine

// void seed(result_type s = default_seed);

#include <random>
#include <cassert>

#include "test_macros.h"

void
test1()
{
    for (int s = 0; s < 20; ++s)
    {
        typedef std::independent_bits_engine<std::ranlux24, 32, unsigned> E;
        E e1(s);
        E e2;
        e2.seed(s);
        assert(e1 == e2);
    }
}

void
test2()
{
    for (int s = 0; s < 20; ++s)
    {
        typedef std::independent_bits_engine<std::ranlux48, 64, unsigned long long> E;
        E e1(s);
        E e2;
        e2.seed(s);
        assert(e1 == e2);
    }
}

int main(int, char**)
{
    test1();
    test2();

  return 0;
}
