#ifndef SIMTBX_DIFFBRAGG_KOKKOSKERNEL
#define SIMTBX_DIFFBRAGG_KOKKOSKERNEL

#include "diffBraggKOKKOS.h"
#include "util_kokkos.h"

void kokkos_sum_over_steps(
    int Npix_to_model,
    vector_uint_t panels_fasts_slows,
    vector_cudareal_t floatimage,
    vector_cudareal_t wavelenimage,
    vector_cudareal_t d_Umat_images,
    vector_cudareal_t d2_Umat_images,
    vector_cudareal_t d_Bmat_images,
    vector_cudareal_t d2_Bmat_images,
    vector_cudareal_t d_Ncells_images,
    vector_cudareal_t d2_Ncells_images,
    vector_cudareal_t d_fcell_images,
    vector_cudareal_t d2_fcell_images,
    vector_cudareal_t d_eta_images,
    vector_cudareal_t d2_eta_images,
    vector_cudareal_t d_lambda_images,
    vector_cudareal_t d2_lambda_images,
    vector_cudareal_t d_panel_rot_images,
    vector_cudareal_t d2_panel_rot_images,
    vector_cudareal_t d_panel_orig_images,
    vector_cudareal_t d2_panel_orig_images,
    vector_cudareal_t d_fp_fdp_images,
    const int Nsteps,
    int printout_fpixel,
    int printout_spixel,
    bool printout,
    CUDAREAL default_F,
    int oversample,
    bool oversample_omega,
    CUDAREAL subpixel_size,
    CUDAREAL pixel_size,
    CUDAREAL detector_thickstep,
    CUDAREAL detector_thick,
    const vector_cudareal_t close_distances,
    CUDAREAL detector_attnlen,
    int detector_thicksteps,
    int sources,
    int phisteps,
    int mosaic_domains,
    bool use_lambda_coefficients,
    CUDAREAL lambda0,
    CUDAREAL lambda1,
    KOKKOS_MAT3 eig_U,
    KOKKOS_MAT3 eig_O,
    KOKKOS_MAT3 eig_B,
    KOKKOS_MAT3 RXYZ,
    vector_vec3_t dF_vecs,
    vector_vec3_t dS_vecs,
    const vector_mat3_t UMATS_RXYZ,
    vector_mat3_t UMATS_RXYZ_prime,
    vector_mat3_t UMATS_RXYZ_dbl_prime,
    vector_mat3_t RotMats,
    vector_mat3_t dRotMats,
    vector_mat3_t d2RotMats,
    vector_mat3_t UMATS,
    vector_mat3_t dB_mats,
    vector_mat3_t dB2_mats,
    vector_mat3_t Amatrices,
    const vector_cudareal_t source_X,
    const vector_cudareal_t source_Y,
    const vector_cudareal_t source_Z,
    const vector_cudareal_t source_lambda,
    const vector_cudareal_t source_I,
    CUDAREAL kahn_factor,
    CUDAREAL Na,
    CUDAREAL Nb,
    CUDAREAL Nc,
    CUDAREAL Nd,
    CUDAREAL Ne,
    CUDAREAL Nf,
    CUDAREAL phi0,
    CUDAREAL phistep,
    KOKKOS_VEC3 spindle_vec,
    KOKKOS_VEC3 polarization_axis,
    int h_range,
    int k_range,
    int l_range,
    int h_max,
    int h_min,
    int k_max,
    int k_min,
    int l_max,
    int l_min,
    CUDAREAL dmin,
    CUDAREAL fudge,
    bool complex_miller,
    int verbose,
    bool only_save_omega_kahn,
    bool isotropic_ncells,
    bool compute_curvatures,
    const vector_cudareal_t FhklLinear,
    const vector_cudareal_t Fhkl2Linear,
    vector_bool_t refine_Bmat,
    vector_bool_t refine_Ncells,
    bool refine_Ncells_def,
    vector_bool_t refine_panel_origin,
    vector_bool_t refine_panel_rot,
    bool refine_fcell,
    vector_bool_t refine_lambda,
    bool refine_eta,
    vector_bool_t refine_Umat,
    const vector_cudareal_t fdet_vectors,
    const vector_cudareal_t sdet_vectors,
    const vector_cudareal_t odet_vectors,
    const vector_cudareal_t pix0_vectors,
    bool nopolar,
    bool point_pixel,
    CUDAREAL fluence,
    CUDAREAL r_e_sqr,
    CUDAREAL spot_scale,
    int Npanels,
    bool aniso_eta,
    bool no_Nabc_scale,
    const vector_cudareal_t fpfdp,
    const vector_cudareal_t fpfdp_derivs,
    const vector_cudareal_t atom_data,
    int num_atoms,
    bool refine_fp_fdp,
    const vector_int_t nominal_hkl,
    bool use_nominal_hkl,
    KOKKOS_MAT3 anisoU,
    KOKKOS_MAT3 anisoG,
    KOKKOS_MAT3 rotate_principal_axes,
    bool use_diffuse,
    vector_cudareal_t d_diffuse_gamma_images,
    vector_cudareal_t d_diffuse_sigma_images,
    bool refine_diffuse,
    bool gamma_miller_units,
    bool refine_Icell,
    bool save_wavelenimage,
    int laue_group_num, int stencil_size,
    bool Fhkl_gradient_mode,
    bool Fhkl_errors_mode,
    bool using_trusted_mask,
    bool Fhkl_channels_empty,
    bool Fhkl_have_scale_factors,
    int Num_ASU,
    const vector_cudareal_t data_residual,
    const vector_cudareal_t data_variance,
    const vector_int_t data_freq,
    const vector_bool_t data_trusted,
    const vector_int_t FhklLinear_ASUid,
    const vector_cudareal_t Fhkl_channels,
    const vector_cudareal_t Fhkl_scale,
    vector_cudareal_t Fhkl_scale_deriv
    );


#endif
