/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : cif.g
 *     -                            On : 2013-04-16 18:47:22
 *     -                 for the lexer : cifLexerLexer
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "cifLexer.h"
/* ----------------------------------------- */


/** String literals used by cifLexer that we must do things like MATCHS() with.
 *  C will normally just lay down 8 bit characters, and you can use L"xxx" to
 *  get wchar_t, but wchar_t is 16 bits on Windows, which is not UTF32 and so
 *  we perform this little trick of defining the literals as arrays of UINT32
 *  and passing in the address of these.
 */
static ANTLR3_UCHAR     lit_1[]  = { 0x0D, 0x0A,  ANTLR3_STRING_TERMINATOR};





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define         CTX     ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef  SCOPE_TYPE
#undef  SCOPE_STACK
#undef  SCOPE_TOP
#define SCOPE_TYPE(scope)   pcifLexer_##scope##_SCOPE
#define SCOPE_STACK(scope)  pcifLexer_##scope##Stack
#define SCOPE_TOP(scope)    ctx->pcifLexer_##scope##Top
#define SCOPE_SIZE(scope)               ctx->pcifLexer_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)        (ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))


/* Macros for accessing things in a lexer
 */
#undef      LEXER
#undef      RECOGNIZER
#undef      RULEMEMO
#undef      GETCHARINDEX
#undef      GETLINE
#undef      GETCHARPOSITIONINLINE
#undef      EMIT
#undef      EMITNEW
#undef      MATCHC
#undef      MATCHS
#undef      MATCHRANGE
#undef      LTOKEN
#undef      HASFAILED
#undef      FAILEDFLAG
#undef      INPUT
#undef      STRSTREAM
#undef      LA
#undef      HASEXCEPTION
#undef      EXCEPTION
#undef      CONSTRUCTEX
#undef      CONSUME
#undef      LRECOVER
#undef      MARK
#undef      REWIND
#undef      REWINDLAST
#undef      BACKTRACKING
#undef          MATCHANY
#undef          MEMOIZE
#undef          HAVEPARSEDRULE
#undef          GETTEXT
#undef          INDEX
#undef          SEEK
#undef          PUSHSTREAM
#undef          POPSTREAM
#undef          SETTEXT
#undef          SETTEXT8

#define     LEXER                                       ctx->pLexer
#define     RECOGNIZER                      LEXER->rec
#define         LEXSTATE                                RECOGNIZER->state
#define         TOKSOURCE                               LEXSTATE->tokSource
#define     GETCHARINDEX()                      LEXER->getCharIndex(LEXER)
#define     GETLINE()                           LEXER->getLine(LEXER)
#define     GETTEXT()                           LEXER->getText(LEXER)
#define     GETCHARPOSITIONINLINE() LEXER->getCharPositionInLine(LEXER)
#define     EMIT()                                      LEXSTATE->type = _type; LEXER->emit(LEXER)
#define     EMITNEW(t)                          LEXER->emitNew(LEXER, t)
#define     MATCHC(c)                           LEXER->matchc(LEXER, c)
#define     MATCHS(s)                           LEXER->matchs(LEXER, s)
#define     MATCHRANGE(c1,c2)       LEXER->matchRange(LEXER, c1, c2)
#define     MATCHANY()                          LEXER->matchAny(LEXER)
#define     LTOKEN                              LEXSTATE->token
#define     HASFAILED()                         (LEXSTATE->failed == ANTLR3_TRUE)
#define     BACKTRACKING                        LEXSTATE->backtracking
#define     FAILEDFLAG                          LEXSTATE->failed
#define     INPUT                                       LEXER->input
#define     STRSTREAM                           INPUT
#define         ISTREAM                                 INPUT->istream
#define         INDEX()                                 ISTREAM->index(ISTREAM)
#define         SEEK(n)                                 ISTREAM->seek(ISTREAM, n)
#define     EOF_TOKEN                           &(LEXSTATE->tokSource->eofToken)
#define     HASEXCEPTION()                      (LEXSTATE->error == ANTLR3_TRUE)
#define     EXCEPTION                           LEXSTATE->exception
#define     CONSTRUCTEX()                       RECOGNIZER->exConstruct(RECOGNIZER)
#define     LRECOVER()                          LEXER->recover(LEXER)
#define     MARK()                                      ISTREAM->mark(ISTREAM)
#define     REWIND(m)                           ISTREAM->rewind(ISTREAM, m)
#define     REWINDLAST()                        ISTREAM->rewindLast(ISTREAM)
#define         MEMOIZE(ri,si)                  RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define         HAVEPARSEDRULE(r)               RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define         PUSHSTREAM(str)                 LEXER->pushCharStream(LEXER, str)
#define         POPSTREAM()                             LEXER->popCharStream(LEXER)
#define         SETTEXT(str)                    LEXSTATE->text = str
#define         SKIP()                                  LEXSTATE->token = &(TOKSOURCE->skipToken)
#define         USER1                                   LEXSTATE->user1
#define         USER2                                   LEXSTATE->user2
#define         USER3                                   LEXSTATE->user3
#define         CUSTOM                                  LEXSTATE->custom
#define         RULEMEMO                                LEXSTATE->ruleMemo
#define         DBG                                             RECOGNIZER->debugger

/* If we have been told we can rely on the standard 8 bit or UTF16 input
 * stream, then we can define our macros to use the direct pointers
 * in the input object, which is much faster than indirect calls. This
 * is really only significant to lexers with a lot of fragment rules (which
 * do not place LA(1) in a temporary at the moment) and even then
 * only if there is a lot of input (order of say 1M or so).
 */
#if     defined(ANTLR3_INLINE_INPUT_8BIT) || defined(ANTLR3_INLINE_INPUT_UTF16)

# ifdef ANTLR3_INLINE_INPUT_8BIT

/* 8 bit character set */

#  define           NEXTCHAR    ((pANTLR3_UINT8)(INPUT->nextChar))
#  define           DATAP       ((pANTLR3_UINT8)(INPUT->data))

# else

#  define           NEXTCHAR    ((pANTLR3_UINT16)(INPUT->nextChar))
#  define           DATAP       ((pANTLR3_UINT16)(INPUT->data))

# endif

# define            LA(n) ((NEXTCHAR + n) > (DATAP + INPUT->sizeBuf) ? ANTLR3_CHARSTREAM_EOF : (ANTLR3_UCHAR)(*(NEXTCHAR + n - 1)))
# define            CONSUME()                                           \
{                                                                       \
    if        (NEXTCHAR < (DATAP + INPUT->sizeBuf))                     \
    {                                                                   \
        INPUT->charPositionInLine++;                                    \
        if  ((ANTLR3_UCHAR)(*NEXTCHAR) == INPUT->newlineChar)           \
        {                                                               \
            INPUT->line++;                                              \
            INPUT->charPositionInLine        = 0;                       \
            INPUT->currentLine                = (void *)(NEXTCHAR + 1); \
        }                                                               \
        INPUT->nextChar = (void *)(NEXTCHAR + 1);                       \
    }                                                                   \
}

#else

// Pick up the input character by calling the input stream implementation.
//
#define     CONSUME()   INPUT->istream->consume(INPUT->istream)
#define     LA(n)       INPUT->istream->_LA(INPUT->istream, n)

#endif

#define         TOKTEXT(tok, txt)                               tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define     UP      ANTLR3_TOKEN_UP
#define     DOWN    ANTLR3_TOKEN_DOWN
#define     EOR     ANTLR3_TOKEN_EOR
#define     INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */

/* Forward declare the locally static matching functions we have generated and any predicate functions.
 */
static ANTLR3_INLINE
 void
        mT__37    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mEOL    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mDOUBLE_QUOTE    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mSINGLE_QUOTE    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mORDINARY_CHAR    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mNON_BLANK_CHAR_    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mTEXT_LEAD_CHAR    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mANY_PRINT_CHAR    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mTAG    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mDATA_    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mSAVE_    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mLOOP_    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mGLOBAL_    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mSTOP_    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mDATA_BLOCK_HEADING    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mSAVE_FRAME_HEADING    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mSAVE    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mDIGIT    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mEXPONENT    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mINTEGER    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mFLOAT    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mUNSIGNED_INTEGER    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mNUMBER    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mNUMERIC    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mINAPPLICABLE    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mUNKNOWN    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mUNQUOTED_STRING    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mSINGLE_QUOTED_STRING    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mDOUBLE_QUOTED_STRING    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mCHAR_STRING    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mSEMI_COLON_TEXT_FIELD    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mCOMMENTS    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mNON_BLANK_CHAR    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mWHITESPACE    (pcifLexer ctx);
static ANTLR3_INLINE
 void
        mTokens    (pcifLexer ctx);
static ANTLR3_INLINE
 ANTLR3_BOOLEAN
        synpred1_cif    (pcifLexer ctx);
static ANTLR3_INLINE
 ANTLR3_BOOLEAN
        synpred2_cif    (pcifLexer ctx);
static void     cifLexerFree(pcifLexer ctx);

/* =========================================================================
 * Lexer matching rules end.
 * =========================================================================
 */



static void
cifLexerFree  (pcifLexer ctx)
{
    LEXER->free(LEXER);

    ANTLR3_FREE(ctx);
}

static void
cifLexerReset (pcifLexer ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "cif.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
        return fileName;
}

/** \brief Create a new lexer called cifLexer
 *
 * \param[in]    instream Pointer to an initialized input stream
 * \return
 *     - Success pcifLexer initialized for the lex start
 *     - Fail NULL
 */
ANTLR3_API pcifLexer cifLexerNew
(
pANTLR3_INPUT_STREAM
 instream)
{
        // See if we can create a new lexer with the standard constructor
        //
        return cifLexerNewSSD(instream, NULL);
}

/** \brief Create a new lexer called cifLexer
 *
 * \param[in]    instream Pointer to an initialized input stream
 * \param[state] state Previously created shared recognizer stat
 * \return
 *     - Success pcifLexer initialized for the lex start
 *     - Fail NULL
 */
ANTLR3_API pcifLexer cifLexerNewSSD
(pANTLR3_INPUT_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pcifLexer ctx; // Context structure we will build and return

    ctx = (pcifLexer) ANTLR3_CALLOC(1, sizeof(cifLexer));

    if  (ctx == NULL)
    {
        // Failed to allocate memory for lexer context
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * in base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 lexer function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in cifLexer.h here so you can get a sense
     * of what goes where.
     */

    /* Create a base lexer, using the supplied input stream
     */
    ctx->pLexer = antlr3LexerNewStream(ANTLR3_SIZE_HINT, instream, state);

    /* Check that we allocated the memory correctly
     */
    if  (ctx->pLexer == NULL)
    {
                ANTLR3_FREE(ctx);
                return  NULL;
    }
    /* Install the implementation of our cifLexer interface
     */
    ctx->mT__37 = mT__37;
    ctx->mEOL   = mEOL;
    ctx->mDOUBLE_QUOTE  = mDOUBLE_QUOTE;
    ctx->mSINGLE_QUOTE  = mSINGLE_QUOTE;
    ctx->mORDINARY_CHAR = mORDINARY_CHAR;
    ctx->mNON_BLANK_CHAR_       = mNON_BLANK_CHAR_;
    ctx->mTEXT_LEAD_CHAR        = mTEXT_LEAD_CHAR;
    ctx->mANY_PRINT_CHAR        = mANY_PRINT_CHAR;
    ctx->mTAG   = mTAG;
    ctx->mDATA_ = mDATA_;
    ctx->mSAVE_ = mSAVE_;
    ctx->mLOOP_ = mLOOP_;
    ctx->mGLOBAL_       = mGLOBAL_;
    ctx->mSTOP_ = mSTOP_;
    ctx->mDATA_BLOCK_HEADING    = mDATA_BLOCK_HEADING;
    ctx->mSAVE_FRAME_HEADING    = mSAVE_FRAME_HEADING;
    ctx->mSAVE  = mSAVE;
    ctx->mDIGIT = mDIGIT;
    ctx->mEXPONENT      = mEXPONENT;
    ctx->mINTEGER       = mINTEGER;
    ctx->mFLOAT = mFLOAT;
    ctx->mUNSIGNED_INTEGER      = mUNSIGNED_INTEGER;
    ctx->mNUMBER        = mNUMBER;
    ctx->mNUMERIC       = mNUMERIC;
    ctx->mINAPPLICABLE  = mINAPPLICABLE;
    ctx->mUNKNOWN       = mUNKNOWN;
    ctx->mUNQUOTED_STRING       = mUNQUOTED_STRING;
    ctx->mSINGLE_QUOTED_STRING  = mSINGLE_QUOTED_STRING;
    ctx->mDOUBLE_QUOTED_STRING  = mDOUBLE_QUOTED_STRING;
    ctx->mCHAR_STRING   = mCHAR_STRING;
    ctx->mSEMI_COLON_TEXT_FIELD = mSEMI_COLON_TEXT_FIELD;
    ctx->mCOMMENTS      = mCOMMENTS;
    ctx->mNON_BLANK_CHAR        = mNON_BLANK_CHAR;
    ctx->mWHITESPACE    = mWHITESPACE;
    ctx->mTokens        = mTokens;



    /** When the nextToken() call is made to this lexer's pANTLR3_TOKEN_SOURCE
     *  it will call mTokens() in this generated code, and will pass it the ctx
     * pointer of this lexer, not the context of the base lexer, so store that now.
     */
    ctx->pLexer->ctx        = ctx;

    /**Install the token matching function
     */
    ctx->pLexer->mTokens = (void (*) (void *))(mTokens);

    ctx->getGrammarFileName     = getGrammarFileName;
    ctx->free           = cifLexerFree;
    ctx->reset          = cifLexerReset;


           LEXER->super = (void *)ctx;


    /* Return the newly built lexer to the caller
     */
    return  ctx;
}

/* =========================================================================
 * DFA tables for the lexer
 */
/** Static dfa state tables for Cyclic dfa:
 *    276:10: fragment FLOAT : ( INTEGER EXPONENT | ( ( '+' | '-' )? ( ( DIGIT )* '.' ( DIGIT )+ ) | ( DIGIT )+ '.' ) ( EXPONENT )? );
 */
static const ANTLR3_INT32 dfa15_eot[6] =
    {
        -1, -1, -1, -1, -1, -1
    };
static const ANTLR3_INT32 dfa15_eof[6] =
    {
        -1, -1, -1, -1, -1, -1
    };
static const ANTLR3_INT32 dfa15_min[6] =
    {
        43, 46, 46, -1, 46, -1
    };
static const ANTLR3_INT32 dfa15_max[6] =
    {
        57, 57, 101, -1, 101, -1
    };
static const ANTLR3_INT32 dfa15_accept[6] =
    {
        -1, -1, -1, 2, -1, 1
    };
static const ANTLR3_INT32 dfa15_special[6] =
    {
        -1, -1, -1, -1, -1, -1
    };

/** Used when there is no transition table entry for a particular state */
#define dfa15_T_empty       NULL

static const ANTLR3_INT32 dfa15_T0[] =
    {
        3, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5
    };
static const ANTLR3_INT32 dfa15_T1[] =
    {
        3, -1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
    };
static const ANTLR3_INT32 dfa15_T2[] =
    {
        3, -1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5
    };
static const ANTLR3_INT32 dfa15_T3[] =
    {
        1, -1, 1, 3, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
    };


/* Transition tables are a table of sub tables, with some tables
 * reused for efficiency.
 */
static const ANTLR3_INT32 * const dfa15_transitions[] =
{
    dfa15_T3, dfa15_T1, dfa15_T0, NULL, dfa15_T2, NULL
};


/* Declare tracking structure for Cyclic DFA 15
 */
static
ANTLR3_CYCLIC_DFA cdfa15
    =   {
            15,             /* Decision number of this dfa          */
            /* Which decision this represents:   */
            (const pANTLR3_UCHAR)"276:10: fragment FLOAT : ( INTEGER EXPONENT | ( ( '+' | '-' )? ( ( DIGIT )* '.' ( DIGIT )+ ) | ( DIGIT )+ '.' ) ( EXPONENT )? );",
            (CDFA_SPECIAL_FUNC) antlr3dfaspecialStateTransition,        /* Default special state transition function    */

            antlr3dfaspecialTransition,         /* DFA specialTransition is currently just a default function in the runtime */
            antlr3dfapredict,                   /* DFA simulator function is in the runtime */
            dfa15_eot,      /* EOT table                            */
            dfa15_eof,      /* EOF table                            */
            dfa15_min,      /* Minimum tokens for each state    */
            dfa15_max,      /* Maximum tokens for each state    */
            dfa15_accept,       /* Accept table                     */
            dfa15_special,      /* Special transition states        */
            dfa15_transitions   /* Table of transition tables       */

        };
/* End of Cyclic DFA 15
 * ---------------------
 *//** Static dfa state tables for Cyclic dfa:
 *    277:25: ( ( '+' | '-' )? ( ( DIGIT )* '.' ( DIGIT )+ ) | ( DIGIT )+ '.' )
 */
static const ANTLR3_INT32 dfa13_eot[5] =
    {
        -1, -1, -1, 4, -1
    };
static const ANTLR3_INT32 dfa13_eof[5] =
    {
        -1, -1, -1, -1, -1
    };
static const ANTLR3_INT32 dfa13_min[5] =
    {
        43, -1, 46, 48, -1
    };
static const ANTLR3_INT32 dfa13_max[5] =
    {
        57, -1, 57, 57, -1
    };
static const ANTLR3_INT32 dfa13_accept[5] =
    {
        -1, 1, -1, -1, 2
    };
static const ANTLR3_INT32 dfa13_special[5] =
    {
        -1, -1, -1, -1, -1
    };

/** Used when there is no transition table entry for a particular state */
#define dfa13_T_empty       NULL

static const ANTLR3_INT32 dfa13_T0[] =
    {
        3, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
    };
static const ANTLR3_INT32 dfa13_T1[] =
    {
        1, -1, 1, 1, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
    };
static const ANTLR3_INT32 dfa13_T2[] =
    {
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1
    };


/* Transition tables are a table of sub tables, with some tables
 * reused for efficiency.
 */
static const ANTLR3_INT32 * const dfa13_transitions[] =
{
    dfa13_T1, NULL, dfa13_T0, dfa13_T2, NULL
};


/* Declare tracking structure for Cyclic DFA 13
 */
static
ANTLR3_CYCLIC_DFA cdfa13
    =   {
            13,             /* Decision number of this dfa          */
            /* Which decision this represents:   */
            (const pANTLR3_UCHAR)"277:25: ( ( '+' | '-' )? ( ( DIGIT )* '.' ( DIGIT )+ ) | ( DIGIT )+ '.' )",
            (CDFA_SPECIAL_FUNC) antlr3dfaspecialStateTransition,        /* Default special state transition function    */

            antlr3dfaspecialTransition,         /* DFA specialTransition is currently just a default function in the runtime */
            antlr3dfapredict,                   /* DFA simulator function is in the runtime */
            dfa13_eot,      /* EOT table                            */
            dfa13_eof,      /* EOF table                            */
            dfa13_min,      /* Minimum tokens for each state    */
            dfa13_max,      /* Maximum tokens for each state    */
            dfa13_accept,       /* Accept table                     */
            dfa13_special,      /* Special transition states        */
            dfa13_transitions   /* Table of transition tables       */

        };
/* End of Cyclic DFA 13
 * ---------------------
 *//** Static dfa state tables for Cyclic dfa:
 *    282:10: fragment NUMBER : ( INTEGER | FLOAT );
 */
static const ANTLR3_INT32 dfa17_eot[6] =
    {
        -1, -1, 5, -1, 5, -1
    };
static const ANTLR3_INT32 dfa17_eof[6] =
    {
        -1, -1, -1, -1, -1, -1
    };
static const ANTLR3_INT32 dfa17_min[6] =
    {
        43, 46, 46, -1, 46, -1
    };
static const ANTLR3_INT32 dfa17_max[6] =
    {
        57, 57, 101, -1, 101, -1
    };
static const ANTLR3_INT32 dfa17_accept[6] =
    {
        -1, -1, -1, 2, -1, 1
    };
static const ANTLR3_INT32 dfa17_special[6] =
    {
        -1, -1, -1, -1, -1, -1
    };

/** Used when there is no transition table entry for a particular state */
#define dfa17_T_empty       NULL

static const ANTLR3_INT32 dfa17_T0[] =
    {
        3, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3
    };
static const ANTLR3_INT32 dfa17_T1[] =
    {
        1, -1, 1, 3, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
    };
static const ANTLR3_INT32 dfa17_T2[] =
    {
        3, -1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
    };
static const ANTLR3_INT32 dfa17_T3[] =
    {
        3, -1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3
    };


/* Transition tables are a table of sub tables, with some tables
 * reused for efficiency.
 */
static const ANTLR3_INT32 * const dfa17_transitions[] =
{
    dfa17_T1, dfa17_T2, dfa17_T0, NULL, dfa17_T3, NULL
};


/* Declare tracking structure for Cyclic DFA 17
 */
static
ANTLR3_CYCLIC_DFA cdfa17
    =   {
            17,             /* Decision number of this dfa          */
            /* Which decision this represents:   */
            (const pANTLR3_UCHAR)"282:10: fragment NUMBER : ( INTEGER | FLOAT );",
            (CDFA_SPECIAL_FUNC) antlr3dfaspecialStateTransition,        /* Default special state transition function    */

            antlr3dfaspecialTransition,         /* DFA specialTransition is currently just a default function in the runtime */
            antlr3dfapredict,                   /* DFA simulator function is in the runtime */
            dfa17_eot,      /* EOT table                            */
            dfa17_eof,      /* EOF table                            */
            dfa17_min,      /* Minimum tokens for each state    */
            dfa17_max,      /* Maximum tokens for each state    */
            dfa17_accept,       /* Accept table                     */
            dfa17_special,      /* Special transition states        */
            dfa17_transitions   /* Table of transition tables       */

        };
/* End of Cyclic DFA 17
 * ---------------------
 *//** Static dfa state tables for Cyclic dfa:
 *    285:1: NUMERIC : ( NUMBER | ( NUMBER '(' ( UNSIGNED_INTEGER )+ ')' ) );
 */
static const ANTLR3_INT32 dfa19_eot[15] =
    {
        -1, -1, 5, -1, 5, -1, -1, 5, -1, 5, -1, 5, -1, -1, 5
    };
static const ANTLR3_INT32 dfa19_eof[15] =
    {
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
    };
static const ANTLR3_INT32 dfa19_min[15] =
    {
        43, 46, 40, 48, 40, -1, 43, 40, -1, 40, 48, 40, 43, 48, 40
    };
static const ANTLR3_INT32 dfa19_max[15] =
    {
        57, 57, 101, 57, 101, -1, 57, 101, -1, 101, 57, 57, 57, 57, 57
    };
static const ANTLR3_INT32 dfa19_accept[15] =
    {
        -1, -1, -1, -1, -1, 1, -1, -1, 2, -1, -1, -1, -1, -1, -1
    };
static const ANTLR3_INT32 dfa19_special[15] =
    {
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
    };

/** Used when there is no transition table entry for a particular state */
#define dfa19_T_empty       NULL

static const ANTLR3_INT32 dfa19_T0[] =
    {
        1, -1, 1, 3, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
    };
static const ANTLR3_INT32 dfa19_T1[] =
    {
        9, 9, 9, 9, 9, 9, 9, 9, 9, 9
    };
static const ANTLR3_INT32 dfa19_T2[] =
    {
        8, -1, -1, -1, -1, -1, -1, -1, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14
    };
static const ANTLR3_INT32 dfa19_T3[] =
    {
        3, -1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
    };
static const ANTLR3_INT32 dfa19_T4[] =
    {
        8, -1, -1, -1, -1, -1, -1, -1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, 12
    };
static const ANTLR3_INT32 dfa19_T5[] =
    {
        14, 14, 14, 14, 14, 14, 14, 14, 14, 14
    };
static const ANTLR3_INT32 dfa19_T6[] =
    {
        8, -1, -1, -1, -1, -1, 3, -1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, 6
    };
static const ANTLR3_INT32 dfa19_T7[] =
    {
        11, 11, 11, 11, 11, 11, 11, 11, 11, 11
    };
static const ANTLR3_INT32 dfa19_T8[] =
    {
        8, -1, -1, -1, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11
    };
static const ANTLR3_INT32 dfa19_T9[] =
    {
        8, -1, -1, -1, -1, -1, 7, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, 6
    };
static const ANTLR3_INT32 dfa19_T10[] =
    {
        10, -1, 10, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11
    };
static const ANTLR3_INT32 dfa19_T11[] =
    {
        13, -1, 13, -1, -1, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14
    };


/* Transition tables are a table of sub tables, with some tables
 * reused for efficiency.
 */
static const ANTLR3_INT32 * const dfa19_transitions[] =
{
    dfa19_T0, dfa19_T3, dfa19_T9, dfa19_T1, dfa19_T6, NULL, dfa19_T10, dfa19_T4,
    NULL, dfa19_T4, dfa19_T7, dfa19_T8, dfa19_T11, dfa19_T5, dfa19_T2
};


/* Declare tracking structure for Cyclic DFA 19
 */
static
ANTLR3_CYCLIC_DFA cdfa19
    =   {
            19,             /* Decision number of this dfa          */
            /* Which decision this represents:   */
            (const pANTLR3_UCHAR)"285:1: NUMERIC : ( NUMBER | ( NUMBER '(' ( UNSIGNED_INTEGER )+ ')' ) );",
            (CDFA_SPECIAL_FUNC) antlr3dfaspecialStateTransition,        /* Default special state transition function    */

            antlr3dfaspecialTransition,         /* DFA specialTransition is currently just a default function in the runtime */
            antlr3dfapredict,                   /* DFA simulator function is in the runtime */
            dfa19_eot,      /* EOT table                            */
            dfa19_eof,      /* EOF table                            */
            dfa19_min,      /* Minimum tokens for each state    */
            dfa19_max,      /* Maximum tokens for each state    */
            dfa19_accept,       /* Accept table                     */
            dfa19_special,      /* Special transition states        */
            dfa19_transitions   /* Table of transition tables       */

        };
/* End of Cyclic DFA 19
 * ---------------------
 *//** Static dfa state tables for Cyclic dfa:
 *    1:1: Tokens : ( T__37 | TAG | LOOP_ | GLOBAL_ | STOP_ | DATA_BLOCK_HEADING | SAVE_FRAME_HEADING | SAVE | NUMERIC | INAPPLICABLE | UNKNOWN | CHAR_STRING | SEMI_COLON_TEXT_FIELD | COMMENTS | NON_BLANK_CHAR | WHITESPACE );
 */
static const ANTLR3_INT32 dfa33_eot[73] =
    {
        -1, -1, 16, 20, 20, 20, 20, 20, 27, 33, 34, 36, -1, 16, 16, -1, -1, -1,
        -1, 20, -1, 20, 20, 20, 20, 27, 20, -1, 27, 20, 27, 20, 27, -1, -1, 48,
        -1, -1, -1, 50, 50, 50, 50, 50, 50, 27, 50, 50, -1, 50, -1, 50, 50, 50,
        50, 50, 27, 27, 63, 50, 65, 66, 50, -1, 50, -1, -1, 70, 71, 72, -1, -1,
        -1
    };
static const ANTLR3_INT32 dfa33_eof[73] =
    {
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1
    };
static const ANTLR3_INT32 dfa33_min[73] =
    {
        9, -1, 33, 79, 76, 65, 65, 46, 33, 33, 33, 9, -1, 9, 9, -1, -1, -1, -1,
        79, -1, 79, 79, 86, 84, 33, 48, -1, 33, 43, 33, 48, 33, -1, -1, 9, 0, -1,
        -1, 80, 66, 80, 69, 65, 48, 33, 43, 41, -1, 95, -1, 65, 95, 95, 95, 48,
        33, 33, 33, 76, 33, 33, 33, -1, 95, -1, -1, 33, 33, 33, -1, -1, -1
    };
static const ANTLR3_INT32 dfa33_max[73] =
    {
        126, -1, 126, 111, 108, 116, 97, 57, 126, 126, 126, 126, -1, 126, 126,
        -1, -1, -1, -1, 111, -1, 111, 111, 118, 116, 126, 57, -1, 126, 57, 126,
        57, 126, -1, -1, 126, 0, -1, -1, 112, 98, 112, 101, 97, 57, 126, 57, 57,
        -1, 95, -1, 97, 95, 95, 95, 57, 126, 126, 126, 108, 126, 126, 126, -1,
        95, -1, -1, 126, 126, 126, -1, -1, -1
    };
static const ANTLR3_INT32 dfa33_accept[73] =
    {
        -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, -1, -1, 14, 15, 16,
        2, -1, 12, -1, -1, -1, -1, -1, -1, 9, -1, -1, -1, -1, -1, 10, 11, -1, -1,
        13, 14, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, -1, 12, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, 5, 8, -1, -1, -1, 7, 6, 4
    };
static const ANTLR3_INT32 dfa33_special[73] =
    {
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2,
        1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1
    };

/** Used when there is no transition table entry for a particular state */
#define dfa33_T_empty       NULL

static const ANTLR3_INT32 dfa33_T0[] =
    {
        47, 47, 47, 47, 47, 47, 47, 47, 47, 47
    };
static const ANTLR3_INT32 dfa33_T1[] =
    {
        50, 50, 50, 50, 50, 50, 50, 31, 50, 50, 50, 50, 50, 50, 50, 56, 56, 56,
        56, 56, 56, 56, 56, 56, 56, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50
    };
static const ANTLR3_INT32 dfa33_T2[] =
    {
        37, 37, -1, -1, 37, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, 37, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
        35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
        35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
        35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
        35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
        35, 35, 35, 35, 35, 35, 35, 35, 35, 35
    };
static const ANTLR3_INT32 dfa33_T3[] =
    {
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50
    };
static const ANTLR3_INT32 dfa33_T4[] =
    {
        39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39
    };
static const ANTLR3_INT32 dfa33_T5[] =
    {
        56, 56, 56, 56, 56, 56, 56, 56, 56, 56
    };
static const ANTLR3_INT32 dfa33_T6[] =
    {
        45, 45, 45, 45, 45, 45, 45, 45, 45, 45
    };
static const ANTLR3_INT32 dfa33_T7[] =
    {
        58
    };
static const ANTLR3_INT32 dfa33_T8[] =
    {
        49, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 49
    };
static const ANTLR3_INT32 dfa33_T9[] =
    {
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 32, 32, 32,
        32, 32, 32, 32, 32, 32, 32, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20
    };
static const ANTLR3_INT32 dfa33_T10[] =
    {
        43, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 43
    };
static const ANTLR3_INT32 dfa33_T11[] =
    {
        62
    };
static const ANTLR3_INT32 dfa33_T12[] =
    {
        26, -1, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25
    };
static const ANTLR3_INT32 dfa33_T13[] =
    {
        54, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 54
    };
static const ANTLR3_INT32 dfa33_T14[] =
    {
        17, 17, -1, 17, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1,
        -1, -1, -1, -1, -1, 17, 12, 14, 15, 16, 12, 12, 13, 12, 12, 12, 7, 12,
        7, 9, 12, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 12, 11, 12, 12, 12, 10, 12, 12,
        12, 12, 6, 12, 12, 4, 12, 12, 12, 12, 3, 12, 12, 12, 12, 12, 12, 5, 12,
        12, 12, 12, 12, 12, 12, 16, 12, 16, 12, 2, 12, 12, 12, 12, 6, 12, 12, 4,
        12, 12, 12, 12, 3, 12, 12, 12, 12, 12, 12, 5, 12, 12, 12, 12, 12, 12, 12,
        12, 12, 12, 12
    };
static const ANTLR3_INT32 dfa33_T15[] =
    {
        44, -1, 44, -1, -1, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45
    };
static const ANTLR3_INT32 dfa33_T16[] =
    {
        55, -1, 55, -1, -1, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56
    };
static const ANTLR3_INT32 dfa33_T17[] =
    {
        20, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20
    };
static const ANTLR3_INT32 dfa33_T18[] =
    {
        68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68,
        68, 68, 68, 68
    };
static const ANTLR3_INT32 dfa33_T19[] =
    {
        -1
    };
static const ANTLR3_INT32 dfa33_T20[] =
    {
        20, 20, 20, 20, 20, 20, 20, 31, 20, 20, 20, 20, 20, 20, 20, 32, 32, 32,
        32, 32, 32, 32, 32, 32, 32, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        46, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 46, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20
    };
static const ANTLR3_INT32 dfa33_T21[] =
    {
        50, 50, 50, 50, 50, 50, 50, 31, 50, 50, 50, 50, 50, 50, 50, 45, 45, 45,
        45, 45, 45, 45, 45, 45, 45, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
        50, 50, 50, 50
    };
static const ANTLR3_INT32 dfa33_T22[] =
    {
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20
    };
static const ANTLR3_INT32 dfa33_T23[] =
    {
        18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
        18, 18, 18, 18
    };
static const ANTLR3_INT32 dfa33_T24[] =
    {
        23, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, 22, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 23, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22
    };
static const ANTLR3_INT32 dfa33_T25[] =
    {
        61
    };
static const ANTLR3_INT32 dfa33_T26[] =
    {
        20, 20, 20, 20, 20, 20, 20, 31, 20, 20, 20, 20, 20, 30, 20, 28, 28, 28,
        28, 28, 28, 28, 28, 28, 28, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        29, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 29, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20
    };
static const ANTLR3_INT32 dfa33_T27[] =
    {
        19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 19
    };
static const ANTLR3_INT32 dfa33_T28[] =
    {
        57, -1, -1, -1, -1, -1, -1, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47
    };
static const ANTLR3_INT32 dfa33_T29[] =
    {
        24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 24
    };
static const ANTLR3_INT32 dfa33_T30[] =
    {
        69
    };
static const ANTLR3_INT32 dfa33_T31[] =
    {
        32, 32, 32, 32, 32, 32, 32, 32, 32, 32
    };
static const ANTLR3_INT32 dfa33_T32[] =
    {
        64, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 64
    };
static const ANTLR3_INT32 dfa33_T33[] =
    {
        59, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 59
    };
static const ANTLR3_INT32 dfa33_T34[] =
    {
        51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 51
    };
static const ANTLR3_INT32 dfa33_T35[] =
    {
        40, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 40
    };
static const ANTLR3_INT32 dfa33_T36[] =
    {
        67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
        67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
        67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
        67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
        67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67,
        67, 67, 67, 67
    };
static const ANTLR3_INT32 dfa33_T37[] =
    {
        60
    };
static const ANTLR3_INT32 dfa33_T38[] =
    {
        52, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 52
    };
static const ANTLR3_INT32 dfa33_T39[] =
    {
        53, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 53
    };
static const ANTLR3_INT32 dfa33_T40[] =
    {
        41, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 41
    };
static const ANTLR3_INT32 dfa33_T41[] =
    {
        20, 20, 20, 20, 20, 20, 20, 31, 20, 20, 20, 20, 20, 26, 20, 25, 25, 25,
        25, 25, 25, 25, 25, 25, 25, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        29, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 29, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20
    };
static const ANTLR3_INT32 dfa33_T42[] =
    {
        21, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 21
    };
static const ANTLR3_INT32 dfa33_T43[] =
    {
        42, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 42
    };


/* Transition tables are a table of sub tables, with some tables
 * reused for efficiency.
 */
static const ANTLR3_INT32 * const dfa33_transitions[] =
{
    dfa33_T14, NULL, dfa33_T23, dfa33_T27, dfa33_T42, dfa33_T24, dfa33_T29,
    dfa33_T12, dfa33_T26, dfa33_T9, dfa33_T22, dfa33_T2, NULL, dfa33_T17,
    dfa33_T17, NULL, NULL, NULL, NULL, dfa33_T4, NULL, dfa33_T35, dfa33_T40,
    dfa33_T43, dfa33_T10, dfa33_T41, dfa33_T31, NULL, dfa33_T26, dfa33_T15,
    dfa33_T20, dfa33_T0, dfa33_T20, NULL, NULL, dfa33_T2, dfa33_T19, NULL,
    NULL, dfa33_T8, dfa33_T34, dfa33_T38, dfa33_T39, dfa33_T13, dfa33_T6,
    dfa33_T21, dfa33_T16, dfa33_T28, NULL, dfa33_T7, NULL, dfa33_T33, dfa33_T37,
    dfa33_T25, dfa33_T11, dfa33_T5, dfa33_T1, dfa33_T3, dfa33_T3, dfa33_T32,
    dfa33_T3, dfa33_T36, dfa33_T18, NULL, dfa33_T30, NULL, NULL, dfa33_T36,
    dfa33_T18, dfa33_T3, NULL, NULL, NULL
};

static ANTLR3_INT32 dfa33_sst(pcifLexer ctx, pANTLR3_BASE_RECOGNIZER recognizer, pANTLR3_INT_STREAM is, pANTLR3_CYCLIC_DFA dfa, ANTLR3_INT32 s)
{
    ANTLR3_INT32    _s;

    _s      = s;
    switch  (s)
    {
        case 0:

        {
            ANTLR3_UINT32 LA33_11;

            ANTLR3_MARKER index33_11;


                LA33_11 = LA(1);


                index33_11 = INDEX();

                REWINDLAST();

            s = -1;
            if ( (((( GETCHARPOSITIONINLINE() > 0 ))||(( GETCHARPOSITIONINLINE() == 0 )))) && (((LA33_11 >= '!') && (LA33_11 <= '~'))) )
            {
                s = 35;
            }

            else if ( (( GETCHARPOSITIONINLINE() == 0 )) && (((LA33_11 >= '\t') && (LA33_11 <= '\n')) || LA33_11 == '\r' || LA33_11 == ' ') )
            {
                s = 37;
            }

            else s = 36;


                        SEEK(index33_11);

            if ( s>=0 )
            {
                return s;
            }
        }
        break;
        case 1:

        {
            ANTLR3_UINT32 LA33_36;

            ANTLR3_MARKER index33_36;


                LA33_36 = LA(1);


                index33_36 = INDEX();

                REWINDLAST();

            s = -1;
            if ( (( GETCHARPOSITIONINLINE() > 0 )) )
            {
                s = 48;
            }

            else if ( (ANTLR3_TRUE) )
            {
                s = 16;
            }


                        SEEK(index33_36);

            if ( s>=0 )
            {
                return s;
            }
        }
        break;
        case 2:

        {
            ANTLR3_UINT32 LA33_35;

            ANTLR3_MARKER index33_35;


                LA33_35 = LA(1);


                index33_35 = INDEX();

                REWINDLAST();

            s = -1;
            if ( (((( GETCHARPOSITIONINLINE() > 0 ))||(( GETCHARPOSITIONINLINE() == 0 )))) && (((LA33_35 >= '!') && (LA33_35 <= '~'))) )
            {
                s = 35;
            }

            else if ( (( GETCHARPOSITIONINLINE() == 0 )) && (((LA33_35 >= '\t') && (LA33_35 <= '\n')) || LA33_35 == '\r' || LA33_35 == ' ') )
            {
                s = 37;
            }

            else s = 48;


                        SEEK(index33_35);

            if ( s>=0 )
            {
                return s;
            }
        }
        break;
    }
    if (BACKTRACKING > 0)
    {
        FAILEDFLAG = ANTLR3_TRUE;
        return  -1;
    }

    CONSTRUCTEX();
    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
    EXCEPTION->message      = (void *)"1:1: Tokens : ( T__37 | TAG | LOOP_ | GLOBAL_ | STOP_ | DATA_BLOCK_HEADING | SAVE_FRAME_HEADING | SAVE | NUMERIC | INAPPLICABLE | UNKNOWN | CHAR_STRING | SEMI_COLON_TEXT_FIELD | COMMENTS | NON_BLANK_CHAR | WHITESPACE );";
    EXCEPTION->decisionNum  = 33;
    EXCEPTION->state        = _s;
    return -1;
}


/* Declare tracking structure for Cyclic DFA 33
 */
static
ANTLR3_CYCLIC_DFA cdfa33
    =   {
            33,             /* Decision number of this dfa          */
            /* Which decision this represents:   */
            (const pANTLR3_UCHAR)"1:1: Tokens : ( T__37 | TAG | LOOP_ | GLOBAL_ | STOP_ | DATA_BLOCK_HEADING | SAVE_FRAME_HEADING | SAVE | NUMERIC | INAPPLICABLE | UNKNOWN | CHAR_STRING | SEMI_COLON_TEXT_FIELD | COMMENTS | NON_BLANK_CHAR | WHITESPACE );",
            (CDFA_SPECIAL_FUNC) dfa33_sst,
            antlr3dfaspecialTransition,         /* DFA specialTransition is currently just a default function in the runtime */
            antlr3dfapredict,                   /* DFA simulator function is in the runtime */
            dfa33_eot,      /* EOT table                            */
            dfa33_eof,      /* EOF table                            */
            dfa33_min,      /* Minimum tokens for each state    */
            dfa33_max,      /* Maximum tokens for each state    */
            dfa33_accept,       /* Accept table                     */
            dfa33_special,      /* Special transition states        */
            dfa33_transitions   /* Table of transition tables       */

        };
/* End of Cyclic DFA 33
 * ---------------------
 */
/* =========================================================================
 * End of DFA tables for the lexer
 */

/* =========================================================================
 * Functions to match the lexer grammar defined tokens from the input stream
 */

//   Comes from: 17:7: ( '\\u001a' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start T__37
 *
 * Looks to match the characters the constitute the token T__37
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mT__37(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = T__37;


    // cif.g:17:7: ( '\\u001a' )
    // cif.g:17:9: '\\u001a'
    {
        MATCHC(0x001a);
        if  (HASEXCEPTION())
        {
            goto ruleT__37Ex;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleT__37Ex; /* Prevent compiler warnings */
    ruleT__37Ex: ;

}
// $ANTLR end T__37

//   Comes from: 203:3: ( ( '\\n' | '\\r' | '\\r\\n' ) )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start EOL
 *
 * Looks to match the characters the constitute the token EOL
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mEOL(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:203:3: ( ( '\\n' | '\\r' | '\\r\\n' ) )
    // cif.g:203:5: ( '\\n' | '\\r' | '\\r\\n' )
    {
        // cif.g:203:5: ( '\\n' | '\\r' | '\\r\\n' )
        {
            int alt1=3;
            switch ( LA(1) )
            {
            case '\n':
                {
                        alt1=1;
                }
                break;
            case '\r':
                {
                        switch ( LA(2) )
                        {
                        case '\n':
                                {
                                        alt1=3;
                                }
                            break;

                        default:
                            alt1=2;
                        }

                }
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleEOLEx;

            }

            switch (alt1)
            {
                case 1:
                    // cif.g:203:7: '\\n'
                    {
                        MATCHC('\n');
                        if  (HASEXCEPTION())
                        {
                            goto ruleEOLEx;
                        }
                        if (HASFAILED())
                        {
                            return ;
                        }


                    }
                    break;
                case 2:
                    // cif.g:203:14: '\\r'
                    {
                        MATCHC('\r');
                        if  (HASEXCEPTION())
                        {
                            goto ruleEOLEx;
                        }
                        if (HASFAILED())
                        {
                            return ;
                        }


                    }
                    break;
                case 3:
                    // cif.g:203:21: '\\r\\n'
                    {
                        MATCHS(lit_1);
                        if  (HASEXCEPTION())
                        {
                            goto ruleEOLEx;
                        }
                        if (HASFAILED())
                        {
                            return ;
                        }




                    }
                    break;

            }
        }

    }


    // This is where rules clean up and exit
    //
    goto ruleEOLEx; /* Prevent compiler warnings */
    ruleEOLEx: ;

}
// $ANTLR end EOL

//   Comes from: 206:3: ( '\"' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start DOUBLE_QUOTE
 *
 * Looks to match the characters the constitute the token DOUBLE_QUOTE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mDOUBLE_QUOTE(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:206:3: ( '\"' )
    // cif.g:206:5: '\"'
    {
        MATCHC('"');
        if  (HASEXCEPTION())
        {
            goto ruleDOUBLE_QUOTEEx;
        }
        if (HASFAILED())
        {
            return ;
        }


    }


    // This is where rules clean up and exit
    //
    goto ruleDOUBLE_QUOTEEx; /* Prevent compiler warnings */
    ruleDOUBLE_QUOTEEx: ;

}
// $ANTLR end DOUBLE_QUOTE

//   Comes from: 209:3: ( '\\'' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start SINGLE_QUOTE
 *
 * Looks to match the characters the constitute the token SINGLE_QUOTE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mSINGLE_QUOTE(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:209:3: ( '\\'' )
    // cif.g:209:5: '\\''
    {
        MATCHC('\'');
        if  (HASEXCEPTION())
        {
            goto ruleSINGLE_QUOTEEx;
        }
        if (HASFAILED())
        {
            return ;
        }


    }


    // This is where rules clean up and exit
    //
    goto ruleSINGLE_QUOTEEx; /* Prevent compiler warnings */
    ruleSINGLE_QUOTEEx: ;

}
// $ANTLR end SINGLE_QUOTE

//   Comes from: 212:3: ( '!' | '%' | '&' | '(' | ')' | '*' | '+' | ',' | '-' | '.' | '/' | ( '0' .. '9' ) | ':' | '<' | '=' | '>' | '?' | '@' | ( 'A' .. 'Z' ) | ( 'a' .. 'z' ) | '\\\\' | '^' | '`' | '{' | '|' | '}' | '~' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start ORDINARY_CHAR
 *
 * Looks to match the characters the constitute the token ORDINARY_CHAR
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mORDINARY_CHAR(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:212:3: ( '!' | '%' | '&' | '(' | ')' | '*' | '+' | ',' | '-' | '.' | '/' | ( '0' .. '9' ) | ':' | '<' | '=' | '>' | '?' | '@' | ( 'A' .. 'Z' ) | ( 'a' .. 'z' ) | '\\\\' | '^' | '`' | '{' | '|' | '}' | '~' )
    // cif.g:
    {
        if ( LA(1) == '!' || ((LA(1) >= '%') && (LA(1) <= '&')) || ((LA(1) >= '(') && (LA(1) <= ':')) || ((LA(1) >= '<') && (LA(1) <= 'Z')) || LA(1) == '\\' || LA(1) == '^' || ((LA(1) >= '`') && (LA(1) <= '~')) )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleORDINARY_CHAREx;
        }


    }


    // This is where rules clean up and exit
    //
    goto ruleORDINARY_CHAREx; /* Prevent compiler warnings */
    ruleORDINARY_CHAREx: ;

}
// $ANTLR end ORDINARY_CHAR

//   Comes from: 219:3: ( ORDINARY_CHAR | DOUBLE_QUOTE | SINGLE_QUOTE | '#' | '$' | '_' | '[' | ']' | ';' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start NON_BLANK_CHAR_
 *
 * Looks to match the characters the constitute the token NON_BLANK_CHAR_
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mNON_BLANK_CHAR_(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:219:3: ( ORDINARY_CHAR | DOUBLE_QUOTE | SINGLE_QUOTE | '#' | '$' | '_' | '[' | ']' | ';' )
    // cif.g:
    {
        if ( ((LA(1) >= '!') && (LA(1) <= '~')) )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleNON_BLANK_CHAR_Ex;
        }


    }


    // This is where rules clean up and exit
    //
    goto ruleNON_BLANK_CHAR_Ex; /* Prevent compiler warnings */
    ruleNON_BLANK_CHAR_Ex: ;

}
// $ANTLR end NON_BLANK_CHAR_

//   Comes from: 222:3: ( ORDINARY_CHAR | DOUBLE_QUOTE | SINGLE_QUOTE | '#' | '$' | '_' | '[' | ']' | ' ' | '\\t' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start TEXT_LEAD_CHAR
 *
 * Looks to match the characters the constitute the token TEXT_LEAD_CHAR
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mTEXT_LEAD_CHAR(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:222:3: ( ORDINARY_CHAR | DOUBLE_QUOTE | SINGLE_QUOTE | '#' | '$' | '_' | '[' | ']' | ' ' | '\\t' )
    // cif.g:
    {
        if ( LA(1) == '\t' || ((LA(1) >= ' ') && (LA(1) <= ':')) || ((LA(1) >= '<') && (LA(1) <= '~')) )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleTEXT_LEAD_CHAREx;
        }


    }


    // This is where rules clean up and exit
    //
    goto ruleTEXT_LEAD_CHAREx; /* Prevent compiler warnings */
    ruleTEXT_LEAD_CHAREx: ;

}
// $ANTLR end TEXT_LEAD_CHAR

//   Comes from: 225:3: ( ORDINARY_CHAR | '#' | '$' | '_' | '[' | ']' | ' ' | '\\t' | ';' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start ANY_PRINT_CHAR
 *
 * Looks to match the characters the constitute the token ANY_PRINT_CHAR
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mANY_PRINT_CHAR(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:225:3: ( ORDINARY_CHAR | '#' | '$' | '_' | '[' | ']' | ' ' | '\\t' | ';' )
    // cif.g:
    {
        if ( LA(1) == '\t' || ((LA(1) >= ' ') && (LA(1) <= '!')) || ((LA(1) >= '#') && (LA(1) <= '&')) || ((LA(1) >= '(') && (LA(1) <= '~')) )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleANY_PRINT_CHAREx;
        }


    }


    // This is where rules clean up and exit
    //
    goto ruleANY_PRINT_CHAREx; /* Prevent compiler warnings */
    ruleANY_PRINT_CHAREx: ;

}
// $ANTLR end ANY_PRINT_CHAR

//   Comes from: 231:5: ( '_' ( NON_BLANK_CHAR_ )+ )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start TAG
 *
 * Looks to match the characters the constitute the token TAG
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mTAG(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = TAG;


    // cif.g:231:5: ( '_' ( NON_BLANK_CHAR_ )+ )
    // cif.g:231:7: '_' ( NON_BLANK_CHAR_ )+
    {
        MATCHC('_');
        if  (HASEXCEPTION())
        {
            goto ruleTAGEx;
        }
        if (HASFAILED())
        {
            return ;
        }


        // cif.g:231:11: ( NON_BLANK_CHAR_ )+
        {
            int cnt2=0;

            for (;;)
            {
                int alt2=2;
                switch ( LA(1) )
                {
                case '!':
                case '"':
                case '#':
                case '$':
                case '%':
                case '&':
                case '\'':
                case '(':
                case ')':
                case '*':
                case '+':
                case ',':
                case '-':
                case '.':
                case '/':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ':':
                case ';':
                case '<':
                case '=':
                case '>':
                case '?':
                case '@':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case '_':
                case '`':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                case '{':
                case '|':
                case '}':
                case '~':
                        {
                                alt2=1;
                        }
                    break;

                }

                switch (alt2)
                {
                    case 1:
                        // cif.g:
                        {
                            if ( ((LA(1) >= '!') && (LA(1) <= '~')) )
                            {
                                CONSUME();
                                FAILEDFLAG=ANTLR3_FALSE;

                            }
                            else
                            {
                                if (BACKTRACKING>0)
                                {
                                    FAILEDFLAG = ANTLR3_TRUE;
                                    return ;
                                }

                                CONSTRUCTEX();
                                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                LRECOVER();
                                goto ruleTAGEx;
                            }


                        }
                        break;

                    default:

                        if ( cnt2 >= 1 )
                        {
                            goto loop2;
                        }
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return ;
                        }

                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto ruleTAGEx;
                }
                cnt2++;
            }
            loop2: ;    /* Jump to here if this rule does not match */
        }

    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleTAGEx; /* Prevent compiler warnings */
    ruleTAGEx: ;

}
// $ANTLR end TAG

//   Comes from: 240:7: ( ( 'D' | 'd' ) ( 'A' | 'a' ) ( 'T' | 't' ) ( 'A' | 'a' ) '_' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start DATA_
 *
 * Looks to match the characters the constitute the token DATA_
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mDATA_(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:240:7: ( ( 'D' | 'd' ) ( 'A' | 'a' ) ( 'T' | 't' ) ( 'A' | 'a' ) '_' )
    // cif.g:240:9: ( 'D' | 'd' ) ( 'A' | 'a' ) ( 'T' | 't' ) ( 'A' | 'a' ) '_'
    {
        if ( LA(1) == 'D' || LA(1) == 'd' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleDATA_Ex;
        }


        if ( LA(1) == 'A' || LA(1) == 'a' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleDATA_Ex;
        }


        if ( LA(1) == 'T' || LA(1) == 't' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleDATA_Ex;
        }


        if ( LA(1) == 'A' || LA(1) == 'a' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleDATA_Ex;
        }


        MATCHC('_');
        if  (HASEXCEPTION())
        {
            goto ruleDATA_Ex;
        }
        if (HASFAILED())
        {
            return ;
        }


    }


    // This is where rules clean up and exit
    //
    goto ruleDATA_Ex; /* Prevent compiler warnings */
    ruleDATA_Ex: ;

}
// $ANTLR end DATA_

//   Comes from: 243:7: ( ( 'S' | 's' ) ( 'A' | 'a' ) ( 'V' | 'v' ) ( 'E' | 'e' ) '_' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start SAVE_
 *
 * Looks to match the characters the constitute the token SAVE_
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mSAVE_(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:243:7: ( ( 'S' | 's' ) ( 'A' | 'a' ) ( 'V' | 'v' ) ( 'E' | 'e' ) '_' )
    // cif.g:243:9: ( 'S' | 's' ) ( 'A' | 'a' ) ( 'V' | 'v' ) ( 'E' | 'e' ) '_'
    {
        if ( LA(1) == 'S' || LA(1) == 's' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleSAVE_Ex;
        }


        if ( LA(1) == 'A' || LA(1) == 'a' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleSAVE_Ex;
        }


        if ( LA(1) == 'V' || LA(1) == 'v' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleSAVE_Ex;
        }


        if ( LA(1) == 'E' || LA(1) == 'e' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleSAVE_Ex;
        }


        MATCHC('_');
        if  (HASEXCEPTION())
        {
            goto ruleSAVE_Ex;
        }
        if (HASFAILED())
        {
            return ;
        }


    }


    // This is where rules clean up and exit
    //
    goto ruleSAVE_Ex; /* Prevent compiler warnings */
    ruleSAVE_Ex: ;

}
// $ANTLR end SAVE_

//   Comes from: 244:8: ( ( 'L' | 'l' ) ( 'O' | 'o' ) ( 'O' | 'o' ) ( 'P' | 'p' ) '_' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start LOOP_
 *
 * Looks to match the characters the constitute the token LOOP_
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mLOOP_(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = LOOP_;


    // cif.g:244:8: ( ( 'L' | 'l' ) ( 'O' | 'o' ) ( 'O' | 'o' ) ( 'P' | 'p' ) '_' )
    // cif.g:244:10: ( 'L' | 'l' ) ( 'O' | 'o' ) ( 'O' | 'o' ) ( 'P' | 'p' ) '_'
    {
        if ( LA(1) == 'L' || LA(1) == 'l' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleLOOP_Ex;
        }


        if ( LA(1) == 'O' || LA(1) == 'o' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleLOOP_Ex;
        }


        if ( LA(1) == 'O' || LA(1) == 'o' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleLOOP_Ex;
        }


        if ( LA(1) == 'P' || LA(1) == 'p' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleLOOP_Ex;
        }


        MATCHC('_');
        if  (HASEXCEPTION())
        {
            goto ruleLOOP_Ex;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleLOOP_Ex; /* Prevent compiler warnings */
    ruleLOOP_Ex: ;

}
// $ANTLR end LOOP_

//   Comes from: 246:9: ( ( 'G' | 'g' ) ( 'L' | 'l' ) ( 'O' | 'o' ) ( 'B' | 'b' ) ( 'A' | 'a' ) ( 'L' | 'l' ) '_' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start GLOBAL_
 *
 * Looks to match the characters the constitute the token GLOBAL_
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mGLOBAL_(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = GLOBAL_;


    // cif.g:246:9: ( ( 'G' | 'g' ) ( 'L' | 'l' ) ( 'O' | 'o' ) ( 'B' | 'b' ) ( 'A' | 'a' ) ( 'L' | 'l' ) '_' )
    // cif.g:246:11: ( 'G' | 'g' ) ( 'L' | 'l' ) ( 'O' | 'o' ) ( 'B' | 'b' ) ( 'A' | 'a' ) ( 'L' | 'l' ) '_'
    {
        if ( LA(1) == 'G' || LA(1) == 'g' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleGLOBAL_Ex;
        }


        if ( LA(1) == 'L' || LA(1) == 'l' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleGLOBAL_Ex;
        }


        if ( LA(1) == 'O' || LA(1) == 'o' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleGLOBAL_Ex;
        }


        if ( LA(1) == 'B' || LA(1) == 'b' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleGLOBAL_Ex;
        }


        if ( LA(1) == 'A' || LA(1) == 'a' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleGLOBAL_Ex;
        }


        if ( LA(1) == 'L' || LA(1) == 'l' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleGLOBAL_Ex;
        }


        MATCHC('_');
        if  (HASEXCEPTION())
        {
            goto ruleGLOBAL_Ex;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleGLOBAL_Ex; /* Prevent compiler warnings */
    ruleGLOBAL_Ex: ;

}
// $ANTLR end GLOBAL_

//   Comes from: 248:7: ( ( 'S' | 's' ) ( 'T' | 't' ) ( 'O' | 'o' ) ( 'P' | 'p' ) '_' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start STOP_
 *
 * Looks to match the characters the constitute the token STOP_
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mSTOP_(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = STOP_;


    // cif.g:248:7: ( ( 'S' | 's' ) ( 'T' | 't' ) ( 'O' | 'o' ) ( 'P' | 'p' ) '_' )
    // cif.g:248:9: ( 'S' | 's' ) ( 'T' | 't' ) ( 'O' | 'o' ) ( 'P' | 'p' ) '_'
    {
        if ( LA(1) == 'S' || LA(1) == 's' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleSTOP_Ex;
        }


        if ( LA(1) == 'T' || LA(1) == 't' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleSTOP_Ex;
        }


        if ( LA(1) == 'O' || LA(1) == 'o' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleSTOP_Ex;
        }


        if ( LA(1) == 'P' || LA(1) == 'p' )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleSTOP_Ex;
        }


        MATCHC('_');
        if  (HASEXCEPTION())
        {
            goto ruleSTOP_Ex;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleSTOP_Ex; /* Prevent compiler warnings */
    ruleSTOP_Ex: ;

}
// $ANTLR end STOP_

//   Comes from: 257:3: ( DATA_ ( NON_BLANK_CHAR )+ )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start DATA_BLOCK_HEADING
 *
 * Looks to match the characters the constitute the token DATA_BLOCK_HEADING
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mDATA_BLOCK_HEADING(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = DATA_BLOCK_HEADING;


    // cif.g:257:3: ( DATA_ ( NON_BLANK_CHAR )+ )
    // cif.g:257:5: DATA_ ( NON_BLANK_CHAR )+
    {
        /* 257:5: DATA_ ( NON_BLANK_CHAR )+ */
        mDATA_(ctx );
        if  (HASEXCEPTION())
        {
            goto ruleDATA_BLOCK_HEADINGEx;
        }
        if (HASFAILED())
        {
            return ;
        }



        // cif.g:257:11: ( NON_BLANK_CHAR )+
        {
            int cnt3=0;

            for (;;)
            {
                int alt3=2;
                switch ( LA(1) )
                {
                case '!':
                case '"':
                case '#':
                case '$':
                case '%':
                case '&':
                case '\'':
                case '(':
                case ')':
                case '*':
                case '+':
                case ',':
                case '-':
                case '.':
                case '/':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ':':
                case ';':
                case '<':
                case '=':
                case '>':
                case '?':
                case '@':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case '_':
                case '`':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                case '{':
                case '|':
                case '}':
                case '~':
                        {
                                alt3=1;
                        }
                    break;

                }

                switch (alt3)
                {
                    case 1:
                        // cif.g:
                        {
                            if ( ((LA(1) >= '!') && (LA(1) <= '~')) )
                            {
                                CONSUME();
                                FAILEDFLAG=ANTLR3_FALSE;

                            }
                            else
                            {
                                if (BACKTRACKING>0)
                                {
                                    FAILEDFLAG = ANTLR3_TRUE;
                                    return ;
                                }

                                CONSTRUCTEX();
                                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                LRECOVER();
                                goto ruleDATA_BLOCK_HEADINGEx;
                            }


                        }
                        break;

                    default:

                        if ( cnt3 >= 1 )
                        {
                            goto loop3;
                        }
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return ;
                        }

                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto ruleDATA_BLOCK_HEADINGEx;
                }
                cnt3++;
            }
            loop3: ;    /* Jump to here if this rule does not match */
        }

    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleDATA_BLOCK_HEADINGEx; /* Prevent compiler warnings */
    ruleDATA_BLOCK_HEADINGEx: ;

}
// $ANTLR end DATA_BLOCK_HEADING

//   Comes from: 260:3: ( SAVE_ ( NON_BLANK_CHAR )+ )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start SAVE_FRAME_HEADING
 *
 * Looks to match the characters the constitute the token SAVE_FRAME_HEADING
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mSAVE_FRAME_HEADING(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = SAVE_FRAME_HEADING;


    // cif.g:260:3: ( SAVE_ ( NON_BLANK_CHAR )+ )
    // cif.g:260:5: SAVE_ ( NON_BLANK_CHAR )+
    {
        /* 260:5: SAVE_ ( NON_BLANK_CHAR )+ */
        mSAVE_(ctx );
        if  (HASEXCEPTION())
        {
            goto ruleSAVE_FRAME_HEADINGEx;
        }
        if (HASFAILED())
        {
            return ;
        }



        // cif.g:260:11: ( NON_BLANK_CHAR )+
        {
            int cnt4=0;

            for (;;)
            {
                int alt4=2;
                switch ( LA(1) )
                {
                case '!':
                case '"':
                case '#':
                case '$':
                case '%':
                case '&':
                case '\'':
                case '(':
                case ')':
                case '*':
                case '+':
                case ',':
                case '-':
                case '.':
                case '/':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ':':
                case ';':
                case '<':
                case '=':
                case '>':
                case '?':
                case '@':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case '_':
                case '`':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                case '{':
                case '|':
                case '}':
                case '~':
                        {
                                alt4=1;
                        }
                    break;

                }

                switch (alt4)
                {
                    case 1:
                        // cif.g:
                        {
                            if ( ((LA(1) >= '!') && (LA(1) <= '~')) )
                            {
                                CONSUME();
                                FAILEDFLAG=ANTLR3_FALSE;

                            }
                            else
                            {
                                if (BACKTRACKING>0)
                                {
                                    FAILEDFLAG = ANTLR3_TRUE;
                                    return ;
                                }

                                CONSTRUCTEX();
                                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                LRECOVER();
                                goto ruleSAVE_FRAME_HEADINGEx;
                            }


                        }
                        break;

                    default:

                        if ( cnt4 >= 1 )
                        {
                            goto loop4;
                        }
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return ;
                        }

                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto ruleSAVE_FRAME_HEADINGEx;
                }
                cnt4++;
            }
            loop4: ;    /* Jump to here if this rule does not match */
        }

    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleSAVE_FRAME_HEADINGEx; /* Prevent compiler warnings */
    ruleSAVE_FRAME_HEADINGEx: ;

}
// $ANTLR end SAVE_FRAME_HEADING

//   Comes from: 262:6: ( SAVE_ )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start SAVE
 *
 * Looks to match the characters the constitute the token SAVE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mSAVE(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = SAVE;


    // cif.g:262:6: ( SAVE_ )
    // cif.g:262:8: SAVE_
    {
        /* 262:8: SAVE_ */
        mSAVE_(ctx );
        if  (HASEXCEPTION())
        {
            goto ruleSAVEEx;
        }
        if (HASFAILED())
        {
            return ;
        }



    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleSAVEEx; /* Prevent compiler warnings */
    ruleSAVEEx: ;

}
// $ANTLR end SAVE

//   Comes from: 268:16: ( '0' .. '9' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start DIGIT
 *
 * Looks to match the characters the constitute the token DIGIT
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mDIGIT(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:268:16: ( '0' .. '9' )
    // cif.g:
    {
        if ( ((LA(1) >= '0') && (LA(1) <= '9')) )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleDIGITEx;
        }


    }


    // This is where rules clean up and exit
    //
    goto ruleDIGITEx; /* Prevent compiler warnings */
    ruleDIGITEx: ;

}
// $ANTLR end DIGIT

//   Comes from: 271:3: ( ( ( 'e' | 'E' ) | ( 'e' | 'E' ) ( '+' | '-' ) ) ( DIGIT )+ )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start EXPONENT
 *
 * Looks to match the characters the constitute the token EXPONENT
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mEXPONENT(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:271:3: ( ( ( 'e' | 'E' ) | ( 'e' | 'E' ) ( '+' | '-' ) ) ( DIGIT )+ )
    // cif.g:271:6: ( ( 'e' | 'E' ) | ( 'e' | 'E' ) ( '+' | '-' ) ) ( DIGIT )+
    {
        // cif.g:271:6: ( ( 'e' | 'E' ) | ( 'e' | 'E' ) ( '+' | '-' ) )
        {
            int alt5=2;
            switch ( LA(1) )
            {
            case 'E':
            case 'e':
                {
                        switch ( LA(2) )
                        {
                        case '+':
                        case '-':
                                {
                                        alt5=2;
                                }
                            break;
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                                {
                                        alt5=1;
                                }
                            break;

                        default:
                            if (BACKTRACKING>0)
                            {
                                FAILEDFLAG = ANTLR3_TRUE;
                                return ;
                            }

                            CONSTRUCTEX();
                            EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                            EXCEPTION->message      = (void *)"";
                            EXCEPTION->decisionNum  = 5;
                            EXCEPTION->state        = 1;


                            goto ruleEXPONENTEx;

                        }

                }
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 5;
                EXCEPTION->state        = 0;


                goto ruleEXPONENTEx;

            }

            switch (alt5)
            {
                case 1:
                    // cif.g:271:8: ( 'e' | 'E' )
                    {
                        if ( LA(1) == 'E' || LA(1) == 'e' )
                        {
                            CONSUME();
                            FAILEDFLAG=ANTLR3_FALSE;

                        }
                        else
                        {
                            if (BACKTRACKING>0)
                            {
                                FAILEDFLAG = ANTLR3_TRUE;
                                return ;
                            }

                            CONSTRUCTEX();
                            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                            LRECOVER();
                            goto ruleEXPONENTEx;
                        }


                    }
                    break;
                case 2:
                    // cif.g:271:23: ( 'e' | 'E' ) ( '+' | '-' )
                    {
                        if ( LA(1) == 'E' || LA(1) == 'e' )
                        {
                            CONSUME();
                            FAILEDFLAG=ANTLR3_FALSE;

                        }
                        else
                        {
                            if (BACKTRACKING>0)
                            {
                                FAILEDFLAG = ANTLR3_TRUE;
                                return ;
                            }

                            CONSTRUCTEX();
                            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                            LRECOVER();
                            goto ruleEXPONENTEx;
                        }


                        if ( LA(1) == '+' || LA(1) == '-' )
                        {
                            CONSUME();
                            FAILEDFLAG=ANTLR3_FALSE;

                        }
                        else
                        {
                            if (BACKTRACKING>0)
                            {
                                FAILEDFLAG = ANTLR3_TRUE;
                                return ;
                            }

                            CONSTRUCTEX();
                            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                            LRECOVER();
                            goto ruleEXPONENTEx;
                        }


                    }
                    break;

            }
        }

        // cif.g:271:51: ( DIGIT )+
        {
            int cnt6=0;

            for (;;)
            {
                int alt6=2;
                switch ( LA(1) )
                {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                        {
                                alt6=1;
                        }
                    break;

                }

                switch (alt6)
                {
                    case 1:
                        // cif.g:
                        {
                            if ( ((LA(1) >= '0') && (LA(1) <= '9')) )
                            {
                                CONSUME();
                                FAILEDFLAG=ANTLR3_FALSE;

                            }
                            else
                            {
                                if (BACKTRACKING>0)
                                {
                                    FAILEDFLAG = ANTLR3_TRUE;
                                    return ;
                                }

                                CONSTRUCTEX();
                                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                LRECOVER();
                                goto ruleEXPONENTEx;
                            }


                        }
                        break;

                    default:

                        if ( cnt6 >= 1 )
                        {
                            goto loop6;
                        }
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return ;
                        }

                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto ruleEXPONENTEx;
                }
                cnt6++;
            }
            loop6: ;    /* Jump to here if this rule does not match */
        }

    }


    // This is where rules clean up and exit
    //
    goto ruleEXPONENTEx; /* Prevent compiler warnings */
    ruleEXPONENTEx: ;

}
// $ANTLR end EXPONENT

//   Comes from: 274:3: ( ( '+' | '-' )? ( DIGIT )+ )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start INTEGER
 *
 * Looks to match the characters the constitute the token INTEGER
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mINTEGER(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:274:3: ( ( '+' | '-' )? ( DIGIT )+ )
    // cif.g:274:6: ( '+' | '-' )? ( DIGIT )+
    {
        // cif.g:274:6: ( '+' | '-' )?
        {
            int alt7=2;
            switch ( LA(1) )
            {
                case '+':
                case '-':
                        {
                                alt7=1;
                        }
                    break;
            }

            switch (alt7)
            {
                case 1:
                    // cif.g:
                    {
                        if ( LA(1) == '+' || LA(1) == '-' )
                        {
                            CONSUME();
                            FAILEDFLAG=ANTLR3_FALSE;

                        }
                        else
                        {
                            if (BACKTRACKING>0)
                            {
                                FAILEDFLAG = ANTLR3_TRUE;
                                return ;
                            }

                            CONSTRUCTEX();
                            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                            LRECOVER();
                            goto ruleINTEGEREx;
                        }


                    }
                    break;

            }
        }

        // cif.g:274:21: ( DIGIT )+
        {
            int cnt8=0;

            for (;;)
            {
                int alt8=2;
                switch ( LA(1) )
                {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                        {
                                alt8=1;
                        }
                    break;

                }

                switch (alt8)
                {
                    case 1:
                        // cif.g:
                        {
                            if ( ((LA(1) >= '0') && (LA(1) <= '9')) )
                            {
                                CONSUME();
                                FAILEDFLAG=ANTLR3_FALSE;

                            }
                            else
                            {
                                if (BACKTRACKING>0)
                                {
                                    FAILEDFLAG = ANTLR3_TRUE;
                                    return ;
                                }

                                CONSTRUCTEX();
                                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                LRECOVER();
                                goto ruleINTEGEREx;
                            }


                        }
                        break;

                    default:

                        if ( cnt8 >= 1 )
                        {
                            goto loop8;
                        }
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return ;
                        }

                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto ruleINTEGEREx;
                }
                cnt8++;
            }
            loop8: ;    /* Jump to here if this rule does not match */
        }

    }


    // This is where rules clean up and exit
    //
    goto ruleINTEGEREx; /* Prevent compiler warnings */
    ruleINTEGEREx: ;

}
// $ANTLR end INTEGER

//   Comes from: 277:3: ( INTEGER EXPONENT | ( ( '+' | '-' )? ( ( DIGIT )* '.' ( DIGIT )+ ) | ( DIGIT )+ '.' ) ( EXPONENT )? )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start FLOAT
 *
 * Looks to match the characters the constitute the token FLOAT
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mFLOAT(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    {
        //  cif.g:277:3: ( INTEGER EXPONENT | ( ( '+' | '-' )? ( ( DIGIT )* '.' ( DIGIT )+ ) | ( DIGIT )+ '.' ) ( EXPONENT )? )

        ANTLR3_UINT32 alt15;

        alt15=2;

        alt15 = cdfa15.predict(ctx, RECOGNIZER, ISTREAM, &cdfa15);
        if  (HASEXCEPTION())
        {
            goto ruleFLOATEx;
        }
        if (HASFAILED())
        {
            return ;
        }

        switch (alt15)
        {
        case 1:
            // cif.g:277:6: INTEGER EXPONENT
            {
                /* 277:6: INTEGER EXPONENT */
                mINTEGER(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleFLOATEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



                /* 277:6: INTEGER EXPONENT */
                mEXPONENT(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleFLOATEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 2:
            // cif.g:277:25: ( ( '+' | '-' )? ( ( DIGIT )* '.' ( DIGIT )+ ) | ( DIGIT )+ '.' ) ( EXPONENT )?
            {
                // cif.g:277:25: ( ( '+' | '-' )? ( ( DIGIT )* '.' ( DIGIT )+ ) | ( DIGIT )+ '.' )
                {
                    int alt13=2;
                    alt13 = cdfa13.predict(ctx, RECOGNIZER, ISTREAM, &cdfa13);
                    if  (HASEXCEPTION())
                    {
                        goto ruleFLOATEx;
                    }
                    if (HASFAILED())
                    {
                        return ;
                    }

                    switch (alt13)
                    {
                        case 1:
                            // cif.g:277:27: ( '+' | '-' )? ( ( DIGIT )* '.' ( DIGIT )+ )
                            {
                                // cif.g:277:27: ( '+' | '-' )?
                                {
                                    int alt9=2;
                                    switch ( LA(1) )
                                    {
                                        case '+':
                                        case '-':
                                                {
                                                        alt9=1;
                                                }
                                            break;
                                    }

                                    switch (alt9)
                                    {
                                        case 1:
                                            // cif.g:
                                            {
                                                if ( LA(1) == '+' || LA(1) == '-' )
                                                {
                                                    CONSUME();
                                                    FAILEDFLAG=ANTLR3_FALSE;

                                                }
                                                else
                                                {
                                                    if (BACKTRACKING>0)
                                                    {
                                                        FAILEDFLAG = ANTLR3_TRUE;
                                                        return ;
                                                    }

                                                    CONSTRUCTEX();
                                                    EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                                    EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                                    LRECOVER();
                                                    goto ruleFLOATEx;
                                                }


                                            }
                                            break;

                                    }
                                }

                                // cif.g:277:42: ( ( DIGIT )* '.' ( DIGIT )+ )
                                // cif.g:277:44: ( DIGIT )* '.' ( DIGIT )+
                                {
                                    // cif.g:277:44: ( DIGIT )*

                                    for (;;)
                                    {
                                        int alt10=2;
                                        switch ( LA(1) )
                                        {
                                        case '0':
                                        case '1':
                                        case '2':
                                        case '3':
                                        case '4':
                                        case '5':
                                        case '6':
                                        case '7':
                                        case '8':
                                        case '9':
                                                {
                                                        alt10=1;
                                                }
                                            break;

                                        }

                                        switch (alt10)
                                        {
                                        case 1:
                                            // cif.g:
                                            {
                                                if ( ((LA(1) >= '0') && (LA(1) <= '9')) )
                                                {
                                                    CONSUME();
                                                    FAILEDFLAG=ANTLR3_FALSE;

                                                }
                                                else
                                                {
                                                    if (BACKTRACKING>0)
                                                    {
                                                        FAILEDFLAG = ANTLR3_TRUE;
                                                        return ;
                                                    }

                                                    CONSTRUCTEX();
                                                    EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                                    EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                                    LRECOVER();
                                                    goto ruleFLOATEx;
                                                }


                                            }
                                            break;

                                        default:
                                            goto loop10;        /* break out of the loop */
                                            break;
                                        }
                                    }
                                    loop10: ; /* Jump out to here if this rule does not match */


                                    MATCHC('.');
                                    if  (HASEXCEPTION())
                                    {
                                        goto ruleFLOATEx;
                                    }
                                    if (HASFAILED())
                                    {
                                        return ;
                                    }


                                    // cif.g:277:57: ( DIGIT )+
                                    {
                                        int cnt11=0;

                                        for (;;)
                                        {
                                            int alt11=2;
                                        switch ( LA(1) )
                                        {
                                        case '0':
                                        case '1':
                                        case '2':
                                        case '3':
                                        case '4':
                                        case '5':
                                        case '6':
                                        case '7':
                                        case '8':
                                        case '9':
                                                {
                                                        alt11=1;
                                                }
                                            break;

                                        }

                                        switch (alt11)
                                        {
                                            case 1:
                                                // cif.g:
                                                {
                                                    if ( ((LA(1) >= '0') && (LA(1) <= '9')) )
                                                    {
                                                        CONSUME();
                                                        FAILEDFLAG=ANTLR3_FALSE;

                                                    }
                                                    else
                                                    {
                                                        if (BACKTRACKING>0)
                                                        {
                                                            FAILEDFLAG = ANTLR3_TRUE;
                                                            return ;
                                                        }

                                                        CONSTRUCTEX();
                                                        EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                                        EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                                        LRECOVER();
                                                        goto ruleFLOATEx;
                                                    }


                                                }
                                                break;

                                            default:

                                                if ( cnt11 >= 1 )
                                                {
                                                    goto loop11;
                                                }
                                                if (BACKTRACKING>0)
                                                {
                                                    FAILEDFLAG = ANTLR3_TRUE;
                                                    return ;
                                                }

                                                /* mismatchedSetEx()
                                                 */
                                                CONSTRUCTEX();
                                                EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                                                EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                                                goto ruleFLOATEx;
                                        }
                                        cnt11++;
                                        }
                                        loop11: ;       /* Jump to here if this rule does not match */
                                    }

                                }


                            }
                            break;
                        case 2:
                            // cif.g:277:69: ( DIGIT )+ '.'
                            {
                                // cif.g:277:69: ( DIGIT )+
                                {
                                    int cnt12=0;

                                    for (;;)
                                    {
                                        int alt12=2;
                                        switch ( LA(1) )
                                        {
                                        case '0':
                                        case '1':
                                        case '2':
                                        case '3':
                                        case '4':
                                        case '5':
                                        case '6':
                                        case '7':
                                        case '8':
                                        case '9':
                                                {
                                                        alt12=1;
                                                }
                                            break;

                                        }

                                        switch (alt12)
                                        {
                                            case 1:
                                                // cif.g:
                                                {
                                                    if ( ((LA(1) >= '0') && (LA(1) <= '9')) )
                                                    {
                                                        CONSUME();
                                                        FAILEDFLAG=ANTLR3_FALSE;

                                                    }
                                                    else
                                                    {
                                                        if (BACKTRACKING>0)
                                                        {
                                                            FAILEDFLAG = ANTLR3_TRUE;
                                                            return ;
                                                        }

                                                        CONSTRUCTEX();
                                                        EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                                        EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                                        LRECOVER();
                                                        goto ruleFLOATEx;
                                                    }


                                                }
                                                break;

                                            default:

                                                if ( cnt12 >= 1 )
                                                {
                                                    goto loop12;
                                                }
                                                if (BACKTRACKING>0)
                                                {
                                                    FAILEDFLAG = ANTLR3_TRUE;
                                                    return ;
                                                }

                                                /* mismatchedSetEx()
                                                 */
                                                CONSTRUCTEX();
                                                EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                                                EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                                                goto ruleFLOATEx;
                                        }
                                        cnt12++;
                                    }
                                    loop12: ;   /* Jump to here if this rule does not match */
                                }

                                MATCHC('.');
                                if  (HASEXCEPTION())
                                {
                                    goto ruleFLOATEx;
                                }
                                if (HASFAILED())
                                {
                                    return ;
                                }


                            }
                            break;

                    }
                }

                // cif.g:277:84: ( EXPONENT )?
                {
                    int alt14=2;
                    switch ( LA(1) )
                    {
                        case 'E':
                        case 'e':
                                {
                                        alt14=1;
                                }
                            break;
                    }

                    switch (alt14)
                    {
                        case 1:
                            // cif.g:277:85: EXPONENT
                            {
                                /* 277:85: EXPONENT */
                                mEXPONENT(ctx );
                                if  (HASEXCEPTION())
                                {
                                    goto ruleFLOATEx;
                                }
                                if (HASFAILED())
                                {
                                    return ;
                                }



                            }
                            break;

                    }
                }

            }
            break;

        }
    }

    // This is where rules clean up and exit
    //
    goto ruleFLOATEx; /* Prevent compiler warnings */
    ruleFLOATEx: ;

}
// $ANTLR end FLOAT

//   Comes from: 280:3: ( ( DIGIT )+ )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start UNSIGNED_INTEGER
 *
 * Looks to match the characters the constitute the token UNSIGNED_INTEGER
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mUNSIGNED_INTEGER(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:280:3: ( ( DIGIT )+ )
    // cif.g:280:5: ( DIGIT )+
    {
        // cif.g:280:5: ( DIGIT )+
        {
            int cnt16=0;

            for (;;)
            {
                int alt16=2;
                switch ( LA(1) )
                {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                        {
                                alt16=1;
                        }
                    break;

                }

                switch (alt16)
                {
                    case 1:
                        // cif.g:
                        {
                            if ( ((LA(1) >= '0') && (LA(1) <= '9')) )
                            {
                                CONSUME();
                                FAILEDFLAG=ANTLR3_FALSE;

                            }
                            else
                            {
                                if (BACKTRACKING>0)
                                {
                                    FAILEDFLAG = ANTLR3_TRUE;
                                    return ;
                                }

                                CONSTRUCTEX();
                                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                LRECOVER();
                                goto ruleUNSIGNED_INTEGEREx;
                            }


                        }
                        break;

                    default:

                        if ( cnt16 >= 1 )
                        {
                            goto loop16;
                        }
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return ;
                        }

                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto ruleUNSIGNED_INTEGEREx;
                }
                cnt16++;
            }
            loop16: ;   /* Jump to here if this rule does not match */
        }

    }


    // This is where rules clean up and exit
    //
    goto ruleUNSIGNED_INTEGEREx; /* Prevent compiler warnings */
    ruleUNSIGNED_INTEGEREx: ;

}
// $ANTLR end UNSIGNED_INTEGER

//   Comes from: 283:3: ( INTEGER | FLOAT )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start NUMBER
 *
 * Looks to match the characters the constitute the token NUMBER
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mNUMBER(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    {
        //  cif.g:283:3: ( INTEGER | FLOAT )

        ANTLR3_UINT32 alt17;

        alt17=2;

        alt17 = cdfa17.predict(ctx, RECOGNIZER, ISTREAM, &cdfa17);
        if  (HASEXCEPTION())
        {
            goto ruleNUMBEREx;
        }
        if (HASFAILED())
        {
            return ;
        }

        switch (alt17)
        {
        case 1:
            // cif.g:283:5: INTEGER
            {
                /* 283:5: INTEGER */
                mINTEGER(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleNUMBEREx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 2:
            // cif.g:283:15: FLOAT
            {
                /* 283:15: FLOAT */
                mFLOAT(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleNUMBEREx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;

        }
    }

    // This is where rules clean up and exit
    //
    goto ruleNUMBEREx; /* Prevent compiler warnings */
    ruleNUMBEREx: ;

}
// $ANTLR end NUMBER

//   Comes from: 285:9: ( NUMBER | ( NUMBER '(' ( UNSIGNED_INTEGER )+ ')' ) )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start NUMERIC
 *
 * Looks to match the characters the constitute the token NUMERIC
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mNUMERIC(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = NUMERIC;


    {
        //  cif.g:285:9: ( NUMBER | ( NUMBER '(' ( UNSIGNED_INTEGER )+ ')' ) )

        ANTLR3_UINT32 alt19;

        alt19=2;

        alt19 = cdfa19.predict(ctx, RECOGNIZER, ISTREAM, &cdfa19);
        if  (HASEXCEPTION())
        {
            goto ruleNUMERICEx;
        }
        if (HASFAILED())
        {
            return ;
        }

        switch (alt19)
        {
        case 1:
            // cif.g:285:11: NUMBER
            {
                /* 285:11: NUMBER */
                mNUMBER(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleNUMERICEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 2:
            // cif.g:285:20: ( NUMBER '(' ( UNSIGNED_INTEGER )+ ')' )
            {
                // cif.g:285:20: ( NUMBER '(' ( UNSIGNED_INTEGER )+ ')' )
                // cif.g:285:22: NUMBER '(' ( UNSIGNED_INTEGER )+ ')'
                {
                    /* 285:22: NUMBER '(' ( UNSIGNED_INTEGER )+ ')' */
                    mNUMBER(ctx );
                    if  (HASEXCEPTION())
                    {
                        goto ruleNUMERICEx;
                    }
                    if (HASFAILED())
                    {
                        return ;
                    }



                    MATCHC('(');
                    if  (HASEXCEPTION())
                    {
                        goto ruleNUMERICEx;
                    }
                    if (HASFAILED())
                    {
                        return ;
                    }


                    // cif.g:285:33: ( UNSIGNED_INTEGER )+
                    {
                        int cnt18=0;

                        for (;;)
                        {
                            int alt18=2;
                        switch ( LA(1) )
                        {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                                {
                                        alt18=1;
                                }
                            break;

                        }

                        switch (alt18)
                        {
                            case 1:
                                // cif.g:285:34: UNSIGNED_INTEGER
                                {
                                    /* 285:34: UNSIGNED_INTEGER */
                                    mUNSIGNED_INTEGER(ctx );
                                    if  (HASEXCEPTION())
                                    {
                                        goto ruleNUMERICEx;
                                    }
                                    if (HASFAILED())
                                    {
                                        return ;
                                    }



                                }
                                break;

                            default:

                                if ( cnt18 >= 1 )
                                {
                                    goto loop18;
                                }
                                if (BACKTRACKING>0)
                                {
                                    FAILEDFLAG = ANTLR3_TRUE;
                                    return ;
                                }

                                /* mismatchedSetEx()
                                 */
                                CONSTRUCTEX();
                                EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                                EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                                goto ruleNUMERICEx;
                        }
                        cnt18++;
                        }
                        loop18: ;       /* Jump to here if this rule does not match */
                    }

                    MATCHC(')');
                    if  (HASEXCEPTION())
                    {
                        goto ruleNUMERICEx;
                    }
                    if (HASFAILED())
                    {
                        return ;
                    }


                }


            }
            break;

        }
    }
        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleNUMERICEx; /* Prevent compiler warnings */
    ruleNUMERICEx: ;

}
// $ANTLR end NUMERIC

//   Comes from: 292:3: ( '.' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start INAPPLICABLE
 *
 * Looks to match the characters the constitute the token INAPPLICABLE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mINAPPLICABLE(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = INAPPLICABLE;


    // cif.g:292:3: ( '.' )
    // cif.g:292:5: '.'
    {
        MATCHC('.');
        if  (HASEXCEPTION())
        {
            goto ruleINAPPLICABLEEx;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleINAPPLICABLEEx; /* Prevent compiler warnings */
    ruleINAPPLICABLEEx: ;

}
// $ANTLR end INAPPLICABLE

//   Comes from: 294:9: ( '?' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start UNKNOWN
 *
 * Looks to match the characters the constitute the token UNKNOWN
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mUNKNOWN(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = UNKNOWN;


    // cif.g:294:9: ( '?' )
    // cif.g:294:11: '?'
    {
        MATCHC('?');
        if  (HASEXCEPTION())
        {
            goto ruleUNKNOWNEx;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleUNKNOWNEx; /* Prevent compiler warnings */
    ruleUNKNOWNEx: ;

}
// $ANTLR end UNKNOWN

//   Comes from: 298:3: ( ( ({...}? => ';' ) | ORDINARY_CHAR ) ( NON_BLANK_CHAR_ )* )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start UNQUOTED_STRING
 *
 * Looks to match the characters the constitute the token UNQUOTED_STRING
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mUNQUOTED_STRING(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:298:3: ( ( ({...}? => ';' ) | ORDINARY_CHAR ) ( NON_BLANK_CHAR_ )* )
    // cif.g:298:5: ( ({...}? => ';' ) | ORDINARY_CHAR ) ( NON_BLANK_CHAR_ )*
    {
        // cif.g:298:5: ( ({...}? => ';' ) | ORDINARY_CHAR )
        {
            int alt20=2;
            {
                int LA20_0 = LA(1);
                if ( (( GETCHARPOSITIONINLINE() > 0 )) && (LA20_0 == ';'))
                {
                    alt20=1;
                }
                else if ( (LA20_0 == '!' || ((LA20_0 >= '%') && (LA20_0 <= '&')) || ((LA20_0 >= '(') && (LA20_0 <= ':')) || ((LA20_0 >= '<') && (LA20_0 <= 'Z')) || LA20_0 == '\\' || LA20_0 == '^' || ((LA20_0 >= '`') && (LA20_0 <= '~'))))
                {
                    alt20=2;
                }
                else
                {
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }


                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 20;
                    EXCEPTION->state        = 0;


                    goto ruleUNQUOTED_STRINGEx;

                }
            }
            switch (alt20)
            {
                case 1:
                    // cif.g:298:6: ({...}? => ';' )
                    {
                        // cif.g:298:6: ({...}? => ';' )
                        // cif.g:298:7: {...}? => ';'
                        {
                            if ( !(( GETCHARPOSITIONINLINE() > 0 )) )
                            {
                                if (BACKTRACKING>0)
                                {
                                    FAILEDFLAG = ANTLR3_TRUE;
                                    return ;
                                }

                                    CONSTRUCTEX();
                                    EXCEPTION->type         = ANTLR3_FAILED_PREDICATE_EXCEPTION;
                                    EXCEPTION->message      = (void *)" GETCHARPOSITIONINLINE() > 0 ";
                                    EXCEPTION->ruleName  = (void *)"UNQUOTED_STRING";


                            }

                            MATCHC(';');
                            if  (HASEXCEPTION())
                            {
                                goto ruleUNQUOTED_STRINGEx;
                            }
                            if (HASFAILED())
                            {
                                return ;
                            }


                        }


                    }
                    break;
                case 2:
                    // cif.g:299:7: ORDINARY_CHAR
                    {
                        /* 299:7: ORDINARY_CHAR */
                        mORDINARY_CHAR(ctx );
                        if  (HASEXCEPTION())
                        {
                            goto ruleUNQUOTED_STRINGEx;
                        }
                        if (HASFAILED())
                        {
                            return ;
                        }



                    }
                    break;

            }
        }

        // cif.g:299:23: ( NON_BLANK_CHAR_ )*

        for (;;)
        {
            int alt21=2;
            switch ( LA(1) )
            {
            case '!':
            case '"':
            case '#':
            case '$':
            case '%':
            case '&':
            case '\'':
            case '(':
            case ')':
            case '*':
            case '+':
            case ',':
            case '-':
            case '.':
            case '/':
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case ':':
            case ';':
            case '<':
            case '=':
            case '>':
            case '?':
            case '@':
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'H':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
            case '[':
            case '\\':
            case ']':
            case '^':
            case '_':
            case '`':
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':
            case '{':
            case '|':
            case '}':
            case '~':
                {
                        alt21=1;
                }
                break;

            }

            switch (alt21)
            {
                case 1:
                    // cif.g:
                    {
                        if ( ((LA(1) >= '!') && (LA(1) <= '~')) )
                        {
                            CONSUME();
                            FAILEDFLAG=ANTLR3_FALSE;

                        }
                        else
                        {
                            if (BACKTRACKING>0)
                            {
                                FAILEDFLAG = ANTLR3_TRUE;
                                return ;
                            }

                            CONSTRUCTEX();
                            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                            LRECOVER();
                            goto ruleUNQUOTED_STRINGEx;
                        }


                    }
                    break;

                default:
                    goto loop21;        /* break out of the loop */
                    break;
            }
        }
        loop21: ; /* Jump out to here if this rule does not match */


    }


    // This is where rules clean up and exit
    //
    goto ruleUNQUOTED_STRINGEx; /* Prevent compiler warnings */
    ruleUNQUOTED_STRINGEx: ;

}
// $ANTLR end UNQUOTED_STRING

//   Comes from: 303:3: ( SINGLE_QUOTE ( ( ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE ) | ANY_PRINT_CHAR | DOUBLE_QUOTE )* SINGLE_QUOTE )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start SINGLE_QUOTED_STRING
 *
 * Looks to match the characters the constitute the token SINGLE_QUOTED_STRING
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mSINGLE_QUOTED_STRING(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:303:3: ( SINGLE_QUOTE ( ( ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE ) | ANY_PRINT_CHAR | DOUBLE_QUOTE )* SINGLE_QUOTE )
    // cif.g:303:5: SINGLE_QUOTE ( ( ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE ) | ANY_PRINT_CHAR | DOUBLE_QUOTE )* SINGLE_QUOTE
    {
        /* 303:5: SINGLE_QUOTE ( ( ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE ) | ANY_PRINT_CHAR | DOUBLE_QUOTE )* SINGLE_QUOTE */
        mSINGLE_QUOTE(ctx );
        if  (HASEXCEPTION())
        {
            goto ruleSINGLE_QUOTED_STRINGEx;
        }
        if (HASFAILED())
        {
            return ;
        }



        // cif.g:304:5: ( ( ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE ) | ANY_PRINT_CHAR | DOUBLE_QUOTE )*

        for (;;)
        {
            int alt22=4;
            switch ( LA(1) )
            {
            case '\'':
                {
                        {
                           /* dfaLoopbackState(k,edges,eotPredictsAlt,description,stateNumber,semPredState)
                            */
                            int LA22_1 = LA(2);
                            if ( (synpred1_cif(ctx)) && (LA22_1 == '\''))
                            {
                                alt22=1;
                            }
                            else if ( (synpred1_cif(ctx)) && (LA22_1 == '\t' || ((LA22_1 >= ' ') && (LA22_1 <= '!')) || ((LA22_1 >= '#') && (LA22_1 <= '&')) || ((LA22_1 >= '(') && (LA22_1 <= '~'))))
                            {
                                alt22=1;
                            }
                            else if ( (synpred1_cif(ctx)) && (LA22_1 == '"'))
                            {
                                alt22=1;
                            }

                        }
                }
                break;
            case '\t':
            case ' ':
            case '!':
            case '#':
            case '$':
            case '%':
            case '&':
            case '(':
            case ')':
            case '*':
            case '+':
            case ',':
            case '-':
            case '.':
            case '/':
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case ':':
            case ';':
            case '<':
            case '=':
            case '>':
            case '?':
            case '@':
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'H':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
            case '[':
            case '\\':
            case ']':
            case '^':
            case '_':
            case '`':
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':
            case '{':
            case '|':
            case '}':
            case '~':
                {
                        alt22=2;
                }
                break;
            case '"':
                {
                        alt22=3;
                }
                break;

            }

            switch (alt22)
            {
                case 1:
                    // cif.g:304:7: ( ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE )
                    {
                        // cif.g:304:7: ( ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE )
                        // cif.g:304:9: ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE
                        {
                            /* 304:9: ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE */
                            mSINGLE_QUOTE(ctx );
                            if  (HASEXCEPTION())
                            {
                                goto ruleSINGLE_QUOTED_STRINGEx;
                            }
                            if (HASFAILED())
                            {
                                return ;
                            }



                        }


                    }
                    break;
                case 2:
                    // cif.g:304:58: ANY_PRINT_CHAR
                    {
                        /* 304:58: ANY_PRINT_CHAR */
                        mANY_PRINT_CHAR(ctx );
                        if  (HASEXCEPTION())
                        {
                            goto ruleSINGLE_QUOTED_STRINGEx;
                        }
                        if (HASFAILED())
                        {
                            return ;
                        }



                    }
                    break;
                case 3:
                    // cif.g:304:75: DOUBLE_QUOTE
                    {
                        /* 304:75: DOUBLE_QUOTE */
                        mDOUBLE_QUOTE(ctx );
                        if  (HASEXCEPTION())
                        {
                            goto ruleSINGLE_QUOTED_STRINGEx;
                        }
                        if (HASFAILED())
                        {
                            return ;
                        }



                    }
                    break;

                default:
                    goto loop22;        /* break out of the loop */
                    break;
            }
        }
        loop22: ; /* Jump out to here if this rule does not match */


        /* 303:5: SINGLE_QUOTE ( ( ( SINGLE_QUOTE NON_BLANK_CHAR_ )=> SINGLE_QUOTE ) | ANY_PRINT_CHAR | DOUBLE_QUOTE )* SINGLE_QUOTE */
        mSINGLE_QUOTE(ctx );
        if  (HASEXCEPTION())
        {
            goto ruleSINGLE_QUOTED_STRINGEx;
        }
        if (HASFAILED())
        {
            return ;
        }



    }


    // This is where rules clean up and exit
    //
    goto ruleSINGLE_QUOTED_STRINGEx; /* Prevent compiler warnings */
    ruleSINGLE_QUOTED_STRINGEx: ;

}
// $ANTLR end SINGLE_QUOTED_STRING

//   Comes from: 309:3: ( DOUBLE_QUOTE ( ( ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE ) | ANY_PRINT_CHAR | SINGLE_QUOTE )* DOUBLE_QUOTE )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start DOUBLE_QUOTED_STRING
 *
 * Looks to match the characters the constitute the token DOUBLE_QUOTED_STRING
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mDOUBLE_QUOTED_STRING(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;


    // cif.g:309:3: ( DOUBLE_QUOTE ( ( ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE ) | ANY_PRINT_CHAR | SINGLE_QUOTE )* DOUBLE_QUOTE )
    // cif.g:309:5: DOUBLE_QUOTE ( ( ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE ) | ANY_PRINT_CHAR | SINGLE_QUOTE )* DOUBLE_QUOTE
    {
        /* 309:5: DOUBLE_QUOTE ( ( ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE ) | ANY_PRINT_CHAR | SINGLE_QUOTE )* DOUBLE_QUOTE */
        mDOUBLE_QUOTE(ctx );
        if  (HASEXCEPTION())
        {
            goto ruleDOUBLE_QUOTED_STRINGEx;
        }
        if (HASFAILED())
        {
            return ;
        }



        // cif.g:310:5: ( ( ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE ) | ANY_PRINT_CHAR | SINGLE_QUOTE )*

        for (;;)
        {
            int alt23=4;
            switch ( LA(1) )
            {
            case '"':
                {
                        {
                           /* dfaLoopbackState(k,edges,eotPredictsAlt,description,stateNumber,semPredState)
                            */
                            int LA23_1 = LA(2);
                            if ( (synpred2_cif(ctx)) && (LA23_1 == '"'))
                            {
                                alt23=1;
                            }
                            else if ( (synpred2_cif(ctx)) && (LA23_1 == '\t' || ((LA23_1 >= ' ') && (LA23_1 <= '!')) || ((LA23_1 >= '#') && (LA23_1 <= '&')) || ((LA23_1 >= '(') && (LA23_1 <= '~'))))
                            {
                                alt23=1;
                            }
                            else if ( (synpred2_cif(ctx)) && (LA23_1 == '\''))
                            {
                                alt23=1;
                            }

                        }
                }
                break;
            case '\t':
            case ' ':
            case '!':
            case '#':
            case '$':
            case '%':
            case '&':
            case '(':
            case ')':
            case '*':
            case '+':
            case ',':
            case '-':
            case '.':
            case '/':
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
            case ':':
            case ';':
            case '<':
            case '=':
            case '>':
            case '?':
            case '@':
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'H':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
            case '[':
            case '\\':
            case ']':
            case '^':
            case '_':
            case '`':
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':
            case '{':
            case '|':
            case '}':
            case '~':
                {
                        alt23=2;
                }
                break;
            case '\'':
                {
                        alt23=3;
                }
                break;

            }

            switch (alt23)
            {
                case 1:
                    // cif.g:310:7: ( ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE )
                    {
                        // cif.g:310:7: ( ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE )
                        // cif.g:310:9: ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE
                        {
                            /* 310:9: ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE */
                            mDOUBLE_QUOTE(ctx );
                            if  (HASEXCEPTION())
                            {
                                goto ruleDOUBLE_QUOTED_STRINGEx;
                            }
                            if (HASFAILED())
                            {
                                return ;
                            }



                        }


                    }
                    break;
                case 2:
                    // cif.g:310:58: ANY_PRINT_CHAR
                    {
                        /* 310:58: ANY_PRINT_CHAR */
                        mANY_PRINT_CHAR(ctx );
                        if  (HASEXCEPTION())
                        {
                            goto ruleDOUBLE_QUOTED_STRINGEx;
                        }
                        if (HASFAILED())
                        {
                            return ;
                        }



                    }
                    break;
                case 3:
                    // cif.g:310:75: SINGLE_QUOTE
                    {
                        /* 310:75: SINGLE_QUOTE */
                        mSINGLE_QUOTE(ctx );
                        if  (HASEXCEPTION())
                        {
                            goto ruleDOUBLE_QUOTED_STRINGEx;
                        }
                        if (HASFAILED())
                        {
                            return ;
                        }



                    }
                    break;

                default:
                    goto loop23;        /* break out of the loop */
                    break;
            }
        }
        loop23: ; /* Jump out to here if this rule does not match */


        /* 309:5: DOUBLE_QUOTE ( ( ( DOUBLE_QUOTE NON_BLANK_CHAR_ )=> DOUBLE_QUOTE ) | ANY_PRINT_CHAR | SINGLE_QUOTE )* DOUBLE_QUOTE */
        mDOUBLE_QUOTE(ctx );
        if  (HASEXCEPTION())
        {
            goto ruleDOUBLE_QUOTED_STRINGEx;
        }
        if (HASFAILED())
        {
            return ;
        }



    }


    // This is where rules clean up and exit
    //
    goto ruleDOUBLE_QUOTED_STRINGEx; /* Prevent compiler warnings */
    ruleDOUBLE_QUOTED_STRINGEx: ;

}
// $ANTLR end DOUBLE_QUOTED_STRING

//   Comes from: 315:3: ( UNQUOTED_STRING | SINGLE_QUOTED_STRING | DOUBLE_QUOTED_STRING )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start CHAR_STRING
 *
 * Looks to match the characters the constitute the token CHAR_STRING
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mCHAR_STRING(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = CHAR_STRING;


    {
        //  cif.g:315:3: ( UNQUOTED_STRING | SINGLE_QUOTED_STRING | DOUBLE_QUOTED_STRING )

        ANTLR3_UINT32 alt24;

        alt24=3;

        {
            int LA24_0 = LA(1);
            if ( (( GETCHARPOSITIONINLINE() > 0 )) && (LA24_0 == ';'))
            {
                alt24=1;
            }
            else if ( (LA24_0 == '!' || ((LA24_0 >= '%') && (LA24_0 <= '&')) || ((LA24_0 >= '(') && (LA24_0 <= ':')) || ((LA24_0 >= '<') && (LA24_0 <= 'Z')) || LA24_0 == '\\' || LA24_0 == '^' || ((LA24_0 >= '`') && (LA24_0 <= '~'))))
            {
                alt24=1;
            }
            else if ( (LA24_0 == '\''))
            {
                alt24=2;
            }
            else if ( (LA24_0 == '"'))
            {
                alt24=3;
            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }


                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 24;
                EXCEPTION->state        = 0;


                goto ruleCHAR_STRINGEx;

            }
        }
        switch (alt24)
        {
        case 1:
            // cif.g:315:5: UNQUOTED_STRING
            {
                /* 315:5: UNQUOTED_STRING */
                mUNQUOTED_STRING(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleCHAR_STRINGEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 2:
            // cif.g:315:23: SINGLE_QUOTED_STRING
            {
                /* 315:23: SINGLE_QUOTED_STRING */
                mSINGLE_QUOTED_STRING(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleCHAR_STRINGEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 3:
            // cif.g:315:46: DOUBLE_QUOTED_STRING
            {
                /* 315:46: DOUBLE_QUOTED_STRING */
                mDOUBLE_QUOTED_STRING(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleCHAR_STRINGEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;

        }
    }
        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleCHAR_STRINGEx; /* Prevent compiler warnings */
    ruleCHAR_STRINGEx: ;

}
// $ANTLR end CHAR_STRING

//   Comes from: 318:3: ( ({...}? => ';' ) ( ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* EOL ( ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )? EOL )* ) ';' )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start SEMI_COLON_TEXT_FIELD
 *
 * Looks to match the characters the constitute the token SEMI_COLON_TEXT_FIELD
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mSEMI_COLON_TEXT_FIELD(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = SEMI_COLON_TEXT_FIELD;


    // cif.g:318:3: ( ({...}? => ';' ) ( ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* EOL ( ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )? EOL )* ) ';' )
    // cif.g:318:5: ({...}? => ';' ) ( ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* EOL ( ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )? EOL )* ) ';'
    {
        // cif.g:318:5: ({...}? => ';' )
        // cif.g:318:7: {...}? => ';'
        {
            if ( !(( GETCHARPOSITIONINLINE() == 0 )) )
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_FAILED_PREDICATE_EXCEPTION;
                    EXCEPTION->message      = (void *)" GETCHARPOSITIONINLINE() == 0 ";
                    EXCEPTION->ruleName  = (void *)"SEMI_COLON_TEXT_FIELD";


            }

            MATCHC(';');
            if  (HASEXCEPTION())
            {
                goto ruleSEMI_COLON_TEXT_FIELDEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }


        // cif.g:319:5: ( ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* EOL ( ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )? EOL )* )
        // cif.g:319:7: ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* EOL ( ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )? EOL )*
        {
            // cif.g:319:7: ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )*

            for (;;)
            {
                int alt25=2;
                switch ( LA(1) )
                {
                case '\t':
                case ' ':
                case '!':
                case '"':
                case '#':
                case '$':
                case '%':
                case '&':
                case '\'':
                case '(':
                case ')':
                case '*':
                case '+':
                case ',':
                case '-':
                case '.':
                case '/':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ':':
                case ';':
                case '<':
                case '=':
                case '>':
                case '?':
                case '@':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case '_':
                case '`':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                case '{':
                case '|':
                case '}':
                case '~':
                        {
                                alt25=1;
                        }
                    break;

                }

                switch (alt25)
                {
                case 1:
                    // cif.g:
                    {
                        if ( LA(1) == '\t' || ((LA(1) >= ' ') && (LA(1) <= '~')) )
                        {
                            CONSUME();
                            FAILEDFLAG=ANTLR3_FALSE;

                        }
                        else
                        {
                            if (BACKTRACKING>0)
                            {
                                FAILEDFLAG = ANTLR3_TRUE;
                                return ;
                            }

                            CONSTRUCTEX();
                            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                            LRECOVER();
                            goto ruleSEMI_COLON_TEXT_FIELDEx;
                        }


                    }
                    break;

                default:
                    goto loop25;        /* break out of the loop */
                    break;
                }
            }
            loop25: ; /* Jump out to here if this rule does not match */


            /* 319:7: ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* EOL ( ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )? EOL )* */
            mEOL(ctx );
            if  (HASEXCEPTION())
            {
                goto ruleSEMI_COLON_TEXT_FIELDEx;
            }
            if (HASFAILED())
            {
                return ;
            }



            // cif.g:320:5: ( ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )? EOL )*

            for (;;)
            {
                int alt28=2;
                switch ( LA(1) )
                {
                case '\t':
                case '\n':
                case '\r':
                case ' ':
                case '!':
                case '"':
                case '#':
                case '$':
                case '%':
                case '&':
                case '\'':
                case '(':
                case ')':
                case '*':
                case '+':
                case ',':
                case '-':
                case '.':
                case '/':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case ':':
                case '<':
                case '=':
                case '>':
                case '?':
                case '@':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case '_':
                case '`':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                case '{':
                case '|':
                case '}':
                case '~':
                        {
                                alt28=1;
                        }
                    break;

                }

                switch (alt28)
                {
                case 1:
                    // cif.g:320:7: ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )? EOL
                    {
                        // cif.g:320:7: ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )?
                        {
                            int alt27=2;
                            switch ( LA(1) )
                            {
                                case '\t':
                                case ' ':
                                case '!':
                                case '"':
                                case '#':
                                case '$':
                                case '%':
                                case '&':
                                case '\'':
                                case '(':
                                case ')':
                                case '*':
                                case '+':
                                case ',':
                                case '-':
                                case '.':
                                case '/':
                                case '0':
                                case '1':
                                case '2':
                                case '3':
                                case '4':
                                case '5':
                                case '6':
                                case '7':
                                case '8':
                                case '9':
                                case ':':
                                case '<':
                                case '=':
                                case '>':
                                case '?':
                                case '@':
                                case 'A':
                                case 'B':
                                case 'C':
                                case 'D':
                                case 'E':
                                case 'F':
                                case 'G':
                                case 'H':
                                case 'I':
                                case 'J':
                                case 'K':
                                case 'L':
                                case 'M':
                                case 'N':
                                case 'O':
                                case 'P':
                                case 'Q':
                                case 'R':
                                case 'S':
                                case 'T':
                                case 'U':
                                case 'V':
                                case 'W':
                                case 'X':
                                case 'Y':
                                case 'Z':
                                case '[':
                                case '\\':
                                case ']':
                                case '^':
                                case '_':
                                case '`':
                                case 'a':
                                case 'b':
                                case 'c':
                                case 'd':
                                case 'e':
                                case 'f':
                                case 'g':
                                case 'h':
                                case 'i':
                                case 'j':
                                case 'k':
                                case 'l':
                                case 'm':
                                case 'n':
                                case 'o':
                                case 'p':
                                case 'q':
                                case 'r':
                                case 's':
                                case 't':
                                case 'u':
                                case 'v':
                                case 'w':
                                case 'x':
                                case 'y':
                                case 'z':
                                case '{':
                                case '|':
                                case '}':
                                case '~':
                                        {
                                                alt27=1;
                                        }
                                    break;
                            }

                            switch (alt27)
                            {
                                case 1:
                                    // cif.g:320:8: TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )*
                                    {
                                        /* 320:8: TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* */
                                        mTEXT_LEAD_CHAR(ctx );
                                        if  (HASEXCEPTION())
                                        {
                                            goto ruleSEMI_COLON_TEXT_FIELDEx;
                                        }
                                        if (HASFAILED())
                                        {
                                            return ;
                                        }



                                        // cif.g:320:23: ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )*

                                        for (;;)
                                        {
                                            int alt26=2;
                                            switch ( LA(1) )
                                            {
                                            case '\t':
                                            case ' ':
                                            case '!':
                                            case '"':
                                            case '#':
                                            case '$':
                                            case '%':
                                            case '&':
                                            case '\'':
                                            case '(':
                                            case ')':
                                            case '*':
                                            case '+':
                                            case ',':
                                            case '-':
                                            case '.':
                                            case '/':
                                            case '0':
                                            case '1':
                                            case '2':
                                            case '3':
                                            case '4':
                                            case '5':
                                            case '6':
                                            case '7':
                                            case '8':
                                            case '9':
                                            case ':':
                                            case ';':
                                            case '<':
                                            case '=':
                                            case '>':
                                            case '?':
                                            case '@':
                                            case 'A':
                                            case 'B':
                                            case 'C':
                                            case 'D':
                                            case 'E':
                                            case 'F':
                                            case 'G':
                                            case 'H':
                                            case 'I':
                                            case 'J':
                                            case 'K':
                                            case 'L':
                                            case 'M':
                                            case 'N':
                                            case 'O':
                                            case 'P':
                                            case 'Q':
                                            case 'R':
                                            case 'S':
                                            case 'T':
                                            case 'U':
                                            case 'V':
                                            case 'W':
                                            case 'X':
                                            case 'Y':
                                            case 'Z':
                                            case '[':
                                            case '\\':
                                            case ']':
                                            case '^':
                                            case '_':
                                            case '`':
                                            case 'a':
                                            case 'b':
                                            case 'c':
                                            case 'd':
                                            case 'e':
                                            case 'f':
                                            case 'g':
                                            case 'h':
                                            case 'i':
                                            case 'j':
                                            case 'k':
                                            case 'l':
                                            case 'm':
                                            case 'n':
                                            case 'o':
                                            case 'p':
                                            case 'q':
                                            case 'r':
                                            case 's':
                                            case 't':
                                            case 'u':
                                            case 'v':
                                            case 'w':
                                            case 'x':
                                            case 'y':
                                            case 'z':
                                            case '{':
                                            case '|':
                                            case '}':
                                            case '~':
                                                {
                                                        alt26=1;
                                                }
                                                break;

                                            }

                                            switch (alt26)
                                            {
                                                case 1:
                                                    // cif.g:
                                                    {
                                                        if ( LA(1) == '\t' || ((LA(1) >= ' ') && (LA(1) <= '~')) )
                                                        {
                                                            CONSUME();
                                                            FAILEDFLAG=ANTLR3_FALSE;

                                                        }
                                                        else
                                                        {
                                                            if (BACKTRACKING>0)
                                                            {
                                                                FAILEDFLAG = ANTLR3_TRUE;
                                                                return ;
                                                            }

                                                            CONSTRUCTEX();
                                                            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                                            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                                            LRECOVER();
                                                            goto ruleSEMI_COLON_TEXT_FIELDEx;
                                                        }


                                                    }
                                                    break;

                                                default:
                                                    goto loop26;        /* break out of the loop */
                                                    break;
                                            }
                                        }
                                        loop26: ; /* Jump out to here if this rule does not match */


                                    }
                                    break;

                            }
                        }

                        /* 320:7: ( TEXT_LEAD_CHAR ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* )? EOL */
                        mEOL(ctx );
                        if  (HASEXCEPTION())
                        {
                            goto ruleSEMI_COLON_TEXT_FIELDEx;
                        }
                        if (HASFAILED())
                        {
                            return ;
                        }



                    }
                    break;

                default:
                    goto loop28;        /* break out of the loop */
                    break;
                }
            }
            loop28: ; /* Jump out to here if this rule does not match */


        }


        if ( BACKTRACKING==0 )
        {
             LEXSTATE->tokenStartCharIndex += 1; EMIT();
        }


        MATCHC(';');
        if  (HASEXCEPTION())
        {
            goto ruleSEMI_COLON_TEXT_FIELDEx;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleSEMI_COLON_TEXT_FIELDEx; /* Prevent compiler warnings */
    ruleSEMI_COLON_TEXT_FIELDEx: ;

}
// $ANTLR end SEMI_COLON_TEXT_FIELD

//   Comes from: 332:3: ( ( ( '#' ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* ( EOL |{...}?) )+ ) )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start COMMENTS
 *
 * Looks to match the characters the constitute the token COMMENTS
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mCOMMENTS(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = COMMENTS;


    // cif.g:332:3: ( ( ( '#' ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* ( EOL |{...}?) )+ ) )
    // cif.g:332:5: ( ( '#' ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* ( EOL |{...}?) )+ )
    {
        // cif.g:332:5: ( ( '#' ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* ( EOL |{...}?) )+ )
        // cif.g:332:7: ( '#' ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* ( EOL |{...}?) )+
        {
            // cif.g:332:7: ( '#' ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* ( EOL |{...}?) )+
            {
                int cnt31=0;

                for (;;)
                {
                    int alt31=2;
                switch ( LA(1) )
                {
                case '#':
                        {
                                alt31=1;
                        }
                    break;

                }

                switch (alt31)
                {
                    case 1:
                        // cif.g:332:9: '#' ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )* ( EOL |{...}?)
                        {
                            MATCHC('#');
                            if  (HASEXCEPTION())
                            {
                                goto ruleCOMMENTSEx;
                            }
                            if (HASFAILED())
                            {
                                return ;
                            }


                            // cif.g:332:13: ( ANY_PRINT_CHAR | SINGLE_QUOTE | DOUBLE_QUOTE )*

                            for (;;)
                            {
                                int alt29=2;
                                switch ( LA(1) )
                                {
                                case '#':
                                        {
                                                {
                                                   /* dfaLoopbackState(k,edges,eotPredictsAlt,description,stateNumber,semPredState)
                                                    */
                                                    int LA29_2 = LA(2);
                                                    if ( (!( (( LA(1) == EOF )) )))
                                                    {
                                                        alt29=1;
                                                    }

                                                }
                                        }
                                    break;
                                case '\t':
                                case ' ':
                                case '!':
                                case '"':
                                case '$':
                                case '%':
                                case '&':
                                case '\'':
                                case '(':
                                case ')':
                                case '*':
                                case '+':
                                case ',':
                                case '-':
                                case '.':
                                case '/':
                                case '0':
                                case '1':
                                case '2':
                                case '3':
                                case '4':
                                case '5':
                                case '6':
                                case '7':
                                case '8':
                                case '9':
                                case ':':
                                case ';':
                                case '<':
                                case '=':
                                case '>':
                                case '?':
                                case '@':
                                case 'A':
                                case 'B':
                                case 'C':
                                case 'D':
                                case 'E':
                                case 'F':
                                case 'G':
                                case 'H':
                                case 'I':
                                case 'J':
                                case 'K':
                                case 'L':
                                case 'M':
                                case 'N':
                                case 'O':
                                case 'P':
                                case 'Q':
                                case 'R':
                                case 'S':
                                case 'T':
                                case 'U':
                                case 'V':
                                case 'W':
                                case 'X':
                                case 'Y':
                                case 'Z':
                                case '[':
                                case '\\':
                                case ']':
                                case '^':
                                case '_':
                                case '`':
                                case 'a':
                                case 'b':
                                case 'c':
                                case 'd':
                                case 'e':
                                case 'f':
                                case 'g':
                                case 'h':
                                case 'i':
                                case 'j':
                                case 'k':
                                case 'l':
                                case 'm':
                                case 'n':
                                case 'o':
                                case 'p':
                                case 'q':
                                case 'r':
                                case 's':
                                case 't':
                                case 'u':
                                case 'v':
                                case 'w':
                                case 'x':
                                case 'y':
                                case 'z':
                                case '{':
                                case '|':
                                case '}':
                                case '~':
                                        {
                                                alt29=1;
                                        }
                                    break;

                                }

                                switch (alt29)
                                {
                                case 1:
                                    // cif.g:
                                    {
                                        if ( LA(1) == '\t' || ((LA(1) >= ' ') && (LA(1) <= '~')) )
                                        {
                                            CONSUME();
                                            FAILEDFLAG=ANTLR3_FALSE;

                                        }
                                        else
                                        {
                                            if (BACKTRACKING>0)
                                            {
                                                FAILEDFLAG = ANTLR3_TRUE;
                                                return ;
                                            }

                                            CONSTRUCTEX();
                                            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                                            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

                                            LRECOVER();
                                            goto ruleCOMMENTSEx;
                                        }


                                    }
                                    break;

                                default:
                                    goto loop29;        /* break out of the loop */
                                    break;
                                }
                            }
                            loop29: ; /* Jump out to here if this rule does not match */


                            // cif.g:333:5: ( EOL |{...}?)
                            {
                                int alt30=2;
                                switch ( LA(1) )
                                {
                                case '\n':
                                case '\r':
                                        {
                                                alt30=1;
                                        }
                                    break;

                                default:
                                    alt30=2;
                                }

                                switch (alt30)
                                {
                                case 1:
                                    // cif.g:333:7: EOL
                                    {
                                        /* 333:7: EOL */
                                        mEOL(ctx );
                                        if  (HASEXCEPTION())
                                        {
                                            goto ruleCOMMENTSEx;
                                        }
                                        if (HASFAILED())
                                        {
                                            return ;
                                        }



                                    }
                                    break;
                                case 2:
                                    // cif.g:333:13: {...}?
                                    {
                                        if ( !(( LA(1) == EOF )) )
                                        {
                                            if (BACKTRACKING>0)
                                            {
                                                FAILEDFLAG = ANTLR3_TRUE;
                                                return ;
                                            }

                                                CONSTRUCTEX();
                                                EXCEPTION->type         = ANTLR3_FAILED_PREDICATE_EXCEPTION;
                                                EXCEPTION->message      = (void *)" LA(1) == EOF ";
                                                EXCEPTION->ruleName      = (void *)"COMMENTS";


                                        }

                                    }
                                    break;

                                }
                            }

                        }
                        break;

                    default:

                        if ( cnt31 >= 1 )
                        {
                            goto loop31;
                        }
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return ;
                        }

                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto ruleCOMMENTSEx;
                }
                cnt31++;
                }
                loop31: ;       /* Jump to here if this rule does not match */
            }

        }


        if ( BACKTRACKING==0 )
        {
             LEXSTATE->channel = HIDDEN;
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleCOMMENTSEx; /* Prevent compiler warnings */
    ruleCOMMENTSEx: ;

}
// $ANTLR end COMMENTS

//   Comes from: 346:3: ( NON_BLANK_CHAR_ )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start NON_BLANK_CHAR
 *
 * Looks to match the characters the constitute the token NON_BLANK_CHAR
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mNON_BLANK_CHAR(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = NON_BLANK_CHAR;


    // cif.g:346:3: ( NON_BLANK_CHAR_ )
    // cif.g:
    {
        if ( ((LA(1) >= '!') && (LA(1) <= '~')) )
        {
            CONSUME();
            FAILEDFLAG=ANTLR3_FALSE;

        }
        else
        {
            if (BACKTRACKING>0)
            {
                FAILEDFLAG = ANTLR3_TRUE;
                return ;
            }

            CONSTRUCTEX();
            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;

            LRECOVER();
            goto ruleNON_BLANK_CHAREx;
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleNON_BLANK_CHAREx; /* Prevent compiler warnings */
    ruleNON_BLANK_CHAREx: ;

}
// $ANTLR end NON_BLANK_CHAR

//   Comes from: 349:3: ( ( '\\t' | ' ' | EOL | '\\u000C' )+ )
/** \brief Lexer rule generated by ANTLR3
 *
 * $ANTLR start WHITESPACE
 *
 * Looks to match the characters the constitute the token WHITESPACE
 * from the attached input stream.
 *
 *
 * \remark
 *  - lexer->error == ANTLR3_TRUE if an exception was thrown.
 */
static ANTLR3_INLINE
void mWHITESPACE(pcifLexer ctx)
{
        ANTLR3_UINT32   _type;

    _type           = WHITESPACE;


    // cif.g:349:3: ( ( '\\t' | ' ' | EOL | '\\u000C' )+ )
    // cif.g:349:6: ( '\\t' | ' ' | EOL | '\\u000C' )+
    {
        // cif.g:349:6: ( '\\t' | ' ' | EOL | '\\u000C' )+
        {
            int cnt32=0;

            for (;;)
            {
                int alt32=5;
                switch ( LA(1) )
                {
                case '\t':
                        {
                                alt32=1;
                        }
                    break;
                case ' ':
                        {
                                alt32=2;
                        }
                    break;
                case '\n':
                case '\r':
                        {
                                alt32=3;
                        }
                    break;
                case '\f':
                        {
                                alt32=4;
                        }
                    break;

                }

                switch (alt32)
                {
                    case 1:
                        // cif.g:349:8: '\\t'
                        {
                            MATCHC('\t');
                            if  (HASEXCEPTION())
                            {
                                goto ruleWHITESPACEEx;
                            }
                            if (HASFAILED())
                            {
                                return ;
                            }


                        }
                        break;
                    case 2:
                        // cif.g:349:15: ' '
                        {
                            MATCHC(' ');
                            if  (HASEXCEPTION())
                            {
                                goto ruleWHITESPACEEx;
                            }
                            if (HASFAILED())
                            {
                                return ;
                            }


                        }
                        break;
                    case 3:
                        // cif.g:349:21: EOL
                        {
                            /* 349:21: EOL */
                            mEOL(ctx );
                            if  (HASEXCEPTION())
                            {
                                goto ruleWHITESPACEEx;
                            }
                            if (HASFAILED())
                            {
                                return ;
                            }



                        }
                        break;
                    case 4:
                        // cif.g:349:27: '\\u000C'
                        {
                            MATCHC(0x000C);
                            if  (HASEXCEPTION())
                            {
                                goto ruleWHITESPACEEx;
                            }
                            if (HASFAILED())
                            {
                                return ;
                            }


                        }
                        break;

                    default:

                        if ( cnt32 >= 1 )
                        {
                            goto loop32;
                        }
                        if (BACKTRACKING>0)
                        {
                            FAILEDFLAG = ANTLR3_TRUE;
                            return ;
                        }

                        /* mismatchedSetEx()
                         */
                        CONSTRUCTEX();
                        EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
                        EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


                        goto ruleWHITESPACEEx;
                }
                cnt32++;
            }
            loop32: ;   /* Jump to here if this rule does not match */
        }

        if ( BACKTRACKING==0 )
        {
             SKIP();
        }


    }

        LEXSTATE->type = _type;
    // This is where rules clean up and exit
    //
    goto ruleWHITESPACEEx; /* Prevent compiler warnings */
    ruleWHITESPACEEx: ;

}
// $ANTLR end WHITESPACE

/** This is the entry point in to the lexer from an object that
 *  wants to generate the next token, such as a pCOMMON_TOKEN_STREAM
 */
static void
mTokens(pcifLexer ctx)
{
    {
        //  cif.g:1:8: ( T__37 | TAG | LOOP_ | GLOBAL_ | STOP_ | DATA_BLOCK_HEADING | SAVE_FRAME_HEADING | SAVE | NUMERIC | INAPPLICABLE | UNKNOWN | CHAR_STRING | SEMI_COLON_TEXT_FIELD | COMMENTS | NON_BLANK_CHAR | WHITESPACE )

        ANTLR3_UINT32 alt33;

        alt33=16;

        alt33 = cdfa33.predict(ctx, RECOGNIZER, ISTREAM, &cdfa33);
        if  (HASEXCEPTION())
        {
            goto ruleTokensEx;
        }
        if (HASFAILED())
        {
            return ;
        }

        switch (alt33)
        {
        case 1:
            // cif.g:1:10: T__37
            {
                /* 1:10: T__37 */
                mT__37(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 2:
            // cif.g:1:16: TAG
            {
                /* 1:16: TAG */
                mTAG(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 3:
            // cif.g:1:20: LOOP_
            {
                /* 1:20: LOOP_ */
                mLOOP_(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 4:
            // cif.g:1:26: GLOBAL_
            {
                /* 1:26: GLOBAL_ */
                mGLOBAL_(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 5:
            // cif.g:1:34: STOP_
            {
                /* 1:34: STOP_ */
                mSTOP_(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 6:
            // cif.g:1:40: DATA_BLOCK_HEADING
            {
                /* 1:40: DATA_BLOCK_HEADING */
                mDATA_BLOCK_HEADING(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 7:
            // cif.g:1:59: SAVE_FRAME_HEADING
            {
                /* 1:59: SAVE_FRAME_HEADING */
                mSAVE_FRAME_HEADING(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 8:
            // cif.g:1:78: SAVE
            {
                /* 1:78: SAVE */
                mSAVE(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 9:
            // cif.g:1:83: NUMERIC
            {
                /* 1:83: NUMERIC */
                mNUMERIC(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 10:
            // cif.g:1:91: INAPPLICABLE
            {
                /* 1:91: INAPPLICABLE */
                mINAPPLICABLE(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 11:
            // cif.g:1:104: UNKNOWN
            {
                /* 1:104: UNKNOWN */
                mUNKNOWN(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 12:
            // cif.g:1:112: CHAR_STRING
            {
                /* 1:112: CHAR_STRING */
                mCHAR_STRING(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 13:
            // cif.g:1:124: SEMI_COLON_TEXT_FIELD
            {
                /* 1:124: SEMI_COLON_TEXT_FIELD */
                mSEMI_COLON_TEXT_FIELD(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 14:
            // cif.g:1:146: COMMENTS
            {
                /* 1:146: COMMENTS */
                mCOMMENTS(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 15:
            // cif.g:1:155: NON_BLANK_CHAR
            {
                /* 1:155: NON_BLANK_CHAR */
                mNON_BLANK_CHAR(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;
        case 16:
            // cif.g:1:170: WHITESPACE
            {
                /* 1:170: WHITESPACE */
                mWHITESPACE(ctx );
                if  (HASEXCEPTION())
                {
                    goto ruleTokensEx;
                }
                if (HASFAILED())
                {
                    return ;
                }



            }
            break;

        }
    }


    goto ruleTokensEx; /* Prevent compiler warnings */
ruleTokensEx: ;
}

// $ANTLR start synpred1_cif
static void synpred1_cif_fragment(pcifLexer ctx )
{
    // cif.g:304:9: ( SINGLE_QUOTE NON_BLANK_CHAR_ )
    // cif.g:304:10: SINGLE_QUOTE NON_BLANK_CHAR_
    {
        /* 304:10: SINGLE_QUOTE NON_BLANK_CHAR_ */
        mSINGLE_QUOTE(ctx );
        if  (HASEXCEPTION())
        {
            goto rulesynpred1_cifEx;
        }
        if (HASFAILED())
        {
            return ;
        }



        /* 304:10: SINGLE_QUOTE NON_BLANK_CHAR_ */
        mNON_BLANK_CHAR_(ctx );
        if  (HASEXCEPTION())
        {
            goto rulesynpred1_cifEx;
        }
        if (HASFAILED())
        {
            return ;
        }



    }

// This is where rules clean up and exit
//
goto rulesynpred1_cifEx; /* Prevent compiler warnings */
rulesynpred1_cifEx: ;

}
// $ANTLR end synpred1_cif

// $ANTLR start synpred2_cif
static void synpred2_cif_fragment(pcifLexer ctx )
{
    // cif.g:310:9: ( DOUBLE_QUOTE NON_BLANK_CHAR_ )
    // cif.g:310:10: DOUBLE_QUOTE NON_BLANK_CHAR_
    {
        /* 310:10: DOUBLE_QUOTE NON_BLANK_CHAR_ */
        mDOUBLE_QUOTE(ctx );
        if  (HASEXCEPTION())
        {
            goto rulesynpred2_cifEx;
        }
        if (HASFAILED())
        {
            return ;
        }



        /* 310:10: DOUBLE_QUOTE NON_BLANK_CHAR_ */
        mNON_BLANK_CHAR_(ctx );
        if  (HASEXCEPTION())
        {
            goto rulesynpred2_cifEx;
        }
        if (HASFAILED())
        {
            return ;
        }



    }

// This is where rules clean up and exit
//
goto rulesynpred2_cifEx; /* Prevent compiler warnings */
rulesynpred2_cifEx: ;

}
// $ANTLR end synpred2_cif

/* =========================================================================
 * Lexer matching rules end.
 * =========================================================================
 */

/* =========================================================================
 * Lexer syntactic predicates
 */
static ANTLR3_BOOLEAN synpred1_cif(pcifLexer ctx)
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start       = MARK();
    synpred1_cif_fragment(ctx);     // can never throw exception
    success     = !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG  = ANTLR3_FALSE;
    return success;
}
static ANTLR3_BOOLEAN synpred2_cif(pcifLexer ctx)
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start       = MARK();
    synpred2_cif_fragment(ctx);     // can never throw exception
    success     = !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG  = ANTLR3_FALSE;
    return success;
}

/* =========================================================================
 * Lexer syntactic predicates end.
 * =========================================================================
 */

/* End of Lexer code
 * ================================================
 * ================================================
 */


/* End of code
 * =============================================================================
 */
