/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Value;

public class NumericComparer
implements Comparator,
Serializable {
    private static NumericComparer THE_INSTANCE = new NumericComparer();

    public static NumericComparer getInstance() {
        return THE_INSTANCE;
    }

    private NumericComparer() {
    }

    public int compare(Object object, Object object2) {
        double d;
        String string;
        double d2;
        if (object instanceof NumericValue) {
            d2 = ((NumericValue)object).getDoubleValue();
        } else if (object == null) {
            d2 = Double.NaN;
        } else {
            try {
                string = object instanceof String ? (String)object : ((Item)object).getStringValue();
                d2 = Value.stringToNumber(string);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = Double.NaN;
            }
        }
        if (object2 instanceof NumericValue) {
            d = ((NumericValue)object2).getDoubleValue();
        } else if (object2 == null) {
            d = Double.NaN;
        } else {
            try {
                string = object2 instanceof String ? (String)object2 : ((Item)object2).getStringValue();
                d = Value.stringToNumber(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = Double.NaN;
            }
        }
        if (Double.isNaN(d2)) {
            if (Double.isNaN(d)) {
                return 0;
            }
            return -1;
        }
        if (Double.isNaN(d)) {
            return 1;
        }
        if (d2 < d) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }
}

