<style>
.promo li a {
    float: left;
    width: 130px;
    height: 20px;
    text-align: center;
    margin: 10px 30px;
    padding: 150px 0 0 0;
    background-position: 0 50%;
    background-size: 130px auto;
    background-repeat: no-repeat;
    font-size: 120%;
    color: black;
}
.promo li {
    list-style: none;
}
</style>

# Django REST framework 3.10

The 3.10 release drops support for Python 2.

* Our supported Python versions are now: 3.5, 3.6, and 3.7.
* Our supported Django versions are now: 1.11, 2.0, 2.1, and 2.2.

## OpenAPI Schema Generation

Since we first introduced schema support in Django REST Framework 3.5, OpenAPI has emerged as the widely adopted standard for modeling Web APIs.

This release begins the deprecation process for the CoreAPI based schema generation, and introduces OpenAPI schema generation in its place.

---

## Continuing to use CoreAPI

If you're currently using the CoreAPI schemas, you'll need to make sure to
update your REST framework settings to include `DEFAULT_SCHEMA_CLASS` explicitly.

**settings.py**:

```python
REST_FRAMEWORK = {
  ...
  'DEFAULT_SCHEMA_CLASS': 'rest_framework.schemas.coreapi.AutoSchema'
}
```

You'll still be able to keep using CoreAPI schemas, API docs, and client for the
foreseeable future. We'll aim to ensure that the CoreAPI schema generator remains
available as a third party package, even once it has eventually been removed
from REST framework, scheduled for version 3.12.

We have removed the old documentation for the CoreAPI based schema generation.
You may view the [Legacy CoreAPI documentation here][legacy-core-api-docs].

----

## OpenAPI Quickstart

You can generate a static OpenAPI schema, using the `generateschema` management
command.

Alternately, to have the project serve an API schema, use the `get_schema_view()`
shortcut.

In your `urls.py`:

```python
from rest_framework.schemas import get_schema_view

urlpatterns = [
    # ...
    # Use the `get_schema_view()` helper to add a `SchemaView` to project URLs.
    #   * `title` and `description` parameters are passed to `SchemaGenerator`.
    #   * Provide view name for use with `reverse()`.
    path('openapi', get_schema_view(
        title="Your Project",
        description="API for all things …"
    ), name='openapi-schema'),
    # ...
]
```

### Customization

For customizations that you want to apply across the entire API, you can subclass `rest_framework.schemas.openapi.SchemaGenerator` and provide it as an argument
to the `generateschema` command or `get_schema_view()` helper function.

For specific per-view customizations, you can subclass `AutoSchema`,
making sure to set `schema = <YourCustomClass>` on the view.

For more details, see the [API Schema documentation](../api-guide/schemas.md).

### API Documentation

There are some great third party options for documenting your API, based on the
OpenAPI schema.

See the [Documenting you API](../topics/documenting-your-api.md) section for more details.

---

## Feature Roadmap

Given that our OpenAPI schema generation is a new feature, it's likely that there
will still be some iterative improvements for us to make. There will be two
main cases here:

* Expanding the supported range of OpenAPI schemas that are generated by default.
* Improving the ability for developers to customize the output.

We'll aim to bring the first type of change quickly in point releases. For the
second kind we'd like to adopt a slower approach, to make sure we keep the API
simple, and as widely applicable as possible, before we bring in API changes.

It's also possible that we'll end up implementing API documentation and API client
tooling that are driven by the OpenAPI schema. The `apistar` project has a
significant amount of work towards this. However, if we do so, we'll plan
on keeping any tooling outside of the core framework.

---

## Funding

REST framework is a *collaboratively funded project*. If you use
REST framework commercially we strongly encourage you to invest in its
continued development by **[signing up for a paid plan][funding]**.

*Every single sign-up helps us make REST framework long-term financially sustainable.*

<ul class="premium-promo promo">
    <li><a href="https://getsentry.com/welcome/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/sentry130.png)">Sentry</a></li>
    <li><a href="https://getstream.io/try-the-api/?utm_source=drf&utm_medium=banner&utm_campaign=drf" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/stream-130.png)">Stream</a></li>
    <li><a href="https://software.esg-usa.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/esg-new-logo.png)">ESG</a></li>
    <li><a href="https://rollbar.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/rollbar2.png)">Rollbar</a></li>
    <li><a href="https://cadre.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/cadre.png)">Cadre</a></li>
    <li><a href="https://hubs.ly/H0f30Lf0" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/kloudless-plus-text.png)">Kloudless</a></li>
    <li><a href="https://lightsonsoftware.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/lightson-dark.png)">Lights On Software</a></li>
</ul>
<div style="clear: both; padding-bottom: 20px;"></div>

*Many thanks to all our [wonderful sponsors][sponsors], and in particular to our premium backers, [Sentry](https://getsentry.com/welcome/), [Stream](https://getstream.io/?utm_source=drf&utm_medium=banner&utm_campaign=drf), [ESG](https://software.esg-usa.com/), [Rollbar](https://rollbar.com/?utm_source=django&utm_medium=sponsorship&utm_campaign=freetrial), [Cadre](https://cadre.com), [Kloudless](https://hubs.ly/H0f30Lf0), and [Lights On Software](https://lightsonsoftware.com).*

[legacy-core-api-docs]:https://github.com/encode/django-rest-framework/blob/master/docs/coreapi/index.md
[sponsors]: https://fund.django-rest-framework.org/topics/funding/#our-sponsors
[funding]: funding.md
