<?php
# dvdisaster: English homepage translation
# Copyright (C) 2004-2012 Carsten Gnörlich
#
# UTF-8 trigger: äöüß 
#
# Include our PHP sub routines, then call begin_page()
# to start the HTML page, insert the header, 
# navigation and news if appropriate.

require("../include/dvdisaster.php");
require("../include/screenshot.php");

begin_page();

howto_headline("Поиск ошибок на носителях", "Объяснение результатов", "images/scan-icon.png");
?>

<!-- Insert actual page content below -->

<?php begin_screen_shot("Обзор","defective-cd.png"); ?>
<b>Обзор.</b> dvdisaster предоставляет информацию о результах проверки:
<ul>
<li>Спираль под "<b>Состояние носителя</b>" (справа).<p>
Эта спираль дает информацию о читаемости носителя. Носитель полностью
читается, когда все сегменты спирали имеют зеленый цвет. Желтыми или красными
квадратиками отмечаются места, где данные не удалось правильно прочитать с носителя.
Общее число нечитаемых секторов выводится в 
сообщении <i>"Проверка завершена:"</i>  внизу окна.<p>
</li>
<li>"<b>Скорость</b>" - График скорости чтения (слева вверху).<p>
Скорость чтения не является абсолютным критерием состояния носителя,
но она может быть своеобразным правилом "буравчика": 
чем равномернее кривая, тем лучше носитель.
Дальше на этой странице будут приведены примеры хороших и плохих графиков 
скорости чтения.<p></li>
<li>"<b>Ошибки C2</b>" - Критерий состояния носителя, даваемый приводом (внизу слева).<p>
Такой вид анализа  
<a href="qa.php?pipo">сейчас доступен только для CD-дисков</a>.
CD-приводы имеют встроенную коррекцию ошибок, которая может исключить небольшие потери данных, вызванные незначительными повреждениями носителя. Число ошибок C2 является мерой того, как часто приводу приходится использовать внутреннюю коррекцию ошибок во время чтения - это значение должно быть равно нулю на хорошем носителе.</li>
</ul>
<?php end_screen_shot(); ?>

<b>Примеры хороших носителей</b><p>

<?php begin_screen_shot("Хороший CD","good-cd.png"); ?>
<b>Хороший CD</b>: На этом снимке экрана показан идеальный CD:
все квадратики под "Состоянием носителя" зеленые, нет сообщения об ошибках C2,
и кривая чтения идет гладко. Возрастающая скорость чтения - это нормально для большинства носителей (см. на следующем снимке экрана обратный пример). Небольшие пики
в начале и в конце кривой являются нормальными; незначительные сбои, подобные показанному на 250M, также безвредны.
<?php end_screen_shot(); ?>


<?php begin_screen_shot("Хороший двухслойный DVD","good-dvd9.png"); ?>
<b>Иногда кривая чтения не будет неуклонно расти</b>: У многослойных носителей
кривая чтения может расти и снижаться симметрично.
Пример не приводится, но возможны и плоские кривые без каких-либо изменений в скорости чтения
(чаще всего это бывает с DVD-RAM).
<?php end_screen_shot(); ?><p>

<b>Пример слабого носителя</b><p>

<?php begin_screen_shot("Слабый CD","weak-cd.png"); ?>
Этот носитель все еще читаемый, о чем свидетельствует зеленая спираль, показанная под
"Состоянием насителя". Тем не менее, есть отчетливые признаки предстоящих серьезных проблем:
привод должен значительно замедлиться перед концом носителя, чтобы
читать с него. Обратите внимание на крутое падение скорости чтения после отметки 600М.
Это сопровождается возрастанием частоты ошибок C2 перед отметкой 100; это еще одно
предупреждение, что носитель ухудшается во внешней области.
Если вы не создали данных для <a href="howtos20.php">исправления ошибок</a>, то
это, вероятно, последняя возможность сделать это, поскольку на носителе скоро
проявятся первые ошибки чтения.
<?php end_screen_shot(); ?><p>

<b>Примеры поврежденных носителей</b><p>

<?php begin_screen_shot("Поврежденный CD","defective-cd.png"); ?>
<b>Поврежденный CD.</b> 
Красные секторы на спирали показывают нечитаемые участки во 
внешней области носителя. Внизу окна приводится информация,
что этот носитель содержит 28752 нечитаемых сектора.
В сумме это составляет примерно 8.2% поврежденных секторов (из всего 352486 секторов) и
хорошо укладывается в границы 
<a href="howtos40.php">восстановления</a> с помощью 
<a href="howtos20.php">данных для исправления ошибок (ecc)</a>, сделанных 
со стандартными настройками - если вы вовремя сделали ecc-данные! 
В противном случае содержимое красных секторов
потеряно, так как ecc-данные не могут быть созданы на основе уже поврежденных носителей.
<?php end_screen_shot(); ?><p>

<a name="crc"></a>
<?php begin_screen_shot("Ошибки контрольной суммы","crc-cd.png"); ?>
<b>Ошибки контрольной суммы.</b> Желтые пятна на спирали изображают места, 
где носитель прочитался полностью, но для прочитанных данных не совпадали
контрольные суммы в данных для исправления ошибок. Для этого есть две причины:
<p>

<ul><li>
<b>С образом что-то делалось</b> в промежутке между созданием 
данных для исправления ошибок и их записью на носитель.
Это может случиться на Unix-системах, если образ смонтирован с доступом на запись
после того, как были созданы ecc-данные. Типичными признаками этого являются ошибки CRC в секторе 64
и в секторах от 200 до 400, поскольку система обновляет здесь время доступа к файлам.
В такой ситуации выполнение восстановления с помощью dvdisaster обычно происходит безболезненно.<p>

Но если вы изменили файлы в образе после создания ecc-данных,
то данные для исправления ошибок будут как бесполезными, так и опасными.
Применение процедуры восстановления к этому носителю восстановит состояние образа
на время создания ecc-данных, а это, очевидно, не соответствует  
последнему содержимому носителя.<p></li>

<li><b>Существуют технические проблемы с компьютерной системой,</b>
в особенности в коммуникациях с устройствами хранения. Еще раз выполните проверку
и обратите внимание на местоположение CRC-ошибок.
Если CRC-ошибки исчезают с поверхности в разных местах, то у вашей системы
может быть дефектное ОЗУ, плохие кабели или контроллеры или неправильные частоты генераторов.</li></ul>
<?php end_screen_shot(); ?><p>

<!-- do not change below -->

<?php
# end_page() adds the footer line and closes the HTML properly.

end_page();
?>
