/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import MCview.PDBChain;
import MCview.PDBfile;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.SequenceRenderer;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.JalviewLite;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.io.AppletFormatAdapter;
import jalview.io.FileParse;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.structure.StructureListener;
import jalview.structure.StructureMapping;
import jalview.structure.StructureSelectionManager;
import jalview.util.Comparison;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.popup.JmolPopup;

public class AppletJmol
extends EmbmenuFrame
implements StructureListener,
JmolStatusListener,
KeyListener,
ActionListener,
ItemListener {
    Menu fileMenu = new Menu("File");
    Menu viewMenu = new Menu("View");
    Menu coloursMenu = new Menu("Colours");
    Menu chainMenu = new Menu("Show Chain");
    Menu helpMenu = new Menu("Help");
    MenuItem mappingMenuItem = new MenuItem("View Mapping");
    CheckboxMenuItem seqColour = new CheckboxMenuItem("By Sequence", true);
    MenuItem chain = new MenuItem("By Chain");
    MenuItem charge = new MenuItem("Charge & Cysteine");
    MenuItem zappo = new MenuItem("Zappo");
    MenuItem taylor = new MenuItem("Taylor");
    MenuItem hydro = new MenuItem("Hydrophobicity");
    MenuItem helix = new MenuItem("Helix Propensity");
    MenuItem strand = new MenuItem("Strand Propensity");
    MenuItem turn = new MenuItem("Turn Propensity");
    MenuItem buried = new MenuItem("Buried Index");
    MenuItem user = new MenuItem("User Defined Colours");
    MenuItem jmolHelp = new MenuItem("Jmol Help");
    JmolViewer viewer;
    JmolPopup jmolpopup;
    Panel scriptWindow;
    TextField inputLine;
    TextArea history;
    SequenceI[] sequence;
    String[] chains;
    StructureSelectionManager ssm;
    RenderPanel renderPanel;
    AlignmentPanel ap;
    String fileLoadingError;
    boolean loadedInline;
    PDBEntry pdbentry;
    boolean colourBySequence = true;
    Vector atomsPicked = new Vector();
    String protocol = null;
    boolean allChainsSelected = false;
    String lastMessage;
    StringBuffer resetLastRes = new StringBuffer();
    StringBuffer eval = new StringBuffer();
    String lastCommand;
    FeatureRenderer fr = null;

    public AppletJmol(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap, String protocol) {
        this.ap = ap;
        this.sequence = seq;
        this.chains = chains;
        this.pdbentry = pdbentry;
        this.protocol = protocol;
        if ((pdbentry.getId() == null || pdbentry.getId().length() < 1) && JalviewLite.debug) {
            System.err.println("Setting PDB id for file " + pdbentry.getFile());
            if (protocol.equals(AppletFormatAdapter.PASTE)) {
                pdbentry.setId("PASTED PDB" + (chains == null ? "_" : chains.toString()));
            } else {
                pdbentry.setId(pdbentry.getFile());
            }
        }
        if (JalviewLite.debug) {
            System.err.println("AppletJmol: PDB ID is '" + pdbentry.getId() + "'");
        }
        String alreadyMapped = StructureSelectionManager.getStructureSelectionManager().alreadyMappedToFile(pdbentry.getId());
        PDBfile reader = null;
        if (alreadyMapped != null) {
            reader = StructureSelectionManager.getStructureSelectionManager().setMapping(seq, chains, pdbentry.getFile(), protocol);
        }
        MenuBar menuBar = new MenuBar();
        menuBar.add(this.fileMenu);
        this.fileMenu.add(this.mappingMenuItem);
        menuBar.add(this.viewMenu);
        this.mappingMenuItem.addActionListener(this);
        this.viewMenu.add(this.chainMenu);
        menuBar.add(this.coloursMenu);
        menuBar.add(this.helpMenu);
        this.charge.addActionListener(this);
        this.hydro.addActionListener(this);
        this.chain.addActionListener(this);
        this.seqColour.addItemListener(this);
        this.zappo.addActionListener(this);
        this.taylor.addActionListener(this);
        this.helix.addActionListener(this);
        this.strand.addActionListener(this);
        this.turn.addActionListener(this);
        this.buried.addActionListener(this);
        this.user.addActionListener(this);
        this.jmolHelp.addActionListener(this);
        this.coloursMenu.add(this.seqColour);
        this.coloursMenu.add(this.chain);
        this.coloursMenu.add(this.charge);
        this.coloursMenu.add(this.zappo);
        this.coloursMenu.add(this.taylor);
        this.coloursMenu.add(this.hydro);
        this.coloursMenu.add(this.helix);
        this.coloursMenu.add(this.strand);
        this.coloursMenu.add(this.turn);
        this.coloursMenu.add(this.buried);
        this.coloursMenu.add(this.user);
        this.helpMenu.add(this.jmolHelp);
        this.setMenuBar(menuBar);
        this.renderPanel = new RenderPanel();
        this.embedMenuIfNeeded(this.renderPanel);
        this.add((Component)this.renderPanel, "Center");
        this.viewer = JmolViewer.allocateViewer((Component)this.renderPanel, (JmolAdapter)new SmarterJmolAdapter());
        this.viewer.setAppletContext("jalview", ap.av.applet.getDocumentBase(), ap.av.applet.getCodeBase(), null);
        this.viewer.setJmolStatusListener((JmolStatusListener)this);
        this.jmolpopup = JmolPopup.newJmolPopup((JmolViewer)this.viewer);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AppletJmol.this.closeViewer();
            }
        });
        if (pdbentry.getFile() != null) {
            if (protocol.equals(AppletFormatAdapter.PASTE)) {
                this.loadInline(pdbentry.getFile());
            } else if (protocol.equals(AppletFormatAdapter.FILE) || protocol.equals(AppletFormatAdapter.URL)) {
                this.viewer.openFile(pdbentry.getFile());
            } else {
                try {
                    Reader freader = null;
                    if (reader != null) {
                        if (JalviewLite.debug) {
                            System.err.println("AppletJmol:Trying to reuse existing PDBfile IO parser.");
                        }
                        freader = reader.getReader();
                    }
                    if (freader == null) {
                        if (JalviewLite.debug) {
                            System.err.println("AppletJmol:Creating new PDBfile IO parser.");
                        }
                        FileParse fp = new FileParse(pdbentry.getFile(), protocol);
                        fp.mark();
                        freader = fp.getReader();
                    }
                    if (freader == null) {
                        throw new Exception("Invalid datasource. Could not obtain Reader.");
                    }
                    this.viewer.openReader(pdbentry.getFile(), pdbentry.getId(), freader);
                }
                catch (Exception e) {
                    System.err.println("Couldn't access pdbentry id=" + pdbentry.getId() + " and file=" + pdbentry.getFile() + " using protocol=" + protocol);
                    e.printStackTrace();
                }
            }
        }
        JalviewLite.addFrame(this, "Jmol", 400, 400);
    }

    public void loadInline(String string) {
        this.loadedInline = true;
        this.viewer.openStringInline(string);
    }

    void setChainMenuItems(Vector chains) {
        this.chainMenu.removeAll();
        MenuItem menuItem = new MenuItem("All");
        menuItem.addActionListener(this);
        this.chainMenu.add(menuItem);
        for (int c = 0; c < chains.size(); ++c) {
            CheckboxMenuItem menuItemCB = new CheckboxMenuItem(chains.elementAt(c).toString(), true);
            menuItemCB.addItemListener(this);
            this.chainMenu.add(menuItemCB);
        }
    }

    void centerViewer() {
        StringBuffer cmd = new StringBuffer();
        for (int i = 0; i < this.chainMenu.getItemCount(); ++i) {
            CheckboxMenuItem item;
            if (!(this.chainMenu.getItem(i) instanceof CheckboxMenuItem) || !(item = (CheckboxMenuItem)this.chainMenu.getItem(i)).getState()) continue;
            cmd.append(":" + item.getLabel() + " or ");
        }
        if (cmd.length() > 0) {
            cmd.setLength(cmd.length() - 4);
        }
        this.viewer.evalString("select *;restrict " + cmd + ";cartoon;center " + cmd);
    }

    void closeViewer() {
        this.viewer.setModeMouse(-1);
        this.viewer.evalStringQuiet("zap");
        this.viewer.setJmolStatusListener(null);
        this.viewer = null;
        StructureSelectionManager.getStructureSelectionManager().removeStructureViewerListener(this, this.pdbentry.getId());
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.mappingMenuItem) {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, null);
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, "PDB - Sequence Mapping", 550, 600);
            cap.setText(StructureSelectionManager.getStructureSelectionManager().printMapping(this.pdbentry.getFile()));
        } else if (evt.getSource() == this.charge) {
            this.colourBySequence = false;
            this.seqColour.setState(false);
            this.viewer.evalStringQuiet("select *;color white;select ASP,GLU;color red;select LYS,ARG;color blue;select CYS;color yellow");
        } else if (evt.getSource() == this.chain) {
            this.colourBySequence = false;
            this.seqColour.setState(false);
            this.viewer.evalStringQuiet("select *;color chain");
        } else if (evt.getSource() == this.zappo) {
            this.setJalviewColourScheme(new ZappoColourScheme());
        } else if (evt.getSource() == this.taylor) {
            this.setJalviewColourScheme(new TaylorColourScheme());
        } else if (evt.getSource() == this.hydro) {
            this.setJalviewColourScheme(new HydrophobicColourScheme());
        } else if (evt.getSource() == this.helix) {
            this.setJalviewColourScheme(new HelixColourScheme());
        } else if (evt.getSource() == this.strand) {
            this.setJalviewColourScheme(new StrandColourScheme());
        } else if (evt.getSource() == this.turn) {
            this.setJalviewColourScheme(new TurnColourScheme());
        } else if (evt.getSource() == this.buried) {
            this.setJalviewColourScheme(new BuriedColourScheme());
        } else if (evt.getSource() == this.user) {
            new UserDefinedColours(this);
        } else if (evt.getSource() == this.jmolHelp) {
            try {
                this.ap.av.applet.getAppletContext().showDocument(new URL("http://jmol.sourceforge.net/docs/JmolUserGuide/"), "jmolHelp");
            }
            catch (MalformedURLException ex) {}
        } else {
            this.allChainsSelected = true;
            for (int i = 0; i < this.chainMenu.getItemCount(); ++i) {
                if (!(this.chainMenu.getItem(i) instanceof CheckboxMenuItem)) continue;
                ((CheckboxMenuItem)this.chainMenu.getItem(i)).setState(true);
            }
            this.centerViewer();
            this.allChainsSelected = false;
        }
    }

    public void setJalviewColourScheme(ColourSchemeI cs) {
        this.colourBySequence = false;
        this.seqColour.setState(false);
        if (cs == null) {
            return;
        }
        Enumeration en = ResidueProperties.aa3Hash.keys();
        StringBuffer command = new StringBuffer("select *;color white;");
        while (en.hasMoreElements()) {
            String res = en.nextElement().toString();
            int index = (Integer)ResidueProperties.aa3Hash.get(res);
            if (index > 20) continue;
            Color col = cs.findColour(ResidueProperties.aa[index].charAt(0));
            command.append("select " + res + ";color[" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "];");
        }
        this.viewer.evalStringQuiet(command.toString());
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.seqColour) {
            this.lastCommand = null;
            this.colourBySequence = this.seqColour.getState();
            this.colourBySequence(this.ap);
        } else if (!this.allChainsSelected) {
            this.centerViewer();
        }
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.scriptWindow.isVisible()) {
            this.viewer.evalString(this.inputLine.getText());
            this.history.append("\n$ " + this.inputLine.getText());
            this.inputLine.setText("");
        }
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public String getPdbFile() {
        return "???";
    }

    public void mouseOverStructure(int atomIndex, String strInfo) {
        int chainSeparator = strInfo.indexOf(":");
        if (chainSeparator == -1) {
            chainSeparator = strInfo.indexOf(".");
        }
        int pdbResNum = Integer.parseInt(strInfo.substring(strInfo.indexOf("]") + 1, chainSeparator));
        String chainId = strInfo.indexOf(":") > -1 ? strInfo.substring(strInfo.indexOf(":") + 1, strInfo.indexOf(".")) : " ";
        if (this.lastMessage == null || !this.lastMessage.equals(strInfo)) {
            this.ssm.mouseOverStructure(pdbResNum, chainId, this.pdbentry.getFile());
        }
        this.lastMessage = strInfo;
    }

    public void highlightAtom(int atomIndex, int pdbResNum, String chain, String pdbfile) {
        if (!pdbfile.equals(this.pdbentry.getFile())) {
            return;
        }
        if (this.resetLastRes.length() > 0) {
            this.viewer.evalStringQuiet(this.resetLastRes.toString());
        }
        this.eval.setLength(0);
        this.eval.append("select " + pdbResNum);
        this.resetLastRes.setLength(0);
        this.resetLastRes.append("select " + pdbResNum);
        if (!chain.equals(" ")) {
            this.eval.append(":" + chain);
            this.resetLastRes.append(":" + chain);
        }
        this.eval.append(";wireframe 100;" + this.eval.toString() + ".CA;");
        this.resetLastRes.append(";wireframe 0;" + this.resetLastRes.toString() + ".CA;spacefill 0;");
        this.eval.append("spacefill 200;select none");
        this.viewer.evalStringQuiet(this.eval.toString());
    }

    public void updateColours(Object source) {
        this.colourBySequence((AlignmentPanel)source);
    }

    public Color getColour(int atomIndex, int pdbResNum, String chain, String pdbfile) {
        if (!pdbfile.equals(this.pdbentry.getFile())) {
            return null;
        }
        return new Color(this.viewer.getAtomArgb(atomIndex));
    }

    public void colourBySequence(AlignmentPanel sourceap) {
        this.ap = sourceap;
        if (!this.colourBySequence) {
            return;
        }
        StructureMapping[] mapping = this.ssm.getMapping(this.pdbentry.getFile());
        if (mapping.length < 1) {
            return;
        }
        SequenceRenderer sr = new SequenceRenderer(this.ap.av);
        boolean showFeatures = false;
        if (this.ap.av.showSequenceFeatures) {
            showFeatures = true;
            if (this.fr == null) {
                this.fr = new FeatureRenderer(this.ap.av);
            }
            this.fr.transferSettings(this.ap.seqPanel.seqCanvas.getFeatureRenderer());
        }
        StringBuffer command = new StringBuffer();
        int lastPos = -1;
        block0: for (int s = 0; s < this.sequence.length; ++s) {
            for (int m = 0; m < mapping.length; ++m) {
                int sp;
                if (mapping[m].getSequence() != this.sequence[s] || (sp = this.ap.av.alignment.findIndex(this.sequence[s])) <= -1) continue;
                SequenceI asp = this.ap.av.alignment.getSequenceAt(sp);
                for (int r = 0; r < asp.getLength(); ++r) {
                    int pos;
                    if (Comparison.isGap(asp.getCharAt(r)) || (pos = mapping[m].getPDBResNum(asp.findPosition(r))) < 1 || pos == lastPos) continue;
                    lastPos = pos;
                    Color col = sr.getResidueBoxColour(this.sequence[s], r);
                    if (showFeatures) {
                        col = this.fr.findFeatureColour(col, this.sequence[s], r);
                    }
                    if (command.toString().endsWith(":" + mapping[m].getChain() + ";color[" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "]")) {
                        command = this.condenseCommand(command.toString(), pos);
                        continue;
                    }
                    command.append(";select " + pos);
                    if (!mapping[m].getChain().equals(" ")) {
                        command.append(":" + mapping[m].getChain());
                    }
                    command.append(";color[" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "]");
                }
                continue block0;
            }
        }
        if (this.lastCommand == null || !this.lastCommand.equals(command.toString())) {
            this.viewer.evalStringQuiet(command.toString());
        }
        this.lastCommand = command.toString();
    }

    StringBuffer condenseCommand(String command, int pos) {
        StringBuffer sb = new StringBuffer(command.substring(0, command.lastIndexOf("select") + 7));
        String start = (command = command.substring(sb.length())).indexOf("-") > -1 ? command.substring(0, command.indexOf("-")) : command.substring(0, command.indexOf(":"));
        sb.append(start + "-" + pos + command.substring(command.indexOf(":")));
        return sb;
    }

    public String eval(String strEval) {
        return null;
    }

    public void createImage(String file, String type, int quality) {
    }

    public void setCallbackFunction(String callbackType, String callbackFunction) {
    }

    public void notifyFileLoaded(String fullPathName, String fileName, String modelName, Object clientFile, String errorMsg) {
        StringBuffer title;
        if (errorMsg != null) {
            this.fileLoadingError = errorMsg;
            this.repaint();
            return;
        }
        this.fileLoadingError = null;
        if (fileName != null) {
            PDBfile pdb;
            this.jmolpopup.updateComputedMenus();
            this.viewer.evalStringQuiet("select backbone;restrict;cartoon;wireframe off;spacefill off");
            this.ssm = StructureSelectionManager.getStructureSelectionManager();
            if (this.loadedInline) {
                pdb = this.ssm.setMapping(this.sequence, this.chains, this.pdbentry.getFile(), AppletFormatAdapter.PASTE);
                this.pdbentry.setFile("INLINE" + pdb.id);
            } else {
                pdb = this.ssm.setMapping(this.sequence, this.chains, this.pdbentry.getFile(), AppletFormatAdapter.URL);
            }
            this.pdbentry.setId(pdb.id);
            this.ssm.addStructureViewerListener(this);
            Vector<String> chains = new Vector<String>();
            for (int i = 0; i < pdb.chains.size(); ++i) {
                chains.addElement(((PDBChain)pdb.chains.elementAt((int)i)).id);
            }
            this.setChainMenuItems(chains);
            this.colourBySequence(this.ap);
            title = new StringBuffer(this.sequence[0].getName() + ":" + this.pdbentry.getId());
            if (this.pdbentry.getProperty() != null) {
                if (this.pdbentry.getProperty().get("method") != null) {
                    title.append(" Method: ");
                    title.append(this.pdbentry.getProperty().get("method"));
                }
                if (this.pdbentry.getProperty().get("chains") != null) {
                    title.append(" Chain:");
                    title.append(this.pdbentry.getProperty().get("chains"));
                }
            }
        } else {
            return;
        }
        this.setTitle(title.toString());
    }

    public void notifyFrameChanged(int frameNo) {
        boolean isAnimationRunning = frameNo <= -2;
    }

    public void notifyScriptStart(String statusMessage, String additionalInfo) {
    }

    public void sendConsoleEcho(String strEcho) {
        if (this.scriptWindow == null) {
            this.showConsole(true);
        }
        this.history.append("\n" + strEcho);
    }

    public void sendConsoleMessage(String strStatus) {
        if (this.history != null && strStatus != null && !strStatus.equals("Script completed")) {
            this.history.append("\n" + strStatus);
        }
    }

    public void notifyScriptTermination(String strStatus, int msWalltime) {
    }

    public void handlePopupMenu(int x, int y) {
        this.jmolpopup.show(x, y);
    }

    public void notifyNewPickingModeMeasurement(int iatom, String strMeasure) {
        this.notifyAtomPicked(iatom, strMeasure);
    }

    public void notifyNewDefaultModeMeasurement(int count, String strInfo) {
    }

    public void notifyAtomPicked(int atomIndex, String strInfo) {
        int chainSeparator = strInfo.indexOf(":");
        if (chainSeparator == -1) {
            chainSeparator = strInfo.indexOf(".");
        }
        String picked = strInfo.substring(strInfo.indexOf("]") + 1, chainSeparator);
        if (strInfo.indexOf(":") > -1) {
            picked = picked + strInfo.substring(strInfo.indexOf(":") + 1, strInfo.indexOf("."));
        }
        if (!this.atomsPicked.contains(picked = picked + ".CA")) {
            this.viewer.evalString("select " + picked + ";label %n %r:%c");
            this.atomsPicked.addElement(picked);
        } else {
            this.viewer.evalString("select " + picked + ";label off");
            this.atomsPicked.removeElement(picked);
        }
    }

    public void notifyAtomHovered(int atomIndex, String strInfo) {
        this.mouseOverStructure(atomIndex, strInfo);
    }

    public void sendSyncScript(String script, String appletName) {
    }

    public void showUrl(String url) {
        try {
            this.ap.av.applet.getAppletContext().showDocument(new URL(url), "jmolOutput");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void showConsole(boolean showConsole) {
        if (this.scriptWindow == null) {
            this.scriptWindow = new Panel(new BorderLayout());
            this.inputLine = new TextField();
            this.history = new TextArea(5, 40);
            this.scriptWindow.add((Component)this.history, "Center");
            this.scriptWindow.add((Component)this.inputLine, "South");
            this.add((Component)this.scriptWindow, "South");
            this.scriptWindow.setVisible(false);
            this.history.setEditable(false);
            this.inputLine.addKeyListener(this);
        }
        this.scriptWindow.setVisible(!this.scriptWindow.isVisible());
        this.validate();
    }

    public float functionXY(String functionName, int x, int y) {
        return 0.0f;
    }

    class RenderPanel
    extends Panel {
        Dimension currentSize = new Dimension();
        Rectangle rectClip = new Rectangle();

        RenderPanel() {
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            this.currentSize = this.getSize();
            this.rectClip = g.getClipBounds();
            if (AppletJmol.this.viewer == null) {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.currentSize.width, this.currentSize.height);
                g.setColor(Color.white);
                g.setFont(new Font("Verdana", 1, 14));
                g.drawString("Retrieving PDB data....", 20, this.currentSize.height / 2);
            } else {
                AppletJmol.this.viewer.renderScreenImage(g, this.currentSize, this.rectClip);
            }
        }
    }
}

