/* $Id$ 
 *
 * BeginTransfer: allocate space for transfer region.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */
#ifndef __BEGIN_TRANSFER_HPP_INCLUDED
#define __BEGIN_TRANSFER_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Reference.hpp"

namespace intermediate {

//! allocate space for transfer region.
/** This opcode will allocate space for the named transfer region.
 *  SetParam call after BeginTransfer will write into this allocated region.
 *
 *  Read operands: src, comp
 *  Write operands: no publicly visible operands.
 *
 *  Operation:
 *      Allocate space for the transfer section of component src at an
 *      implementation defined location.
 *      Use comp as name for current stack frame.
 */
class BeginTransfer : public OpCode {
public:
	//! c'tor
	/** @param source reference to a component.
	 *  @param compName instance name of the component.
	 */
	BeginTransfer(
		Reference *source,
		Reference *compName) : src(source), comp(compName) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! references a component (denoting the transfer region of it)
	Reference *src;

	/** name of the instantiated component, in case the BeginTransfer
	 *  is used to call a component create function. Empty reference
	 *  otherwise.
	 *  Used so that the stack frames can denote unique instance names.
	 */
	Reference *comp;

protected:
	virtual ~BeginTransfer() {
		util::MiscUtil::terminate(this->src);
	}
};

}; /* namespace intermediate */

#endif /* __BEGIN_TRANSFER_HPP_INCLUDED */
