/*
 * $Id: arch_gen_cpu_x86_seg_fast.h,v 1.2 2009-01-23 10:34:54 potyra Exp $
 *
 * Derived from QEMU sources.
 * Modified for FAUmachine by Volkmar Sieh.
 *  
 *  Copyright (c) 2005-2009 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

#ifndef FAST
#error "Don't include in non-fast modules."
#endif

#ifndef __CPU_SEG_FAST_H_INCLUDED
#define __CPU_SEG_FAST_H_INCLUDED

/* return non zero if error */
static inline int
load_segment(uint32_t *e1_ptr, uint32_t *e2_ptr, int selector)
{
	SegmentCache *dt;
	int index_;
	target_ulong ptr;

	if (selector & 0x4)
		dt = &env->ldt;
	else
		dt = &env->gdt;
	index_ = selector & ~7;
	if ((index_ + 7) > dt->limit)
		return -1;
	ptr = dt->base + index_;
	*e1_ptr = ldl_kernel(ptr);
	*e2_ptr = ldl_kernel(ptr + 4);
	return 0;
}

static inline unsigned int
get_seg_limit(uint32_t e1, uint32_t e2)
{
	unsigned int limit;
	limit = (e1 & 0xffff) | (e2 & 0x000f0000);
	if (e2 & DESC_G_MASK)
		limit = (limit << 12) | 0xfff;
	return limit;
}

static inline uint32_t
get_seg_base(uint32_t e1, uint32_t e2)
{
	return ((e1 >> 16) | ((e2 & 0xff) << 16) | (e2 & 0xff000000));
}

#endif /* __CPU_SEG_FAST_H_INCLUDED */
