/*
declare name "Modulations";
declare author "ER";

import("stdfaust.lib");
instrument = library("instruments.lib"); 

// =========== DESCRIPTION ==============

//- Non Linear Filter Modulators applied to a sinewave
//- Head = Silence/Revereration/Higher Frequencies
//- Bottom = Modulation n°3 = FM/ Lower Frequencies
//- Rocking = Modulating Frequency (low to high)
//- Front = Modulation n°2
//- Left = Modulation n°0 & n°1
//- Upward = swing from head/bottom/head (a bit like tennis racket) = interesting

//======================== INSTRUMENT =============================

process = vgroup("Modulations",oscil <: seq(i, 3, NLFM(i)), NLFM3 :> fi.lowpass(1,2000) *(0.6) *(vol) <: instrReverbMod:*(vool),*(vool));

NLFM(n) = _ : instrument.nonLinearModulator((nonlinearity:si.smooth(0.999)),env(n),freq,typeMod(n),freqMod,nlfOrder) : _;
NLFM3 = _ : instrument.nonLinearModulator((nonlinearity:si.smooth(0.999)),env(3),freq,typeMod(3),freqMod,nlfOrder) : _;
oscil = os.osci(freq);

//======================== GUI SPECIFICATIONS =====================

freq = hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330, 100, 1200, 0.1):si.smooth(0.999);
freqMod = hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200, 900, 1700, 0.1):si.smooth(0.999);

vol = (hslider("h:Instrument/ Oscillator Volume[style:knob][acc:1 0 -10 0 10]", 0.5, 0, 1, 0.01)^2):si.smooth(0.999);
vool = hslider("h:Instrument/ General Volume[style:knob][acc:1 1 -10 0 10]", 1, 0.75, 4, 0.01):si.smooth(0.999):min(4):max(0.75);

gate(0) = hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0,0,1,1);
gate(1) = hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0,0,1,1);
gate(2) = hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0,0,1,1);
gate(3) = hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0,0,1,1);

//------------------------ NLFM PARAMETERS ------------------------
nlfOrder = 6;
nonlinearity = 0.8;
typeMod(n) = n;

env(n) = ASR(n);
ASR(n) = en.asr(a,s,r,t(n));
a = 3;
s = 1;
r = 2;
t(n) = gate(n);

//----------------------- INSTRREVERB -------------------------------

instrReverbMod = _,_ <: *(reverbGain),*(reverbGain),*(1 - reverbGain),*(1 - reverbGain) :
re.zita_rev1_stereo(rdel,f1,f2,t60dc,t60m,fsmax),_,_ <: _,!,_,!,!,_,!,_ : +,+
    with {
       reverbGain = hslider("v:Reverb/Reverberation Volume(InstrReverb)[acc:1 1 -10 0 10]",0.25,0.05,1,0.01) : si.smooth(0.999):min(1):max(0.05);
       roomSize = hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5,0.05,2,0.01):min(2):max(0.05);
       rdel = 20;
       f1 = 200;
       f2 = 6000;
       t60dc = roomSize*3;
       t60m = roomSize*2;
       fsmax = 48000;
    };
*/

declare compilation_options    "-single -scal -e Modulations.dsp -o Modulations_exp.dsp";
declare library_path "/Documents/faustwebsite-github/modules-worklet/Modulations.dsp";
declare library_path "/usr/local/share/faust/stdfaust.lib";
declare library_path "/usr/local/share/faust/oscillators.lib";
declare library_path "/usr/local/share/faust/signals.lib";
declare library_path "/usr/local/share/faust/maths.lib";
declare library_path "/usr/local/share/faust/basics.lib";
declare library_path "/usr/local/share/faust/instruments.lib";
declare library_path "/usr/local/share/faust/envelopes.lib";
declare library_path "/usr/local/share/faust/filters.lib";
declare library_path "/usr/local/share/faust/reverbs.lib";
declare library_path "/usr/local/share/faust/delays.lib";
declare library_path "/usr/local/share/faust/routes.lib";
declare author "ER";
declare basics_lib_name "Faust Basic Element Library";
declare basics_lib_version "0.0";
declare delays_lib_name "Faust Delay Library";
declare delays_lib_version "0.1";
declare envelopes_lib_author "GRAME";
declare envelopes_lib_copyright "GRAME";
declare envelopes_lib_license "LGPL with exception";
declare envelopes_lib_name "Faust Envelope Library";
declare envelopes_lib_version "0.0";
declare filename "Modulations";
declare filters_lib_name "Faust Filters Library";
declare filters_lib_version "0.0";
declare instruments_lib_author "Romain Michon (rmichon@ccrma.stanford.edu)";
declare instruments_lib_copyright "Romain Michon";
declare instruments_lib_licence "STK-4.3";
declare instruments_lib_name "Faust-STK Tools Library";
declare instruments_lib_version "1.0";
declare maths_lib_author "GRAME";
declare maths_lib_copyright "GRAME";
declare maths_lib_license "LGPL with exception";
declare maths_lib_name "Faust Math Library";
declare maths_lib_version "2.1";
declare name "Modulations";
declare oscillators_lib_name "Faust Oscillator Library";
declare oscillators_lib_version "0.0";
declare reverbs_lib_name "Faust Reverb Library";
declare reverbs_lib_version "0.0";
declare routes_lib_name "Faust Signal Routing Library";
declare routes_lib_version "0.0";
declare signals_lib_name "Faust Signal Routing Library";
declare signals_lib_version "0.0";
process = vgroup("Modulations", (65537,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),(65536 : float) : / : sin),((hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x1).(x1,(x1 : floor) : -))~_ : _,(65536 : float) : * : int) : rdtable),((((hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x2).(x2,(x2 : floor) : -))~_ : _,65536.0f : *),((hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x2).(x2,(x2 : floor) : -))~_ : _,65536.0f : * : floor) : -),((65537,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),(65536 : float) : / : sin),(((hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x1).(x1,(x1 : floor) : -))~_ : _,(65536 : float) : * : int),1 : +) : rdtable),(65537,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),(65536 : float) : / : sin),((hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x1).(x1,(x1 : floor) : -))~_ : _,(65536 : float) : * : int) : rdtable) : -) : *) : +<:(_ : _<:((_<:_<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : * : (+ : _)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : * : cos) : *) : +),0 : *),((_<:(\(x109).(x109<:_<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : * : (+ : _)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),1 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x109,(x109 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x109 : *),x109 : *),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x70).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x70,1 : +) : min),0 : select2)~_ : \(x71).(0,0,x71,0) : \(x72).(\(x73).(\(x74).(\(x75).((x74,x72 : <),((x74,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x73,(((x74,x72 : -),((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x73 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x72 : -) : /) : +) : select2),x75 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x76).(((hslider("v:Modulations/Play Modulation 0 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x76,1 : +) : min),0 : select2)~_ : \(x77).(\(x78).(0,x77,x78,x77)) : \(x79).(\(x80).(\(x81).(\(x82).((x81,x79 : <),((x81,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x80,(((x81,x79 : -),(0,x80 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x79 : -) : /) : +) : select2),x82 : select2))))) : *),0 : *) : + : cos) : *) : +),(0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(_,(1,(0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : -) : *):>+),1 : *):>+ : _ : _ : _<:((_<:_<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : * : (+ : _)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : * : cos) : *) : +),0 : *),((_<:(\(x110).(x110<:_<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : * : (+ : _)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x110,(x110 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),1 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x110 : *),x110 : *),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x44).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x44,1 : +) : min),0 : select2)~_ : \(x45).(0,0,x45,0) : \(x46).(\(x47).(\(x48).(\(x49).((x48,x46 : <),((x48,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x47,(((x48,x46 : -),((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x47 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x46 : -) : /) : +) : select2),x49 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x50).(((hslider("v:Modulations/Play Modulation 1 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:0 0 -30 0 5]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x50,1 : +) : min),0 : select2)~_ : \(x51).(\(x52).(0,x51,x52,x51)) : \(x53).(\(x54).(\(x55).(\(x56).((x55,x53 : <),((x55,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x54,(((x55,x53 : -),(0,x54 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x53 : -) : /) : +) : select2),x56 : select2))))) : *),0 : *) : + : cos) : *) : +),(0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(_,(1,(0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : -) : *):>+),1 : *):>+ : _ : _ : _<:((_<:_<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : * : (+ : _)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : * : cos) : *) : +),0 : *),((_<:(\(x111).(x111<:_<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : * : (+ : _)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x111,(x111 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x111 : *),x111 : *),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x18).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x18,1 : +) : min),0 : select2)~_ : \(x19).(0,0,x19,0) : \(x20).(\(x21).(\(x22).(\(x23).((x22,x20 : <),((x22,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x21,(((x22,x20 : -),((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x21 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x20 : -) : /) : +) : select2),x23 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x24).(((hslider("v:Modulations/Play Modulation 2 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:2 1 -30 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x24,1 : +) : min),0 : select2)~_ : \(x25).(\(x26).(0,x25,x26,x25)) : \(x27).(\(x28).(\(x29).(\(x30).((x29,x27 : <),((x29,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x28,(((x29,x27 : -),(0,x28 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x27 : -) : /) : +) : select2),x30 : select2))))) : *),1 : *) : + : cos) : *) : +),(0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(_,(1,(0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : -) : *):>+),1 : *):>+ : _),(_ : _<:((_<:_<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : * : (+ : _<:(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : *),(_,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : * : (+ : _)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : *) : +)~(_,(0,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : sin) : -) : *)) : _,(mem,((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),(65536,((((_,1 : +)~_,1 : - : float),6.2831853071795862f : *),65536.0f : / : sin),(((0,(hslider("h:Instrument/ Frequency [unit:Hz][acc:1 1 -10 0 15]", 330.0f, 100.0f, 1200.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(1,(hslider("h:Instrument/Modulating Frequency[style:knob][unit:Hz][acc:0 0 -10 0 10]", 1200.0f, 900.0f, 1700.0f, 0.10000000000000001f) : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *) : +),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : (+ : \(x17).(x17,(x17 : floor) : -))~_ : _,65536.0f : * : int) : rdtable) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : * : cos) : *) : +),1 : *),((_<:(\(x112).(x112<:_<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : * : (+ : _<:(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : *),(_,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : * : (+ : _)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : *) : +)~(_,(0,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : sin) : -) : *)) : _,(mem,(((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *),(((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),((x112,(x112 : mem) : +),2 : /) : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : +),((((((0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)),3.1415926535897931f : *),x112 : *),x112 : *),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),(\(x96).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : ==),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),(x96,1 : +) : min),0 : select2)~_ : \(x97).(0,0,x97,0) : \(x98).(\(x99).(\(x100).(\(x101).((x100,x98 : <),((x100,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *) : <),(hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),(x99,(((x100,x98 : -),((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),1 : *),x99 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),3 : *),x98 : -) : /) : +) : select2),x101 : select2))))) : * : ((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),_,_ : select2)~_ : _,\(x102).(((hslider("v:Modulations/Play Modulation 3 (ASR Envelope)[tooltip:noteOn = 1, noteOff = 0][acc:1 0 -10 0 10]", 0.0f, 0.0f, 1.0f, 1.0f),0 : >),0 : >),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),(x102,1 : +) : min),0 : select2)~_ : \(x103).(\(x104).(0,x103,x104,x103)) : \(x105).(\(x106).(\(x107).(\(x108).((x107,x105 : <),((x107,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *) : <),0,(x106,(((x107,x105 : -),(0,x106 : -) : *),(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),2 : *),x105 : -) : /) : +) : select2),x108 : select2))))) : *),0 : *) : + : cos) : *) : +),(0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *),(_,(1,(0.80000000000000004f : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : -) : *):>+),0 : *):>+ : _):>((_<:(_,((1,(0,(1,(6283.1853071795858f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : +),(1,(1,(6283.1853071795858f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *),(mem : _,((1,(0,(1,(6283.1853071795858f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : -),(1,(1,(6283.1853071795858f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *):>+~(_,(0,((1,(1,(6283.1853071795858f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : -),(1,(1,(6283.1853071795858f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : -) : *)),0.59999999999999998f : *),(hslider("h:Instrument/ Oscillator Volume[style:knob][acc:1 0 -10 0 10]", 0.5f, 0.0f, 1.0f, 0.01f),2 : pow : _,0.0010000000000000009f : * : +~(_,0.999f : *)) : *<:_,_<:(_,(hslider("v:Reverb/Reverberation Volume(InstrReverb)[acc:1 1 -10 0 10]", 0.25f, 0.050000000000000003f, 1.0f, 0.01f) : _,0.0010000000000000009f : * : +~(_,0.999f : *) : 1,_ : min : 0.050000000000000003f,_ : max) : *),(_,(hslider("v:Reverb/Reverberation Volume(InstrReverb)[acc:1 1 -10 0 10]", 0.25f, 0.050000000000000003f, 1.0f, 0.01f) : _,0.0010000000000000009f : * : +~(_,0.999f : *) : 1,_ : min : 0.050000000000000003f,_ : max) : *),(_,(1,(hslider("v:Reverb/Reverberation Volume(InstrReverb)[acc:1 1 -10 0 10]", 0.25f, 0.050000000000000003f, 1.0f, 0.01f) : _,0.0010000000000000009f : * : +~(_,0.999f : *) : 1,_ : min : 0.050000000000000003f,_ : max) : -) : *),(_,(1,(hslider("v:Reverb/Reverberation Volume(InstrReverb)[acc:1 1 -10 0 10]", 0.25f, 0.050000000000000003f, 1.0f, 0.01f) : _,0.0010000000000000009f : * : +~(_,0.999f : *) : 1,_ : min : 0.050000000000000003f,_ : max) : -) : *) : ((\(x113).(x113,(8192,(0,(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),20 : *),0.001f : *) : max) : min) : @),0.29999999999999999f : *),(\(x113).(x113,(8192,(0,(((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),20 : *),0.001f : *) : max) : min) : @),0.29999999999999999f : *) : _,_<:_,_,(_,-1 : *),(_,-1 : *),_,_,(_,-1 : *),(_,-1 : *) : (_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_:>((+<:\(x114).(x114,(1024,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.020346f : *) : + : floor),1 : -) : max) : min) : @),(_,0.59999999999999998f : *))~(_,-0.59999999999999998f : *) : mem,_ : +),((+<:\(x115).(x115,(2048,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.024421000000000002f : *) : + : floor),1 : -) : max) : min) : @),(_,-0.59999999999999998f : *))~(_,0.59999999999999998f : *) : mem,_ : +),((+<:\(x116).(x116,(2048,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.031604f : *) : + : floor),1 : -) : max) : min) : @),(_,0.59999999999999998f : *))~(_,-0.59999999999999998f : *) : mem,_ : +),((+<:\(x117).(x117,(2048,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.027333f : *) : + : floor),1 : -) : max) : min) : @),(_,-0.59999999999999998f : *))~(_,0.59999999999999998f : *) : mem,_ : +),((+<:\(x118).(x118,(2048,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.022904000000000001f : *) : + : floor),1 : -) : max) : min) : @),(_,0.59999999999999998f : *))~(_,-0.59999999999999998f : *) : mem,_ : +),((+<:\(x119).(x119,(2048,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.029291000000000001f : *) : + : floor),1 : -) : max) : min) : @),(_,-0.59999999999999998f : *))~(_,0.59999999999999998f : *) : mem,_ : +),((+<:\(x120).(x120,(1024,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.013457999999999999f : *) : + : floor),1 : -) : max) : min) : @),(_,0.59999999999999998f : *))~(_,-0.59999999999999998f : *) : mem,_ : +),((+<:\(x121).(x121,(1024,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.019123000000000001f : *) : + : floor),1 : -) : max) : min) : @),(_,-0.59999999999999998f : *))~(_,0.59999999999999998f : *) : mem,_ : +) : _,_,_,_,_,_,_,_<:(_,_,_,_,_,_,_,_<:_,!,!,!,!,!,!,!,!,!,!,!,_,!,!,!,!,_,!,!,!,!,!,!,!,!,!,!,!,_,!,!,!,!,_,!,!,!,!,!,!,!,!,!,!,!,_,!,!,!,!,_,!,!,!,!,!,!,!,!,!,!,!,_),(_,_,_,_,_,_,_,_<:_,!,!,!,!,!,!,!,!,!,!,!,_,!,!,!,!,_,!,!,!,!,!,!,!,!,!,!,!,_,!,!,!,!,_,!,!,!,!,!,!,!,!,!,!,!,_,!,!,!,!,_,!,!,!,!,!,!,!,!,!,!,!,_) : +,+,+,+,-,-,-,- : (_,_,_,_<:(_,_,_,_<:_,!,!,!,!,!,_,!,!,_,!,!,!,!,!,_),(_,_,_,_<:_,!,!,!,!,!,_,!,!,_,!,!,!,!,!,_) : +,+,-,- : (_,_<:(_,_<:_,!,!,_),(_,_<:_,!,!,_) : +,-),(_,_<:(_,_<:_,!,!,_),(_,_<:_,!,!,_) : +,-)),(_,_,_,_<:(_,_,_,_<:_,!,!,!,!,!,_,!,!,_,!,!,!,!,!,_),(_,_,_,_<:_,!,!,!,!,!,_,!,!,_,!,!,!,!,!,_) : +,+,-,- : (_,_<:(_,_<:_,!,!,_),(_,_<:_,!,!,_) : +,-),(_,_<:(_,_<:_,!,!,_),(_,_<:_,!,!,_) : +,-)))~(((((((-3.0f,(10.0f : log) : *),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),\(x122).(x122,(((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),3 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : /),1 : -),(x122 : _<:(_,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : +),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *),(mem : _,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *):>+~(_,(0,((1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : -) : *)) : *) : +) : * : _,(1.0f,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : -) : * : +~(_,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : *)),(8 : float : sqrt) : /),9.9999999999999995e-21f : +),((((((-3.0f,(10.0f : log) : *),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),\(x123).(x123,(((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),3 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : /),1 : -),(x123 : _<:(_,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : +),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *),(mem : _,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *):>+~(_,(0,((1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : -) : *)) : *) : +) : * : _,(1.0f,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : -) : * : +~(_,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : *)),(8 : float : sqrt) : /),9.9999999999999995e-21f : +),((((((-3.0f,(10.0f : log) : *),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),\(x124).(x124,(((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),3 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : /),1 : -),(x124 : _<:(_,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : +),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *),(mem : _,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *):>+~(_,(0,((1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : -) : *)) : *) : +) : * : _,(1.0f,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : -) : * : +~(_,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : *)),(8 : float : sqrt) : /),9.9999999999999995e-21f : +),((((((-3.0f,(10.0f : log) : *),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),\(x125).(x125,(((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),3 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : /),1 : -),(x125 : _<:(_,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : +),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *),(mem : _,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *):>+~(_,(0,((1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : -) : *)) : *) : +) : * : _,(1.0f,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : -) : * : +~(_,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : *)),(8 : float : sqrt) : /),9.9999999999999995e-21f : +),((((((-3.0f,(10.0f : log) : *),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),\(x126).(x126,(((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),3 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : /),1 : -),(x126 : _<:(_,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : +),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *),(mem : _,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *):>+~(_,(0,((1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : -) : *)) : *) : +) : * : _,(1.0f,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : -) : * : +~(_,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : *)),(8 : float : sqrt) : /),9.9999999999999995e-21f : +),((((((-3.0f,(10.0f : log) : *),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),\(x127).(x127,(((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),3 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : /),1 : -),(x127 : _<:(_,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : +),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *),(mem : _,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *):>+~(_,(0,((1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : -) : *)) : *) : +) : * : _,(1.0f,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : -) : * : +~(_,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : *)),(8 : float : sqrt) : /),9.9999999999999995e-21f : +),((((((-3.0f,(10.0f : log) : *),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),\(x128).(x128,(((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),3 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : /),1 : -),(x128 : _<:(_,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : +),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *),(mem : _,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *):>+~(_,(0,((1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : -) : *)) : *) : +) : * : _,(1.0f,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : -) : * : +~(_,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : *)),(8 : float : sqrt) : /),9.9999999999999995e-21f : +),((((((-3.0f,(10.0f : log) : *),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),\(x129).(x129,(((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),3 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : /),1 : -),(x129 : _<:(_,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : +),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *),(mem : _,((1,(0,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : *) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : *):>+~(_,(0,((1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : -),(1,(1,(628.31853071795865f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : / : tan) : /) : +) : /) : -) : *)) : *) : +) : * : _,(1.0f,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : -) : * : +~(_,(((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),(0,((((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /),((1.0f,((((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *),(37699.111843077517f,(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min : float) : / : cos) : *) : -),(1.0f,(((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp),((-6.9077552789821377f,(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor) : *),(((hslider("v:Reverb/Reverberation Room Size(InstrReverb)[acc:1 1 -10 0 10]", 0.5f, 0.050000000000000003f, 2.0f, 0.01f) : 2,_ : min : 0.050000000000000003f,_ : max),2 : *),(192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min) : *) : / : exp) : *) : -) : /) : *),1.0f : -) : max : sqrt) : -) : *)),(8 : float : sqrt) : /),9.9999999999999995e-21f : +) : \(x130).(x130,(8192,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.15312899999999999f : *) : + : floor),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.020346f : *) : + : floor) : -) : max) : min) : @),\(x131).(x131,(16384,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21038899999999999f : *) : + : floor),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.024421000000000002f : *) : + : floor) : -) : max) : min) : @),\(x132).(x132,(8192,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.12783700000000001f : *) : + : floor),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.031604f : *) : + : floor) : -) : max) : min) : @),\(x133).(x133,(16384,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.25689099999999998f : *) : + : floor),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.027333f : *) : + : floor) : -) : max) : min) : @),\(x134).(x134,(8192,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.17471300000000001f : *) : + : floor),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.022904000000000001f : *) : + : floor) : -) : max) : min) : @),\(x135).(x135,(8192,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.192303f : *) : + : floor),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.029291000000000001f : *) : + : floor) : -) : max) : min) : @),\(x136).(x136,(8192,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.125f : *) : + : floor),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.013457999999999999f : *) : + : floor) : -) : max) : min) : @),\(x137).(x137,(16384,(0,((0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.21999099999999999f : *) : + : floor),(0.5f,((192000.0f,(1.0f,fconstant(int fSamplingFreq, <math.h>) : max) : min),0.019123000000000001f : *) : + : floor) : -) : max) : min) : @)) : !,(_,_<:(_,_<:_,!,!,_),(_,_<:_,!,!,_) : +,-),!,!,!,!,! : (_,0.37f : *),(_,0.37f : *)),_,_<:_,!,_,!,!,_,!,_ : +,+ : (_,(hslider("h:Instrument/ General Volume[style:knob][acc:1 1 -10 0 10]", 1.0f, 0.75f, 4.0f, 0.01f) : _,0.0010000000000000009f : * : +~(_,0.999f : *) : 4,_ : min : 0.75f,_ : max) : *),(_,(hslider("h:Instrument/ General Volume[style:knob][acc:1 1 -10 0 10]", 1.0f, 0.75f, 4.0f, 0.01f) : _,0.0010000000000000009f : * : +~(_,0.999f : *) : 4,_ : min : 0.75f,_ : max) : *));
