/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Element;
import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphEvent;
import hypergraph.graphApi.Node;
import hypergraph.hyperbolic.Complex;
import hypergraph.visualnet.AbstractGraphLayout;
import hypergraph.visualnet.DefaultGraphLayoutModel;
import java.util.Iterator;

public class RandomLayout
extends AbstractGraphLayout {
    public RandomLayout() {
    }

    public RandomLayout(Graph graph) {
        this.setGraph(graph);
    }

    public void elementsAdded(GraphEvent graphEvent) {
        this.invalidate();
        Element element = graphEvent.getElement();
        if (element instanceof Node) {
            this.getGraphLayoutModel().setNodePosition((Node)element, new Complex(Math.random() * 1.4 - 0.7, Math.random() * 1.4 - 0.7));
        }
    }

    public void layout() {
        if (this.getGraphLayoutModel() == null) {
            this.setGraphLayoutModel(new DefaultGraphLayoutModel());
        }
        Iterator iterator = this.getGraph().getNodes().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            this.getGraphLayoutModel().setNodePosition(node, new Complex(Math.random() * 1.4 - 0.7, Math.random() * 1.4 - 0.7));
        }
        this.getGraphLayoutModel().setValid(true);
    }

    public boolean isExpandingEnabled() {
        return false;
    }
}

