(declare (extended-bindings) (not constant-fold) (not safe))

(define v1 (##s16vector -32768 -111 0 111 32767))
(define v2 (##make-s16vector 10 -32768))
(define v3 (##make-s16vector 10 -111))
(define v4 (##make-s16vector 10))
(define v5 (##make-s16vector 10 111))
(define v6 (##make-s16vector 10 32767))

(define (test v i expected)
  (println (##eq? v (##s16vector-set! v i 0)))
  (let ((val (##s16vector-ref v i))) 
    (println (if (##fx= val 0) "good" "bad")))
  (println (##eq? v (##s16vector-set! v i expected)))
  (let ((val (##s16vector-ref v i))) 
    (println (if (##fx= val expected) "good" "bad"))))

(test v1 0 -32768)
(test v1 1 -111)
(test v1 2 0)
(test v1 3 111)
(test v1 4 32767)

(test v2 9 -32768)
(test v3 9 -111)
(test v4 9 0)
(test v5 9 111)
(test v6 9 32767)
