# Copyright (C) 2001-2009 Yves Renard
#
# This file is a part of GETFEM++
#
# Getfem++  is  free software;  you  can  redistribute  it  and/or modify it
# under  the  terms  of the  GNU  Lesser General Public License as published
# by  the  Free Software Foundation;  either version 2.1 of the License,  or
# (at your option) any later version.
# This program  is  distributed  in  the  hope  that it will be useful,  but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or  FITNESS  FOR  A PARTICULAR PURPOSE.  See the GNU Lesser General Public
# License for more details.
# You  should  have received a copy of the GNU Lesser General Public License
# along  with  this program;  if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA.

from getfem import *
from numpy import *
from scipy import *
from matplotlib.pyplot import * # see http://matplotlib.sourceforge.net/



with_graphics=True
try:
    import getfem_tvtk
except:
    print "\n** Could NOT import getfem_tvtk -- graphical output disabled **\n"
    import time
    time.sleep(2)
    with_graphics=False

print 'Some tests with python',

if 0:

    # m=Mesh('load', '../../tests/meshes/disc_P2_h4.mesh')
    m=Mesh('import', 'gmsh', '/media/disk/rectangularQ3.msh')


    if with_graphics:
        fig = getfem_tvtk.Figure()
        fig.show_mesh(m, faces=0, edges=1)
        print "Press Q to continue.."
        fig.set_colormap('tripod')
        fig.loop()



# convergence graphics
params = {'backend': 'ps',
          'axes.labelsize': 20,
          'text.fontsize': 20,
          'legend.fontsize': 20,
          'xtick.labelsize': 20,
          'ytick.labelsize': 20,
          'text.usetex': True,
          'figure.figsize': (9,6)}
rcParams.update(params)


if 1:

    T = loadtxt('mixed_dynamic_friction.t');
    E = loadtxt('mixed_dynamic_friction.e');
    u = loadtxt('mixed_dynamic_friction.u');
    s = loadtxt('mixed_dynamic_friction.s');
    plot(T, E, '-', lw=2, alpha=0.9);
    xlabel(r"mesh size $h$", fontsize=20);
    ylabel(r'$H_1$ and $L_2$ error', fontsize=20);
    show()
    

if 0:

    # elastodyn case (P2)
    h = array([0.5, 1., 2., 4.]);
    el2 = array([0.416, 0.891, 3.236, 8.909]); al2=stats.linregress(log(h),log(el2));
    eh1 = array([0.619, 1.095, 3.388, 9.098]); ah1=stats.linregress(log(h),log(eh1));
    # ms = taille des "points", mfc = couleurs des "points"
    # alpha = transparence des "points", lw = linewidth 
    # fig = figure(figsize=(9,6))
    grid(True)
    
    
    # ax = fig.add_subplot(111)
    loglog(h, el2, 'o-', ms=15, lw=2, alpha=0.9, mfc='orange')
    loglog(h, eh1, 'd-', ms=15, lw=2, alpha=0.9, mfc='red')
    loglog(h, exp(al2[0]*log(h)+al2[1]), 'k:')
    loglog(h, exp(ah1[0]*log(h)+ah1[1]), 'k:')
    xlim((0.4, 10.0))
    ylim((0.2, 17.0))
    # lines marker : [ $B!F(B+$B!G(B | $B!F(B*$B!G(B | $B!F(B,$B!G(B | $B!F(B.$B!G(B | $B!F(B1$B!G(B | $B!F(B2$B!G(B | $B!F(B3$B!G(B | $B!F(B4$B!G(B | $B!F(B<$B!G(B | $B!F(B>$B!G(B | $B!F(BD$B!G(B | $B!F(BH$B!G(B | $B!F(B^$B!G(B | $B!F(B_$B!G(B | $B!F(Bd$B!G(B | $B!F(Bh$B!G(B | $B!F(Bo$B!G(B | $B!F(Bp$B!G(B | $B!F(Bs$B!G(B | $B!F(Bv$B!G(B | $B!F(Bx$B!G(B | $B!F(B|$B!G(B | TICKUP | TICKDOWN | TICKLEFT | TICKRIGHT | $B!F(BNone$B!G(B | $B!F(B $B!F(B | $B!F!G(B ]
    # line style [ $B!F(B-$B!F(B | $B!F(B_$B!G(B | $B!F(B-.$B!G(B | $B!F(B:$B!G(B | $B!F(BNone$B!G(B | $B!F(B $B!F(B | $B!F!G(B ] 
    
    # title('the title', fontsize=20)
    xlabel(r"mesh size $h$", fontsize=20)
    ylabel(r'$H_1$ and $L_2$ error', fontsize=20)
    legend((r'$L_2$ error (rate %f)' % al2[0], r'$H_1$ error (rate %f)' % ah1[0]), 'upper left', shadow=True)
    show()
    


if 0 :

    # scalar case (P2)
    h = array([0.0125, 0.025, 0.05, 0.1, 0.2]);
    el2 = array([0.001547, 0.003366, 0.005068, 0.007915, 0.007619]); al2=stats.linregress(log(h),log(el2));
    eh1 = array([0.04558,  0.06532, 0.06480, 0.07417, 0.0751705]); ah1=stats.linregress(log(h),log(eh1));
    loglog(h, el2, 'o-', ms=15, lw=2, alpha=0.9, mfc='orange')
    loglog(h, eh1, 'd-', ms=15, lw=2, alpha=0.9, mfc='red')
    loglog(h, exp(al2[0]*log(h)+al2[1]), 'k:')
    loglog(h, exp(ah1[0]*log(h)+ah1[1]), 'k:')
    # xlim((0.4, 10.0))
    # ylim((0.2, 17.0))
    xlabel(r"mesh size $h$", fontsize=20)
    ylabel(r'$H_1$ and $L_2$ error', fontsize=20)
    legend((r'$L_2$ error (rate %f)' % al2[0], r'$H_1$ error (rate %f)' % ah1[0]), 'upper left', shadow=True)
    show()
    

