// Code generated by smithy-go-codegen DO NOT EDIT.

package iotevents

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/iotevents/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateAlarmModel struct {
}

func (*validateOpCreateAlarmModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAlarmModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAlarmModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAlarmModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDetectorModel struct {
}

func (*validateOpCreateDetectorModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDetectorModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDetectorModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDetectorModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateInput struct {
}

func (*validateOpCreateInput) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateInput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateInputInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateInputInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAlarmModel struct {
}

func (*validateOpDeleteAlarmModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAlarmModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAlarmModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAlarmModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDetectorModel struct {
}

func (*validateOpDeleteDetectorModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDetectorModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDetectorModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDetectorModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteInput struct {
}

func (*validateOpDeleteInput) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteInput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteInputInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteInputInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeAlarmModel struct {
}

func (*validateOpDescribeAlarmModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeAlarmModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeAlarmModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeAlarmModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDetectorModelAnalysis struct {
}

func (*validateOpDescribeDetectorModelAnalysis) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDetectorModelAnalysis) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDetectorModelAnalysisInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDetectorModelAnalysisInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeDetectorModel struct {
}

func (*validateOpDescribeDetectorModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDetectorModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDetectorModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDetectorModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeInput struct {
}

func (*validateOpDescribeInput) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeInput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeInputInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeInputInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDetectorModelAnalysisResults struct {
}

func (*validateOpGetDetectorModelAnalysisResults) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDetectorModelAnalysisResults) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDetectorModelAnalysisResultsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDetectorModelAnalysisResultsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAlarmModelVersions struct {
}

func (*validateOpListAlarmModelVersions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAlarmModelVersions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAlarmModelVersionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAlarmModelVersionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDetectorModelVersions struct {
}

func (*validateOpListDetectorModelVersions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDetectorModelVersions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDetectorModelVersionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDetectorModelVersionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListInputRoutings struct {
}

func (*validateOpListInputRoutings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListInputRoutings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListInputRoutingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListInputRoutingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutLoggingOptions struct {
}

func (*validateOpPutLoggingOptions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutLoggingOptions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutLoggingOptionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutLoggingOptionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartDetectorModelAnalysis struct {
}

func (*validateOpStartDetectorModelAnalysis) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartDetectorModelAnalysis) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartDetectorModelAnalysisInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartDetectorModelAnalysisInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateAlarmModel struct {
}

func (*validateOpUpdateAlarmModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateAlarmModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateAlarmModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateAlarmModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDetectorModel struct {
}

func (*validateOpUpdateDetectorModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDetectorModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDetectorModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDetectorModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateInput struct {
}

func (*validateOpUpdateInput) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateInput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateInputInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateInputInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateAlarmModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAlarmModel{}, middleware.After)
}

func addOpCreateDetectorModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDetectorModel{}, middleware.After)
}

func addOpCreateInputValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateInput{}, middleware.After)
}

func addOpDeleteAlarmModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAlarmModel{}, middleware.After)
}

func addOpDeleteDetectorModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDetectorModel{}, middleware.After)
}

func addOpDeleteInputValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteInput{}, middleware.After)
}

func addOpDescribeAlarmModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeAlarmModel{}, middleware.After)
}

func addOpDescribeDetectorModelAnalysisValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDetectorModelAnalysis{}, middleware.After)
}

func addOpDescribeDetectorModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDetectorModel{}, middleware.After)
}

func addOpDescribeInputValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeInput{}, middleware.After)
}

func addOpGetDetectorModelAnalysisResultsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDetectorModelAnalysisResults{}, middleware.After)
}

func addOpListAlarmModelVersionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAlarmModelVersions{}, middleware.After)
}

func addOpListDetectorModelVersionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDetectorModelVersions{}, middleware.After)
}

func addOpListInputRoutingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListInputRoutings{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPutLoggingOptionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutLoggingOptions{}, middleware.After)
}

func addOpStartDetectorModelAnalysisValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartDetectorModelAnalysis{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateAlarmModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateAlarmModel{}, middleware.After)
}

func addOpUpdateDetectorModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDetectorModel{}, middleware.After)
}

func addOpUpdateInputValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateInput{}, middleware.After)
}

func validateAcknowledgeFlow(v *types.AcknowledgeFlow) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcknowledgeFlow"}
	if v.Enabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Enabled"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAction(v *types.Action) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Action"}
	if v.SetVariable != nil {
		if err := validateSetVariableAction(v.SetVariable); err != nil {
			invalidParams.AddNested("SetVariable", err.(smithy.InvalidParamsError))
		}
	}
	if v.Sns != nil {
		if err := validateSNSTopicPublishAction(v.Sns); err != nil {
			invalidParams.AddNested("Sns", err.(smithy.InvalidParamsError))
		}
	}
	if v.IotTopicPublish != nil {
		if err := validateIotTopicPublishAction(v.IotTopicPublish); err != nil {
			invalidParams.AddNested("IotTopicPublish", err.(smithy.InvalidParamsError))
		}
	}
	if v.SetTimer != nil {
		if err := validateSetTimerAction(v.SetTimer); err != nil {
			invalidParams.AddNested("SetTimer", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClearTimer != nil {
		if err := validateClearTimerAction(v.ClearTimer); err != nil {
			invalidParams.AddNested("ClearTimer", err.(smithy.InvalidParamsError))
		}
	}
	if v.ResetTimer != nil {
		if err := validateResetTimerAction(v.ResetTimer); err != nil {
			invalidParams.AddNested("ResetTimer", err.(smithy.InvalidParamsError))
		}
	}
	if v.Lambda != nil {
		if err := validateLambdaAction(v.Lambda); err != nil {
			invalidParams.AddNested("Lambda", err.(smithy.InvalidParamsError))
		}
	}
	if v.IotEvents != nil {
		if err := validateIotEventsAction(v.IotEvents); err != nil {
			invalidParams.AddNested("IotEvents", err.(smithy.InvalidParamsError))
		}
	}
	if v.Sqs != nil {
		if err := validateSqsAction(v.Sqs); err != nil {
			invalidParams.AddNested("Sqs", err.(smithy.InvalidParamsError))
		}
	}
	if v.Firehose != nil {
		if err := validateFirehoseAction(v.Firehose); err != nil {
			invalidParams.AddNested("Firehose", err.(smithy.InvalidParamsError))
		}
	}
	if v.DynamoDB != nil {
		if err := validateDynamoDBAction(v.DynamoDB); err != nil {
			invalidParams.AddNested("DynamoDB", err.(smithy.InvalidParamsError))
		}
	}
	if v.DynamoDBv2 != nil {
		if err := validateDynamoDBv2Action(v.DynamoDBv2); err != nil {
			invalidParams.AddNested("DynamoDBv2", err.(smithy.InvalidParamsError))
		}
	}
	if v.IotSiteWise != nil {
		if err := validateIotSiteWiseAction(v.IotSiteWise); err != nil {
			invalidParams.AddNested("IotSiteWise", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActions(v []types.Action) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Actions"}
	for i := range v {
		if err := validateAction(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAlarmAction(v *types.AlarmAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AlarmAction"}
	if v.Sns != nil {
		if err := validateSNSTopicPublishAction(v.Sns); err != nil {
			invalidParams.AddNested("Sns", err.(smithy.InvalidParamsError))
		}
	}
	if v.IotTopicPublish != nil {
		if err := validateIotTopicPublishAction(v.IotTopicPublish); err != nil {
			invalidParams.AddNested("IotTopicPublish", err.(smithy.InvalidParamsError))
		}
	}
	if v.Lambda != nil {
		if err := validateLambdaAction(v.Lambda); err != nil {
			invalidParams.AddNested("Lambda", err.(smithy.InvalidParamsError))
		}
	}
	if v.IotEvents != nil {
		if err := validateIotEventsAction(v.IotEvents); err != nil {
			invalidParams.AddNested("IotEvents", err.(smithy.InvalidParamsError))
		}
	}
	if v.Sqs != nil {
		if err := validateSqsAction(v.Sqs); err != nil {
			invalidParams.AddNested("Sqs", err.(smithy.InvalidParamsError))
		}
	}
	if v.Firehose != nil {
		if err := validateFirehoseAction(v.Firehose); err != nil {
			invalidParams.AddNested("Firehose", err.(smithy.InvalidParamsError))
		}
	}
	if v.DynamoDB != nil {
		if err := validateDynamoDBAction(v.DynamoDB); err != nil {
			invalidParams.AddNested("DynamoDB", err.(smithy.InvalidParamsError))
		}
	}
	if v.DynamoDBv2 != nil {
		if err := validateDynamoDBv2Action(v.DynamoDBv2); err != nil {
			invalidParams.AddNested("DynamoDBv2", err.(smithy.InvalidParamsError))
		}
	}
	if v.IotSiteWise != nil {
		if err := validateIotSiteWiseAction(v.IotSiteWise); err != nil {
			invalidParams.AddNested("IotSiteWise", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAlarmActions(v []types.AlarmAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AlarmActions"}
	for i := range v {
		if err := validateAlarmAction(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAlarmCapabilities(v *types.AlarmCapabilities) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AlarmCapabilities"}
	if v.InitializationConfiguration != nil {
		if err := validateInitializationConfiguration(v.InitializationConfiguration); err != nil {
			invalidParams.AddNested("InitializationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.AcknowledgeFlow != nil {
		if err := validateAcknowledgeFlow(v.AcknowledgeFlow); err != nil {
			invalidParams.AddNested("AcknowledgeFlow", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAlarmEventActions(v *types.AlarmEventActions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AlarmEventActions"}
	if v.AlarmActions != nil {
		if err := validateAlarmActions(v.AlarmActions); err != nil {
			invalidParams.AddNested("AlarmActions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAlarmNotification(v *types.AlarmNotification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AlarmNotification"}
	if v.NotificationActions != nil {
		if err := validateNotificationActions(v.NotificationActions); err != nil {
			invalidParams.AddNested("NotificationActions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAlarmRule(v *types.AlarmRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AlarmRule"}
	if v.SimpleRule != nil {
		if err := validateSimpleRule(v.SimpleRule); err != nil {
			invalidParams.AddNested("SimpleRule", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAssetPropertyTimestamp(v *types.AssetPropertyTimestamp) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssetPropertyTimestamp"}
	if v.TimeInSeconds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimeInSeconds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAssetPropertyValue(v *types.AssetPropertyValue) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssetPropertyValue"}
	if v.Timestamp != nil {
		if err := validateAssetPropertyTimestamp(v.Timestamp); err != nil {
			invalidParams.AddNested("Timestamp", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAttribute(v *types.Attribute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Attribute"}
	if v.JsonPath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JsonPath"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAttributes(v []types.Attribute) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Attributes"}
	for i := range v {
		if err := validateAttribute(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClearTimerAction(v *types.ClearTimerAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClearTimerAction"}
	if v.TimerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimerName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDetectorDebugOption(v *types.DetectorDebugOption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DetectorDebugOption"}
	if v.DetectorModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DetectorModelName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDetectorDebugOptions(v []types.DetectorDebugOption) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DetectorDebugOptions"}
	for i := range v {
		if err := validateDetectorDebugOption(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDetectorModelDefinition(v *types.DetectorModelDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DetectorModelDefinition"}
	if v.States == nil {
		invalidParams.Add(smithy.NewErrParamRequired("States"))
	} else if v.States != nil {
		if err := validateStates(v.States); err != nil {
			invalidParams.AddNested("States", err.(smithy.InvalidParamsError))
		}
	}
	if v.InitialStateName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InitialStateName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDynamoDBAction(v *types.DynamoDBAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DynamoDBAction"}
	if v.HashKeyField == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HashKeyField"))
	}
	if v.HashKeyValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HashKeyValue"))
	}
	if v.TableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableName"))
	}
	if v.Payload != nil {
		if err := validatePayload(v.Payload); err != nil {
			invalidParams.AddNested("Payload", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDynamoDBv2Action(v *types.DynamoDBv2Action) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DynamoDBv2Action"}
	if v.TableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableName"))
	}
	if v.Payload != nil {
		if err := validatePayload(v.Payload); err != nil {
			invalidParams.AddNested("Payload", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEmailConfiguration(v *types.EmailConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EmailConfiguration"}
	if v.From == nil {
		invalidParams.Add(smithy.NewErrParamRequired("From"))
	}
	if v.Recipients == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Recipients"))
	} else if v.Recipients != nil {
		if err := validateEmailRecipients(v.Recipients); err != nil {
			invalidParams.AddNested("Recipients", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEmailConfigurations(v []types.EmailConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EmailConfigurations"}
	for i := range v {
		if err := validateEmailConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEmailRecipients(v *types.EmailRecipients) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EmailRecipients"}
	if v.To != nil {
		if err := validateRecipientDetails(v.To); err != nil {
			invalidParams.AddNested("To", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEvent(v *types.Event) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Event"}
	if v.EventName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventName"))
	}
	if v.Actions != nil {
		if err := validateActions(v.Actions); err != nil {
			invalidParams.AddNested("Actions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEvents(v []types.Event) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Events"}
	for i := range v {
		if err := validateEvent(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFirehoseAction(v *types.FirehoseAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FirehoseAction"}
	if v.DeliveryStreamName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeliveryStreamName"))
	}
	if v.Payload != nil {
		if err := validatePayload(v.Payload); err != nil {
			invalidParams.AddNested("Payload", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInitializationConfiguration(v *types.InitializationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InitializationConfiguration"}
	if v.DisabledOnInitialization == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DisabledOnInitialization"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputDefinition(v *types.InputDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputDefinition"}
	if v.Attributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Attributes"))
	} else if v.Attributes != nil {
		if err := validateAttributes(v.Attributes); err != nil {
			invalidParams.AddNested("Attributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInputIdentifier(v *types.InputIdentifier) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InputIdentifier"}
	if v.IotEventsInputIdentifier != nil {
		if err := validateIotEventsInputIdentifier(v.IotEventsInputIdentifier); err != nil {
			invalidParams.AddNested("IotEventsInputIdentifier", err.(smithy.InvalidParamsError))
		}
	}
	if v.IotSiteWiseInputIdentifier != nil {
		if err := validateIotSiteWiseInputIdentifier(v.IotSiteWiseInputIdentifier); err != nil {
			invalidParams.AddNested("IotSiteWiseInputIdentifier", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIotEventsAction(v *types.IotEventsAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IotEventsAction"}
	if v.InputName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputName"))
	}
	if v.Payload != nil {
		if err := validatePayload(v.Payload); err != nil {
			invalidParams.AddNested("Payload", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIotEventsInputIdentifier(v *types.IotEventsInputIdentifier) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IotEventsInputIdentifier"}
	if v.InputName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIotSiteWiseAction(v *types.IotSiteWiseAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IotSiteWiseAction"}
	if v.PropertyValue != nil {
		if err := validateAssetPropertyValue(v.PropertyValue); err != nil {
			invalidParams.AddNested("PropertyValue", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIotSiteWiseAssetModelPropertyIdentifier(v *types.IotSiteWiseAssetModelPropertyIdentifier) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IotSiteWiseAssetModelPropertyIdentifier"}
	if v.AssetModelId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssetModelId"))
	}
	if v.PropertyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PropertyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIotSiteWiseInputIdentifier(v *types.IotSiteWiseInputIdentifier) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IotSiteWiseInputIdentifier"}
	if v.IotSiteWiseAssetModelPropertyIdentifier != nil {
		if err := validateIotSiteWiseAssetModelPropertyIdentifier(v.IotSiteWiseAssetModelPropertyIdentifier); err != nil {
			invalidParams.AddNested("IotSiteWiseAssetModelPropertyIdentifier", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIotTopicPublishAction(v *types.IotTopicPublishAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IotTopicPublishAction"}
	if v.MqttTopic == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MqttTopic"))
	}
	if v.Payload != nil {
		if err := validatePayload(v.Payload); err != nil {
			invalidParams.AddNested("Payload", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLambdaAction(v *types.LambdaAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LambdaAction"}
	if v.FunctionArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FunctionArn"))
	}
	if v.Payload != nil {
		if err := validatePayload(v.Payload); err != nil {
			invalidParams.AddNested("Payload", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLoggingOptions(v *types.LoggingOptions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LoggingOptions"}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if len(v.Level) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Level"))
	}
	if v.DetectorDebugOptions != nil {
		if err := validateDetectorDebugOptions(v.DetectorDebugOptions); err != nil {
			invalidParams.AddNested("DetectorDebugOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNotificationAction(v *types.NotificationAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotificationAction"}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateNotificationTargetActions(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if v.SmsConfigurations != nil {
		if err := validateSMSConfigurations(v.SmsConfigurations); err != nil {
			invalidParams.AddNested("SmsConfigurations", err.(smithy.InvalidParamsError))
		}
	}
	if v.EmailConfigurations != nil {
		if err := validateEmailConfigurations(v.EmailConfigurations); err != nil {
			invalidParams.AddNested("EmailConfigurations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNotificationActions(v []types.NotificationAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotificationActions"}
	for i := range v {
		if err := validateNotificationAction(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNotificationTargetActions(v *types.NotificationTargetActions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotificationTargetActions"}
	if v.LambdaAction != nil {
		if err := validateLambdaAction(v.LambdaAction); err != nil {
			invalidParams.AddNested("LambdaAction", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOnEnterLifecycle(v *types.OnEnterLifecycle) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OnEnterLifecycle"}
	if v.Events != nil {
		if err := validateEvents(v.Events); err != nil {
			invalidParams.AddNested("Events", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOnExitLifecycle(v *types.OnExitLifecycle) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OnExitLifecycle"}
	if v.Events != nil {
		if err := validateEvents(v.Events); err != nil {
			invalidParams.AddNested("Events", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOnInputLifecycle(v *types.OnInputLifecycle) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OnInputLifecycle"}
	if v.Events != nil {
		if err := validateEvents(v.Events); err != nil {
			invalidParams.AddNested("Events", err.(smithy.InvalidParamsError))
		}
	}
	if v.TransitionEvents != nil {
		if err := validateTransitionEvents(v.TransitionEvents); err != nil {
			invalidParams.AddNested("TransitionEvents", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePayload(v *types.Payload) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Payload"}
	if v.ContentExpression == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ContentExpression"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRecipientDetail(v *types.RecipientDetail) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RecipientDetail"}
	if v.SsoIdentity != nil {
		if err := validateSSOIdentity(v.SsoIdentity); err != nil {
			invalidParams.AddNested("SsoIdentity", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRecipientDetails(v []types.RecipientDetail) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RecipientDetails"}
	for i := range v {
		if err := validateRecipientDetail(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResetTimerAction(v *types.ResetTimerAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResetTimerAction"}
	if v.TimerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimerName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSetTimerAction(v *types.SetTimerAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetTimerAction"}
	if v.TimerName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TimerName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSetVariableAction(v *types.SetVariableAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetVariableAction"}
	if v.VariableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VariableName"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSimpleRule(v *types.SimpleRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SimpleRule"}
	if v.InputProperty == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputProperty"))
	}
	if len(v.ComparisonOperator) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ComparisonOperator"))
	}
	if v.Threshold == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Threshold"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSMSConfiguration(v *types.SMSConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SMSConfiguration"}
	if v.Recipients == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Recipients"))
	} else if v.Recipients != nil {
		if err := validateRecipientDetails(v.Recipients); err != nil {
			invalidParams.AddNested("Recipients", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSMSConfigurations(v []types.SMSConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SMSConfigurations"}
	for i := range v {
		if err := validateSMSConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSNSTopicPublishAction(v *types.SNSTopicPublishAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SNSTopicPublishAction"}
	if v.TargetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetArn"))
	}
	if v.Payload != nil {
		if err := validatePayload(v.Payload); err != nil {
			invalidParams.AddNested("Payload", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSqsAction(v *types.SqsAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SqsAction"}
	if v.QueueUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QueueUrl"))
	}
	if v.Payload != nil {
		if err := validatePayload(v.Payload); err != nil {
			invalidParams.AddNested("Payload", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSSOIdentity(v *types.SSOIdentity) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SSOIdentity"}
	if v.IdentityStoreId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IdentityStoreId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateState(v *types.State) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "State"}
	if v.StateName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StateName"))
	}
	if v.OnInput != nil {
		if err := validateOnInputLifecycle(v.OnInput); err != nil {
			invalidParams.AddNested("OnInput", err.(smithy.InvalidParamsError))
		}
	}
	if v.OnEnter != nil {
		if err := validateOnEnterLifecycle(v.OnEnter); err != nil {
			invalidParams.AddNested("OnEnter", err.(smithy.InvalidParamsError))
		}
	}
	if v.OnExit != nil {
		if err := validateOnExitLifecycle(v.OnExit); err != nil {
			invalidParams.AddNested("OnExit", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStates(v []types.State) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "States"}
	for i := range v {
		if err := validateState(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTags(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tags"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTransitionEvent(v *types.TransitionEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TransitionEvent"}
	if v.EventName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventName"))
	}
	if v.Condition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Condition"))
	}
	if v.Actions != nil {
		if err := validateActions(v.Actions); err != nil {
			invalidParams.AddNested("Actions", err.(smithy.InvalidParamsError))
		}
	}
	if v.NextState == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NextState"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTransitionEvents(v []types.TransitionEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TransitionEvents"}
	for i := range v {
		if err := validateTransitionEvent(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAlarmModelInput(v *CreateAlarmModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAlarmModelInput"}
	if v.AlarmModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmModelName"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.AlarmRule == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmRule"))
	} else if v.AlarmRule != nil {
		if err := validateAlarmRule(v.AlarmRule); err != nil {
			invalidParams.AddNested("AlarmRule", err.(smithy.InvalidParamsError))
		}
	}
	if v.AlarmNotification != nil {
		if err := validateAlarmNotification(v.AlarmNotification); err != nil {
			invalidParams.AddNested("AlarmNotification", err.(smithy.InvalidParamsError))
		}
	}
	if v.AlarmEventActions != nil {
		if err := validateAlarmEventActions(v.AlarmEventActions); err != nil {
			invalidParams.AddNested("AlarmEventActions", err.(smithy.InvalidParamsError))
		}
	}
	if v.AlarmCapabilities != nil {
		if err := validateAlarmCapabilities(v.AlarmCapabilities); err != nil {
			invalidParams.AddNested("AlarmCapabilities", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDetectorModelInput(v *CreateDetectorModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDetectorModelInput"}
	if v.DetectorModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DetectorModelName"))
	}
	if v.DetectorModelDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DetectorModelDefinition"))
	} else if v.DetectorModelDefinition != nil {
		if err := validateDetectorModelDefinition(v.DetectorModelDefinition); err != nil {
			invalidParams.AddNested("DetectorModelDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateInputInput(v *CreateInputInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateInputInput"}
	if v.InputName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputName"))
	}
	if v.InputDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputDefinition"))
	} else if v.InputDefinition != nil {
		if err := validateInputDefinition(v.InputDefinition); err != nil {
			invalidParams.AddNested("InputDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAlarmModelInput(v *DeleteAlarmModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAlarmModelInput"}
	if v.AlarmModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmModelName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDetectorModelInput(v *DeleteDetectorModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDetectorModelInput"}
	if v.DetectorModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DetectorModelName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteInputInput(v *DeleteInputInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteInputInput"}
	if v.InputName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeAlarmModelInput(v *DescribeAlarmModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeAlarmModelInput"}
	if v.AlarmModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmModelName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDetectorModelAnalysisInput(v *DescribeDetectorModelAnalysisInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDetectorModelAnalysisInput"}
	if v.AnalysisId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalysisId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDetectorModelInput(v *DescribeDetectorModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDetectorModelInput"}
	if v.DetectorModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DetectorModelName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeInputInput(v *DescribeInputInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeInputInput"}
	if v.InputName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDetectorModelAnalysisResultsInput(v *GetDetectorModelAnalysisResultsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDetectorModelAnalysisResultsInput"}
	if v.AnalysisId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AnalysisId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAlarmModelVersionsInput(v *ListAlarmModelVersionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAlarmModelVersionsInput"}
	if v.AlarmModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmModelName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDetectorModelVersionsInput(v *ListDetectorModelVersionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDetectorModelVersionsInput"}
	if v.DetectorModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DetectorModelName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListInputRoutingsInput(v *ListInputRoutingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListInputRoutingsInput"}
	if v.InputIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputIdentifier"))
	} else if v.InputIdentifier != nil {
		if err := validateInputIdentifier(v.InputIdentifier); err != nil {
			invalidParams.AddNested("InputIdentifier", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutLoggingOptionsInput(v *PutLoggingOptionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutLoggingOptionsInput"}
	if v.LoggingOptions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LoggingOptions"))
	} else if v.LoggingOptions != nil {
		if err := validateLoggingOptions(v.LoggingOptions); err != nil {
			invalidParams.AddNested("LoggingOptions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartDetectorModelAnalysisInput(v *StartDetectorModelAnalysisInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartDetectorModelAnalysisInput"}
	if v.DetectorModelDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DetectorModelDefinition"))
	} else if v.DetectorModelDefinition != nil {
		if err := validateDetectorModelDefinition(v.DetectorModelDefinition); err != nil {
			invalidParams.AddNested("DetectorModelDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateAlarmModelInput(v *UpdateAlarmModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateAlarmModelInput"}
	if v.AlarmModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmModelName"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.AlarmRule == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmRule"))
	} else if v.AlarmRule != nil {
		if err := validateAlarmRule(v.AlarmRule); err != nil {
			invalidParams.AddNested("AlarmRule", err.(smithy.InvalidParamsError))
		}
	}
	if v.AlarmNotification != nil {
		if err := validateAlarmNotification(v.AlarmNotification); err != nil {
			invalidParams.AddNested("AlarmNotification", err.(smithy.InvalidParamsError))
		}
	}
	if v.AlarmEventActions != nil {
		if err := validateAlarmEventActions(v.AlarmEventActions); err != nil {
			invalidParams.AddNested("AlarmEventActions", err.(smithy.InvalidParamsError))
		}
	}
	if v.AlarmCapabilities != nil {
		if err := validateAlarmCapabilities(v.AlarmCapabilities); err != nil {
			invalidParams.AddNested("AlarmCapabilities", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDetectorModelInput(v *UpdateDetectorModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDetectorModelInput"}
	if v.DetectorModelName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DetectorModelName"))
	}
	if v.DetectorModelDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DetectorModelDefinition"))
	} else if v.DetectorModelDefinition != nil {
		if err := validateDetectorModelDefinition(v.DetectorModelDefinition); err != nil {
			invalidParams.AddNested("DetectorModelDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateInputInput(v *UpdateInputInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateInputInput"}
	if v.InputName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputName"))
	}
	if v.InputDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputDefinition"))
	} else if v.InputDefinition != nil {
		if err := validateInputDefinition(v.InputDefinition); err != nil {
			invalidParams.AddNested("InputDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
