// Copyright 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for RSA SSA (Signature Schemes with Appendix) using PSS
// (Probabilistic Signature Scheme ) encoding
// (https://tools.ietf.org/html/rfc8017#section-8.1).

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.21.12
// source: third_party/tink/proto/rsa_ssa_pss.proto

package rsa_ssa_pss_go_proto

import (
	common_go_proto "github.com/tink-crypto/tink-go/v2/proto/common_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RsaSsaPssParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hash function used in computing hash of the signing message
	// (see https://tools.ietf.org/html/rfc8017#section-9.1.1).
	// Required.
	SigHash common_go_proto.HashType `protobuf:"varint,1,opt,name=sig_hash,json=sigHash,proto3,enum=google.crypto.tink.HashType" json:"sig_hash,omitempty"`
	// Hash function used in MGF1 (a mask generation function based on a
	// hash function) (see https://tools.ietf.org/html/rfc8017#appendix-B.2.1).
	// Required.
	Mgf1Hash common_go_proto.HashType `protobuf:"varint,2,opt,name=mgf1_hash,json=mgf1Hash,proto3,enum=google.crypto.tink.HashType" json:"mgf1_hash,omitempty"`
	// Salt length (see https://tools.ietf.org/html/rfc8017#section-9.1.1)
	// Required.
	SaltLength int32 `protobuf:"varint,3,opt,name=salt_length,json=saltLength,proto3" json:"salt_length,omitempty"`
}

func (x *RsaSsaPssParams) Reset() {
	*x = RsaSsaPssParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RsaSsaPssParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPssParams) ProtoMessage() {}

func (x *RsaSsaPssParams) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPssParams.ProtoReflect.Descriptor instead.
func (*RsaSsaPssParams) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescGZIP(), []int{0}
}

func (x *RsaSsaPssParams) GetSigHash() common_go_proto.HashType {
	if x != nil {
		return x.SigHash
	}
	return common_go_proto.HashType(0)
}

func (x *RsaSsaPssParams) GetMgf1Hash() common_go_proto.HashType {
	if x != nil {
		return x.Mgf1Hash
	}
	return common_go_proto.HashType(0)
}

func (x *RsaSsaPssParams) GetSaltLength() int32 {
	if x != nil {
		return x.SaltLength
	}
	return 0
}

// key_type: type.googleapis.com/google.crypto.tink.RsaSsaPssPublicKey
type RsaSsaPssPublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	Params *RsaSsaPssParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// Modulus.
	// Unsigned big integer in bigendian representation.
	N []byte `protobuf:"bytes,3,opt,name=n,proto3" json:"n,omitempty"`
	// Public exponent.
	// Unsigned big integer in bigendian representation.
	E []byte `protobuf:"bytes,4,opt,name=e,proto3" json:"e,omitempty"`
}

func (x *RsaSsaPssPublicKey) Reset() {
	*x = RsaSsaPssPublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RsaSsaPssPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPssPublicKey) ProtoMessage() {}

func (x *RsaSsaPssPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPssPublicKey.ProtoReflect.Descriptor instead.
func (*RsaSsaPssPublicKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescGZIP(), []int{1}
}

func (x *RsaSsaPssPublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *RsaSsaPssPublicKey) GetParams() *RsaSsaPssParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *RsaSsaPssPublicKey) GetN() []byte {
	if x != nil {
		return x.N
	}
	return nil
}

func (x *RsaSsaPssPublicKey) GetE() []byte {
	if x != nil {
		return x.E
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.RsaSsaPssPrivateKey
type RsaSsaPssPrivateKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	PublicKey *RsaSsaPssPublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Private exponent.
	// Unsigned big integer in bigendian representation.
	// Required.
	D []byte `protobuf:"bytes,3,opt,name=d,proto3" json:"d,omitempty"`
	// The following parameters are used to optimize RSA signature computation.
	// The prime factor p of n.
	// Unsigned big integer in bigendian representation.
	// Required.
	P []byte `protobuf:"bytes,4,opt,name=p,proto3" json:"p,omitempty"`
	// The prime factor q of n.
	// Unsigned big integer in bigendian representation.
	// Required.
	Q []byte `protobuf:"bytes,5,opt,name=q,proto3" json:"q,omitempty"`
	// d mod (p - 1).
	// Unsigned big integer in bigendian representation.
	// Required.
	Dp []byte `protobuf:"bytes,6,opt,name=dp,proto3" json:"dp,omitempty"`
	// d mod (q - 1).
	// Unsigned big integer in bigendian representation.
	// Required.
	Dq []byte `protobuf:"bytes,7,opt,name=dq,proto3" json:"dq,omitempty"`
	// Chinese Remainder Theorem coefficient q^(-1) mod p.
	// Unsigned big integer in bigendian representation.
	// Required.
	Crt []byte `protobuf:"bytes,8,opt,name=crt,proto3" json:"crt,omitempty"`
}

func (x *RsaSsaPssPrivateKey) Reset() {
	*x = RsaSsaPssPrivateKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RsaSsaPssPrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPssPrivateKey) ProtoMessage() {}

func (x *RsaSsaPssPrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPssPrivateKey.ProtoReflect.Descriptor instead.
func (*RsaSsaPssPrivateKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescGZIP(), []int{2}
}

func (x *RsaSsaPssPrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *RsaSsaPssPrivateKey) GetPublicKey() *RsaSsaPssPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetD() []byte {
	if x != nil {
		return x.D
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetP() []byte {
	if x != nil {
		return x.P
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetQ() []byte {
	if x != nil {
		return x.Q
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetDp() []byte {
	if x != nil {
		return x.Dp
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetDq() []byte {
	if x != nil {
		return x.Dq
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetCrt() []byte {
	if x != nil {
		return x.Crt
	}
	return nil
}

type RsaSsaPssKeyFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Params *RsaSsaPssParams `protobuf:"bytes,1,opt,name=params,proto3" json:"params,omitempty"`
	// Required.
	ModulusSizeInBits uint32 `protobuf:"varint,2,opt,name=modulus_size_in_bits,json=modulusSizeInBits,proto3" json:"modulus_size_in_bits,omitempty"`
	// Required.
	PublicExponent []byte `protobuf:"bytes,3,opt,name=public_exponent,json=publicExponent,proto3" json:"public_exponent,omitempty"`
}

func (x *RsaSsaPssKeyFormat) Reset() {
	*x = RsaSsaPssKeyFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RsaSsaPssKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPssKeyFormat) ProtoMessage() {}

func (x *RsaSsaPssKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPssKeyFormat.ProtoReflect.Descriptor instead.
func (*RsaSsaPssKeyFormat) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescGZIP(), []int{3}
}

func (x *RsaSsaPssKeyFormat) GetParams() *RsaSsaPssParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *RsaSsaPssKeyFormat) GetModulusSizeInBits() uint32 {
	if x != nil {
		return x.ModulusSizeInBits
	}
	return 0
}

func (x *RsaSsaPssKeyFormat) GetPublicExponent() []byte {
	if x != nil {
		return x.PublicExponent
	}
	return nil
}

var File_third_party_tink_proto_rsa_ssa_pss_proto protoreflect.FileDescriptor

var file_third_party_tink_proto_rsa_ssa_pss_proto_rawDesc = []byte{
	0x0a, 0x28, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69,
	0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x72, 0x73, 0x61, 0x5f, 0x73, 0x73, 0x61,
	0x5f, 0x70, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x1a, 0x23,
	0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69, 0x6e, 0x6b,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xa6, 0x01, 0x0a, 0x0f, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x73,
	0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x37, 0x0a, 0x08, 0x73, 0x69, 0x67, 0x5f, 0x68,
	0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x48,
	0x61, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x73, 0x69, 0x67, 0x48, 0x61, 0x73, 0x68,
	0x12, 0x39, 0x0a, 0x09, 0x6d, 0x67, 0x66, 0x31, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x08, 0x6d, 0x67, 0x66, 0x31, 0x48, 0x61, 0x73, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x73,
	0x61, 0x6c, 0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0a, 0x73, 0x61, 0x6c, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x87, 0x01, 0x0a,
	0x12, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x73, 0x73, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69,
	0x6e, 0x6b, 0x2e, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x73, 0x73, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x0c, 0x0a, 0x01, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x6e, 0x12, 0x0c, 0x0a, 0x01, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x01, 0x65, 0x22, 0xd2, 0x01, 0x0a, 0x13, 0x52, 0x73, 0x61, 0x53, 0x73,
	0x61, 0x50, 0x73, 0x73, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e,
	0x6b, 0x2e, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x73, 0x73, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12,
	0x0c, 0x0a, 0x01, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x64, 0x12, 0x0c, 0x0a,
	0x01, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x70, 0x12, 0x0c, 0x0a, 0x01, 0x71,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x71, 0x12, 0x0e, 0x0a, 0x02, 0x64, 0x70, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x64, 0x70, 0x12, 0x0e, 0x0a, 0x02, 0x64, 0x71, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x64, 0x71, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x72, 0x74,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x63, 0x72, 0x74, 0x22, 0xab, 0x01, 0x0a, 0x12,
	0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x73,
	0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12,
	0x2f, 0x0a, 0x14, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x75, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x69, 0x6e, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x75, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x49, 0x6e, 0x42, 0x69, 0x74, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x42, 0x56, 0x0a, 0x1c, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74,
	0x69, 0x6e, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x34, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x69, 0x6e, 0x6b, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x72, 0x73, 0x61,
	0x5f, 0x73, 0x73, 0x61, 0x5f, 0x70, 0x73, 0x73, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescOnce sync.Once
	file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescData = file_third_party_tink_proto_rsa_ssa_pss_proto_rawDesc
)

func file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescGZIP() []byte {
	file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescOnce.Do(func() {
		file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescData = protoimpl.X.CompressGZIP(file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescData)
	})
	return file_third_party_tink_proto_rsa_ssa_pss_proto_rawDescData
}

var file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_third_party_tink_proto_rsa_ssa_pss_proto_goTypes = []interface{}{
	(*RsaSsaPssParams)(nil),       // 0: google.crypto.tink.RsaSsaPssParams
	(*RsaSsaPssPublicKey)(nil),    // 1: google.crypto.tink.RsaSsaPssPublicKey
	(*RsaSsaPssPrivateKey)(nil),   // 2: google.crypto.tink.RsaSsaPssPrivateKey
	(*RsaSsaPssKeyFormat)(nil),    // 3: google.crypto.tink.RsaSsaPssKeyFormat
	(common_go_proto.HashType)(0), // 4: google.crypto.tink.HashType
}
var file_third_party_tink_proto_rsa_ssa_pss_proto_depIdxs = []int32{
	4, // 0: google.crypto.tink.RsaSsaPssParams.sig_hash:type_name -> google.crypto.tink.HashType
	4, // 1: google.crypto.tink.RsaSsaPssParams.mgf1_hash:type_name -> google.crypto.tink.HashType
	0, // 2: google.crypto.tink.RsaSsaPssPublicKey.params:type_name -> google.crypto.tink.RsaSsaPssParams
	1, // 3: google.crypto.tink.RsaSsaPssPrivateKey.public_key:type_name -> google.crypto.tink.RsaSsaPssPublicKey
	0, // 4: google.crypto.tink.RsaSsaPssKeyFormat.params:type_name -> google.crypto.tink.RsaSsaPssParams
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_third_party_tink_proto_rsa_ssa_pss_proto_init() }
func file_third_party_tink_proto_rsa_ssa_pss_proto_init() {
	if File_third_party_tink_proto_rsa_ssa_pss_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RsaSsaPssParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RsaSsaPssPublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RsaSsaPssPrivateKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RsaSsaPssKeyFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_third_party_tink_proto_rsa_ssa_pss_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_third_party_tink_proto_rsa_ssa_pss_proto_goTypes,
		DependencyIndexes: file_third_party_tink_proto_rsa_ssa_pss_proto_depIdxs,
		MessageInfos:      file_third_party_tink_proto_rsa_ssa_pss_proto_msgTypes,
	}.Build()
	File_third_party_tink_proto_rsa_ssa_pss_proto = out.File
	file_third_party_tink_proto_rsa_ssa_pss_proto_rawDesc = nil
	file_third_party_tink_proto_rsa_ssa_pss_proto_goTypes = nil
	file_third_party_tink_proto_rsa_ssa_pss_proto_depIdxs = nil
}
