# -*- mode: autoconf -*-
# Configure macro for Libnc-dap
#
# Code for version detection and comparison comes from freetype2.m4
# Marcelo Magallon 2001-10-26, based on gtk.m4 by Owen Taylor
#
# Copyright 2001, 2003 by
# David Turner, Robert Wilhelm, and Werner Lemberg.
#
# This file is part of the FreeType project, and may only be used, modified,
# and distributed under the terms of the FreeType project license,
# LICENSE.TXT.  By continuing to use, modify, or distribute this file you
# indicate that you have read the license and understand and accept it
# fully.
#
# As a special exception to the FreeType project license, this file may be
# distributed as part of a program that contains a configuration script
# generated by Autoconf, under the same distribution terms as the rest of
# that program.
#
# Patrice Dumas 2005 Libnc-dap specific code

# AC_CHECK_LIBNC_DAP([MINIMUM-VERSION [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
# Test for Libnc-dap and define NC_DAP_CFLAGS and NC_DAP_LIBS.
# Check that the version is above MINIMUM-VERSION 
# Check for the inclusion of a netcdf.h header file with netcdf 3 interface
AC_DEFUN([AC_CHECK_LIBNC_DAP],
[
  ncdap_header_ok='no'
  ncdap_lib_ok='no'

  ncdap_pkgconfig_libncdap=yes
  ncdap_min_version=m4_if([$1], [], [3.5.0], [$1])
  PKG_CHECK_MODULES([NC_DAP],[libnc-dap >= $ncdap_min_version],,
    [ncdap_pkgconfig_libncdap=no])

  if test $ncdap_pkgconfig_libncdap = yes ; then
    ncdap_lib_ok=yes
    ncdap_header_ok=yes
  else
    AC_CHECK_LIBNC_DAP_LIB([$1],[ncdap_lib_ok='yes'],
      [ncdap_lib_ok='no'])
    ncdap_save_CPPFLAGS=$CPPFLAGS
    CPPFLAGS="$CPPFLAGS $NC_DAP_CFLAGS"
    AC_CHECK_NETCDF_DAP_HEADER([],[ncdap_header_ok='yes'],
      [ncdap_header_ok='no'],[3])
    CPPFLAGS=$ncdap_save_CPPFLAGS
  fi

  if test "$ncdap_lib_ok" = 'yes' -a "$ncdap_header_ok" = 'yes' ; then
    m4_if([$2], [], [:], [$2])
  else
    m4_if([$3], [], [:], [$3])
  fi
])

# AC_CHECK_LIBNC_DAP_LIB([MINIMUM-VERSION [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
# Test for Libnc-dap and define NC_DAP_CFLAGS and NC_DAP_LIBS.
# Check that the version is above MINIMUM-VERSION
AC_DEFUN([AC_CHECK_LIBNC_DAP_LIB],
[
  AC_PATH_PROG([NC_DAP_CONFIG], [ncdap-config], [no])
  ncdap_min_version=m4_if([$1], [], [3.5.0], [$1])
  AC_MSG_CHECKING([for libnc-dap version >= $ncdap_min_version])
  ncdap_ok='no'
  if test "$NC_DAP_CONFIG" = "no" ; then
     ncdap_ok='no'
  else
     ncdap_config_major_version=`$NC_DAP_CONFIG --version | sed 's/^libnc-dap \([[0-9]]\)*\.\([[0-9]]*\)\.\([[0-9]]*\)$/\1/'`
     ncdap_config_minor_version=`$NC_DAP_CONFIG --version | sed 's/^libnc-dap \([[0-9]]\)*\.\([[0-9]]*\)\.\([[0-9]]*\)$/\2/'`
     ncdap_config_micro_version=`$NC_DAP_CONFIG --version | sed 's/^libnc-dap \([[0-9]]\)*\.\([[0-9]]*\)\.\([[0-9]]*\)$/\2/'`
     ncdap_min_major_version=`echo $ncdap_min_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
     ncdap_min_minor_version=`echo $ncdap_min_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
     ncdap_min_micro_version=`echo $ncdap_min_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

     ncdap_config_is_lt='no'
     if test $ncdap_config_major_version -lt $ncdap_min_major_version ; then
       ncdap_config_is_lt='yes'
     else
       if test $ncdap_config_major_version -eq $ncdap_min_major_version ; then
         if test $ncdap_config_minor_version -lt $ncdap_min_minor_version ; then
           ncdap_config_is_lt='yes'
         else
           if test $ncdap_config_minor_version -eq $ncdap_min_minor_version ; then
             if test $ncdap_config_micro_version -lt $ncdap_min_micro_version ; then
               ncdap_config_is_lt='yes'
             fi
           fi
         fi
       fi
     fi
     if test "x$ncdap_config_is_lt" = "xyes" ; then
       ncdap_ok='no'
     else
       NC_DAP_LIBS="`$NC_DAP_CONFIG --libs`"
       NC_DAP_CFLAGS="`$NC_DAP_CONFIG --cflags`"
     fi
   fi
   if test "x$ncdap_ok" = 'xyes' ; then
     AC_MSG_RESULT([yes])
     m4_if([$2], [], [:], [$2])
   else
     AC_MSG_RESULT([no])
     if test "$NC_DAP_CONFIG" = "no" ; then
     AC_MSG_NOTICE([The ncdap-config script could not be found.])
     else
       if test x$ncdap_config_is_lt = xyes ; then
         AC_MSG_NOTICE([The installed libnc-dap library is too old.])
       fi
     fi
     NC_DAP_LIBS=""
     NC_DAP_CFLAGS=""
     m4_if([$3], [], [:], [$3])
     
   fi
   AC_SUBST([NC_DAP_CFLAGS])
   AC_SUBST([NC_DAP_LIBS])
]) 


# AC_FC_CHECK_LIBNC_DAP([MINIMUM-VERSION [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
# Test for Libnc-dap and define NC_DAP_FFLAGS and NC_DAP_FLIBS with flags
# for fortran.
# Check that the version is above MINIMUM-VERSION 

AC_DEFUN([AC_FC_CHECK_LIBNC_DAP],
[
  libnc_fc_dap_ok="no"
  AC_CHECK_LIBNC_DAP_LIB([$1],[libnc_fc_dap_ok="yes"],[libnc_fc_dap_ok="no"])
  if test $libnc_fc_dap_ok = "yes"; then
     NC_DAP_FLIBS="`$NC_DAP_CONFIG --flibs`"
     NC_DAP_FFLAGS="$NC_DAP_CFLAGS"
     m4_if([$2], [], [:], [$2])
  else
     m4_if([$3], [], [:], [$3])
     NC_DAP_FLIBS=""
     NC_DAP_FFLAGS=""
  fi
  AC_SUBST([NC_DAP_FFLAGS])
  AC_SUBST([NC_DAP_FLIBS])
])

# AC_CHECK_NC_DODS([ ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
# Test for Libnc-dap or older versions. Define NC_DAP_CFLAGS and NC_DAP_LIBS.
# check for the netcdf.h file inclusion
# the old way of finding libs is used first to allow the user to 
# specify a root with the 'old style' nc-dods all-in-a-root.
AC_DEFUN([AC_CHECK_NC_DODS],
[
  ncdods_header_ok='no'
  ncdods_lib_ok='no'
  
# we find lib using pkg-config now, before we set NC_DAP_* to something else, 
# and we keep the result. 
  ncdods_pkgconfig_ncdods=yes
  PKG_CHECK_MODULES([NC_DAP],[libnc-dap],,
    [ncdods_pkgconfig_ncdods=no])
  if test $ncdods_pkgconfig_ncdods = yes ; then
    ncdods_pkgconfig_NC_DAP_LIBS=$NC_DAP_LIBS
    ncdods_pkgconfig_NC_DAP_CFLAGS=$NC_DAP_CFLAGS
    NC_DAP_LIBS=
    NC_DAP_CFLAGS=
  fi

  AC_CHECK_NC_DODS_LIB([ncdods_lib_ok='yes'],
     [ncdods_lib_ok='no'])
  ncdods_save_CPPFLAGS=$CPPFLAGS
  CPPFLAGS="$CPPFLAGS $NC_DAP_CFLAGS"
  AC_CHECK_NETCDF_DAP_HEADER([],[ncdods_header_ok='yes'],
    [ncdods_header_ok='no'])
  CPPFLAGS=$ncdods_save_CPPFLAGS

# if the 'old style' failed or DAP_ROOT is unset and pkg-config succeded, 
# use pkg-config
  if test "$ncdods_lib_ok" = 'no' -o "$ncdods_header_ok" = 'no' -o "z$DAP_ROOT" = 'z' ; then
    if test $ncdods_pkgconfig_ncdods = 'yes' ; then
      NC_DAP_LIBS=$ncdods_pkgconfig_NC_DAP_LIBS
      NC_DAP_CFLAGS=$ncdods_pkgconfig_NC_DAP_CFLAGS
      ncdods_lib_ok=yes
      ncdods_header_ok=yes
    fi
  fi

  if test "$ncdods_lib_ok" = 'yes' -a "$ncdods_header_ok" = 'yes' ; then
    m4_if([$1], [], [:], [$1])
  else
    m4_if([$2], [], [:], [$2])
  fi
])

# AC_CHECK_NC_DODS_LIB([ ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
# Test for Libnc-dap or older versions. Define NC_DAP_CFLAGS and NC_DAP_LIBS.
# use AC_CHECK_DODS first
AC_DEFUN([AC_CHECK_NC_DODS_LIB],
[
  ac_ncdods_ok='no'
  ac_ncdods_dap_ok='no'
  NC_DAP_LIBS=
  NC_DAP_CFLAGS=
  dnl it may happen that the cflags are not the ones associated 
  dnl with -L and -l flags, however even in that case the most recent 
  dnl netcdf.h should be picked up and things should go smoothly
  AC_PATH_PROG([OPENNC_DAP_CONFIG], [opendap-config], [no])
  if test "$OPENNC_DAP_CONFIG" != "no" ; then
     NC_DAP_CFLAGS="`$OPENNC_DAP_CONFIG --cflags`"
  fi
  AC_PATH_PROG([NC_DAP_CONFIG], [ncdap-config], [no])
  if test "$NC_DAP_CONFIG" != "no" ; then
     NC_DAP_CFLAGS="`$NC_DAP_CONFIG --cflags`"
  fi
  AC_CHECK_DODS([ac_ncdods_dap_ok='yes'],[ac_ncdods_dap_ok='no'])
  if test "z$ac_ncdods_dap_ok" = 'zyes'; then
     if test "z$DAP_ROOT" != "z" ; then
        NC_DAP_CFLAGS=$DAP_ROOT/include
     fi
     dnl We check that linking is succesfull
     dnl instead of using a C++ compiler we add -lstdc++
     dnl AC_LANG_PUSH([C++])
     NC_DAP_LIBS="-lnc-dap $DAP_LIBS -ldap"
     ac_save_LIBS=$LIBS
     LIBS="$LIBS $NC_DAP_LIBS -lstdc++"
     AC_MSG_CHECKING([for nc_open with -lnc-dap -ldap])
     AC_LINK_IFELSE([AC_LANG_CALL([],[nc_open])],
       [ ac_ncdods_ok='yes'
         AC_MSG_RESULT([yes])
       ],[ ac_ncdods_ok='no'
         AC_MSG_RESULT([no])
       ])
     LIBS=$ac_save_LIBS
     if test $ac_ncdods_ok = 'no' ; then
       NC_DAP_LIBS="-lnc-dods $DAP_LIBS -ldap++"
       LIBS="$LIBS $NC_DAP_LIBS -lstdc++"
       AC_MSG_CHECKING([for nc_open with -lnc-dods -ldap++])
       AC_LINK_IFELSE([AC_LANG_CALL([],[nc_open])],
         [ ac_ncdods_ok='yes'
           AC_MSG_RESULT([yes])
         ],[ ac_ncdods_ok='no'
           AC_MSG_RESULT([no])
         ])
       LIBS=$ac_save_LIBS
     fi
     dnl AC_LANG_POP
  fi
  if test $ac_ncdods_ok = no ; then
    AC_CHECK_LIBNC_DAP_LIB([],[ac_ncdods_ok='yes'],[ac_ncdods_ok='no'])
    if test "z$ac_ncdods_ok" = "zno" ; then
      AC_MSG_CHECKING([for libnc-dap with opendap-config])
      if test "$OPENNC_DAP_CONFIG" = "no" ; then
        ac_ncdods_ok='no'
        AC_MSG_RESULT([no])
      else
        NC_DAP_LIBS="`$OPENNC_DAP_CONFIG --libs-nc`"
        ac_ncdods_ok='yes'
        AC_MSG_RESULT([yes])
      fi
    fi
  fi 
  if test "x$ac_ncdods_ok" = "xyes" ; then
     m4_if([$1], [], [:], [$1])
  else
     m4_if([$2], [], [:], [$2])
  fi
  AC_SUBST([NC_DAP_CFLAGS])
  AC_SUBST([NC_DAP_LIBS])
])
