/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.io;

import java.io.File;
import java.io.FilenameFilter;

/**
 * Die Klasse <code>EndsWithFilter</code> überprüft ob der Name einer Datei mit
 * der definierten Endung übereinstimmt.
 * 
 * @author <a href="mailto:michael.fuchs@unico-group.com">Michael Fuchs</a>
 * @version 1.0
 */
public class EndsWithFilter implements FilenameFilter {

    /** Die Endung, die überprüft werden soll. */
    private String[] extensions;

    /**
     * Erzeugt eine neue Instanz der Klasse <code>EndsWithFileNameFilter</code>.
     * 
     * @param extensions
     *            Die Endung, die überprüft werden soll.
     */
    public EndsWithFilter(String... extensions) {

        if (extensions == null) {
            throw new IllegalArgumentException("The argument extensions may not be null!");
        }

        this.extensions = extensions;
    }

    /**
     * Die Methode <code>accept</code> überprüft ob der angegebene Dateiname auf
     * die definierte Endung endet.
     * 
     * Die Überprüfung der Endung erfolgt ohne Beachtung der Groß- und
     * Kleinschreibung.
     * 
     * @param file
     *            <code>File</code>
     * @param name
     *            <code>String</code>
     * @return <code>boolean</code>
     */
    public boolean accept(File file, String name) {

        String s1 = name.toLowerCase();

        for (String extension : extensions) {
            String s2 = extension.toLowerCase();
            if (s1.endsWith(s2)) {
                return true;
            }
        }

        return false;
    }
}
/*
 * $Log: EndsWithFileNameFilter.java,v $ Revision 1.1.1.1 2004/12/21 14:06:38
 * mfuchs Reimport
 * 
 * Revision 1.2 2004/08/27 19:30:32 mfuchs Dokumentation
 * 
 * Revision 1.1.1.1 2004/05/13 17:14:37 mfuchs Services
 */
