/*
 *  Copyright (C) 2005-2008  Maarten de Boer <maarten@resorama.com>
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *  02110-1301, USA.
 * 
 */

#ifndef __Point__
#define __Point__

struct Point
{
	float x, y;
	Point()
			:x(0), y(0)
	{}
	Point(float _x, float _y)
			:x(_x), y(_y)
	{}
	Point& operator += (const Point& pt)
	{
		x += pt.x;
		y += pt.y;
		return *this;
	}
	Point& operator -= (const Point& pt)
	{
		x -= pt.x;
		y -= pt.y;
		return *this;
	}
	Point operator + (const Point& pt)
	{
		Point ret(*this);
		ret.x += pt.x;
		ret.y += pt.y;
		return ret;
	}
	Point operator - (const Point& pt)
	{
		Point ret(*this);
		ret.x -= pt.x;
		ret.y -= pt.y;
		return ret;
	}
	Point& operator /= (float d)
	{
		x /= d;
		y /= d;
		return *this;
	}
	Point operator / (const Point& pt)
	{
		Point ret(*this);
		ret.x /= pt.x;
		ret.y /= pt.y;
		return ret;
	}
	float Length()
	{
		return sqrt(x*x + y*y);
	}
	float Angle()
	{
		return atan2(y,x);
	}
	void Rotate(float angle)
	{
			float d = Length();
			angle += Angle();
			x = d*cos(angle);
			y = d*sin(angle);
	}
}
;

#endif
