---
name: New Feature
about: Submit a pull request that adds new Features (complete files) to LAMMPS
title: "[New Feature] _Replace With Suitable Title_"
labels: enhancement
assignees: ''

---

**Summary**

_Briefly describe the new feature(s) included in this pull request._

**Related Issues**

_If this addresses an existing (open) GitHub issue, e.g. a feature request, mention the issue number here following a pound sign (aka hashmark), e.g. `#331`._

**Author(s)**

_Please state name and affiliation of the author or authors that should be credited with the features added in this pull request. Please provide a suitable "long-lived" e-mail address (e.g. from gmail, yahoo, outlook, etc.) for the *corresponding* author, i.e. the person the LAMMPS developers can contact directly with questions and requests related to maintenance and support of this code. now and in the future_

**Licensing**

_Please add *yes* or *no* to the following two statements (please contact @lammps/core if you have questions about this)_

My contribution may be licensed as GPL v2 (default LAMMPS license):
My contribution may be licensed as LGPL (for use as a library with proprietary software):

**Backward Compatibility**

_Please state if any of the changes in this pull request will affect backward compatibility for inputs, and - if yes - explain what has been changed and why_

**Implementation Notes**

_Provide any relevant details about how the new features are implemented, how correctness was verified, what platforms (OS, compiler, MPI, hardware, number of processors, accelerator(s)) it was tested on_

## Post Submission Checklist

_Please check the fields below as they are completed *after* the pull request has been submitted_

- [ ] The feature or features in this pull request is complete
- [ ] Licensing information is complete
- [ ] Corresponding author information is complete
- [ ] The source code follows the LAMMPS formatting guidelines
- [ ] Suitable new documentation files and/or updates to the existing docs are included
- [ ] The added/updated documentation is integrated and tested with the documentation build system
- [ ] The feature has been verified to work with the conventional build system
- [ ] The feature has been verified to work with the CMake based build system
- [ ] A package specific README file has been included or updated
- [ ] One or more example input decks are included

## Further Information, Files, and Links

_Put any additional information here, attach relevant text or image files, and URLs to external sites (e.g. DOIs or webpages)_


