/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.editors.AbstractLisaacEditor;

public class ToggleComment
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        IWorkbenchWindow w = LisaacPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPart part = w.getPartService().getActivePart();
        if (part instanceof AbstractLisaacEditor) {
            IDocument document = ((AbstractLisaacEditor)part).getDocument();
            ITextSelection selection = (ITextSelection)((AbstractLisaacEditor)part).getSelectionProvider().getSelection();
            try {
                if (selection.getStartLine() == selection.getEndLine()) {
                    char c;
                    int startPos;
                    int pos = startPos = document.getLineOffset(selection.getStartLine());
                    do {
                        if ((c = document.getChar(pos)) == '\uffffffff' || c != '/' || (c = document.getChar(++pos)) == '\uffffffff' || c != '/') continue;
                        document.replace(pos - 1, 2, "");
                        return;
                    } while (c != '\uffffffff' && ++pos <= startPos + selection.getLength());
                    document.replace(startPos, 0, "//");
                } else {
                    char c;
                    int startPos;
                    int pos = startPos = document.getLineOffset(selection.getStartLine());
                    boolean deleteComment = false;
                    do {
                        if ((c = document.getChar(pos)) == '\uffffffff') continue;
                        if (c == '/' && (c = document.getChar(++pos)) != '\uffffffff' && c == '*') {
                            document.replace(pos - 1, 2, "");
                            deleteComment = true;
                            ++pos;
                        }
                        if (c != '*' || (c = document.getChar(++pos)) == '\uffffffff' || c != '/' || !deleteComment) continue;
                        document.replace(pos - 1, 2, "");
                    } while (c != '\uffffffff' && ++pos <= startPos + selection.getLength());
                    if (!deleteComment) {
                        document.replace(startPos, 0, "/*");
                        int ofs = document.getLineOffset(selection.getEndLine());
                        document.replace(ofs += document.getLineLength(selection.getEndLine()), 0, "*/");
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }
}

