<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
/*
 * This MILLE-XTERM Configurateur attribute class. This object
 * make association betwen a node or computer and attribute
 * definition.
 *
 * Author: Nicolas Dufresne
 * Last Modification:
 *               05 aug 2004 Nicolas Dufresnes <nicolas@revolutionlinux.com>
 *               - Creation
 */

require_once 'AttributeDef.php';
require_once 'dbFunctions.php';
class Attribute {

	var $node_id;
	var $def_id;
	var $value;
	var $name;
	var $type;
	var $attClass;
	var $mask;
	var $editable;
	var $selection;
	var $isError;
	var $notFound;

	function Attribute($nodeId,$defId=NULL) {
		$this->isError = false;
		$this->noFound = false;

		if (is_numeric($nodeId)) {
			if (!$attribute = $this->getFromDB("*", "nodes_id=".$nodeId." AND attributesdef_id = ".$defId)) return;
		}
		else if (is_array($nodeId)) {
			$attribute = $nodeId;
		}
		else {
			$this->isError = true;
			$this->lastError = getMessage('bad_id')."nodeid=".$nodeId.", defid=".$defId;
			return;
		}

		//$this->id = $attribute['id'];
		$this->value = $attribute['value'];
		$this->node_id =  $attribute['nodes_id'];
		$this->def_id =  $attribute['attributesdef_id'];

		if (isset($attribute['name'])) {
			$definition = $attribute;
		}
		else {
			$definition = $this->getFromDB("*", "id=".$this->def_id, "attributesDef");
		}

		$this->name = $definition['name'];
		$this->type = $definition['attributetype'];
		$this->attClass = $definition['attributeclass'];
		$this->mask = $definition['mask'];
		$this->editable =  $definition['editable'];
	}

	// private
	function getFromDB($column,$where,$from="attributes",$isFatal=true, $multiple = false) {
		$query = 'SELECT '.$column.' FROM '.$from.' WHERE '.$where;
		if ($multiple) {
			$result = select($query);
		}
		else {
			$result = singleResultSelect($query);
		}
		if (!$result) {
			if (($from == "attributes") && $isFatal) $this->lastError = getMessage('attribute_not_found')." : ".$where;
			else  $this->lastError = getMessage('not_found').$query;
			$this->notFound = true;
			if ($isFatal) $this->isError = true;
			return NULL;
		}
		elseif (!is_array($result)) {
			$this->lastError = getMessage('db_error').$result." : ".$query;
			if ($isFatal) $this->isError = true;
			return NULL;
		}
		else return $result;
	}

	// private
	function updateDB($toSet,$table="attributes", $where = "id") {
		if ($where == "id") $where = "nodes_id=".$this->node_id." AND attributesdef_id = ".$this->def_id;
		$query = "UPDATE ".$table." SET ".$toSet." WHERE ".$where;
		if ($error = write($query)) {
			$this->lastError = getMessage('db_write_error').$error." : ".$query;
			return false;
		}
		else return true;
	}


	//////////////////////////////////////////////////////////////////
	// Getters
	//////////////////////////////////////////////////////////////////

	function getNodeID() {
		return $this->node_id;
	}

	function getAttributeDefID() {
		return $this->def_id;
	}

	function getName() {
		return $this->name;
	}

	function getAttClass() {
		return $this->attClass;
	}

	function getValue() {
		if ($this->isError) return NULL;
		if ($this->type < 2) {
			return $this->value;
		}
		else {
			$this->getSelection();
			if (is_array($this->selection)) {
			    foreach ($this->selection as $value => $selected) {
				if ($selected) {
				    if ($result) $result .= ",";
				    $result .= $value;
				}
			    }
			}
			return $result;
		}
	}

	function getType() {
		return $this->type;
	}

	function getMask() {
		return $this->mask;
	}

	function getEditable() {
		return $this->editable;
	}

	// Use Lazy loading for selection
	function getSelection() {
		if (!is_array($this->selection) && ($this->type >= 1 || $this->editable)) {
			$column = "value";
			$where = "attributesdef_id=".$this->def_id." ORDER BY sortval,value";
			$tableName =  "attributesDefDict";
			$dictionary = $this->getFromDB($column, $where, $tableName, true, true);
			if (is_null($dictionary)) return;
			if ($this->type == 1) {
				$selected[0]['value'] = $this->value;
			}
			if ($this->type == 2) {
				$column = "value";
				$where = "attributesdef_id=".$this->def_id." AND nodes_id=".$this->node_id;
				$tableName = "attributesSelect";
				$selected = $this->getFromDB($column, $where, $tableName, true, true);
				if (is_null($selected)) {
					if ($this->notFound) {
						$this->isError = false;
					}
					else return;
				}
			}
			foreach ($dictionary as $value) {
				$this->selection[$value['value']] = false;
			}
			if (is_array($selected)) {
				foreach ($selected as $value) {
					$this->selection[$value['value']] = true;
				}
			}
		}
		return $this->selection;
	}

	function isError() {
		return $this->isError;
	}


	function lastError() {
		return $this->lastError;
	}

	function notFound() {
		return $this->NotFound;
	}

	//////////////////////////////////////////////////////////////////
	// Setters
	//////////////////////////////////////////////////////////////////

	function delete() {
		$error = NULL;
		if ($this->type == 2) {
			delete("DELETE FROM attributesSelect WHERE nodes_id=".$this->node_id." AND attributesdef_id=".$this->def_id);
			if ($error) $error.= " : ";
		}
		$error .= delete("DELETE FROM attributes WHERE nodes_id=".$this->node_id." AND attributesdef_id=".$this->def_id);
		return $error;
	}

	function setValue($newValue) {
		if ($this->isError) return false;
		switch ($this->type) {
			case 0:
				if (ereg($this->mask,$newValue)) {
					if (!$this->updateDB("value=".qstr($newValue)."")) return false;
					$this->value = $newValue;
					return true;
				}
				$this->lastError = getMessage('invalide_value').$this->name." = ".$newValue;
				return false;
			case 1:
				$newValue = $newValue[0];
				$this->getSelection();
				if (isset($this->selection[$newValue])) {
					if (!$this->updateDB("value=".qstr($newValue)."")) return false;
					$this->selection[$this->value] = false;
					$this->selection[$newValue] = true;
					$this->value = $newValue;
					return true;
				}
				return false;
			case 2:
				$temp = $newValue;
				unset($newValue);
				if (is_array($temp)) {
				    foreach ($temp as $value) {
					$newValue[$value] = true;
				    }
				}
				$this->getSelection();
				$temp = $this->selection;
				foreach ($temp as $value => $selected) {
					$temp[$value] = false;
				}
				// Complete newArray temp one
				if (is_array($newValue)) {
				    $newValue = array_merge($temp, $newValue);
				}
				else {
				   $newValue = $temp;
			       }
				// Check if new element accidently added
				foreach ($newValue as $value => $selected) {
					if (!isset($this->selection[$value])) {
						$this->lastError = getMessage('invalide_value').$value;
						return false;
					}
				}
				startTrans();
				$deleteQuery = "DELETE FROM attributesSelect WHERE nodes_id=".$this->node_id." AND attributesdef_id=".$this->def_id;
				$errors[] = delete($deleteQuery);
				foreach ($newValue as $value => $selected) {
					if ($selected) {
						$query = "INSERT INTO attributesSelect (nodes_id,attributesdef_id,value) VALUES ";
						$query .= "(".$this->node_id.",".$this->def_id.",".qstr($value).")";
						$errors[] = write($query);
					}
				}
				$failed = hasFailedTrans();
				completeTrans();
				if ($failed) {
					$this->lastError = getMessage('db_error');
					foreach ($errors as $error) {
						$this->lastError .= " : ".$error;
					}
					return false;
				}
				else {
					$this->selection = $newValue;
					return true;
				}
				break;
		}
	}
}
?>
