/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * An enumeration of the different kinds of attribute value types, 
 * as specified by the XML standard.
 * <p>
 * @see AttributeRule
 * @author Elias Ross
 * @version 1.0
 */
public interface AttributeValueType 
{
	/** Attribute value can contain any character data. */
	int CDATA = 0; 

	/** Attribute value must contain a name. */
	int NMTOKEN = 1; 

	/** Attribute value must contain a list of names. */
	int NMTOKENS = 2; 

	/** Attribute value must contain an entity. */
	int ENTITY = 3; 

	/** Attribute value must contain a list of entities. */
	int ENTITIES = 4; 

	/** Attribute value must be a document unique identifier. */
	int ID = 5; 

	/** Attribute must reference some other ID. */
	int IDREF = 6; 

	/** Attribute must reference some other IDs. */
	int IDREFS = 7; 

	/** Attribute must reference a notation. */
	int NOTATION = 8; 

	/** Attribute must be a name group. */
	int NAME_GROUP = 9; 
}
