/*
 *  @(#)AutoDocITSet.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.autodoc.v1.defimpl;


import net.sourceforge.groboutils.autodoc.v1.AutoDocIT;

import java.util.Vector;
import java.util.Enumeration;
 

/**
 * Issue Tracker entry point.  Allows bugs and requriements to be tracked
 * directly to the test that ensures that part of the bug/requirement has been
 * fulfilled in the current code base.
 * <P>
 * The alternate forms of the base {@link #testsIssue( String, String )} are
 * for convenience only.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:11 $
 * @since      June 28, 2002
 */
public class AutoDocITSet implements AutoDocIT, IAutoDocSet
{
    private Vector set = new Vector();
    
    public void addIT( AutoDocIT it )
    {
        this.set.addElement( it );
    }
    
    
    public Enumeration getSetContents()
    {
        return this.set.elements();
    }
    
    
    /**
     * Traces an issue from the owning class and declared method, to the
     * given ID.  This is a <tt>long</tt>, as some systems may allow for
     * more than 2 billion issues.
     *
     * @param methodName the owning class's method to trace the issue back to.
     * @param issueID the id of the issue being tracked.
     */
    public void testsIssue( String methodName, long issueID )
    {
        Enumeration enum = getSetContents();
        while (enum.hasMoreElements())
        {
            ((AutoDocIT)enum.nextElement()).testsIssue( methodName, issueID );
        }
    }
    
    
    /**
     * Traces an issue from the owning class and declared method, to the
     * given ID.
     *
     * @param methodName the owning class's method to trace the issue back to.
     * @param issueID the id of the issue being tracked.
     */
    public void testsIssue( String methodName, String issueID )
    {
        Enumeration enum = getSetContents();
        while (enum.hasMoreElements())
        {
            ((AutoDocIT)enum.nextElement()).testsIssue( methodName, issueID );
        }
    }
    
    
    /**
     * Traces an issue from the owning class to the given ID.
     * The method will still be given to the underlying tracker, but it will
     * be discovered through the stack trace.  Hence, this is a volitile
     * method for tracking; it should only be called from the owning class
     * which is actually testing the bug.
     *
     * @param issueID the id of the issue being tracked.
     */
    public void testsIssue( long issueID )
    {
        Enumeration enum = getSetContents();
        while (enum.hasMoreElements())
        {
            ((AutoDocIT)enum.nextElement()).testsIssue( issueID );
        }
    }
    
    
    /**
     * Traces an issue from the owning class to the given ID.
     * The method will still be given to the underlying tracker, but it will
     * be discovered through the stack trace.  Hence, this is a volitile
     * method for tracking; it should only be called from the owning class
     * which is actually testing the bug.
     *
     * @param issueID the id of the issue being tracked.
     */
    public void testsIssue( String issueID )
    {
        Enumeration enum = getSetContents();
        while (enum.hasMoreElements())
        {
            ((AutoDocIT)enum.nextElement()).testsIssue( issueID );
        }
    }
}

