/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef QT_BAMF_APPLICATION_H
#define QT_BAMF_APPLICATION_H

#include <QtCore/QObject>

#include "bamf-view.h"
#include "bamf-window.h"
#include "bamf-list.h"

class OrgAyatanaBamfApplicationInterface;

class __attribute__ ((visibility ("default"))) BamfApplication: public BamfView
{
    Q_OBJECT

    Q_PROPERTY(QString application_type READ application_type);
    Q_PROPERTY(QString desktop_file READ desktop_file);

friend class BamfFactory;

private:
    BamfApplication(QString path);
    ~BamfApplication();
    BamfApplication(BamfApplication const&);
    void operator=(BamfApplication const&);

public:
    // getters
    const QString application_type() const;
    const QString desktop_file() const;

    Q_INVOKABLE BamfUintList *xids() const;
    Q_INVOKABLE BamfWindowList *windows() const;

Q_SIGNALS:
    void WindowAdded(BamfWindow *child);
    void WindowRemoved(BamfWindow *child);

private:
    OrgAyatanaBamfApplicationInterface *m_application_proxy;

private Q_SLOTS:
    void OnWindowAdded(const QString &path);
    void OnWindowRemoved(const QString &path);
};

#endif

