.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_fread.mdoc -- read from file
.\" Copyright (C) 2003-2022 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_FREAD" "3" "September 11, 2024" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_fread\fR
\- read from file
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_int64_t\fR
.br
.PD 0
.HP 4n
\fBzip_fread\fR(\fIzip_file_t\ *file\fR, \fIvoid\ *buf\fR, \fIzip_uint64_t\ nbytes\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_fread\fR()
function reads up to
\fInbytes\fR
bytes from
\fIfile\fR
into
\fIbuf\fR
from the current position in the file (see
zip_fseek(3)).
After reading, the current position is updated by the number of bytes read.
.SH "RETURN VALUES"
If successful, the number of bytes actually read is returned.
When
\fBzip_fread\fR()
is called after reaching the end of the file, 0 is returned.
In case of error, \-1 is returned.
.SH "SEE ALSO"
libzip(3),
zip_fclose(3),
zip_file_get_error(3),
zip_fopen(3),
zip_fseek(3)
.SH "HISTORY"
\fBzip_fread\fR()
was added in libzip 0.6.
In libzip 0.10 the return type was changed from
\fIssize_t\fR
to
\fIzip_int64_t\fR.
In libzip 0.10 the type of
\fInbytes\fR
was changed from
\fIsize_t\fR
to
\fIzip_uint64_t\fR.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>
