/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#ifndef MvQColourListLine_H
#define MvQColourListLine_H

#include "MvQRequestPanelLine.h"
#include "Parameter.h"

#include <QPen>
#include <QString>
#include <QWidget>

class QColor;
class QLabel;

class  RequestPanel;

class MvQColourListWidget : public QWidget
{
Q_OBJECT

public:
	MvQColourListWidget(QWidget* parent=0);
	void setColours(QList<QColor>);
	QColor currentColour() const;
	void setCurrentColour(QColor);
	QList<QColor> colours() {return colours_;}
	void setEdited(bool);
  
public slots:
	void slotInsertBeforeCell();
	void slotInsertAfterCell();
	void slotDeleteCell();
  
signals:
        void changed();
    	void currentChanged(QColor);
	void singleCellClicked();

protected:	
  	void resizeEvent(QResizeEvent *);
	void paintEvent(QPaintEvent *);
	void mousePressEvent(QMouseEvent *);
	void createPixmap();
	void renderCurrentCell(QPainter*);
	void setCurrentCell(QPoint);
	void setCurrentCell(int);
	void deleteCell(int);
	void insertBeforeCell(int);
	void insertAfterCell(int);
	void checkActionState();
	
	bool edited_;
	QPixmap pix_;
  	QList<QColor> colours_;
	int cellWidth_;	
  	int currentCell_;
	QPen blackPen_;
	QPen whitePen_;
	QAction* insertBeforeAc_;
	QAction* insertAfterAc_;
	QAction* deleteCellAc_;	
	int editorGapX_;
	int editorGapY_;
};  

class MvQColourListLine : public MvQRequestPanelLine
{
Q_OBJECT  
  
public:
	MvQColourListLine(RequestPanel& owner,const Parameter& param);
	~MvQColourListLine() {};	
	
	QString currentValue() {return QString();}
	void refresh(const vector<string>&);
	
public slots: 
    	void slotListChanged();
    	void slotCurrentChanged(QColor);
	void slotHelperEdited(const vector<string>&);
	void slotSingleCellClicked();
	void slotHelperOpened(bool);
	
protected:
	 void buildHelper();
	 void updateHelper();
	 
	 MvQColourListWidget *widget_;
	
};	

#endif
