/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "IconSelection.h"
#include "Folder.h"
#include "IconClass.h"

#ifndef ConfigLoader_H
#include "ConfigLoader.h"
#endif

#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>

#ifndef XPixmap_H
#include "XPixmap.h"
#endif

static list<string> classes;

IconSelection::IconSelection()
{
	for(list<string>::iterator j = classes.begin(); j != classes.end(); ++j)
	{
		const IconClass& c = IconClass::find(*j);

		Widget rc = XmCreateRowColumn(rowcol_,"rc",0,0);
		XtVaSetValues(rc,XmNorientation, XmHORIZONTAL,0);

		Widget icon = XmCreatePushButton(rc,(char*)c.name().c_str(),0,0);
		Widget label = XmCreateLabel(rc,(char*)c.defaultName().c_str(),0,0);

		XPixmap p(c.pixmap());
		p.setLabel(icon);

	    XtAddCallback (icon, XmNactivateCallback, &UIIconSelection_c::okCB, (XtPointer) this);


		XtManageChild(icon);
		XtManageChild(label);
		XtManageChild(rc);
	}
}

IconSelection::~IconSelection()
{
}

IconObject* IconSelection::make(Folder* f,int x,int y)
{
	return instance().choose(f,x,y);
}


IconObject* IconSelection::choose(Folder* f,int x,int y)
{
	if(modal("Create...",true))
	{
		IconObject* o = IconClass::find(name_).createOne(f);
		f->position(o,x,y);
		return o;
	}
	return 0;
}

void IconSelection::okCB(Widget w,XtPointer data)
{								
	name_ = XtName(w);
	ok_   = true;
	stop_ = true;
}

void IconSelection::load(request* r)
{
	const char *p = get_value(r, "class", 0);
	const char *c = get_value(r, "can_be_created", 0);

	if(c && (*c == 'T' || *c == 't' || atol(c) != 0))
		classes.push_back(p);
}


static SimpleLoader<IconSelection> loadClasses("object",1);
