/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef IconGroupTools_H
#define IconGroupTools_H

#include "Metview.h"
#include "IconObject.h"

class IconGroupTools
{
public:
    IconGroupTools(request*);
    ~IconGroupTools();

    string name();
    static void load(request*);
    static void run(const string&, const vector<IconObject*>& items);
    static bool can(const string&);

private:
    // No copy allowed
    IconGroupTools(const IconGroupTools&);
    IconGroupTools& operator=(const IconGroupTools&);
    void run(const vector<IconObject*>& items);

    request* request_;
};

inline void destroy(IconGroupTools**) {}

#endif
