"use strict";

var helpers = require("../../../helpers/helpers");

exports["America/North_Dakota/Center"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/North_Dakota/Center", { offset: true, expect: "America/Chicago" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/North_Dakota/Center", { abbr: true, expect: "America/Chicago" }),

	"1883" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1883-11-18T19:00:00+00:00", "12:00:00", "MST", 420]
	]),

	"1918" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1918-03-31T08:59:59+00:00", "01:59:59", "MST", 420],
		["1918-03-31T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1918-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1918-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1919" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1919-03-30T08:59:59+00:00", "01:59:59", "MST", 420],
		["1919-03-30T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1919-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1919-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1942" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1942-02-09T08:59:59+00:00", "01:59:59", "MST", 420],
		["1942-02-09T09:00:00+00:00", "03:00:00", "MWT", 360]
	]),

	"1945" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1945-08-14T22:59:59+00:00", "16:59:59", "MWT", 360],
		["1945-08-14T23:00:00+00:00", "17:00:00", "MPT", 360],
		["1945-09-30T07:59:59+00:00", "01:59:59", "MPT", 360],
		["1945-09-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1967" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1967-04-30T08:59:59+00:00", "01:59:59", "MST", 420],
		["1967-04-30T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1967-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1967-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1968" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1968-04-28T08:59:59+00:00", "01:59:59", "MST", 420],
		["1968-04-28T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1968-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1968-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1969" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1969-04-27T08:59:59+00:00", "01:59:59", "MST", 420],
		["1969-04-27T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1969-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1969-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1970" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1970-04-26T08:59:59+00:00", "01:59:59", "MST", 420],
		["1970-04-26T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1970-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1970-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1971" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1971-04-25T08:59:59+00:00", "01:59:59", "MST", 420],
		["1971-04-25T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1971-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1971-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1972" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1972-04-30T08:59:59+00:00", "01:59:59", "MST", 420],
		["1972-04-30T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1972-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1972-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1973" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1973-04-29T08:59:59+00:00", "01:59:59", "MST", 420],
		["1973-04-29T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1973-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1973-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1974" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1974-01-06T08:59:59+00:00", "01:59:59", "MST", 420],
		["1974-01-06T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1974-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1974-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1975" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1975-02-23T08:59:59+00:00", "01:59:59", "MST", 420],
		["1975-02-23T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1975-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1975-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1976" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1976-04-25T08:59:59+00:00", "01:59:59", "MST", 420],
		["1976-04-25T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1976-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1976-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1977" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1977-04-24T08:59:59+00:00", "01:59:59", "MST", 420],
		["1977-04-24T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1977-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1977-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1978" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1978-04-30T08:59:59+00:00", "01:59:59", "MST", 420],
		["1978-04-30T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1978-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1978-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1979" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1979-04-29T08:59:59+00:00", "01:59:59", "MST", 420],
		["1979-04-29T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1979-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1979-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1980" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1980-04-27T08:59:59+00:00", "01:59:59", "MST", 420],
		["1980-04-27T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1980-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1980-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1981" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1981-04-26T08:59:59+00:00", "01:59:59", "MST", 420],
		["1981-04-26T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1981-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1981-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1982" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1982-04-25T08:59:59+00:00", "01:59:59", "MST", 420],
		["1982-04-25T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1982-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1982-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1983" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1983-04-24T08:59:59+00:00", "01:59:59", "MST", 420],
		["1983-04-24T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1983-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1983-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1984" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1984-04-29T08:59:59+00:00", "01:59:59", "MST", 420],
		["1984-04-29T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1984-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1984-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1985" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1985-04-28T08:59:59+00:00", "01:59:59", "MST", 420],
		["1985-04-28T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1985-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1985-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1986" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1986-04-27T08:59:59+00:00", "01:59:59", "MST", 420],
		["1986-04-27T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1986-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1986-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1987" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1987-04-05T08:59:59+00:00", "01:59:59", "MST", 420],
		["1987-04-05T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1987-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1987-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1988" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1988-04-03T08:59:59+00:00", "01:59:59", "MST", 420],
		["1988-04-03T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1988-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1988-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1989" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1989-04-02T08:59:59+00:00", "01:59:59", "MST", 420],
		["1989-04-02T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1989-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1989-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1990" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1990-04-01T08:59:59+00:00", "01:59:59", "MST", 420],
		["1990-04-01T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1990-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1990-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1991" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1991-04-07T08:59:59+00:00", "01:59:59", "MST", 420],
		["1991-04-07T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1991-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1991-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1992" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1992-04-05T08:59:59+00:00", "01:59:59", "MST", 420],
		["1992-04-05T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1992-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1992-10-25T08:00:00+00:00", "02:00:00", "CST", 360]
	]),

	"1993" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1993-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["1993-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1993-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1993-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1994" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1994-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["1994-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1994-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1994-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1995" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1995-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["1995-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1995-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1995-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1996" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1996-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["1996-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1996-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1996-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1997" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1997-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["1997-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1997-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1997-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1998" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1998-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["1998-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1998-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1998-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1999" : helpers.makeTestYear("America/North_Dakota/Center", [
		["1999-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["1999-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["1999-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["1999-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2000" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2000-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2000-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2000-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2000-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2001" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2001-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2001-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2001-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2001-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2002" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2002-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2002-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2002-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2002-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2003" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2003-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2003-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2003-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2003-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2004" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2004-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2004-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2004-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2004-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2005" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2005-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2005-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2005-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2005-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2006" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2006-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2006-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2006-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2006-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2007" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2007-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2007-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2007-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2007-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2008" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2008-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2008-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2008-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2008-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2009" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2009-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2009-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2009-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2009-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2010" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2010-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2010-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2010-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2010-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2011" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2011-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2011-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2011-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2011-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2012" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2012-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2012-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2012-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2012-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2013" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2013-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2013-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2013-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2013-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2014" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2014-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2014-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2014-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2014-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2015" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2015-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2015-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2015-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2015-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2016" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2016-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2016-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2016-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2016-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2017" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2017-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2017-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2017-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2017-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2018" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2018-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2018-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2018-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2018-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2019" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2019-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2019-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2019-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2019-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2020" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2020-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2020-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2020-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2020-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2021" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2021-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2021-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2021-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2021-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2022" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2022-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2022-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2022-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2022-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2023" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2023-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2023-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2023-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2023-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2024" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2024-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2024-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2024-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2024-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2025" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2025-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2025-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2025-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2025-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2026" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2026-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2026-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2026-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2026-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2027" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2027-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2027-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2027-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2027-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2028" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2028-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2028-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2028-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2028-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2029" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2029-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2029-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2029-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2029-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2030" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2030-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2030-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2030-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2030-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2031" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2031-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2031-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2031-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2031-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2032" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2032-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2032-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2032-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2032-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2033" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2033-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2033-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2033-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2033-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2034" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2034-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2034-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2034-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2034-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2035" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2035-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2035-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2035-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2035-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2036" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2036-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2036-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2036-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2036-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2037" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2037-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2037-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2037-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2037-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2038" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2038-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2038-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2038-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2038-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2039" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2039-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2039-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2039-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2039-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2040" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2040-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2040-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2040-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2040-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2041" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2041-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2041-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2041-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2041-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2042" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2042-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2042-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2042-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2042-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2043" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2043-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2043-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2043-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2043-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2044" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2044-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2044-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2044-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2044-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2045" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2045-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2045-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2045-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2045-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2046" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2046-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2046-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2046-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2046-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2047" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2047-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2047-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2047-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2047-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2048" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2048-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2048-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2048-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2048-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2049" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2049-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2049-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2049-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2049-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2050" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2050-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2050-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2050-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2050-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2051" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2051-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2051-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2051-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2051-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2052" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2052-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2052-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2052-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2052-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2053" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2053-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2053-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2053-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2053-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2054" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2054-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2054-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2054-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2054-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2055" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2055-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2055-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2055-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2055-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2056" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2056-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2056-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2056-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2056-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2057" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2057-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2057-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2057-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2057-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2058" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2058-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2058-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2058-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2058-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2059" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2059-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2059-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2059-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2059-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2060" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2060-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2060-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2060-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2060-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2061" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2061-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2061-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2061-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2061-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2062" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2062-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2062-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2062-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2062-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2063" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2063-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2063-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2063-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2063-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2064" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2064-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2064-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2064-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2064-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2065" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2065-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2065-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2065-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2065-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2066" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2066-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2066-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2066-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2066-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2067" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2067-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2067-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2067-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2067-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2068" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2068-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2068-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2068-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2068-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2069" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2069-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2069-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2069-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2069-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2070" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2070-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2070-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2070-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2070-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2071" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2071-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2071-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2071-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2071-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2072" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2072-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2072-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2072-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2072-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2073" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2073-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2073-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2073-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2073-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2074" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2074-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2074-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2074-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2074-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2075" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2075-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2075-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2075-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2075-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2076" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2076-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2076-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2076-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2076-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2077" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2077-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2077-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2077-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2077-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2078" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2078-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2078-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2078-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2078-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2079" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2079-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2079-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2079-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2079-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2080" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2080-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2080-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2080-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2080-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2081" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2081-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2081-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2081-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2081-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2082" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2082-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2082-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2082-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2082-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2083" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2083-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2083-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2083-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2083-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2084" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2084-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2084-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2084-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2084-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2085" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2085-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2085-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2085-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2085-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2086" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2086-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2086-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2086-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2086-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2087" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2087-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2087-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2087-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2087-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2088" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2088-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2088-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2088-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2088-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2089" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2089-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2089-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2089-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2089-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2090" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2090-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2090-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2090-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2090-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2091" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2091-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2091-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2091-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2091-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2092" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2092-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2092-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2092-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2092-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2093" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2093-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2093-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2093-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2093-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2094" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2094-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2094-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2094-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2094-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2095" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2095-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2095-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2095-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2095-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2096" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2096-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2096-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2096-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2096-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2097" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2097-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2097-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2097-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2097-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2098" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2098-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2098-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2098-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2098-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2099" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2099-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2099-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2099-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2099-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2100" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2100-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2100-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2100-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2100-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2101" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2101-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2101-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2101-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2101-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2102" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2102-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2102-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2102-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2102-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2103" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2103-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2103-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2103-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2103-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2104" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2104-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2104-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2104-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2104-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2105" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2105-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2105-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2105-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2105-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2106" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2106-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2106-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2106-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2106-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2107" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2107-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2107-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2107-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2107-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2108" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2108-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2108-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2108-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2108-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2109" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2109-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2109-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2109-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2109-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2110" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2110-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2110-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2110-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2110-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2111" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2111-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2111-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2111-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2111-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2112" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2112-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2112-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2112-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2112-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2113" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2113-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2113-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2113-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2113-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2114" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2114-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2114-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2114-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2114-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2115" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2115-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2115-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2115-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2115-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2116" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2116-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2116-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2116-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2116-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2117" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2117-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2117-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2117-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2117-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2118" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2118-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2118-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2118-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2118-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2119" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2119-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2119-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2119-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2119-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2120" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2120-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2120-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2120-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2120-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2121" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2121-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2121-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2121-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2121-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2122" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2122-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2122-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2122-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2122-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2123" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2123-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2123-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2123-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2123-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2124" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2124-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2124-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2124-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2124-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2125" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2125-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2125-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2125-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2125-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2126" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2126-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2126-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2126-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2126-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2127" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2127-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2127-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2127-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2127-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2128" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2128-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2128-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2128-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2128-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2129" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2129-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2129-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2129-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2129-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2130" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2130-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2130-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2130-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2130-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2131" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2131-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2131-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2131-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2131-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2132" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2132-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2132-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2132-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2132-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2133" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2133-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2133-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2133-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2133-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2134" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2134-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2134-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2134-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2134-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2135" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2135-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2135-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2135-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2135-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2136" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2136-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2136-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2136-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2136-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2137" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2137-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2137-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2137-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2137-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2138" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2138-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2138-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2138-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2138-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2139" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2139-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2139-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2139-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2139-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2140" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2140-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2140-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2140-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2140-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2141" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2141-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2141-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2141-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2141-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2142" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2142-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2142-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2142-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2142-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2143" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2143-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2143-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2143-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2143-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2144" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2144-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2144-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2144-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2144-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2145" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2145-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2145-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2145-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2145-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2146" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2146-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2146-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2146-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2146-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2147" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2147-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2147-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2147-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2147-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2148" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2148-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2148-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2148-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2148-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2149" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2149-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2149-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2149-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2149-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2150" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2150-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2150-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2150-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2150-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2151" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2151-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2151-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2151-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2151-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2152" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2152-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2152-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2152-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2152-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2153" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2153-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2153-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2153-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2153-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2154" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2154-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2154-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2154-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2154-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2155" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2155-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2155-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2155-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2155-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2156" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2156-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2156-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2156-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2156-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2157" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2157-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2157-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2157-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2157-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2158" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2158-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2158-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2158-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2158-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2159" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2159-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2159-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2159-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2159-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2160" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2160-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2160-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2160-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2160-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2161" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2161-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2161-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2161-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2161-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2162" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2162-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2162-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2162-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2162-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2163" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2163-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2163-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2163-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2163-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2164" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2164-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2164-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2164-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2164-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2165" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2165-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2165-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2165-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2165-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2166" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2166-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2166-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2166-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2166-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2167" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2167-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2167-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2167-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2167-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2168" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2168-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2168-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2168-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2168-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2169" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2169-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2169-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2169-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2169-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2170" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2170-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2170-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2170-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2170-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2171" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2171-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2171-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2171-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2171-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2172" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2172-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2172-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2172-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2172-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2173" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2173-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2173-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2173-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2173-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2174" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2174-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2174-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2174-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2174-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2175" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2175-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2175-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2175-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2175-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2176" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2176-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2176-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2176-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2176-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2177" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2177-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2177-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2177-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2177-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2178" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2178-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2178-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2178-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2178-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2179" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2179-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2179-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2179-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2179-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2180" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2180-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2180-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2180-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2180-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2181" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2181-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2181-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2181-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2181-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2182" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2182-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2182-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2182-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2182-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2183" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2183-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2183-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2183-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2183-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2184" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2184-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2184-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2184-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2184-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2185" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2185-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2185-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2185-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2185-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2186" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2186-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2186-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2186-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2186-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2187" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2187-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2187-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2187-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2187-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2188" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2188-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2188-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2188-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2188-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2189" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2189-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2189-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2189-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2189-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2190" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2190-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2190-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2190-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2190-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2191" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2191-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2191-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2191-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2191-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2192" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2192-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2192-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2192-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2192-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2193" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2193-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2193-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2193-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2193-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2194" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2194-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2194-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2194-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2194-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2195" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2195-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2195-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2195-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2195-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2196" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2196-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2196-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2196-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2196-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2197" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2197-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2197-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2197-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2197-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2198" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2198-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2198-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2198-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2198-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2199" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2199-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2199-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2199-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2199-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2200" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2200-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2200-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2200-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2200-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2201" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2201-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2201-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2201-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2201-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2202" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2202-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2202-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2202-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2202-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2203" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2203-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2203-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2203-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2203-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2204" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2204-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2204-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2204-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2204-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2205" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2205-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2205-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2205-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2205-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2206" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2206-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2206-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2206-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2206-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2207" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2207-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2207-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2207-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2207-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2208" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2208-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2208-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2208-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2208-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2209" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2209-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2209-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2209-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2209-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2210" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2210-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2210-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2210-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2210-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2211" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2211-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2211-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2211-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2211-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2212" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2212-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2212-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2212-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2212-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2213" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2213-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2213-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2213-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2213-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2214" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2214-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2214-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2214-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2214-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2215" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2215-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2215-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2215-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2215-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2216" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2216-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2216-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2216-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2216-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2217" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2217-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2217-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2217-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2217-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2218" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2218-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2218-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2218-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2218-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2219" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2219-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2219-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2219-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2219-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2220" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2220-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2220-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2220-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2220-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2221" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2221-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2221-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2221-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2221-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2222" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2222-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2222-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2222-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2222-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2223" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2223-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2223-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2223-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2223-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2224" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2224-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2224-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2224-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2224-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2225" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2225-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2225-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2225-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2225-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2226" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2226-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2226-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2226-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2226-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2227" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2227-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2227-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2227-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2227-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2228" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2228-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2228-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2228-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2228-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2229" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2229-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2229-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2229-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2229-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2230" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2230-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2230-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2230-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2230-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2231" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2231-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2231-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2231-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2231-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2232" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2232-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2232-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2232-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2232-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2233" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2233-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2233-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2233-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2233-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2234" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2234-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2234-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2234-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2234-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2235" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2235-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2235-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2235-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2235-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2236" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2236-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2236-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2236-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2236-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2237" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2237-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2237-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2237-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2237-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2238" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2238-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2238-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2238-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2238-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2239" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2239-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2239-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2239-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2239-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2240" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2240-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2240-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2240-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2240-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2241" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2241-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2241-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2241-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2241-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2242" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2242-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2242-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2242-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2242-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2243" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2243-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2243-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2243-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2243-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2244" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2244-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2244-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2244-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2244-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2245" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2245-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2245-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2245-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2245-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2246" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2246-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2246-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2246-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2246-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2247" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2247-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2247-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2247-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2247-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2248" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2248-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2248-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2248-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2248-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2249" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2249-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2249-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2249-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2249-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2250" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2250-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2250-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2250-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2250-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2251" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2251-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2251-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2251-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2251-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2252" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2252-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2252-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2252-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2252-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2253" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2253-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2253-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2253-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2253-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2254" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2254-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2254-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2254-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2254-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2255" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2255-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2255-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2255-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2255-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2256" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2256-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2256-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2256-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2256-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2257" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2257-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2257-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2257-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2257-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2258" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2258-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2258-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2258-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2258-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2259" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2259-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2259-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2259-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2259-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2260" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2260-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2260-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2260-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2260-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2261" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2261-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2261-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2261-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2261-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2262" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2262-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2262-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2262-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2262-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2263" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2263-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2263-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2263-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2263-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2264" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2264-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2264-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2264-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2264-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2265" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2265-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2265-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2265-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2265-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2266" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2266-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2266-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2266-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2266-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2267" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2267-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2267-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2267-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2267-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2268" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2268-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2268-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2268-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2268-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2269" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2269-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2269-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2269-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2269-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2270" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2270-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2270-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2270-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2270-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2271" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2271-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2271-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2271-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2271-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2272" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2272-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2272-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2272-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2272-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2273" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2273-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2273-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2273-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2273-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2274" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2274-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2274-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2274-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2274-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2275" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2275-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2275-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2275-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2275-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2276" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2276-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2276-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2276-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2276-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2277" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2277-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2277-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2277-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2277-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2278" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2278-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2278-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2278-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2278-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2279" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2279-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2279-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2279-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2279-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2280" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2280-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2280-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2280-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2280-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2281" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2281-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2281-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2281-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2281-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2282" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2282-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2282-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2282-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2282-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2283" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2283-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2283-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2283-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2283-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2284" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2284-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2284-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2284-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2284-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2285" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2285-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2285-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2285-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2285-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2286" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2286-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2286-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2286-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2286-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2287" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2287-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2287-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2287-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2287-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2288" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2288-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2288-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2288-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2288-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2289" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2289-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2289-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2289-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2289-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2290" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2290-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2290-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2290-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2290-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2291" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2291-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2291-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2291-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2291-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2292" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2292-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2292-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2292-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2292-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2293" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2293-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2293-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2293-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2293-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2294" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2294-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2294-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2294-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2294-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2295" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2295-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2295-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2295-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2295-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2296" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2296-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2296-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2296-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2296-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2297" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2297-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2297-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2297-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2297-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2298" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2298-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2298-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2298-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2298-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2299" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2299-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2299-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2299-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2299-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2300" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2300-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2300-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2300-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2300-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2301" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2301-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2301-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2301-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2301-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2302" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2302-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2302-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2302-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2302-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2303" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2303-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2303-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2303-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2303-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2304" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2304-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2304-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2304-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2304-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2305" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2305-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2305-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2305-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2305-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2306" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2306-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2306-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2306-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2306-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2307" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2307-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2307-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2307-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2307-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2308" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2308-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2308-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2308-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2308-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2309" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2309-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2309-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2309-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2309-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2310" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2310-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2310-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2310-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2310-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2311" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2311-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2311-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2311-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2311-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2312" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2312-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2312-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2312-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2312-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2313" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2313-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2313-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2313-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2313-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2314" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2314-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2314-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2314-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2314-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2315" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2315-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2315-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2315-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2315-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2316" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2316-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2316-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2316-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2316-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2317" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2317-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2317-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2317-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2317-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2318" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2318-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2318-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2318-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2318-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2319" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2319-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2319-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2319-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2319-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2320" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2320-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2320-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2320-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2320-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2321" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2321-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2321-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2321-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2321-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2322" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2322-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2322-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2322-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2322-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2323" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2323-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2323-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2323-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2323-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2324" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2324-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2324-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2324-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2324-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2325" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2325-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2325-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2325-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2325-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2326" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2326-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2326-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2326-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2326-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2327" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2327-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2327-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2327-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2327-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2328" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2328-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2328-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2328-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2328-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2329" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2329-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2329-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2329-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2329-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2330" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2330-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2330-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2330-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2330-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2331" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2331-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2331-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2331-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2331-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2332" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2332-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2332-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2332-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2332-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2333" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2333-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2333-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2333-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2333-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2334" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2334-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2334-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2334-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2334-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2335" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2335-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2335-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2335-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2335-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2336" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2336-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2336-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2336-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2336-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2337" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2337-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2337-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2337-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2337-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2338" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2338-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2338-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2338-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2338-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2339" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2339-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2339-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2339-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2339-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2340" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2340-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2340-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2340-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2340-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2341" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2341-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2341-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2341-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2341-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2342" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2342-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2342-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2342-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2342-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2343" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2343-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2343-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2343-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2343-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2344" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2344-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2344-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2344-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2344-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2345" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2345-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2345-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2345-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2345-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2346" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2346-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2346-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2346-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2346-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2347" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2347-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2347-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2347-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2347-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2348" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2348-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2348-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2348-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2348-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2349" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2349-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2349-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2349-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2349-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2350" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2350-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2350-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2350-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2350-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2351" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2351-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2351-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2351-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2351-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2352" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2352-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2352-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2352-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2352-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2353" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2353-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2353-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2353-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2353-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2354" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2354-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2354-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2354-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2354-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2355" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2355-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2355-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2355-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2355-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2356" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2356-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2356-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2356-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2356-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2357" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2357-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2357-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2357-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2357-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2358" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2358-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2358-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2358-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2358-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2359" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2359-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2359-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2359-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2359-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2360" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2360-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2360-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2360-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2360-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2361" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2361-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2361-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2361-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2361-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2362" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2362-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2362-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2362-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2362-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2363" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2363-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2363-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2363-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2363-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2364" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2364-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2364-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2364-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2364-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2365" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2365-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2365-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2365-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2365-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2366" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2366-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2366-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2366-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2366-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2367" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2367-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2367-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2367-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2367-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2368" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2368-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2368-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2368-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2368-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2369" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2369-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2369-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2369-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2369-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2370" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2370-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2370-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2370-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2370-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2371" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2371-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2371-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2371-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2371-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2372" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2372-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2372-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2372-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2372-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2373" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2373-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2373-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2373-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2373-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2374" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2374-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2374-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2374-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2374-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2375" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2375-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2375-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2375-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2375-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2376" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2376-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2376-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2376-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2376-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2377" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2377-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2377-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2377-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2377-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2378" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2378-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2378-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2378-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2378-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2379" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2379-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2379-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2379-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2379-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2380" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2380-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2380-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2380-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2380-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2381" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2381-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2381-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2381-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2381-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2382" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2382-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2382-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2382-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2382-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2383" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2383-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2383-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2383-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2383-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2384" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2384-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2384-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2384-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2384-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2385" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2385-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2385-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2385-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2385-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2386" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2386-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2386-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2386-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2386-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2387" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2387-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2387-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2387-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2387-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2388" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2388-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2388-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2388-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2388-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2389" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2389-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2389-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2389-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2389-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2390" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2390-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2390-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2390-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2390-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2391" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2391-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2391-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2391-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2391-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2392" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2392-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2392-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2392-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2392-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2393" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2393-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2393-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2393-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2393-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2394" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2394-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2394-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2394-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2394-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2395" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2395-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2395-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2395-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2395-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2396" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2396-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2396-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2396-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2396-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2397" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2397-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2397-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2397-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2397-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2398" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2398-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2398-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2398-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2398-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2399" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2399-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2399-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2399-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2399-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2400" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2400-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2400-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2400-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2400-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2401" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2401-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2401-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2401-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2401-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2402" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2402-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2402-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2402-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2402-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2403" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2403-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2403-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2403-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2403-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2404" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2404-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2404-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2404-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2404-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2405" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2405-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2405-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2405-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2405-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2406" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2406-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2406-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2406-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2406-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2407" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2407-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2407-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2407-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2407-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2408" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2408-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2408-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2408-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2408-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2409" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2409-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2409-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2409-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2409-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2410" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2410-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2410-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2410-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2410-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2411" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2411-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2411-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2411-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2411-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2412" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2412-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2412-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2412-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2412-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2413" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2413-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2413-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2413-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2413-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2414" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2414-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2414-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2414-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2414-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2415" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2415-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2415-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2415-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2415-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2416" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2416-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2416-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2416-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2416-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2417" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2417-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2417-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2417-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2417-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2418" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2418-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2418-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2418-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2418-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2419" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2419-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2419-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2419-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2419-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2420" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2420-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2420-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2420-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2420-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2421" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2421-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2421-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2421-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2421-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2422" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2422-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2422-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2422-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2422-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2423" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2423-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2423-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2423-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2423-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2424" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2424-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2424-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2424-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2424-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2425" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2425-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2425-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2425-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2425-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2426" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2426-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2426-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2426-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2426-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2427" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2427-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2427-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2427-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2427-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2428" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2428-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2428-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2428-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2428-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2429" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2429-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2429-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2429-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2429-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2430" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2430-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2430-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2430-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2430-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2431" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2431-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2431-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2431-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2431-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2432" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2432-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2432-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2432-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2432-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2433" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2433-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2433-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2433-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2433-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2434" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2434-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2434-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2434-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2434-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2435" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2435-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2435-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2435-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2435-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2436" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2436-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2436-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2436-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2436-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2437" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2437-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2437-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2437-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2437-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2438" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2438-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2438-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2438-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2438-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2439" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2439-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2439-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2439-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2439-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2440" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2440-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2440-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2440-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2440-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2441" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2441-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2441-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2441-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2441-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2442" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2442-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2442-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2442-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2442-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2443" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2443-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2443-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2443-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2443-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2444" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2444-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2444-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2444-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2444-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2445" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2445-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2445-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2445-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2445-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2446" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2446-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2446-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2446-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2446-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2447" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2447-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2447-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2447-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2447-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2448" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2448-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2448-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2448-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2448-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2449" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2449-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2449-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2449-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2449-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2450" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2450-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2450-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2450-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2450-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2451" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2451-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2451-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2451-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2451-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2452" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2452-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2452-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2452-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2452-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2453" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2453-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2453-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2453-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2453-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2454" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2454-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2454-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2454-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2454-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2455" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2455-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2455-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2455-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2455-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2456" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2456-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2456-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2456-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2456-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2457" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2457-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2457-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2457-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2457-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2458" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2458-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2458-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2458-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2458-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2459" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2459-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2459-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2459-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2459-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2460" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2460-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2460-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2460-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2460-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2461" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2461-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2461-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2461-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2461-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2462" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2462-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2462-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2462-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2462-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2463" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2463-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2463-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2463-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2463-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2464" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2464-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2464-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2464-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2464-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2465" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2465-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2465-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2465-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2465-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2466" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2466-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2466-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2466-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2466-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2467" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2467-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2467-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2467-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2467-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2468" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2468-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2468-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2468-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2468-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2469" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2469-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2469-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2469-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2469-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2470" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2470-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2470-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2470-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2470-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2471" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2471-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2471-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2471-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2471-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2472" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2472-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2472-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2472-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2472-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2473" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2473-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2473-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2473-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2473-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2474" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2474-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2474-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2474-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2474-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2475" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2475-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2475-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2475-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2475-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2476" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2476-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2476-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2476-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2476-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2477" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2477-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2477-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2477-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2477-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2478" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2478-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2478-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2478-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2478-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2479" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2479-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2479-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2479-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2479-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2480" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2480-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2480-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2480-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2480-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2481" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2481-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2481-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2481-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2481-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2482" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2482-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2482-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2482-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2482-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2483" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2483-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2483-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2483-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2483-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2484" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2484-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2484-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2484-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2484-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2485" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2485-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2485-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2485-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2485-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2486" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2486-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2486-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2486-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2486-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2487" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2487-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2487-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2487-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2487-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2488" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2488-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2488-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2488-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2488-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2489" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2489-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2489-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2489-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2489-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2490" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2490-03-12T07:59:59+00:00", "01:59:59", "CST", 360],
		["2490-03-12T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2490-11-05T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2490-11-05T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2491" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2491-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2491-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2491-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2491-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2492" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2492-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2492-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2492-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2492-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2493" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2493-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2493-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2493-11-01T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2493-11-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2494" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2494-03-14T07:59:59+00:00", "01:59:59", "CST", 360],
		["2494-03-14T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2494-11-07T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2494-11-07T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2495" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2495-03-13T07:59:59+00:00", "01:59:59", "CST", 360],
		["2495-03-13T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2495-11-06T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2495-11-06T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2496" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2496-03-11T07:59:59+00:00", "01:59:59", "CST", 360],
		["2496-03-11T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2496-11-04T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2496-11-04T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2497" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2497-03-10T07:59:59+00:00", "01:59:59", "CST", 360],
		["2497-03-10T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2497-11-03T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2497-11-03T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2498" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2498-03-09T07:59:59+00:00", "01:59:59", "CST", 360],
		["2498-03-09T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2498-11-02T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2498-11-02T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2499" : helpers.makeTestYear("America/North_Dakota/Center", [
		["2499-03-08T07:59:59+00:00", "01:59:59", "CST", 360],
		["2499-03-08T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2499-11-01T06:59:59+00:00", "01:59:59", "CDT", 300]
	])
};