/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;

public class IO {
    public static void writeFile(File file, String contents) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            writer.append(contents);
        }
        finally {
            writer.close();
        }
    }

    public static String readFile(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[32768];
            int read = 0;
            while ((read = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, read);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void collectLines(ArrayList<String> lines, BufferedReader reader) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            String[] stringArray = line.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                lines.add(arg);
                ++n2;
            }
        }
    }

    public static String[] linesFromFile(String fname) {
        String[] stringArray;
        FileReader reader = new FileReader(fname);
        try {
            ArrayList<String> lines = new ArrayList<String>();
            IO.collectLines(lines, new BufferedReader(reader));
            stringArray = lines.toArray(new String[lines.size()]);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return stringArray;
    }
}

