/* moonshot-local-flat-file-store.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-local-flat-file-store.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "config.h"
#include <glib/gstdio.h>
#include <gio/gio.h>


#define TYPE_IIDENTITY_CARD_STORE (iidentity_card_store_get_type ())
#define IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStore))
#define IS_IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IIDENTITY_CARD_STORE))
#define IIDENTITY_CARD_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStoreIface))

typedef struct _IIdentityCardStore IIdentityCardStore;
typedef struct _IIdentityCardStoreIface IIdentityCardStoreIface;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define IIDENTITY_CARD_STORE_TYPE_STORE_TYPE (iidentity_card_store_store_type_get_type ())

#define TYPE_LOCAL_FLAT_FILE_STORE (local_flat_file_store_get_type ())
#define LOCAL_FLAT_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStore))
#define LOCAL_FLAT_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStoreClass))
#define IS_LOCAL_FLAT_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCAL_FLAT_FILE_STORE))
#define IS_LOCAL_FLAT_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCAL_FLAT_FILE_STORE))
#define LOCAL_FLAT_FILE_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStoreClass))

typedef struct _LocalFlatFileStore LocalFlatFileStore;
typedef struct _LocalFlatFileStoreClass LocalFlatFileStoreClass;
typedef struct _LocalFlatFileStorePrivate LocalFlatFileStorePrivate;

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;

typedef enum  {
	IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE,
	IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING
} IIdentityCardStoreStoreType;

struct _IIdentityCardStoreIface {
	GTypeInterface parent_iface;
	void (*add_card) (IIdentityCardStore* self, IdCard* card);
	gboolean (*remove_card) (IIdentityCardStore* self, IdCard* card);
	IdCard* (*update_card) (IIdentityCardStore* self, IdCard* card);
	IIdentityCardStoreStoreType (*get_store_type) (IIdentityCardStore* self);
	GeeLinkedList* (*get_card_list) (IIdentityCardStore* self);
	void (*store_id_cards) (IIdentityCardStore* self);
};

struct _LocalFlatFileStore {
	GObject parent_instance;
	LocalFlatFileStorePrivate * priv;
};

struct _LocalFlatFileStoreClass {
	GObjectClass parent_class;
};

struct _LocalFlatFileStorePrivate {
	GeeLinkedList* id_card_list;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};


static gpointer local_flat_file_store_parent_class = NULL;
static MoonshotLogger* local_flat_file_store_logger;
static MoonshotLogger* local_flat_file_store_logger = NULL;
static IIdentityCardStoreIface* local_flat_file_store_iidentity_card_store_parent_iface = NULL;

GType id_card_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_store_type_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_get_type (void) G_GNUC_CONST;
GType local_flat_file_store_get_type (void) G_GNUC_CONST;
#define LOCAL_FLAT_FILE_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStorePrivate))
enum  {
	LOCAL_FLAT_FILE_STORE_DUMMY_PROPERTY
};
GType moonshot_logger_get_type (void) G_GNUC_CONST;
MoonshotLogger* get_logger (const gchar* name);
#define LOCAL_FLAT_FILE_STORE_FILE_NAME "identities.txt"
static void local_flat_file_store_real_add_card (IIdentityCardStore* base, IdCard* card);
void iidentity_card_store_store_id_cards (IIdentityCardStore* self);
static IdCard* local_flat_file_store_real_update_card (IIdentityCardStore* base, IdCard* card);
const gchar* id_card_get_display_name (IdCard* self);
void moonshot_logger_error (MoonshotLogger* self, const gchar* message, GError* e);
static gboolean local_flat_file_store_real_remove_card (IIdentityCardStore* base, IdCard* card);
static GeeLinkedList* local_flat_file_store_real_get_card_list (IIdentityCardStore* base);
static IIdentityCardStoreStoreType local_flat_file_store_real_get_store_type (IIdentityCardStore* base);
static void local_flat_file_store_load_id_cards (LocalFlatFileStore* self);
static gchar* local_flat_file_store_get_data_dir (LocalFlatFileStore* self);
void moonshot_logger_trace (MoonshotLogger* self, const gchar* message, GError* e);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_password (IdCard* self, const gchar* value);
void id_card_update_services (IdCard* self, gchar** services, int services_length1);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_store_password (IdCard* self, gboolean value);
const gchar* id_card_get_password (IdCard* self);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
void id_card_set_rules (IdCard* self, Rule* value, int value_length1);
static void _vala_Rule_array_free (Rule* array, gint array_length);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* trust_anchor_new (const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
TrustAnchor* trust_anchor_construct (GType object_type, const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
gchar* get_string_setting (const gchar* group_name, const gchar* key_name, const gchar* _default_, GKeyFile* key_file);
void trust_anchor_set_datetime_added (TrustAnchor* self, const gchar* datetime);
void id_card_set_trust_anchor_from_store (IdCard* self, TrustAnchor* ta);
static void local_flat_file_store_real_store_id_cards (IIdentityCardStore* base);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
static Rule* _vala_array_dup1 (Rule* self, int length);
const gchar* id_card_get_issuer (IdCard* self);
const gchar* id_card_get_username (IdCard* self);
gboolean id_card_get_store_password (IdCard* self);
GeeArrayList* id_card_get_services (IdCard* self);
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
const gchar* trust_anchor_get_datetime_added (TrustAnchor* self);
LocalFlatFileStore* local_flat_file_store_new (void);
LocalFlatFileStore* local_flat_file_store_construct (GType object_type);
static void local_flat_file_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void local_flat_file_store_real_add_card (IIdentityCardStore* base, IdCard* card) {
	LocalFlatFileStore * self;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_if_fail (card != NULL);
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = card;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iidentity_card_store_store_id_cards ((IIdentityCardStore*) self);
#line 225 "moonshot-local-flat-file-store.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 232 "moonshot-local-flat-file-store.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1420 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 244 "moonshot-local-flat-file-store.c"
}


static IdCard* local_flat_file_store_real_update_card (IIdentityCardStore* base, IdCard* card) {
	LocalFlatFileStore * self;
	IdCard* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	MoonshotLogger* _tmp21_ = NULL;
	IdCard* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = card;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp2_ = self->priv->id_card_list;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp3_ = card;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iidentity_card_store_store_id_cards ((IIdentityCardStore*) self);
#line 280 "moonshot-local-flat-file-store.c"
	{
		GeeLinkedList* _idcard_list = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		gint _idcard_size = 0;
		GeeLinkedList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _idcard_index = 0;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp4_ = self->priv->id_card_list;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_idcard_list = _tmp5_;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp6_ = _idcard_list;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp8_ = _tmp7_;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_idcard_size = _tmp8_;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_idcard_index = -1;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		while (TRUE) {
#line 308 "moonshot-local-flat-file-store.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			IdCard* idcard = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			IdCard* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			IdCard* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp9_ = _idcard_index;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_idcard_index = _tmp9_ + 1;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp10_ = _idcard_index;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp11_ = _idcard_size;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				break;
#line 334 "moonshot-local-flat-file-store.c"
			}
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp12_ = _idcard_list;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp13_ = _idcard_index;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			idcard = (IdCard*) _tmp14_;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp15_ = idcard;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp16_ = id_card_get_display_name (_tmp15_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp17_ = _tmp16_;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp18_ = card;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp19_ = id_card_get_display_name (_tmp18_);
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp20_ = _tmp19_;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (g_strcmp0 (_tmp17_, _tmp20_) == 0) {
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				result = idcard;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_g_object_unref0 (_idcard_list);
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				return result;
#line 364 "moonshot-local-flat-file-store.c"
			}
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (idcard);
#line 368 "moonshot-local-flat-file-store.c"
		}
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_object_unref0 (_idcard_list);
#line 372 "moonshot-local-flat-file-store.c"
	}
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp21_ = local_flat_file_store_logger;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp22_ = card;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp23_ = id_card_get_display_name (_tmp22_);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp24_ = _tmp23_;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp25_ = string_to_string (_tmp24_);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp26_ = g_strconcat ("update_card: card '", _tmp25_, "' was not found after re-loading!", NULL);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp27_ = _tmp26_;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	moonshot_logger_error (_tmp21_, _tmp27_, NULL);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (_tmp27_);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = NULL;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 396 "moonshot-local-flat-file-store.c"
}


static gboolean local_flat_file_store_real_remove_card (IIdentityCardStore* base, IdCard* card) {
	LocalFlatFileStore * self;
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = card;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp2_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (_tmp2_) {
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		iidentity_card_store_store_id_cards ((IIdentityCardStore*) self);
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		result = TRUE;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		return result;
#line 424 "moonshot-local-flat-file-store.c"
	}
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = FALSE;
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 430 "moonshot-local-flat-file-store.c"
}


static GeeLinkedList* local_flat_file_store_real_get_card_list (IIdentityCardStore* base) {
	LocalFlatFileStore * self;
	GeeLinkedList* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = _tmp1_;
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 449 "moonshot-local-flat-file-store.c"
}


static IIdentityCardStoreStoreType local_flat_file_store_real_get_store_type (IIdentityCardStore* base) {
	LocalFlatFileStore * self;
	IIdentityCardStoreStoreType result = 0;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 462 "moonshot-local-flat-file-store.c"
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (array != NULL) {
#line 469 "moonshot-local-flat-file-store.c"
		int i;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rule_destroy (&array[i]);
#line 475 "moonshot-local-flat-file-store.c"
		}
	}
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_free (array);
#line 480 "moonshot-local-flat-file-store.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1215 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1216 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1216 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1218 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1218 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 503 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_load_id_cards (LocalFlatFileStore* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GKeyFile* key_file = NULL;
	GKeyFile* _tmp1_ = NULL;
	gchar* path = NULL;
	gchar* _tmp2_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	MoonshotLogger* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar** identities_uris = NULL;
	GKeyFile* _tmp15_ = NULL;
	gsize _tmp16_;
	gchar** _tmp17_ = NULL;
	gint identities_uris_length1 = 0;
	gint _identities_uris_size_ = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	GError * _inner_error_ = NULL;
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = g_key_file_new ();
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	key_file = _tmp1_;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp2_ = local_flat_file_store_get_data_dir (self);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	path = _tmp2_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp3_ = path;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp4_ = g_build_filename (_tmp3_, LOCAL_FLAT_FILE_STORE_FILE_NAME, NULL);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	filename = _tmp4_;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp5_ = local_flat_file_store_logger;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp6_ = filename;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp7_ = g_strconcat ("load_id_cards: attempting to load from ", _tmp6_, NULL);
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp8_ = _tmp7_;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	moonshot_logger_trace (_tmp5_, _tmp8_, NULL);
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (_tmp8_);
#line 561 "moonshot-local-flat-file-store.c"
	{
		GKeyFile* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp9_ = key_file;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp10_ = filename;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_key_file_load_from_file (_tmp9_, _tmp10_, G_KEY_FILE_NONE, &_inner_error_);
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 573 "moonshot-local-flat-file-store.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		e = _inner_error_;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_inner_error_ = NULL;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp11_ = stdout;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp12_ = filename;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp13_ = e;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp14_ = _tmp13_->message;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		fprintf (_tmp11_, "Error while attempting to load from %s: %s\n", _tmp12_, _tmp14_);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_error_free0 (e);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (filename);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (path);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_key_file_unref0 (key_file);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		return;
#line 609 "moonshot-local-flat-file-store.c"
	}
	__finally6:
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (filename);
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (path);
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_key_file_unref0 (key_file);
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_clear_error (&_inner_error_);
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		return;
#line 626 "moonshot-local-flat-file-store.c"
	}
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp15_ = key_file;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp17_ = g_key_file_get_groups (_tmp15_, &_tmp16_);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	identities_uris = _tmp17_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	identities_uris_length1 = _tmp16_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_identities_uris_size_ = identities_uris_length1;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp18_ = identities_uris;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp18__length1 = identities_uris_length1;
#line 642 "moonshot-local-flat-file-store.c"
	{
		gchar** identity_collection = NULL;
		gint identity_collection_length1 = 0;
		gint _identity_collection_size_ = 0;
		gint identity_it = 0;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		identity_collection = _tmp18_;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		identity_collection_length1 = _tmp18__length1;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		for (identity_it = 0; identity_it < _tmp18__length1; identity_it = identity_it + 1) {
#line 654 "moonshot-local-flat-file-store.c"
			gchar* _tmp19_ = NULL;
			gchar* identity = NULL;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp19_ = g_strdup (identity_collection[identity_it]);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			identity = _tmp19_;
#line 661 "moonshot-local-flat-file-store.c"
			{
				{
					IdCard* id_card = NULL;
					IdCard* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					GKeyFile* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					IdCard* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					GKeyFile* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					IdCard* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					GKeyFile* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					IdCard* _tmp35_ = NULL;
					gchar** _tmp36_ = NULL;
					GKeyFile* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
					gsize _tmp39_;
					gchar** _tmp40_ = NULL;
					gint _tmp36__length1 = 0;
					gint __tmp36__size_ = 0;
					IdCard* _tmp41_ = NULL;
					gchar* _tmp42_ = NULL;
					GKeyFile* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					IdCard* _tmp46_ = NULL;
					gboolean _tmp47_ = FALSE;
					GKeyFile* _tmp48_ = NULL;
					const gchar* _tmp49_ = NULL;
					gboolean _tmp50_ = FALSE;
					gboolean _tmp66_ = FALSE;
					gboolean _tmp67_ = FALSE;
					GKeyFile* _tmp68_ = NULL;
					const gchar* _tmp69_ = NULL;
					gboolean _tmp70_ = FALSE;
					gchar* _tmp105_ = NULL;
					GKeyFile* _tmp106_ = NULL;
					const gchar* _tmp107_ = NULL;
					gchar* _tmp108_ = NULL;
					gchar* ca_cert = NULL;
					gchar* _tmp109_ = NULL;
					gchar* _tmp110_ = NULL;
					gchar* _tmp111_ = NULL;
					gchar* _tmp112_ = NULL;
					gchar* server_cert = NULL;
					GKeyFile* _tmp113_ = NULL;
					const gchar* _tmp114_ = NULL;
					gchar* _tmp115_ = NULL;
					gchar* subject = NULL;
					GKeyFile* _tmp116_ = NULL;
					const gchar* _tmp117_ = NULL;
					gchar* _tmp118_ = NULL;
					gchar* subject_alt = NULL;
					GKeyFile* _tmp119_ = NULL;
					const gchar* _tmp120_ = NULL;
					gchar* _tmp121_ = NULL;
					TrustAnchor* ta = NULL;
					const gchar* _tmp122_ = NULL;
					const gchar* _tmp123_ = NULL;
					const gchar* _tmp124_ = NULL;
					const gchar* _tmp125_ = NULL;
					TrustAnchor* _tmp126_ = NULL;
					gchar* ta_datetime_added = NULL;
					const gchar* _tmp127_ = NULL;
					GKeyFile* _tmp128_ = NULL;
					gchar* _tmp129_ = NULL;
					const gchar* _tmp130_ = NULL;
					IdCard* _tmp133_ = NULL;
					TrustAnchor* _tmp134_ = NULL;
					GeeLinkedList* _tmp135_ = NULL;
					IdCard* _tmp136_ = NULL;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp20_ = id_card_new ();
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card = _tmp20_;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp22_ = key_file;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp23_ = identity;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp24_ = g_key_file_get_string (_tmp22_, _tmp23_, "Issuer", &_inner_error_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp21_ = _tmp24_;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 755 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp25_ = id_card;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_issuer (_tmp25_, _tmp21_);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp27_ = key_file;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp28_ = identity;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp29_ = g_key_file_get_string (_tmp27_, _tmp28_, "Username", &_inner_error_);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp26_ = _tmp29_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 776 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp30_ = id_card;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_username (_tmp30_, _tmp26_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp32_ = key_file;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp33_ = identity;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp34_ = g_key_file_get_string (_tmp32_, _tmp33_, "Password", &_inner_error_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp31_ = _tmp34_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 799 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp35_ = id_card;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_password (_tmp35_, _tmp31_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp37_ = key_file;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp38_ = identity;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp40_ = g_key_file_get_string_list (_tmp37_, _tmp38_, "Services", &_tmp39_, &_inner_error_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp36_ = _tmp40_;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp36__length1 = _tmp39_;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					__tmp36__size_ = _tmp36__length1;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp31_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 828 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp41_ = id_card;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_update_services (_tmp41_, _tmp36_, _tmp36__length1);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp43_ = key_file;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp44_ = identity;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp45_ = g_key_file_get_string (_tmp43_, _tmp44_, "DisplayName", &_inner_error_);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp42_ = _tmp45_;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp31_);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 855 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp46_ = id_card;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_display_name (_tmp46_, _tmp42_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp48_ = key_file;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp49_ = identity;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp50_ = g_key_file_has_key (_tmp48_, _tmp49_, "StorePassword", &_inner_error_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp47_ = _tmp50_;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp42_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp31_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 884 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_tmp47_) {
#line 889 "moonshot-local-flat-file-store.c"
						gchar* _tmp51_ = NULL;
						GKeyFile* _tmp52_ = NULL;
						const gchar* _tmp53_ = NULL;
						gchar* _tmp54_ = NULL;
						IdCard* _tmp55_ = NULL;
						gchar* _tmp56_ = NULL;
						gchar* _tmp57_ = NULL;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp52_ = key_file;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp53_ = identity;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp54_ = g_key_file_get_string (_tmp52_, _tmp53_, "StorePassword", &_inner_error_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp51_ = _tmp54_;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp42_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp31_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp26_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp21_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_object_unref0 (id_card);
#line 919 "moonshot-local-flat-file-store.c"
							goto __catch7_g_error;
						}
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp55_ = id_card;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp56_ = _tmp51_;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp51_ = NULL;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp57_ = _tmp56_;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						id_card_set_store_password (_tmp55_, g_strcmp0 (_tmp57_, "yes") == 0);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp57_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp51_);
#line 936 "moonshot-local-flat-file-store.c"
					} else {
						gboolean _tmp58_ = FALSE;
						IdCard* _tmp59_ = NULL;
						const gchar* _tmp60_ = NULL;
						const gchar* _tmp61_ = NULL;
						IdCard* _tmp65_ = NULL;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp59_ = id_card;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp60_ = id_card_get_password (_tmp59_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp61_ = _tmp60_;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (_tmp61_ != NULL) {
#line 951 "moonshot-local-flat-file-store.c"
							IdCard* _tmp62_ = NULL;
							const gchar* _tmp63_ = NULL;
							const gchar* _tmp64_ = NULL;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp62_ = id_card;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp63_ = id_card_get_password (_tmp62_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp64_ = _tmp63_;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp58_ = g_strcmp0 (_tmp64_, "") != 0;
#line 963 "moonshot-local-flat-file-store.c"
						} else {
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp58_ = FALSE;
#line 967 "moonshot-local-flat-file-store.c"
						}
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp65_ = id_card;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						id_card_set_store_password (_tmp65_, _tmp58_);
#line 973 "moonshot-local-flat-file-store.c"
					}
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp68_ = key_file;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp69_ = identity;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp70_ = g_key_file_has_key (_tmp68_, _tmp69_, "Rules-Patterns", &_inner_error_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp67_ = _tmp70_;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp42_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp31_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 997 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_tmp67_) {
#line 1002 "moonshot-local-flat-file-store.c"
						gboolean _tmp71_ = FALSE;
						GKeyFile* _tmp72_ = NULL;
						const gchar* _tmp73_ = NULL;
						gboolean _tmp74_ = FALSE;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp72_ = key_file;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp73_ = identity;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp74_ = g_key_file_has_key (_tmp72_, _tmp73_, "Rules-AlwaysConfirm", &_inner_error_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp71_ = _tmp74_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp42_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp31_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp26_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp21_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_object_unref0 (id_card);
#line 1029 "moonshot-local-flat-file-store.c"
							goto __catch7_g_error;
						}
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp66_ = _tmp71_;
#line 1034 "moonshot-local-flat-file-store.c"
					} else {
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp66_ = FALSE;
#line 1038 "moonshot-local-flat-file-store.c"
					}
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_tmp66_) {
#line 1042 "moonshot-local-flat-file-store.c"
						gchar** rules_patterns = NULL;
						GKeyFile* _tmp75_ = NULL;
						const gchar* _tmp76_ = NULL;
						gsize _tmp77_;
						gchar** _tmp78_ = NULL;
						gint rules_patterns_length1 = 0;
						gint _rules_patterns_size_ = 0;
						gchar** rules_always_conf = NULL;
						GKeyFile* _tmp79_ = NULL;
						const gchar* _tmp80_ = NULL;
						gsize _tmp81_;
						gchar** _tmp82_ = NULL;
						gint rules_always_conf_length1 = 0;
						gint _rules_always_conf_size_ = 0;
						gchar** _tmp83_ = NULL;
						gint _tmp83__length1 = 0;
						gchar** _tmp84_ = NULL;
						gint _tmp84__length1 = 0;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp75_ = key_file;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp76_ = identity;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp78_ = g_key_file_get_string_list (_tmp75_, _tmp76_, "Rules-Patterns", &_tmp77_, &_inner_error_);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_patterns = _tmp78_;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_patterns_length1 = _tmp77_;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_rules_patterns_size_ = rules_patterns_length1;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp42_);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp31_);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp26_);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp21_);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_object_unref0 (id_card);
#line 1087 "moonshot-local-flat-file-store.c"
							goto __catch7_g_error;
						}
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp79_ = key_file;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp80_ = identity;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp82_ = g_key_file_get_string_list (_tmp79_, _tmp80_, "Rules-AlwaysConfirm", &_tmp81_, &_inner_error_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_always_conf = _tmp82_;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_always_conf_length1 = _tmp81_;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_rules_always_conf_size_ = rules_always_conf_length1;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp42_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp31_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp26_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp21_);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_object_unref0 (id_card);
#line 1118 "moonshot-local-flat-file-store.c"
							goto __catch7_g_error;
						}
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp83_ = rules_patterns;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp83__length1 = rules_patterns_length1;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp84_ = rules_always_conf;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp84__length1 = rules_always_conf_length1;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (_tmp83__length1 == _tmp84__length1) {
#line 1131 "moonshot-local-flat-file-store.c"
							Rule* rules = NULL;
							gchar** _tmp85_ = NULL;
							gint _tmp85__length1 = 0;
							Rule* _tmp86_ = NULL;
							gint rules_length1 = 0;
							gint _rules_size_ = 0;
							IdCard* _tmp103_ = NULL;
							Rule* _tmp104_ = NULL;
							gint _tmp104__length1 = 0;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp85_ = rules_patterns;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp85__length1 = rules_patterns_length1;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp86_ = g_new0 (Rule, _tmp85__length1);
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							rules = _tmp86_;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							rules_length1 = _tmp85__length1;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_rules_size_ = rules_length1;
#line 1153 "moonshot-local-flat-file-store.c"
							{
								gint i = 0;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
								i = 0;
#line 1158 "moonshot-local-flat-file-store.c"
								{
									gboolean _tmp87_ = FALSE;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
									_tmp87_ = TRUE;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
									while (TRUE) {
#line 1165 "moonshot-local-flat-file-store.c"
										gint _tmp89_ = 0;
										gchar** _tmp90_ = NULL;
										gint _tmp90__length1 = 0;
										Rule* _tmp91_ = NULL;
										gint _tmp91__length1 = 0;
										gint _tmp92_ = 0;
										gchar** _tmp93_ = NULL;
										gint _tmp93__length1 = 0;
										gint _tmp94_ = 0;
										const gchar* _tmp95_ = NULL;
										gchar* _tmp96_ = NULL;
										gchar** _tmp97_ = NULL;
										gint _tmp97__length1 = 0;
										gint _tmp98_ = 0;
										const gchar* _tmp99_ = NULL;
										gchar* _tmp100_ = NULL;
										Rule _tmp101_ = {0};
										Rule _tmp102_ = {0};
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										if (!_tmp87_) {
#line 1186 "moonshot-local-flat-file-store.c"
											gint _tmp88_ = 0;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
											_tmp88_ = i;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
											i = _tmp88_ + 1;
#line 1192 "moonshot-local-flat-file-store.c"
										}
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp87_ = FALSE;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp89_ = i;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp90_ = rules_patterns;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp90__length1 = rules_patterns_length1;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										if (!(_tmp89_ < _tmp90__length1)) {
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
											break;
#line 1206 "moonshot-local-flat-file-store.c"
										}
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp91_ = rules;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp91__length1 = rules_length1;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp92_ = i;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp93_ = rules_patterns;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp93__length1 = rules_patterns_length1;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp94_ = i;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp95_ = _tmp93_[_tmp94_];
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp96_ = g_strdup (_tmp95_);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp97_ = rules_always_conf;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp97__length1 = rules_always_conf_length1;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp98_ = i;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp99_ = _tmp97_[_tmp98_];
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp100_ = g_strdup (_tmp99_);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_g_free0 (_tmp101_.pattern);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp101_.pattern = _tmp96_;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_g_free0 (_tmp101_.always_confirm);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp101_.always_confirm = _tmp100_;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										rule_destroy (&_tmp91_[_tmp92_]);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp91_[_tmp92_] = _tmp101_;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp102_ = _tmp91_[_tmp92_];
#line 1248 "moonshot-local-flat-file-store.c"
									}
								}
							}
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp103_ = id_card;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp104_ = rules;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp104__length1 = rules_length1;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							id_card_set_rules (_tmp103_, _tmp104_, _tmp104__length1);
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 1262 "moonshot-local-flat-file-store.c"
						}
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_always_conf = (_vala_array_free (rules_always_conf, rules_always_conf_length1, (GDestroyNotify) g_free), NULL);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 1268 "moonshot-local-flat-file-store.c"
					}
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp106_ = key_file;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp107_ = identity;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp108_ = g_key_file_get_string (_tmp106_, _tmp107_, "CA-Cert", &_inner_error_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp105_ = _tmp108_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp42_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp31_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 1292 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp109_ = _tmp105_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp105_ = NULL;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp110_ = _tmp109_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp111_ = string_strip (_tmp110_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp112_ = _tmp111_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp110_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					ca_cert = _tmp112_;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp113_ = key_file;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp114_ = identity;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp115_ = g_key_file_get_string (_tmp113_, _tmp114_, "ServerCert", &_inner_error_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					server_cert = _tmp115_;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (ca_cert);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp105_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp42_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp31_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 1335 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp116_ = key_file;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp117_ = identity;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp118_ = g_key_file_get_string (_tmp116_, _tmp117_, "Subject", &_inner_error_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					subject = _tmp118_;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (server_cert);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (ca_cert);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp105_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp42_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp31_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 1366 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp119_ = key_file;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp120_ = identity;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp121_ = g_key_file_get_string (_tmp119_, _tmp120_, "SubjectAlt", &_inner_error_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					subject_alt = _tmp121_;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (subject);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (server_cert);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (ca_cert);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp105_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp42_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp31_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 1399 "moonshot-local-flat-file-store.c"
						goto __catch7_g_error;
					}
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp122_ = ca_cert;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp123_ = server_cert;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp124_ = subject;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp125_ = subject_alt;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp126_ = trust_anchor_new (_tmp122_, _tmp123_, _tmp124_, _tmp125_);
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					ta = _tmp126_;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp127_ = identity;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp128_ = key_file;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp129_ = get_string_setting (_tmp127_, "TA_DateTime_Added", "", _tmp128_);
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					ta_datetime_added = _tmp129_;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp130_ = ta_datetime_added;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (g_strcmp0 (_tmp130_, "") != 0) {
#line 1426 "moonshot-local-flat-file-store.c"
						TrustAnchor* _tmp131_ = NULL;
						const gchar* _tmp132_ = NULL;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp131_ = ta;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp132_ = ta_datetime_added;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						trust_anchor_set_datetime_added (_tmp131_, _tmp132_);
#line 1435 "moonshot-local-flat-file-store.c"
					}
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp133_ = id_card;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp134_ = ta;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_trust_anchor_from_store (_tmp133_, _tmp134_);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp135_ = self->priv->id_card_list;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp136_ = id_card;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp135_, _tmp136_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (ta_datetime_added);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_object_unref0 (ta);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (subject_alt);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (subject);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (server_cert);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (ca_cert);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp105_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp42_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp31_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp26_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp21_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_object_unref0 (id_card);
#line 1475 "moonshot-local-flat-file-store.c"
				}
				goto __finally7;
				__catch7_g_error:
				{
					GError* e = NULL;
					MoonshotLogger* _tmp137_ = NULL;
					const gchar* _tmp138_ = NULL;
					GError* _tmp139_ = NULL;
					const gchar* _tmp140_ = NULL;
					gchar* _tmp141_ = NULL;
					gchar* _tmp142_ = NULL;
					FILE* _tmp143_ = NULL;
					const gchar* _tmp144_ = NULL;
					GError* _tmp145_ = NULL;
					const gchar* _tmp146_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					e = _inner_error_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_inner_error_ = NULL;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp137_ = local_flat_file_store_logger;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp138_ = filename;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp139_ = e;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp140_ = _tmp139_->message;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp141_ = g_strdup_printf ("load_id_cards: Error while loading keyfile %s: %s\n", _tmp138_, _tmp140_);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp142_ = _tmp141_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					moonshot_logger_error (_tmp137_, _tmp142_, NULL);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp142_);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp143_ = stdout;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp144_ = filename;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp145_ = e;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp146_ = _tmp145_->message;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					fprintf (_tmp143_, "Error while attempting to load from %s: %s\n", _tmp144_, _tmp146_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_error_free0 (e);
#line 1523 "moonshot-local-flat-file-store.c"
				}
				__finally7:
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (identity);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					identities_uris = (_vala_array_free (identities_uris, identities_uris_length1, (GDestroyNotify) g_free), NULL);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (filename);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (path);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_key_file_unref0 (key_file);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					g_clear_error (&_inner_error_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					return;
#line 1544 "moonshot-local-flat-file-store.c"
				}
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_g_free0 (identity);
#line 1548 "moonshot-local-flat-file-store.c"
			}
		}
	}
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	identities_uris = (_vala_array_free (identities_uris, identities_uris_length1, (GDestroyNotify) g_free), NULL);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (filename);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (path);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_key_file_unref0 (key_file);
#line 1560 "moonshot-local-flat-file-store.c"
}


static gchar* local_flat_file_store_get_data_dir (LocalFlatFileStore* self) {
	gchar* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (path);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	path = _tmp1_;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp2_ = path;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS);
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (!_tmp3_) {
#line 1587 "moonshot-local-flat-file-store.c"
		const gchar* _tmp4_ = NULL;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp4_ = path;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_mkdir_with_parents (_tmp4_, 0700);
#line 1593 "moonshot-local-flat-file-store.c"
	}
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = path;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 1599 "moonshot-local-flat-file-store.c"
}


static Rule* _vala_array_dup1 (Rule* self, int length) {
	Rule* result;
	int i;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = g_new0 (Rule, length);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	for (i = 0; i < length; i++) {
#line 1610 "moonshot-local-flat-file-store.c"
		Rule _tmp0_ = {0};
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		rule_copy (&self[i], &_tmp0_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		result[i] = _tmp0_;
#line 1616 "moonshot-local-flat-file-store.c"
	}
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 1620 "moonshot-local-flat-file-store.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1406 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1407 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1408 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1664 "moonshot-local-flat-file-store.c"
	}
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1409 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1670 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_real_store_id_cards (IIdentityCardStore* base) {
	LocalFlatFileStore * self;
	GKeyFile* key_file = NULL;
	GKeyFile* _tmp0_ = NULL;
	gchar* text = NULL;
	GKeyFile* _tmp192_ = NULL;
	gchar* _tmp193_ = NULL;
	GError * _inner_error_ = NULL;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = g_key_file_new ();
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	key_file = _tmp0_;
#line 1688 "moonshot-local-flat-file-store.c"
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _id_card_index = 0;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp1_ = self->priv->id_card_list;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_id_card_list = _tmp2_;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp3_ = _id_card_list;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp5_ = _tmp4_;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_id_card_size = _tmp5_;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_id_card_index = -1;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		while (TRUE) {
#line 1716 "moonshot-local-flat-file-store.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			MoonshotLogger* _tmp12_ = NULL;
			IdCard* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			Rule* rules = NULL;
			IdCard* _tmp19_ = NULL;
			Rule* _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			Rule* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			Rule* _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			gint rules_length1 = 0;
			gint _rules_size_ = 0;
			gchar** rules_patterns = NULL;
			Rule* _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			gchar** _tmp24_ = NULL;
			gint rules_patterns_length1 = 0;
			gint _rules_patterns_size_ = 0;
			gchar** rules_always_conf = NULL;
			Rule* _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gchar** _tmp26_ = NULL;
			gint rules_always_conf_length1 = 0;
			gint _rules_always_conf_size_ = 0;
			const gchar* _tmp47_ = NULL;
			IdCard* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			GKeyFile* _tmp51_ = NULL;
			IdCard* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			IdCard* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			GKeyFile* _tmp59_ = NULL;
			IdCard* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
			const gchar* _tmp62_ = NULL;
			const gchar* _tmp63_ = NULL;
			IdCard* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			const gchar* _tmp66_ = NULL;
			GKeyFile* _tmp67_ = NULL;
			IdCard* _tmp68_ = NULL;
			const gchar* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			gboolean _tmp71_ = FALSE;
			IdCard* _tmp72_ = NULL;
			gboolean _tmp73_ = FALSE;
			gboolean _tmp74_ = FALSE;
			gchar** svcs = NULL;
			IdCard* _tmp89_ = NULL;
			GeeArrayList* _tmp90_ = NULL;
			GeeArrayList* _tmp91_ = NULL;
			gint _tmp92_ = 0;
			gint _tmp93_ = 0;
			gchar** _tmp94_ = NULL;
			gint svcs_length1 = 0;
			gint _svcs_size_ = 0;
			GKeyFile* _tmp111_ = NULL;
			IdCard* _tmp112_ = NULL;
			const gchar* _tmp113_ = NULL;
			const gchar* _tmp114_ = NULL;
			gchar** _tmp115_ = NULL;
			gint _tmp115__length1 = 0;
			Rule* _tmp116_ = NULL;
			gint _tmp116__length1 = 0;
			const gchar* _tmp127_ = NULL;
			IdCard* _tmp128_ = NULL;
			gboolean _tmp129_ = FALSE;
			gboolean _tmp130_ = FALSE;
			GKeyFile* _tmp131_ = NULL;
			IdCard* _tmp132_ = NULL;
			const gchar* _tmp133_ = NULL;
			const gchar* _tmp134_ = NULL;
			GKeyFile* _tmp135_ = NULL;
			IdCard* _tmp136_ = NULL;
			const gchar* _tmp137_ = NULL;
			const gchar* _tmp138_ = NULL;
			IdCard* _tmp139_ = NULL;
			TrustAnchor* _tmp140_ = NULL;
			TrustAnchor* _tmp141_ = NULL;
			const gchar* _tmp142_ = NULL;
			const gchar* _tmp143_ = NULL;
			GKeyFile* _tmp144_ = NULL;
			IdCard* _tmp145_ = NULL;
			const gchar* _tmp146_ = NULL;
			const gchar* _tmp147_ = NULL;
			IdCard* _tmp148_ = NULL;
			TrustAnchor* _tmp149_ = NULL;
			TrustAnchor* _tmp150_ = NULL;
			const gchar* _tmp151_ = NULL;
			const gchar* _tmp152_ = NULL;
			GKeyFile* _tmp153_ = NULL;
			IdCard* _tmp154_ = NULL;
			const gchar* _tmp155_ = NULL;
			const gchar* _tmp156_ = NULL;
			IdCard* _tmp157_ = NULL;
			TrustAnchor* _tmp158_ = NULL;
			TrustAnchor* _tmp159_ = NULL;
			const gchar* _tmp160_ = NULL;
			const gchar* _tmp161_ = NULL;
			GKeyFile* _tmp162_ = NULL;
			IdCard* _tmp163_ = NULL;
			const gchar* _tmp164_ = NULL;
			const gchar* _tmp165_ = NULL;
			IdCard* _tmp166_ = NULL;
			TrustAnchor* _tmp167_ = NULL;
			TrustAnchor* _tmp168_ = NULL;
			const gchar* _tmp169_ = NULL;
			const gchar* _tmp170_ = NULL;
			IdCard* _tmp171_ = NULL;
			TrustAnchor* _tmp172_ = NULL;
			TrustAnchor* _tmp173_ = NULL;
			const gchar* _tmp174_ = NULL;
			const gchar* _tmp175_ = NULL;
			MoonshotLogger* _tmp185_ = NULL;
			IdCard* _tmp186_ = NULL;
			const gchar* _tmp187_ = NULL;
			const gchar* _tmp188_ = NULL;
			const gchar* _tmp189_ = NULL;
			gchar* _tmp190_ = NULL;
			gchar* _tmp191_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp6_ = _id_card_index;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_id_card_index = _tmp6_ + 1;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp7_ = _id_card_index;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp8_ = _id_card_size;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				break;
#line 1866 "moonshot-local-flat-file-store.c"
			}
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp9_ = _id_card_list;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp10_ = _id_card_index;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			id_card = (IdCard*) _tmp11_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp12_ = local_flat_file_store_logger;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp13_ = id_card;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp14_ = id_card_get_display_name (_tmp13_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp15_ = _tmp14_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp16_ = string_to_string (_tmp15_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp17_ = g_strconcat ("store_id_cards: Storing '", _tmp16_, "'", NULL);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp18_ = _tmp17_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			moonshot_logger_trace (_tmp12_, _tmp18_, NULL);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (_tmp18_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp19_ = id_card;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp20_ = id_card_get_rules (_tmp19_, &_tmp20__length1);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp21_ = _tmp20_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp21__length1 = _tmp20__length1;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup1 (_tmp21_, _tmp21__length1) : ((gpointer) _tmp21_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp22__length1 = _tmp21__length1;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules = _tmp22_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_length1 = _tmp22__length1;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_rules_size_ = rules_length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp23_ = rules;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp23__length1 = rules_length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp24_ = g_new0 (gchar*, _tmp23__length1 + 1);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_patterns = _tmp24_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_patterns_length1 = _tmp23__length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_rules_patterns_size_ = rules_patterns_length1;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp25_ = rules;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp25__length1 = rules_length1;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp26_ = g_new0 (gchar*, _tmp25__length1 + 1);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_always_conf = _tmp26_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_always_conf_length1 = _tmp25__length1;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_rules_always_conf_size_ = rules_always_conf_length1;
#line 1936 "moonshot-local-flat-file-store.c"
			{
				gint i = 0;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				i = 0;
#line 1941 "moonshot-local-flat-file-store.c"
				{
					gboolean _tmp27_ = FALSE;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp27_ = TRUE;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					while (TRUE) {
#line 1948 "moonshot-local-flat-file-store.c"
						gint _tmp29_ = 0;
						Rule* _tmp30_ = NULL;
						gint _tmp30__length1 = 0;
						gchar** _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
						gint _tmp32_ = 0;
						Rule* _tmp33_ = NULL;
						gint _tmp33__length1 = 0;
						gint _tmp34_ = 0;
						Rule _tmp35_ = {0};
						const gchar* _tmp36_ = NULL;
						gchar* _tmp37_ = NULL;
						gchar* _tmp38_ = NULL;
						gchar** _tmp39_ = NULL;
						gint _tmp39__length1 = 0;
						gint _tmp40_ = 0;
						Rule* _tmp41_ = NULL;
						gint _tmp41__length1 = 0;
						gint _tmp42_ = 0;
						Rule _tmp43_ = {0};
						const gchar* _tmp44_ = NULL;
						gchar* _tmp45_ = NULL;
						gchar* _tmp46_ = NULL;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (!_tmp27_) {
#line 1974 "moonshot-local-flat-file-store.c"
							gint _tmp28_ = 0;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp28_ = i;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							i = _tmp28_ + 1;
#line 1980 "moonshot-local-flat-file-store.c"
						}
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp27_ = FALSE;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp29_ = i;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp30_ = rules;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp30__length1 = rules_length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (!(_tmp29_ < _tmp30__length1)) {
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							break;
#line 1994 "moonshot-local-flat-file-store.c"
						}
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_ = rules_patterns;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31__length1 = rules_patterns_length1;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp32_ = i;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp33_ = rules;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp33__length1 = rules_length1;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp34_ = i;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp35_ = _tmp33_[_tmp34_];
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp36_ = _tmp35_.pattern;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp37_ = g_strdup (_tmp36_);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp31_[_tmp32_]);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_[_tmp32_] = _tmp37_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp38_ = _tmp31_[_tmp32_];
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp39_ = rules_always_conf;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp39__length1 = rules_always_conf_length1;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp40_ = i;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp41_ = rules;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp41__length1 = rules_length1;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp42_ = i;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp43_ = _tmp41_[_tmp42_];
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp44_ = _tmp43_.always_confirm;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp45_ = g_strdup (_tmp44_);
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp39_[_tmp40_]);
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp39_[_tmp40_] = _tmp45_;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp46_ = _tmp39_[_tmp40_];
#line 2044 "moonshot-local-flat-file-store.c"
					}
				}
			}
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp48_ = id_card;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp49_ = id_card_get_issuer (_tmp48_);
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp50_ = _tmp49_;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp47_ = _tmp50_;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp47_ == NULL) {
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp47_ = "";
#line 2060 "moonshot-local-flat-file-store.c"
			}
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp51_ = key_file;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp52_ = id_card;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp53_ = id_card_get_display_name (_tmp52_);
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp54_ = _tmp53_;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp51_, _tmp54_, "Issuer", _tmp47_);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp56_ = id_card;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp57_ = id_card_get_display_name (_tmp56_);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp58_ = _tmp57_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp55_ = _tmp58_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp55_ == NULL) {
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp55_ = "";
#line 2084 "moonshot-local-flat-file-store.c"
			}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp59_ = key_file;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp60_ = id_card;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp61_ = id_card_get_display_name (_tmp60_);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp62_ = _tmp61_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp59_, _tmp62_, "DisplayName", _tmp55_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp64_ = id_card;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp65_ = id_card_get_username (_tmp64_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp66_ = _tmp65_;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp63_ = _tmp66_;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp63_ == NULL) {
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp63_ = "";
#line 2108 "moonshot-local-flat-file-store.c"
			}
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp67_ = key_file;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp68_ = id_card;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp69_ = id_card_get_display_name (_tmp68_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp70_ = _tmp69_;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp67_, _tmp70_, "Username", _tmp63_);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp72_ = id_card;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp73_ = id_card_get_store_password (_tmp72_);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp74_ = _tmp73_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp74_) {
#line 2128 "moonshot-local-flat-file-store.c"
				IdCard* _tmp75_ = NULL;
				const gchar* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp75_ = id_card;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp76_ = id_card_get_password (_tmp75_);
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp77_ = _tmp76_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp71_ = _tmp77_ != NULL;
#line 2140 "moonshot-local-flat-file-store.c"
			} else {
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp71_ = FALSE;
#line 2144 "moonshot-local-flat-file-store.c"
			}
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp71_) {
#line 2148 "moonshot-local-flat-file-store.c"
				GKeyFile* _tmp78_ = NULL;
				IdCard* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				const gchar* _tmp81_ = NULL;
				IdCard* _tmp82_ = NULL;
				const gchar* _tmp83_ = NULL;
				const gchar* _tmp84_ = NULL;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp78_ = key_file;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp79_ = id_card;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp80_ = id_card_get_display_name (_tmp79_);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp81_ = _tmp80_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp82_ = id_card;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp83_ = id_card_get_password (_tmp82_);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp84_ = _tmp83_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				g_key_file_set_string (_tmp78_, _tmp81_, "Password", _tmp84_);
#line 2172 "moonshot-local-flat-file-store.c"
			} else {
				GKeyFile* _tmp85_ = NULL;
				IdCard* _tmp86_ = NULL;
				const gchar* _tmp87_ = NULL;
				const gchar* _tmp88_ = NULL;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp85_ = key_file;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp86_ = id_card;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp87_ = id_card_get_display_name (_tmp86_);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp88_ = _tmp87_;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				g_key_file_set_string (_tmp85_, _tmp88_, "Password", "");
#line 2188 "moonshot-local-flat-file-store.c"
			}
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp89_ = id_card;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp90_ = id_card_get_services (_tmp89_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp91_ = _tmp90_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp92_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp91_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp93_ = _tmp92_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp94_ = g_new0 (gchar*, _tmp93_ + 1);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			svcs = _tmp94_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			svcs_length1 = _tmp93_;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_svcs_size_ = svcs_length1;
#line 2208 "moonshot-local-flat-file-store.c"
			{
				gint i = 0;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				i = 0;
#line 2213 "moonshot-local-flat-file-store.c"
				{
					gboolean _tmp95_ = FALSE;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp95_ = TRUE;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					while (TRUE) {
#line 2220 "moonshot-local-flat-file-store.c"
						gint _tmp97_ = 0;
						IdCard* _tmp98_ = NULL;
						GeeArrayList* _tmp99_ = NULL;
						GeeArrayList* _tmp100_ = NULL;
						gint _tmp101_ = 0;
						gint _tmp102_ = 0;
						gchar** _tmp103_ = NULL;
						gint _tmp103__length1 = 0;
						gint _tmp104_ = 0;
						IdCard* _tmp105_ = NULL;
						GeeArrayList* _tmp106_ = NULL;
						GeeArrayList* _tmp107_ = NULL;
						gint _tmp108_ = 0;
						gpointer _tmp109_ = NULL;
						gchar* _tmp110_ = NULL;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (!_tmp95_) {
#line 2238 "moonshot-local-flat-file-store.c"
							gint _tmp96_ = 0;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp96_ = i;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							i = _tmp96_ + 1;
#line 2244 "moonshot-local-flat-file-store.c"
						}
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp95_ = FALSE;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp97_ = i;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp98_ = id_card;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp99_ = id_card_get_services (_tmp98_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp100_ = _tmp99_;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp101_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp100_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp102_ = _tmp101_;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (!(_tmp97_ < _tmp102_)) {
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							break;
#line 2264 "moonshot-local-flat-file-store.c"
						}
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp103_ = svcs;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp103__length1 = svcs_length1;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp104_ = i;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp105_ = id_card;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp106_ = id_card_get_services (_tmp105_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp107_ = _tmp106_;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp108_ = i;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp109_ = gee_abstract_list_get ((GeeAbstractList*) _tmp107_, _tmp108_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp103_[_tmp104_]);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp103_[_tmp104_] = (gchar*) _tmp109_;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp110_ = _tmp103_[_tmp104_];
#line 2288 "moonshot-local-flat-file-store.c"
					}
				}
			}
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp111_ = key_file;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp112_ = id_card;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp113_ = id_card_get_display_name (_tmp112_);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp114_ = _tmp113_;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp115_ = svcs;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp115__length1 = svcs_length1;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string_list (_tmp111_, _tmp114_, "Services", (const gchar* const*) _tmp115_, _tmp115__length1);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp116_ = rules;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp116__length1 = rules_length1;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp116__length1 > 0) {
#line 2312 "moonshot-local-flat-file-store.c"
				GKeyFile* _tmp117_ = NULL;
				IdCard* _tmp118_ = NULL;
				const gchar* _tmp119_ = NULL;
				const gchar* _tmp120_ = NULL;
				gchar** _tmp121_ = NULL;
				gint _tmp121__length1 = 0;
				GKeyFile* _tmp122_ = NULL;
				IdCard* _tmp123_ = NULL;
				const gchar* _tmp124_ = NULL;
				const gchar* _tmp125_ = NULL;
				gchar** _tmp126_ = NULL;
				gint _tmp126__length1 = 0;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp117_ = key_file;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp118_ = id_card;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp119_ = id_card_get_display_name (_tmp118_);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp120_ = _tmp119_;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp121_ = rules_patterns;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp121__length1 = rules_patterns_length1;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				g_key_file_set_string_list (_tmp117_, _tmp120_, "Rules-Patterns", (const gchar* const*) _tmp121_, _tmp121__length1);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp122_ = key_file;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp123_ = id_card;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp124_ = id_card_get_display_name (_tmp123_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp125_ = _tmp124_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp126_ = rules_always_conf;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp126__length1 = rules_always_conf_length1;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				g_key_file_set_string_list (_tmp122_, _tmp125_, "Rules-AlwaysConfirm", (const gchar* const*) _tmp126_, _tmp126__length1);
#line 2353 "moonshot-local-flat-file-store.c"
			}
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp128_ = id_card;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp129_ = id_card_get_store_password (_tmp128_);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp130_ = _tmp129_;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp130_) {
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp127_ = "yes";
#line 2365 "moonshot-local-flat-file-store.c"
			} else {
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp127_ = "no";
#line 2369 "moonshot-local-flat-file-store.c"
			}
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp131_ = key_file;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp132_ = id_card;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp133_ = id_card_get_display_name (_tmp132_);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp134_ = _tmp133_;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp131_, _tmp134_, "StorePassword", _tmp127_);
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp135_ = key_file;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp136_ = id_card;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp137_ = id_card_get_display_name (_tmp136_);
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp138_ = _tmp137_;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp139_ = id_card;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp140_ = id_card_get_trust_anchor (_tmp139_);
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp141_ = _tmp140_;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp142_ = trust_anchor_get_ca_cert (_tmp141_);
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp143_ = _tmp142_;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp135_, _tmp138_, "CA-Cert", _tmp143_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp144_ = key_file;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp145_ = id_card;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp146_ = id_card_get_display_name (_tmp145_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp147_ = _tmp146_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp148_ = id_card;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp149_ = id_card_get_trust_anchor (_tmp148_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp150_ = _tmp149_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp151_ = trust_anchor_get_subject (_tmp150_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp152_ = _tmp151_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp144_, _tmp147_, "Subject", _tmp152_);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp153_ = key_file;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp154_ = id_card;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp155_ = id_card_get_display_name (_tmp154_);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp156_ = _tmp155_;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp157_ = id_card;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp158_ = id_card_get_trust_anchor (_tmp157_);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp159_ = _tmp158_;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp160_ = trust_anchor_get_subject_alt (_tmp159_);
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp161_ = _tmp160_;
#line 191 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp153_, _tmp156_, "SubjectAlt", _tmp161_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp162_ = key_file;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp163_ = id_card;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp164_ = id_card_get_display_name (_tmp163_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp165_ = _tmp164_;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp166_ = id_card;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp167_ = id_card_get_trust_anchor (_tmp166_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp168_ = _tmp167_;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp169_ = trust_anchor_get_server_cert (_tmp168_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp170_ = _tmp169_;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp162_, _tmp165_, "ServerCert", _tmp170_);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp171_ = id_card;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp172_ = id_card_get_trust_anchor (_tmp171_);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp173_ = _tmp172_;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp174_ = trust_anchor_get_datetime_added (_tmp173_);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp175_ = _tmp174_;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (g_strcmp0 (_tmp175_, "") != 0) {
#line 2473 "moonshot-local-flat-file-store.c"
				GKeyFile* _tmp176_ = NULL;
				IdCard* _tmp177_ = NULL;
				const gchar* _tmp178_ = NULL;
				const gchar* _tmp179_ = NULL;
				IdCard* _tmp180_ = NULL;
				TrustAnchor* _tmp181_ = NULL;
				TrustAnchor* _tmp182_ = NULL;
				const gchar* _tmp183_ = NULL;
				const gchar* _tmp184_ = NULL;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp176_ = key_file;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp177_ = id_card;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp178_ = id_card_get_display_name (_tmp177_);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp179_ = _tmp178_;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp180_ = id_card;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp181_ = id_card_get_trust_anchor (_tmp180_);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp182_ = _tmp181_;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp183_ = trust_anchor_get_datetime_added (_tmp182_);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp184_ = _tmp183_;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				g_key_file_set_string (_tmp176_, _tmp179_, "TA_DateTime_Added", _tmp184_);
#line 2503 "moonshot-local-flat-file-store.c"
			}
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp185_ = local_flat_file_store_logger;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp186_ = id_card;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp187_ = id_card_get_display_name (_tmp186_);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp188_ = _tmp187_;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp189_ = string_to_string (_tmp188_);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp190_ = g_strconcat ("store_id_cards: Stored '", _tmp189_, "'", NULL);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp191_ = _tmp190_;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			moonshot_logger_trace (_tmp185_, _tmp191_, NULL);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (_tmp191_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			svcs = (_vala_array_free (svcs, svcs_length1, (GDestroyNotify) g_free), NULL);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_always_conf = (_vala_array_free (rules_always_conf, rules_always_conf_length1, (GDestroyNotify) g_free), NULL);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (id_card);
#line 2533 "moonshot-local-flat-file-store.c"
		}
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_object_unref0 (_id_card_list);
#line 2537 "moonshot-local-flat-file-store.c"
	}
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp192_ = key_file;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp193_ = g_key_file_to_data (_tmp192_, NULL, NULL);
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	text = _tmp193_;
#line 2545 "moonshot-local-flat-file-store.c"
	{
		gchar* path = NULL;
		gchar* _tmp194_ = NULL;
		gchar* filename = NULL;
		const gchar* _tmp195_ = NULL;
		gchar* _tmp196_ = NULL;
		MoonshotLogger* _tmp197_ = NULL;
		const gchar* _tmp198_ = NULL;
		gchar* _tmp199_ = NULL;
		gchar* _tmp200_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp201_ = NULL;
		GFile* _tmp202_ = NULL;
		GFileOutputStream* stream = NULL;
		GFile* _tmp203_ = NULL;
		GFileOutputStream* _tmp204_ = NULL;
		GFileOutputStream* _tmp205_ = NULL;
		const gchar* _tmp206_ = NULL;
		guint8* _tmp207_ = NULL;
		gint _tmp207__length1 = 0;
		guint8* _tmp208_ = NULL;
		gint _tmp208__length1 = 0;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp194_ = local_flat_file_store_get_data_dir (self);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		path = _tmp194_;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp195_ = path;
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp196_ = g_build_filename (_tmp195_, LOCAL_FLAT_FILE_STORE_FILE_NAME, NULL);
#line 203 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		filename = _tmp196_;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp197_ = local_flat_file_store_logger;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp198_ = filename;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp199_ = g_strconcat ("store_id_cards: attempting to store to ", _tmp198_, NULL);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp200_ = _tmp199_;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		moonshot_logger_trace (_tmp197_, _tmp200_, NULL);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (_tmp200_);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp201_ = filename;
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp202_ = g_file_new_for_path (_tmp201_);
#line 205 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		file = _tmp202_;
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp203_ = file;
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp204_ = g_file_replace (_tmp203_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, &_inner_error_);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		stream = _tmp204_;
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (file);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (filename);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (path);
#line 2610 "moonshot-local-flat-file-store.c"
			goto __catch8_g_error;
		}
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp205_ = stream;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp206_ = text;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp207_ = string_get_data (_tmp206_, &_tmp207__length1);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp208_ = _tmp207_;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp208__length1 = _tmp207__length1;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_output_stream_write ((GOutputStream*) _tmp205_, _tmp208_, (gsize) _tmp208__length1, NULL, &_inner_error_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (stream);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (file);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (filename);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (path);
#line 2635 "moonshot-local-flat-file-store.c"
			goto __catch8_g_error;
		}
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_object_unref0 (stream);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_object_unref0 (file);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (filename);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (path);
#line 2646 "moonshot-local-flat-file-store.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		MoonshotLogger* _tmp209_ = NULL;
		GError* _tmp210_ = NULL;
		const gchar* _tmp211_ = NULL;
		gchar* _tmp212_ = NULL;
		gchar* _tmp213_ = NULL;
		FILE* _tmp214_ = NULL;
		GError* _tmp215_ = NULL;
		const gchar* _tmp216_ = NULL;
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		e = _inner_error_;
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_inner_error_ = NULL;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp209_ = local_flat_file_store_logger;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp210_ = e;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp211_ = _tmp210_->message;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp212_ = g_strdup_printf ("store_id_cards: Error while saving keyfile: %s\n", _tmp211_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp213_ = _tmp212_;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		moonshot_logger_error (_tmp209_, _tmp213_, NULL);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (_tmp213_);
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp214_ = stdout;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp215_ = e;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp216_ = _tmp215_->message;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		fprintf (_tmp214_, "Error:  %s\n", _tmp216_);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_error_free0 (e);
#line 2688 "moonshot-local-flat-file-store.c"
	}
	__finally8:
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (text);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_key_file_unref0 (key_file);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_clear_error (&_inner_error_);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		return;
#line 2703 "moonshot-local-flat-file-store.c"
	}
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_load_id_cards (self);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (text);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_key_file_unref0 (key_file);
#line 2711 "moonshot-local-flat-file-store.c"
}


LocalFlatFileStore* local_flat_file_store_construct (GType object_type) {
	LocalFlatFileStore * self = NULL;
	GeeLinkedList* _tmp0_ = NULL;
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) g_object_new (object_type, NULL);
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = gee_linked_list_new (TYPE_ID_CARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self->priv->id_card_list = _tmp0_;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_load_id_cards (self);
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return self;
#line 2730 "moonshot-local-flat-file-store.c"
}


LocalFlatFileStore* local_flat_file_store_new (void) {
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return local_flat_file_store_construct (TYPE_LOCAL_FLAT_FILE_STORE);
#line 2737 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_class_init (LocalFlatFileStoreClass * klass) {
	MoonshotLogger* _tmp0_ = NULL;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_type_class_add_private (klass, sizeof (LocalFlatFileStorePrivate));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	G_OBJECT_CLASS (klass)->finalize = local_flat_file_store_finalize;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = get_logger ("LocalFlatFileStore");
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_logger = _tmp0_;
#line 2753 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_iidentity_card_store_interface_init (IIdentityCardStoreIface * iface) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_iidentity_card_store_parent_iface = g_type_interface_peek_parent (iface);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->add_card = (void (*)(IIdentityCardStore*, IdCard*)) local_flat_file_store_real_add_card;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->update_card = (IdCard* (*)(IIdentityCardStore*, IdCard*)) local_flat_file_store_real_update_card;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->remove_card = (gboolean (*)(IIdentityCardStore*, IdCard*)) local_flat_file_store_real_remove_card;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->get_card_list = (GeeLinkedList* (*)(IIdentityCardStore*)) local_flat_file_store_real_get_card_list;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->get_store_type = (IIdentityCardStoreStoreType (*)(IIdentityCardStore*)) local_flat_file_store_real_get_store_type;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->store_id_cards = (void (*)(IIdentityCardStore*)) local_flat_file_store_real_store_id_cards;
#line 2772 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_instance_init (LocalFlatFileStore * self) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self->priv = LOCAL_FLAT_FILE_STORE_GET_PRIVATE (self);
#line 2779 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_finalize (GObject* obj) {
	LocalFlatFileStore * self;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStore);
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	G_OBJECT_CLASS (local_flat_file_store_parent_class)->finalize (obj);
#line 2791 "moonshot-local-flat-file-store.c"
}


GType local_flat_file_store_get_type (void) {
	static volatile gsize local_flat_file_store_type_id__volatile = 0;
	if (g_once_init_enter (&local_flat_file_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LocalFlatFileStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) local_flat_file_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LocalFlatFileStore), 0, (GInstanceInitFunc) local_flat_file_store_instance_init, NULL };
		static const GInterfaceInfo iidentity_card_store_info = { (GInterfaceInitFunc) local_flat_file_store_iidentity_card_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType local_flat_file_store_type_id;
		local_flat_file_store_type_id = g_type_register_static (G_TYPE_OBJECT, "LocalFlatFileStore", &g_define_type_info, 0);
		g_type_add_interface_static (local_flat_file_store_type_id, TYPE_IIDENTITY_CARD_STORE, &iidentity_card_store_info);
		g_once_init_leave (&local_flat_file_store_type_id__volatile, local_flat_file_store_type_id);
	}
	return local_flat_file_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



