/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.expr.ExtensionContext;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.ResultBase;
import com.jclark.xsl.sax.ResultTreeFragment;
import com.jclark.xsl.sax.SingleNamespaceResult;
import com.jclark.xsl.tr.ExtensionHandler;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.ResultFragmentVariant;
import com.jclark.xsl.tr.ResultFragmentVariantBase;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

class ExtensionHandlerImpl
implements ExtensionHandler {
    private static final String JAVA_NS = "http://www.jclark.com/xt/java/";

    public Object wrapResultFragmentVariant(final ResultFragmentVariant resultFragmentVariant) {
        return new ResultTreeFragment(this){
            final /* synthetic */ ExtensionHandlerImpl this$0;
            {
                this.this$0 = extensionHandlerImpl;
                this.this$0.getClass();
            }

            public void emit(DocumentHandler documentHandler, boolean bl) throws SAXException {
                ResultBase resultBase = bl ? new SingleNamespaceResult(documentHandler) : new MultiNamespaceResult(documentHandler);
                try {
                    resultBase.start();
                    resultFragmentVariant.append(resultBase);
                    resultBase.end();
                    return;
                }
                catch (XSLException xSLException) {
                    throw new SAXException(xSLException);
                }
            }
        };
    }

    static Object wrapResultTreeFragment(final ResultTreeFragment resultTreeFragment) {
        return new ResultFragmentVariantBase(){

            public Object convertToObject() {
                return resultTreeFragment;
            }

            public void append(Result result) throws XSLException {
                if (result instanceof ResultBase) {
                    ((ResultBase)result).resultTreeFragment(resultTreeFragment);
                    return;
                }
                throw new XSLException("weird result tree fragment usage not implemented");
            }
        };
    }

    ExtensionHandlerImpl() {
    }

    public ExtensionContext createContext(String string) throws XSLException {
        if (string.startsWith(JAVA_NS)) {
            try {
                return new ContextImpl(Class.forName(string.substring(JAVA_NS.length())));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    private static class ContextImpl
    implements ExtensionContext {
        private final Class cls;

        private Object callMethod(String string, Object[] objectArray) throws XSLException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            string = this.camelCase(string);
            Method[] methodArray = this.cls.getMethods();
            Method method = null;
            boolean bl = true;
            if (objectArray.length > 0 && this.cls.isInstance(objectArray[0])) {
                bl = false;
            }
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(string)) {
                    boolean bl2 = Modifier.isStatic(methodArray[n].getModifiers()) ? methodArray[n].getParameterTypes().length == objectArray.length : !bl && methodArray[n].getParameterTypes().length == objectArray.length - 1;
                    if (bl2) {
                        if (method != null) {
                            throw new XSLException(string + ": overloaded method");
                        }
                        method = methodArray[n];
                    }
                }
                ++n;
            }
            if (method == null) {
                throw new XSLException(string + ": no method with " + objectArray.length + " arguments");
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, objectArray);
            }
            Object object = objectArray[0];
            Object[] objectArray2 = new Object[objectArray.length - 1];
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
            object = method.invoke(object, objectArray2);
            if (object instanceof ResultTreeFragment) {
                return ExtensionHandlerImpl.wrapResultTreeFragment((ResultTreeFragment)object);
            }
            return object;
        }

        ContextImpl(Class clazz) {
            this.cls = clazz;
        }

        public boolean available(String string) {
            if (string.equals("new")) {
                return this.cls.getConstructors().length != 0;
            }
            string = this.camelCase(string);
            Method[] methodArray = this.cls.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(string)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private String camelCase(String string) {
            int n = string.indexOf(45);
            if (n < 0 || n + 1 == string.length()) {
                return string;
            }
            return string.substring(0, n) + Character.toUpperCase(string.charAt(n + 1)) + this.camelCase(string.substring(n + 2));
        }

        private Object callConstructor(Object[] objectArray) throws XSLException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Constructor<?>[] constructorArray = this.cls.getConstructors();
            Constructor<?> constructor = null;
            int n = 0;
            while (n < constructorArray.length) {
                if (constructorArray[n].getParameterTypes().length == objectArray.length) {
                    if (constructor != null) {
                        throw new XSLException("overloaded constructor");
                    }
                    constructor = constructorArray[n];
                }
                ++n;
            }
            if (constructor == null) {
                throw new XSLException("no constructor with " + objectArray.length + " arguments");
            }
            return constructor.newInstance(objectArray);
        }

        public Object call(String string, Node node, Object[] objectArray) throws XSLException {
            try {
                if (string.equals("new")) {
                    return this.callConstructor(objectArray);
                }
                return this.callMethod(string, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XSLException(string + ": illegal access");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XSLException(string + ": illegal arguments");
            }
            catch (InstantiationException instantiationException) {
                throw new XSLException("cannot instantiate class");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof Exception) {
                    throw new XSLException((Exception)throwable);
                }
                throw new XSLException(invocationTargetException);
            }
        }
    }
}

