# Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# This software is available to you under a choice of one of two
# licenses.  You may choose to be licensed under the terms of the GNU
# General Public License (GPL) Version 2, available from the file
# COPYING in the main directory of this source tree, or the
# OpenIB.org BSD license below:
#
#     Redistribution and use in source and binary forms, with or
#     without modification, are permitted provided that the following
#     conditions are met:
#
#      - Redistributions of source code must retain the above
#        copyright notice, this list of conditions and the following
#        disclaimer.
#
#      - Redistributions in binary form must reproduce the above
#        copyright notice, this list of conditions and the following
#        disclaimer in the documentation and/or other materials
#        provided with the distribution.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

#######################################################
#
# CommandSegment.py
# Python implementation of the Class CommandSegment
# Generated by Enterprise Architect
# Created on:      14-Aug-2019 10:11:57 AM
# Original author: talve
#
#######################################################
from segments.Segment import Segment
from segments.SegmentFactory import SegmentFactory
from resourcedump_lib.utils import constants

import struct
import sys


class CommandSegment(Segment):
    """this class is responsible for holding command segment data.
    """

    _segment_type_id = constants.RESOURCE_DUMP_SEGMENT_TYPE_COMMAND

    command_struct = struct.Struct('HHIIHH')

    def __init__(self, data):
        """initialize the class by setting the class data.
        """
        super().__init__(data)
        _, _, self.index1, self.index2, _, _ = self.unpack_command()  # TODO: for optimization move this line to later stage, before parsing

    def unpack_command(self):
        fields = self.command_struct.unpack_from(self.raw_data, self.segment_header_struct.size)
        segment_id, vhca_id, index1, index2, num_of_obj1, num_of_obj2 = fields if sys.byteorder == 'big' \
            else fields[1], fields[0], fields[2], fields[3], fields[5], fields[4]
        return segment_id, vhca_id, index1, index2, num_of_obj1, num_of_obj2

    def additional_title_info(self):
        """return index1 and index2 if exists in the segment.
        """
        return " ; index1 = {0}, index2 = {1}".format(hex(self.index1), hex(self.index2))


SegmentFactory.register(constants.RESOURCE_DUMP_SEGMENT_TYPE_COMMAND, CommandSegment)
